# Reko build process

As the Reko project has developed over time, its complexity has grown to the point where it is hard to understand
how everything gets built. This document aims to clarify the Reko build process. 

## Quick start
For the tl;dr crowd:

To build the Reko solution for x86-64 versions of Windows, use the following command:
```
msbuild /p:Configuration=Release /p:Platform=x64 src/Reko-decompiler.sln
```
To build the solution for x86-64 Unix systems, use the following command:
```
msbuild /p:Configuration=UnixRelease /p:Platform=x64 src/Reko-decompiler.sln
```

## Background 

The goal of the Reko build process is to generate a coherent set of executable files that work correctly when launched.
The bulk of the source code is written in C#, but because users have requested the Reko project to support extensions written in
C/C++, the build system had to be modified. Reko was initially developed with Visual Studio. The Reko solution contained a
mixture of `csproj` (C#) and `vcxproj` (C++) projects. Users requested support for MonoDevelop,
which didn't have support for `vcxproj` files. This was accomodated by switching to MonoDevelop specific `cproj` files, and
using advanced hackery to switch between "Windows" and "Unix" flavors of the solution.

At the time of writing (February 2018), we are regrettably seeing how MonoDevelop is withdrawing its mainline support
for compiling C++, making it an obscure optional feature. This forced us to adopt a different approach, that sacrifices
IDE convenience in order to support cross-platform compilation. It's an infelicitous situation that we hope will be 
remedied in the future.

## Prerequisites

To successfully build Reko, you will have to install a recent version of `msbuild` and `CMake`, along with appropriate 
C# and C++ compilers. The current version of Reko is building with version 15.5 of `msbuild` and CMake version 3.9.
`Msbuild` assumes .NET framework is present, and currently Reko C# projects require .NET Framework 4.7 and C# 7. Your
C++ compiler must be C++ 14 compliant.

## Overview

The Reko solution consists of the following projects:
* `Core.csproj` -- classes and interfaces used by all projects
* `Decompiler.csproj` -- the decompiler implementation.
* `Gui.csproj` -- support for graphical user interface
* Front end drivers (in `src/Drivers`)
  - `CmdLine.csproj` -- the command line front end, which generates a `decompiler.exe` executable
  - `WindowsDecompiler.csproj` -- Windows Forms front end
* Plugins, supporting the various processor architectures, operating environment platforms, and executable
  image formats supported by Reko. These can be written in C# or C++.
* WiX installers -- only supported for Windows builds.

The solution projects form a directed acyclic graph (DAG) of project dependencies. Cyclical dependencies are forbidden. 

## Supported platforms and configurations

Most C# projects will be compiled platform agnostically, using the `Any CPU` solution platform. However, all front end
drivers and Reko unit tests must be built for specific platforms. Currently, the Reko solution can generate 32-bit executables for 
x86 and 64-bit executables for x86-64 processors. The names of the solution platforms are `x86` and `x64`, following 
the conventions used by Visual Studio solution files.

The currently supported solution configurations are `Debug`, `Release`, and `UnixRelease`. The `Debug` configuration
is not optimized and contains full debug symbols. The `Release` configuration is optimized and may not contain
full debug symbol support. The `UnixRelease` configuration is identical to the `Release` configuration except
that it excludes the WiX MSI installer scripts. The `UnixRelease` configuration is used to build on Unixy platforms, where MSI
installers are not supported nor relevant.

## Build process

The build starts with the `Core.csproj` project.  All C# projects will depend directly on this project. 
C++ projects will depend on this project indirectly, via header files generated by `hdrgen` (see below). `Core.csproj`
is built platform neutrally, using the `Any CPU` platform.

### Tools

Once `Core.csproj` is compiled, the projects in the `src/Tools` directory can be compiled. These tools are used to 
assist the build by generating source code from XML files or C header files. In no particular order:
* `c2xml` - parses C 99 header files and generates XML files complying with Reko's type library schema. This tool is used  
  to generate Reko metadata files from C header files to assist the decompilation process.
* `xslt` - hosts an XSL transform. This tool is used to transform XSL template files into source code. Notably, it is used
  to generate the menu system in the Gui project without a hard dependency on the GUI front end.
* `hdrgen` - generates a C++ header file, `reko.h`, by using .NET reflection on the the output of `Core.csproj` project.
  This C++ header file is consumed by C++ plugin projects at a later stage.

### C# / .NET plugins

When the `src/Tools` have been built, the various plugins supported by Reko are built. Those plugins that are written in C# 
or any other .NET language may have dependencies on `Core.csproj` and `src/Tools`, and optionally other plugins.

### C++ plugins 

In order to support plugins written in C++, the Reko source tree has a `src/Native` directory. All C++ plugin projects will 
be located here. The `NativeProxy.csproj` project is a stub project whose sole purpose is to start off the build of the 
Native (i.e. non-managed) components of Reko. This sub-build is performed with CMake.

Any C++ plugin of even the smallest usefulness must access Reko's C# object model. This access is provided by the
`src/Native/inc/reko.h` header file, which is generated by the `hdrgen` tool as described above.

Separate solution build platforms are used for the supported `x86` and `x86-64` execution platforms. These solution platforms
are called `x86` and `x64`, respectively.

### Decompiler and Core GUI

The decompiler implementation and the GUI implementation are built using the `Any CPU` solution platforms.

### Front end drivers

Each one of the front end drivers is compiled for each supported solution platform: `x86` and `x64`.

### Unit tests

The Reko unit test suite is compiled for each supported solution platform: `x86` and `x64`.

