#region License
/* 
 * Copyright (C) 1999-2019 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Reko.Core;

namespace Reko.Arch.Vax
{
    public partial class VaxDisassembler
    {
        // http://www2.hmc.edu/www_common/OVMS072-OLD/72final/4515/4515pro_038.html#mnemonics

        private static Decoder[] oneByteInstructions = new[]
        {
 /* 00 */ new Decoder(Opcode.halt, InstrClass.System|InstrClass.Terminates|InstrClass.Zero), 
 /* 01 */ new Decoder(Opcode.nop), 
 /* 02 */ new Decoder(Opcode.rei, InstrClass.Transfer), 
 /* 03 */ new Decoder(Opcode.bpt), 
 /* 04 */ new Decoder(Opcode.ret, InstrClass.Transfer), 
 /* 05 */ new Decoder(Opcode.rsb, InstrClass.Transfer), 
 /* 06 */ new Decoder(Opcode.ldpctx), 
 /* 07 */ new Decoder(Opcode.svpctx), 
 /* 08 */ new Decoder(Opcode.cvtps, rw,ab,rw,ab), 
 /* 09 */ new Decoder(Opcode.cvtsp, rw,ab,rw,ab),
 /* 0A */ new Decoder(Opcode.index, rl,rl,rl,rl,rl,wl),
 /* 0B */ new Decoder(Opcode.crc, ab,rl,rw,ab), 
 /* 0C */ new Decoder(Opcode.prober, rb,rw,ab), 
 /* 0D */ new Decoder(Opcode.probew, rb,rw,ab), 
 /* 0E */ new Decoder(Opcode.insque, ab,ab), 
 /* 0F */ new Decoder(Opcode.remque, ab,wl), 

 /* 10 */ new Decoder(Opcode.bsbb, InstrClass.Transfer, bb), 
 /* 11 */ new Decoder(Opcode.brb, InstrClass.Transfer, bb), 
 /* 12 */ new Decoder(Opcode.bneq, InstrClass.ConditionalTransfer, bb),    // bnequ
 /* 13 */ new Decoder(Opcode.beql, InstrClass.ConditionalTransfer, bb),  // beqlu
 /* 14 */ new Decoder(Opcode.bgtr, InstrClass.ConditionalTransfer, bb), 
 /* 15 */ new Decoder(Opcode.bleq, InstrClass.ConditionalTransfer, bb), 
 /* 16 */ new Decoder(Opcode.jsb, InstrClass.Transfer|InstrClass.Call, ab), 
 /* 17 */ new Decoder(Opcode.jmp, InstrClass.Transfer, ab), 
 /* 18 */ new Decoder(Opcode.bgeq, InstrClass.ConditionalTransfer, bb), 
 /* 19 */ new Decoder(Opcode.blss, InstrClass.ConditionalTransfer, bb), 
 /* 1A */ new Decoder(Opcode.bgtru, InstrClass.ConditionalTransfer, bb), 
 /* 1B */ new Decoder(Opcode.blequ, InstrClass.ConditionalTransfer, bb), 
 /* 1C */ new Decoder(Opcode.bvc, InstrClass.ConditionalTransfer, bb), 
 /* 1D */ new Decoder(Opcode.bvs, InstrClass.ConditionalTransfer, bb), 
 /* 1E */ new Decoder(Opcode.bgequ, InstrClass.ConditionalTransfer, bb), // bcc, 
 /* 1F */ new Decoder(Opcode.blssu, InstrClass.ConditionalTransfer, bb), //  bcs, 

 /* 20 */ new Decoder(Opcode.addp4, rw,ab,rw,ab),
 /* 21 */ new Decoder(Opcode.addp6, rw,ab,rw,ab,rw,ab),
 /* 22 */ new Decoder(Opcode.subp4, rw,ab,rw,ab),
 /* 23 */ new Decoder(Opcode.subp6, rw,ab,rw,ab,rw,ab),
 /* 24 */ new Decoder(Opcode.cvtpt, rw,ab,ab,rw),
 /* 25 */ new Decoder(Opcode.mulp,  rw,ab,rw,ab,rw,ab),
 /* 26 */ new Decoder(Opcode.cvttp, rw,ab,ab,rw),
 /* 27 */ new Decoder(Opcode.divp,  rw,ab,rw,ab,rw,ab),
 /* 28 */ new Decoder(Opcode.movc3, rw,ab,ab),
 /* 29 */ new Decoder(Opcode.cmpc3, rw,ab,ab),
 /* 2A */ new Decoder(Opcode.scanc, rw,ab,ab,rb),
 /* 2B */ new Decoder(Opcode.spanc, rw,ab,ab,rb),
 /* 2C */ new Decoder(Opcode.movc5,  -1), 
 /* 2D */ new Decoder(Opcode.cmpc5, rw,ab,rb,rw,ab), 
 /* 2E */ new Decoder(Opcode.movtc,  -1), 
 /* 2F */ new Decoder(Opcode.movtuc,  -1), 

 /* 30 */ new Decoder(Opcode.bsbw,  InstrClass.Transfer, bw), 
 /* 31 */ new Decoder(Opcode.brw,   InstrClass.Transfer, bw), 
 /* 32 */ new Decoder(Opcode.cvtwl, rw,wl),
 /* 33 */ new Decoder(Opcode.cvtwb, rw,wb), 
 /* 34 */ new Decoder(Opcode.movp,  rw,ab,ab), 
 /* 35 */ new Decoder(Opcode.cmpp3,  rw,ab,ab), 
 /* 36 */ new Decoder(Opcode.cvtpl,  -1), 
 /* 37 */ new Decoder(Opcode.cmpp4,  rw,ab,rw,ab), 
 /* 38 */ new Decoder(Opcode.editpc,  -1), 
 /* 39 */ new Decoder(Opcode.matchc, rw,ab,rw,ab), 
 /* 3A */ new Decoder(Opcode.locc,  -1), 
 /* 3B */ new Decoder(Opcode.skpc,  -1), 
 /* 3C */ new Decoder(Opcode.movzwl, rw,wl),
 /* 3D */ new Decoder(Opcode.acbw,  InstrClass.ConditionalTransfer, rw,rw,mw,bw),
 /* 3E */ new Decoder(Opcode.movaw,  aw,wl), 
 /* 3F */ new Decoder(Opcode.pushaw, aw), 
 
 /* 40 */ new Decoder(Opcode.addf2, rf,wf), 
 /* 41 */ new Decoder(Opcode.addf3, rf,rf,wf), 
 /* 42 */ new Decoder(Opcode.subf2, rf,wf), 
 /* 43 */ new Decoder(Opcode.subf3, rf,rf,wf), 
 /* 44 */ new Decoder(Opcode.mulf2, rf,wf), 
 /* 45 */ new Decoder(Opcode.mulf3, rf,rf,wf), 
 /* 46 */ new Decoder(Opcode.divf2, rf,wf), 
 /* 47 */ new Decoder(Opcode.divf3, rf,rf,wf), 
 /* 48 */ new Decoder(Opcode.cvtfb, rf,wb),
 /* 49 */ new Decoder(Opcode.cvtfw, rf,ww),
 /* 4A */ new Decoder(Opcode.cvtfl, rf,wl), 
 /* 4B */ new Decoder(Opcode.cvtrfl, rf,wl),
 /* 4C */ new Decoder(Opcode.cvtbf, rb,wf),
 /* 4D */ new Decoder(Opcode.cvtwf, rw,wf),
 /* 4E */ new Decoder(Opcode.cvtlf, rl,wf), 
 /* 4F */ new Decoder(Opcode.acbf,  InstrClass.ConditionalTransfer, rf,rf,mf,bw),

 /* 50 */ new Decoder(Opcode.movf,  rf,wf),
 /* 51 */ new Decoder(Opcode.cmpf,  rf,rf), 
 /* 52 */ new Decoder(Opcode.mnegf, rf,wf), 
 /* 53 */ new Decoder(Opcode.tstf,  rf), 
 /* 54 */ new Decoder(Opcode.emodf, rf,rb,rd,wl,wf), 
 /* 55 */ new Decoder(Opcode.polyf, rf,rw,ab), 
 /* 56 */ new Decoder(Opcode.cvtfd, rf,wd),
 /* 57 */ new Decoder(Opcode.Reserved ,  -1), 
 /* 58 */ new Decoder(Opcode.adawi, rw,aw), 
 /* 59 */ new Decoder(Opcode.Reserved,  -1), 
 /* 5A */ new Decoder(Opcode.Reserved,  -1), 
 /* 5B */ new Decoder(Opcode.Reserved,  -1), 
 /* 5C */ new Decoder(Opcode.insqhi,  -1), 
 /* 5D */ new Decoder(Opcode.insqti,  -1), 
 /* 5E */ new Decoder(Opcode.remqhi,  -1), 
 /* 5F */ new Decoder(Opcode.remqti,  -1), 

 /* 60 */ new Decoder(Opcode.addd2,  rd,rw), 
 /* 61 */ new Decoder(Opcode.addd3,  rd,rd,wd), 
 /* 62 */ new Decoder(Opcode.subd2,  rd,rw), 
 /* 63 */ new Decoder(Opcode.subd3,  rd,rd,wd),  
 /* 64 */ new Decoder(Opcode.muld2,  rd,rw), 
 /* 65 */ new Decoder(Opcode.muld3,  rd,rd,wd),
 /* 66 */ new Decoder(Opcode.divd2,  rd,rw), 
 /* 67 */ new Decoder(Opcode.divd3,  rd,rd,wd),
 /* 68 */ new Decoder(Opcode.cvtdb,  rd,rb),  
 /* 69 */ new Decoder(Opcode.cvtdw,  rd,rw),  
 /* 6A */ new Decoder(Opcode.cvtdl,  rd,rl),  
 /* 6B */ new Decoder(Opcode.cvtrdl, rd,rl), 
 /* 6C */ new Decoder(Opcode.cvtbd,  rb,rd),
 /* 6D */ new Decoder(Opcode.cvtwd,  rw,rd),
 /* 6E */ new Decoder(Opcode.cvtld,  rl,rd),
 /* 6F */ new Decoder(Opcode.acbd,   InstrClass.ConditionalTransfer, rd,rd,md,bw),

 /* 70 */ new Decoder(Opcode.movd,  rd,wd), 
 /* 71 */ new Decoder(Opcode.cmpd,  rd,rd), 
 /* 72 */ new Decoder(Opcode.mnegd, rd,wd), 
 /* 73 */ new Decoder(Opcode.tstd,  rd), 
 /* 74 */ new Decoder(Opcode.emodd, rd,rb,rd,wl,wd), 
 /* 75 */ new Decoder(Opcode.polyd, rd,rw,ab), 
 /* 76 */ new Decoder(Opcode.cvtdf, rd,wf), 
 /* 77 */ new Decoder(Opcode.Reserved,  -1), 
 /* 78 */ new Decoder(Opcode.ashl, rb,rl,wl), 
 /* 79 */ new Decoder(Opcode.ashq, rb,rq,wq), 
 /* 7A */ new Decoder(Opcode.emul, rl,rl,rl,wq), 
 /* 7B */ new Decoder(Opcode.ediv, rl,rq,wl,wl), 
 /* 7C */ new Decoder(Opcode.clrq, wq), //  clrd,  clrg,  -1), 
 /* 7D */ new Decoder(Opcode.movq, rq,wq), 
 /* 7E */ new Decoder(Opcode.movaq, aq,wl), //  movad,  movag,  -1), 
 /* 7F */ new Decoder(Opcode.pushaq, aq), //  pushad,  pushag,  -1), 

 /* 80 */ new Decoder(Opcode.addb2, rb,wb), 
 /* 81 */ new Decoder(Opcode.addb3, rb,rb,wb), 
 /* 82 */ new Decoder(Opcode.subb2, rb,wb), 
 /* 83 */ new Decoder(Opcode.subb3, rb,rb,wb), 
 /* 84 */ new Decoder(Opcode.mulb2, rb,rb), 
 /* 85 */ new Decoder(Opcode.mulb3, rb,rb,wb), 
 /* 86 */ new Decoder(Opcode.divb2, rb,rb), 
 /* 87 */ new Decoder(Opcode.divb3, rb,rb,wb), 
 /* 88 */ new Decoder(Opcode.bisb2, rb,rb), 
 /* 89 */ new Decoder(Opcode.bisb3, rb,rb,wb), 
 /* 8A */ new Decoder(Opcode.bicb2, rb,rb), 
 /* 8B */ new Decoder(Opcode.bicb3, rb,rb,wb), 
 /* 8C */ new Decoder(Opcode.xorb2, rb,wb),  
 /* 8D */ new Decoder(Opcode.xorb3, rb,rb,wb),  
 /* 8E */ new Decoder(Opcode.mnegb, rb,wb), 
 /* 8F */ new Decoder(Opcode.caseb, InstrClass.Transfer, rb,rb,rb),

 /* 90 */ new Decoder(Opcode.movb,  rb,wb), 
 /* 91 */ new Decoder(Opcode.cmpb,  rb,rb), 
 /* 92 */ new Decoder(Opcode.mcomb,  rb,wb), 
 /* 93 */ new Decoder(Opcode.bitb,  rb,rb), 
 /* 94 */ new Decoder(Opcode.clrb,  wb), 
 /* 95 */ new Decoder(Opcode.tstb,  rb), 
 /* 96 */ new Decoder(Opcode.incb,  wb), 
 /* 97 */ new Decoder(Opcode.decb,  wb), 
 /* 98 */ new Decoder(Opcode.cvtbl, rb,wl), 
 /* 99 */ new Decoder(Opcode.cvtbw, rb,ww), 
 /* 9A */ new Decoder(Opcode.movzbl, rb,wl), 
 /* 9B */ new Decoder(Opcode.movzbw, rb,ww),
 /* 9C */ new Decoder(Opcode.rotl,  rb,rl,wl),
 /* 9D */ new Decoder(Opcode.acbb,  InstrClass.ConditionalTransfer, rb,rb,mb,bw), 
 /* 9E */ new Decoder(Opcode.movab,  ab,wl), 
 /* 9F */ new Decoder(Opcode.pushab, ab), 

 /* A0 */ new Decoder(Opcode.addw2, rw,ww), 
 /* A1 */ new Decoder(Opcode.addw3, rw,rw,ww), 
 /* A2 */ new Decoder(Opcode.subw2, rw,ww), 
 /* A3 */ new Decoder(Opcode.subw3, rw,rw,ww), 
 /* A4 */ new Decoder(Opcode.mulw2, rw,ww), 
 /* A5 */ new Decoder(Opcode.mulw3, rw,rw,ww), 
 /* A6 */ new Decoder(Opcode.divw2, rw,ww), 
 /* A7 */ new Decoder(Opcode.divw3, rw,rw,ww), 
 /* A8 */ new Decoder(Opcode.bisw2, rw,ww), 
 /* A9 */ new Decoder(Opcode.bisw3, rw,rw,ww), 
 /* AA */ new Decoder(Opcode.bicw2, rw,ww), 
 /* AB */ new Decoder(Opcode.bicw3, rw,rw,ww), 
 /* AC */ new Decoder(Opcode.xorw2, rw,ww), 
 /* AD */ new Decoder(Opcode.xorw3, rw,rw,ww), 
 /* AE */ new Decoder(Opcode.mnegw, rw,ww),
 /* AF */ new Decoder(Opcode.casew, InstrClass.Transfer, rw,rw,rw), 

 /* B0 */ new Decoder(Opcode.movw, rw,ww), 
 /* B1 */ new Decoder(Opcode.cmpw, rw,rw),
 /* B2 */ new Decoder(Opcode.mcomw, rw,ww), 
 /* B3 */ new Decoder(Opcode.bitw, rw,rw),
 /* B4 */ new Decoder(Opcode.clrw,  ww), 
 /* B5 */ new Decoder(Opcode.tstw,  rw), 
 /* B6 */ new Decoder(Opcode.incw,  ww), 
 /* B7 */ new Decoder(Opcode.decw,  ww), 
 /* B8 */ new Decoder(Opcode.bispsw, rw), 
 /* B9 */ new Decoder(Opcode.bicpsw, rw), 
 /* BA */ new Decoder(Opcode.popr,  -1), 
 /* BB */ new Decoder(Opcode.pushr,  -1), 
 /* BC */ new Decoder(Opcode.chmk,  rw), 
 /* BD */ new Decoder(Opcode.chme,  rw), 
 /* BE */ new Decoder(Opcode.chms,  rw), 
 /* BF */ new Decoder(Opcode.chmu,  rw),
        
 /* C0 */ new Decoder(Opcode.addl2, rl,wl), 
 /* C1 */ new Decoder(Opcode.addl3, rl,rl,wl), 
 /* C2 */ new Decoder(Opcode.subl2, rl,wl),
 /* C3 */ new Decoder(Opcode.subl3, rl,rl,wl),
 /* C4 */ new Decoder(Opcode.mull2, rl,wl), 
 /* C5 */ new Decoder(Opcode.mull3, rl,rl,wl), 
 /* C6 */ new Decoder(Opcode.divl2, rl,wl),
 /* C7 */ new Decoder(Opcode.divl3, rl,rl,wl),
 /* C8 */ new Decoder(Opcode.bisl2, rl,wl),
 /* C9 */ new Decoder(Opcode.bisl3, rl,rl,wl),
 /* CA */ new Decoder(Opcode.bicl2, rl,wl),
 /* CB */ new Decoder(Opcode.bicl3, rl,rl,wl),
 /* CC */ new Decoder(Opcode.xorl2, rl,wl), 
 /* CD */ new Decoder(Opcode.xorl3, rl,rl,wl),
 /* CE */ new Decoder(Opcode.mnegl, rl,wl),
 /* CF */ new Decoder(Opcode.casel, InstrClass.Transfer, rl,rl,rl),
              
 /* D0 */ new Decoder(Opcode.movl, rl,wl), 
 /* D1 */ new Decoder(Opcode.cmpl, rl,rl), 
 /* D2 */ new Decoder(Opcode.mcoml, rl,wl),
 /* D3 */ new Decoder(Opcode.bitl, rl,rl),
 /* D4 */ new Decoder(Opcode.clrl, wl), //  clrf,  -1), 
 /* D5 */ new Decoder(Opcode.tstl, rl), 
 /* D6 */ new Decoder(Opcode.incl, wl), 
 /* D7 */ new Decoder(Opcode.decl, wl), 
 /* D8 */ new Decoder(Opcode.adwc, rl,wl),
 /* D9 */ new Decoder(Opcode.sbwc, rl,ml), 
 /* DA */ new Decoder(Opcode.mtpr,  -1), 
 /* DB */ new Decoder(Opcode.mfpr, rl,wl), 
 /* DC */ new Decoder(Opcode.movpsl,  -1), 
 /* DD */ new Decoder(Opcode.pushl, rl), 
 /* DE */ new Decoder(Opcode.moval, al,wl), // mova,  -1), 
 /* DF */ new Decoder(Opcode.pushal, al), // pushaf,  -1), 

 /* E0 */ new Decoder(Opcode.bbs, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E1 */ new Decoder(Opcode.bbc, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E2 */ new Decoder(Opcode.bbss, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E3 */ new Decoder(Opcode.bbcs, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E4 */ new Decoder(Opcode.bbsc, InstrClass.ConditionalTransfer, rl,vb,bb),
 /* E5 */ new Decoder(Opcode.bbcc, InstrClass.ConditionalTransfer, rl,vb,bb),
 /* E6 */ new Decoder(Opcode.bbssi, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E7 */ new Decoder(Opcode.bbcci, InstrClass.ConditionalTransfer, rl,vb,bb),
 /* E8 */ new Decoder(Opcode.blbs,  InstrClass.ConditionalTransfer, rl,bb), 
 /* E9 */ new Decoder(Opcode.blbc,  InstrClass.ConditionalTransfer, rl,bb), 
 /* EA */ new Decoder(Opcode.ffs,  rl,rb,vb,wl), 
 /* EB */ new Decoder(Opcode.ffc,  rl,rb,vb,wl), 
 /* EC */ new Decoder(Opcode.cmpv,  -1), 
 /* ED */ new Decoder(Opcode.cmpzv,  -1), 
 /* EE */ new Decoder(Opcode.extv,  rl,rb,vb,wl),
 /* EF */ new Decoder(Opcode.extzv, rl,rb,vb,wl),

 /* F0 */ new Decoder(Opcode.insv,  rl,rl,rb,vb), 
 /* F1 */ new Decoder(Opcode.acbl,   InstrClass.ConditionalTransfer, rl,rl,ml,bw),
 /* F2 */ new Decoder(Opcode.aoblss, InstrClass.ConditionalTransfer, rl,ml,bb), 
 /* F3 */ new Decoder(Opcode.aobleq, InstrClass.ConditionalTransfer, rl,ml,bb), 
 /* F4 */ new Decoder(Opcode.sobgeq, InstrClass.ConditionalTransfer, ml,bb), 
 /* F5 */ new Decoder(Opcode.sobgtr, InstrClass.ConditionalTransfer, ml,bb), 
 /* F6 */ new Decoder(Opcode.cvtlb, rl,wb), 
 /* F7 */ new Decoder(Opcode.cvtlw, rl,ww), 
 /* F8 */ new Decoder(Opcode.ashp,  rb,rw,ab,rb,rw,ab),
 /* F9 */ new Decoder(Opcode.cvtlp, rl,rw,ab), 
 /* FA */ new Decoder(Opcode.callg, InstrClass.Transfer|InstrClass.Call, ab,ab), 
 /* FB */ new Decoder(Opcode.calls, InstrClass.Transfer|InstrClass.Call, ab,ab), 
 /* FC */ new Decoder(Opcode.xfc,  -1), 
 /* FD */ new Decoder(Opcode.Invalid), // escd to Digital,  -1), 
 /* FE */ new Decoder(Opcode.Invalid), // esce to Digital,  -1), 
 /* FF */ new Decoder(Opcode.Invalid), // escf to Digital,  -1), 

            };
    }
}