#region License
/* 
 * Copyright (C) 1999-2019 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Reko.Arch.Vax
{
    public partial class VaxDisassembler
    {
        private static Decoder[] twoByteInstructions = new[]
        {
/* 00FD */ new Decoder(Opcode.Reserved, -1),
/* 01FD */ new Decoder(Opcode.Reserved, -1),
/* 02FD */ new Decoder(Opcode.Reserved, -1),
/* 03FD */ new Decoder(Opcode.Reserved, -1),
/* 04FD */ new Decoder(Opcode.Reserved, -1),
/* 05FD */ new Decoder(Opcode.Reserved, -1),
/* 06FD */ new Decoder(Opcode.Reserved, -1),
/* 07FD */ new Decoder(Opcode.Reserved, -1),
/* 08FD */ new Decoder(Opcode.Reserved, -1),
/* 30FD */ new Decoder(Opcode.Reserved, -1),
/* 31FD */ new Decoder(Opcode.mfvp, -1),
/* 32FD */ new Decoder(Opcode.cvtdh, -1),
/* 33FD */ new Decoder(Opcode.cvtgf, -1),
/* 34FD */ new Decoder(Opcode.vldl, -1),
/* 35FD */ new Decoder(Opcode.vgathl, -1),
/* 36FD */ new Decoder(Opcode.vldq, -1),
/* 37FD */ new Decoder(Opcode.vgathq, -1),
/* 38FD */ new Decoder(Opcode.Reserved, -1),
/* 09FD */ new Decoder(Opcode.Reserved, -1),
/* 39FD */ new Decoder(Opcode.Reserved, -1),
/* 0AFD */ new Decoder(Opcode.Reserved, -1),
/* 3AFD */ new Decoder(Opcode.Reserved, -1),
/* 0BFD */ new Decoder(Opcode.Reserved, -1),
/* 3BFD */ new Decoder(Opcode.Reserved, -1),
/* 0CFD */ new Decoder(Opcode.Reserved, -1),
/* 3CFD */ new Decoder(Opcode.Reserved, -1),
/* 0DFD */ new Decoder(Opcode.Reserved, -1),
/* 3DFD */ new Decoder(Opcode.Reserved, -1),
/* 0EFD */ new Decoder(Opcode.Reserved, -1),
/* 3EFD */ new Decoder(Opcode.Reserved, -1),
/* 0FFD */ new Decoder(Opcode.Reserved, -1),
/* 3FFD */ new Decoder(Opcode.Reserved, -1),
/* 10FD */ new Decoder(Opcode.Reserved, -1),
/* 40FD */ new Decoder(Opcode.addg2, -1),
/* 11FD */ new Decoder(Opcode.Reserved, -1),
/* 41FD */ new Decoder(Opcode.addg3, -1),
/* 12FD */ new Decoder(Opcode.Reserved, -1),
/* 42FD */ new Decoder(Opcode.subg2, -1),
/* 13FD */ new Decoder(Opcode.Reserved, -1),
/* 43FD */ new Decoder(Opcode.subg3, -1),
/* 14FD */ new Decoder(Opcode.Reserved, -1),
/* 44FD */ new Decoder(Opcode.mulg2, -1),
/* 15FD */ new Decoder(Opcode.Reserved, -1),
/* 45FD */ new Decoder(Opcode.mulg3, -1),
/* 16FD */ new Decoder(Opcode.Reserved, -1),
/* 46FD */ new Decoder(Opcode.divg2, -1),
/* 17FD */ new Decoder(Opcode.Reserved, -1),
/* 47FD */ new Decoder(Opcode.divg3, -1),
/* 18FD */ new Decoder(Opcode.Reserved, -1),
/* 48FD */ new Decoder(Opcode.cvtgb, -1),
/* 19FD */ new Decoder(Opcode.Reserved, -1),
/* 49FD */ new Decoder(Opcode.cvtgw, -1),
/* 1AFD */ new Decoder(Opcode.Reserved, -1),
/* 4AFD */ new Decoder(Opcode.cvtgl, -1),
/* 1BFD */ new Decoder(Opcode.Reserved, -1),
/* 4BFD */ new Decoder(Opcode.cvtrgl, -1),
/* 1CFD */ new Decoder(Opcode.Reserved, -1),
/* 4CFD */ new Decoder(Opcode.cvtbg, -1),
/* 1DFD */ new Decoder(Opcode.Reserved, -1),
/* 4DFD */ new Decoder(Opcode.cvtwg, -1),
/* 1EFD */ new Decoder(Opcode.Reserved, -1),
/* 4EFD */ new Decoder(Opcode.cvtlg, -1),
/* 1FFD */ new Decoder(Opcode.Reserved, -1),
/* 4FFD */ new Decoder(Opcode.acbg,  rg,rg,mg,bw),
/* 20FD */ new Decoder(Opcode.Reserved, -1),
/* 50FD */ new Decoder(Opcode.movg, -1),
/* 21FD */ new Decoder(Opcode.Reserved, -1),
/* 51FD */ new Decoder(Opcode.cmpg, -1),
/* 22FD */ new Decoder(Opcode.Reserved, -1),
/* 52FD */ new Decoder(Opcode.mnegg, -1),
/* 23FD */ new Decoder(Opcode.Reserved, -1),
/* 53FD */ new Decoder(Opcode.tstg, -1),
/* 24FD */ new Decoder(Opcode.Reserved, -1),
/* 54FD */ new Decoder(Opcode.emodg,  rg,rb,rd,wl,wg),
/* 25FD */ new Decoder(Opcode.Reserved, -1),
/* 55FD */ new Decoder(Opcode.polyg,  rg,rw,ab), 
/* 26FD */ new Decoder(Opcode.Reserved, -1),
/* 56FD */ new Decoder(Opcode.cvtgh, -1),
/* 27FD */ new Decoder(Opcode.Reserved, -1),
/* 57FD */ new Decoder(Opcode.Reserved, -1),
/* 28FD */ new Decoder(Opcode.Reserved, -1),
/* 58FD */ new Decoder(Opcode.Reserved, -1),
/* 29FD */ new Decoder(Opcode.Reserved, -1),
/* 59FD */ new Decoder(Opcode.Reserved, -1),
/* 2AFD */ new Decoder(Opcode.Reserved, -1),
/* 5AFD */ new Decoder(Opcode.Reserved, -1),
/* 2BFD */ new Decoder(Opcode.Reserved, -1),
/* 5BFD */ new Decoder(Opcode.Reserved, -1),
/* 2CFD */ new Decoder(Opcode.Reserved, -1),
/* 5CFD */ new Decoder(Opcode.Reserved, -1),
/* 2DFD */ new Decoder(Opcode.Reserved, -1),
/* 5DFD */ new Decoder(Opcode.Reserved, -1),
/* 2EFD */ new Decoder(Opcode.Reserved, -1),
/* 5EFD */ new Decoder(Opcode.Reserved, -1),
/* 2FFD */ new Decoder(Opcode.Reserved, -1),
/* 5FFD */ new Decoder(Opcode.Reserved, -1),
/* 60FD */ new Decoder(Opcode.addh2, rh,wh),
/* 90FD */ new Decoder(Opcode.Reserved, -1),
/* 61FD */ new Decoder(Opcode.addh3, rh,rh,wh),
/* 91FD */ new Decoder(Opcode.Reserved, -1),
/* 62FD */ new Decoder(Opcode.subh2, rh,wh),
/* 92FD */ new Decoder(Opcode.Reserved, -1),
/* 63FD */ new Decoder(Opcode.subh3, rh,rh,wh),
/* 93FD */ new Decoder(Opcode.Reserved, -1),
/* 64FD */ new Decoder(Opcode.mulh2, rh,wh),
/* 94FD */ new Decoder(Opcode.Reserved, -1),
/* 65FD */ new Decoder(Opcode.mulh3, rh,rh,wh),
/* 95FD */ new Decoder(Opcode.Reserved, -1),
/* 66FD */ new Decoder(Opcode.divh2, rh,wh),
/* 96FD */ new Decoder(Opcode.Reserved, -1),
/* 67FD */ new Decoder(Opcode.divh3, rh,rh,wh),
/* 97FD */ new Decoder(Opcode.Reserved, -1),
/* 68FD */ new Decoder(Opcode.cvthb, -1),
/* 98FD */ new Decoder(Opcode.cvtfh, -1),
/* 69FD */ new Decoder(Opcode.cvthw, -1),
/* 99FD */ new Decoder(Opcode.cvtfg, -1),
/* 6AFD */ new Decoder(Opcode.cvthl, -1),
/* 9AFD */ new Decoder(Opcode.Reserved, -1),
/* 6BFD */ new Decoder(Opcode.cvtrhl, -1),
/* 9BFD */ new Decoder(Opcode.Reserved, -1),
/* 6CFD */ new Decoder(Opcode.cvtbh, -1),
/* 9CFD */ new Decoder(Opcode.vstl, -1),
/* 6DFD */ new Decoder(Opcode.cvtwh, -1),
/* 9DFD */ new Decoder(Opcode.vscatl, -1),
/* 6EFD */ new Decoder(Opcode.cvtlh, -1),
/* 9EFD */ new Decoder(Opcode.vstq, -1),
/* 6FFD */ new Decoder(Opcode.acbh,  rh,rh,mh,bw),
/* 9FFD */ new Decoder(Opcode.vscatq, -1),
/* 70FD */ new Decoder(Opcode.movh, -1),
/* 71FD */ new Decoder(Opcode.cmph, -1),
/* 72FD */ new Decoder(Opcode.mnegh, -1),
/* 73FD */ new Decoder(Opcode.tsth, -1),
/* 74FD */ new Decoder(Opcode.emodh,  rh,rb,rd,wl,wh),
/* 75FD */ new Decoder(Opcode.polyh,  rh,rw,ab), 
/* 76FD */ new Decoder(Opcode.cvthg, -1),
/* 77FD */ new Decoder(Opcode.Reserved, -1),
/* 78FD */ new Decoder(Opcode.Reserved, -1),
/* 79FD */ new Decoder(Opcode.Reserved, -1),
/* 7AFD */ new Decoder(Opcode.Reserved, -1),
/* 7BFD */ new Decoder(Opcode.Reserved, -1),
/* 7CFD */ new Decoder(Opcode.clrh, -1), // clro, -1),
/* 7DFD */ new Decoder(Opcode.movo, -1),
/* 7EFD */ new Decoder(Opcode.movah, -1), //  movao, -1),
/* 7FFD */ new Decoder(Opcode.pushah, -1), // pushao, -1),


/* 80FD */ new Decoder(Opcode.vvaddl, -1),
/* 81FD */ new Decoder(Opcode.vsaddl, -1),
/* 82FD */ new Decoder(Opcode.vvaddg, -1),
/* 83FD */ new Decoder(Opcode.vsaddg, -1),
/* 84FD */ new Decoder(Opcode.vvaddf, -1),
/* 85FD */ new Decoder(Opcode.vsaddf, -1),
/* 86FD */ new Decoder(Opcode.vvaddd, -1),
/* 87FD */ new Decoder(Opcode.vsaddd, -1),
/* 88FD */ new Decoder(Opcode.vvsubl, -1),
/* 89FD */ new Decoder(Opcode.vssubl, -1),
/* 8AFD */ new Decoder(Opcode.vvsubg, -1),
/* 8BFD */ new Decoder(Opcode.vssubg, -1),
/* 8CFD */ new Decoder(Opcode.vvsubf, -1),
/* 8DFD */ new Decoder(Opcode.vssubf, -1),
/* 8EFD */ new Decoder(Opcode.vvsubd, -1),
/* 8FFD */ new Decoder(Opcode.vssubd, -1),

/* A0FD */ new Decoder(Opcode.vvmull, -1),
/* A1FD */ new Decoder(Opcode.vsmull, -1),
/* A2FD */ new Decoder(Opcode.vvmulg, -1),
/* A3FD */ new Decoder(Opcode.vsmulg, -1),
/* A4FD */ new Decoder(Opcode.vvmulf, -1),
/* A5FD */ new Decoder(Opcode.vsmulf, -1),
/* A6FD */ new Decoder(Opcode.vvmuld, -1),
/* A7FD */ new Decoder(Opcode.vsmuld, -1),
/* A8FD */ new Decoder(Opcode.vsync, -1),
/* A9FD */ new Decoder(Opcode.mtvp, -1),
/* AAFD */ new Decoder(Opcode.vvdivg, -1),
/* ABFD */ new Decoder(Opcode.vsdivg, -1),
/* ACFD */ new Decoder(Opcode.vvdivf, -1),
/* ADFD */ new Decoder(Opcode.vsdivf, -1),
/* AEFD */ new Decoder(Opcode.vvdivd, -1),
/* AFFD */ new Decoder(Opcode.vsdivd, -1),

/* B0FD */ new Decoder(Opcode.Reserved, -1),
/* B1FD */ new Decoder(Opcode.Reserved, -1),
/* B2FD */ new Decoder(Opcode.Reserved, -1),
/* B3FD */ new Decoder(Opcode.Reserved, -1),
/* B4FD */ new Decoder(Opcode.Reserved, -1),
/* B5FD */ new Decoder(Opcode.Reserved, -1),
/* B6FD */ new Decoder(Opcode.Reserved, -1),
/* B7FD */ new Decoder(Opcode.Reserved, -1),
/* B8FD */ new Decoder(Opcode.Reserved, -1),
/* B9FD */ new Decoder(Opcode.Reserved, -1),
/* BAFD */ new Decoder(Opcode.Reserved, -1),
/* BBFD */ new Decoder(Opcode.Reserved, -1),
/* BCFD */ new Decoder(Opcode.Reserved, -1),
/* BDFD */ new Decoder(Opcode.Reserved, -1),
/* BEFD */ new Decoder(Opcode.Reserved, -1),
/* BFFD */ new Decoder(Opcode.Reserved, -1),

/* C0FD */ new Decoder(Opcode.vvcmpl, -1),
/* C1FD */ new Decoder(Opcode.vscmpl, -1),
/* C2FD */ new Decoder(Opcode.vvcmpg, -1),
/* C3FD */ new Decoder(Opcode.vscmpg, -1),
/* C4FD */ new Decoder(Opcode.vvcmpf, -1),
/* C5FD */ new Decoder(Opcode.vscmpf, -1),
/* C6FD */ new Decoder(Opcode.vvcmpd, -1),
/* C7FD */ new Decoder(Opcode.vscmpd, -1),
/* C8FD */ new Decoder(Opcode.vvbisl, -1),
/* C9FD */ new Decoder(Opcode.vsbisl, -1),
/* CAFD */ new Decoder(Opcode.Invalid, -1),
/* CBFD */ new Decoder(Opcode.Invalid, -1),
/* CCFD */ new Decoder(Opcode.vvbicl, -1),
/* CDFD */ new Decoder(Opcode.vsbicl, -1),
/* CEFD */ new Decoder(Opcode.Invalid, -1),
/* CFFD */ new Decoder(Opcode.Invalid, -1),

/* D0FD */ new Decoder(Opcode.Reserved, -1),
/* D1FD */ new Decoder(Opcode.Reserved, -1),
/* D2FD */ new Decoder(Opcode.Reserved, -1),
/* D3FD */ new Decoder(Opcode.Reserved, -1),
/* D4FD */ new Decoder(Opcode.Reserved, -1),
/* D5FD */ new Decoder(Opcode.Reserved, -1),
/* D6FD */ new Decoder(Opcode.Reserved, -1),
/* D7FD */ new Decoder(Opcode.Reserved, -1),
/* D8FD */ new Decoder(Opcode.Reserved, -1),
/* D9FD */ new Decoder(Opcode.Reserved, -1),
/* DAFD */ new Decoder(Opcode.Reserved, -1),
/* DBFD */ new Decoder(Opcode.Reserved, -1),
/* DCFD */ new Decoder(Opcode.Reserved, -1),
/* DDFD */ new Decoder(Opcode.Reserved, -1),
/* DEFD */ new Decoder(Opcode.Reserved, -1),
/* DFFD */ new Decoder(Opcode.Reserved, -1),

/* E0FD */ new Decoder(Opcode.vvsrll, -1),
/* E1FD */ new Decoder(Opcode.vssrll, -1),
/* E2FD */ new Decoder(Opcode.Invalid, -1),
/* E3FD */ new Decoder(Opcode.Invalid, -1),
/* E4FD */ new Decoder(Opcode.vvslll, -1),
/* E5FD */ new Decoder(Opcode.vsslll, -1),
/* E6FD */ new Decoder(Opcode.Invalid, -1),
/* E7FD */ new Decoder(Opcode.Invalid, -1),
/* E8FD */ new Decoder(Opcode.vvxorl, -1),
/* E9FD */ new Decoder(Opcode.vsxorl, -1),
/* EAFD */ new Decoder(Opcode.Invalid, -1),
/* EBFD */ new Decoder(Opcode.Invalid, -1),
/* ECFD */ new Decoder(Opcode.vvcvt, -1),
/* EDFD */ new Decoder(Opcode.iota, -1),
/* EEFD */ new Decoder(Opcode.vvmerge, -1),
/* EFFD */ new Decoder(Opcode.vsmerge, -1),

/* F0FD */ new Decoder(Opcode.Reserved, -1),
/* F1FD */ new Decoder(Opcode.Reserved, -1),
/* F2FD */ new Decoder(Opcode.Reserved, -1),
/* F3FD */ new Decoder(Opcode.Reserved, -1),
/* F4FD */ new Decoder(Opcode.Reserved, -1),
/* F5FD */ new Decoder(Opcode.Reserved, -1),
/* F6FD */ new Decoder(Opcode.cvthf, -1),
/* F7FD */ new Decoder(Opcode.cvthd, -1),
/* F8FD */ new Decoder(Opcode.Reserved, -1),
/* F9FD */ new Decoder(Opcode.Reserved, -1),
/* FAFD */ new Decoder(Opcode.Reserved, -1),
/* FBFD */ new Decoder(Opcode.Reserved, -1),
/* FCFD */ new Decoder(Opcode.Reserved, -1),
/* FCFE */ new Decoder(Opcode.Reserved, -1),
/* FCFF */ new Decoder(Opcode.Reserved, -1),

/* FDFF */ new Decoder(Opcode.bugl, -1),
/* FEFF */ new Decoder(Opcode.bugw, -1),
/* FFFF */ new Decoder(Opcode.Reserved   , -1), // invalid opcode, basically

    };
    }
}
