#region License
/* 
 * Copyright (C) 2018-2019 Stefano Moioli <smxdev4@gmail.com>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Reko.ImageLoaders.Xex
{
    public class Enums
    {
        [Flags]
        public enum PESectionFlags : UInt32 {
            IMAGE_SCN_TYPE_NO_PAD = 0x00000008,
            IMAGE_SCN_CNT_CODE = 0x00000020,
            IMAGE_SCN_CNT_INITIALIZED_DATA = 0x00000040,
            IMAGE_SCN_CNT_UNINITIALIZED_DATA = 0x00000080,
            IMAGE_SCN_LNK_OTHER = 0x00000100,
            IMAGE_SCN_LNK_INFO = 0x00000200,
            IMAGE_SCN_LNK_REMOVE = 0x00000800,
            IMAGE_SCN_LNK_COMDAT = 0x00001000,
            IMAGE_SCN_NO_DEFER_SPEC_EXC = 0x00004000,
            IMAGE_SCN_GPREL = 0x00008000,
            IMAGE_SCN_MEM_FARDATA = 0x00008000,
            IMAGE_SCN_MEM_PURGEABLE = 0x00020000,
            IMAGE_SCN_MEM_16BIT = 0x00020000,
            IMAGE_SCN_MEM_LOCKED = 0x00040000,
            IMAGE_SCN_MEM_PRELOAD = 0x00080000,
            IMAGE_SCN_ALIGN_1BYTES = 0x00100000,
            IMAGE_SCN_ALIGN_2BYTES = 0x00200000,
            IMAGE_SCN_ALIGN_4BYTES = 0x00300000,
            IMAGE_SCN_ALIGN_8BYTES = 0x00400000,
            IMAGE_SCN_ALIGN_16BYTES = 0x00500000,
            IMAGE_SCN_ALIGN_32BYTES = 0x00600000,
            IMAGE_SCN_ALIGN_64BYTES = 0x00700000,
            IMAGE_SCN_ALIGN_128BYTES = 0x00800000,
            IMAGE_SCN_ALIGN_256BYTES = 0x00900000,
            IMAGE_SCN_ALIGN_512BYTES = 0x00A00000,
            IMAGE_SCN_ALIGN_1024BYTES = 0x00B00000,
            IMAGE_SCN_ALIGN_2048BYTES = 0x00C00000,
            IMAGE_SCN_ALIGN_4096BYTES = 0x00D00000,
            IMAGE_SCN_ALIGN_8192BYTES = 0x00E00000,
            IMAGE_SCN_ALIGN_MASK = 0x00F00000,
            IMAGE_SCN_LNK_NRELOC_OVFL = 0x01000000,
            IMAGE_SCN_MEM_DISCARDABLE = 0x02000000,
            IMAGE_SCN_MEM_NOT_CACHED = 0x04000000,
            IMAGE_SCN_MEM_NOT_PAGED = 0x08000000,
            IMAGE_SCN_MEM_SHARED = 0x10000000,
            IMAGE_SCN_MEM_EXECUTE = 0x20000000,
            IMAGE_SCN_MEM_READ = 0x40000000,
            IMAGE_SCN_MEM_WRITE = 0x80000000
        }

        public enum XEXHeaderKeys : UInt32
        {
            XEX_HEADER_RESOURCE_INFO = 0x000002FF,
            XEX_HEADER_FILE_FORMAT_INFO = 0x000003FF,
            XEX_HEADER_DELTA_PATCH_DESCRIPTOR = 0x000005FF,
            XEX_HEADER_BASE_REFERENCE = 0x00000405,
            XEX_HEADER_BOUNDING_PATH = 0x000080FF,
            XEX_HEADER_DEVICE_ID = 0x00008105,
            XEX_HEADER_ORIGINAL_BASE_ADDRESS = 0x00010001,
            XEX_HEADER_ENTRY_POINT = 0x00010100,
            XEX_HEADER_IMAGE_BASE_ADDRESS = 0x00010201,
            XEX_HEADER_IMPORT_LIBRARIES = 0x000103FF,
            XEX_HEADER_CHECKSUM_TIMESTAMP = 0x00018002,
            XEX_HEADER_ENABLED_FOR_CALLCAP = 0x00018102,
            XEX_HEADER_ENABLED_FOR_FASTCAP = 0x00018200,
            XEX_HEADER_ORIGINAL_PE_NAME = 0x000183FF,
            XEX_HEADER_STATIC_LIBRARIES = 0x000200FF,
            XEX_HEADER_TLS_INFO = 0x00020104,
            XEX_HEADER_DEFAULT_STACK_SIZE = 0x00020200,
            XEX_HEADER_DEFAULT_FILESYSTEM_CACHE_SIZE = 0x00020301,
            XEX_HEADER_DEFAULT_HEAP_SIZE = 0x00020401,
            XEX_HEADER_PAGE_HEAP_SIZE_AND_FLAGS = 0x00028002,
            XEX_HEADER_SYSTEM_FLAGS = 0x00030000,
            XEX_HEADER_EXECUTION_INFO = 0x00040006,
            XEX_HEADER_TITLE_WORKSPACE_SIZE = 0x00040201,
            XEX_HEADER_GAME_RATINGS = 0x00040310,
            XEX_HEADER_LAN_KEY = 0x00040404,
            XEX_HEADER_XBOX360_LOGO = 0x000405FF,
            XEX_HEADER_MULTIDISC_MEDIA_IDS = 0x000406FF,
            XEX_HEADER_ALTERNATE_TITLE_IDS = 0x000407FF,
            XEX_HEADER_ADDITIONAL_TITLE_MEMORY = 0x00040801,
            XEX_HEADER_EXPORTS_BY_NAME = 0x00E10402,
        };

        public enum XEXSystemFlags : UInt32
        {
            XEX_SYSTEM_NO_FORCED_REBOOT = 0x00000001,
            XEX_SYSTEM_FOREGROUND_TASKS = 0x00000002,
            XEX_SYSTEM_NO_ODD_MAPPING = 0x00000004,
            XEX_SYSTEM_HANDLE_MCE_INPUT = 0x00000008,
            XEX_SYSTEM_RESTRICTED_HUD_FEATURES = 0x00000010,
            XEX_SYSTEM_HANDLE_GAMEPAD_DISCONNECT = 0x00000020,
            XEX_SYSTEM_INSECURE_SOCKETS = 0x00000040,
            XEX_SYSTEM_XBOX1_INTEROPERABILITY = 0x00000080,
            XEX_SYSTEM_DASH_CONTEXT = 0x00000100,
            XEX_SYSTEM_USES_GAME_VOICE_CHANNEL = 0x00000200,
            XEX_SYSTEM_PAL50_INCOMPATIBLE = 0x00000400,
            XEX_SYSTEM_INSECURE_UTILITY_DRIVE = 0x00000800,
            XEX_SYSTEM_XAM_HOOKS = 0x00001000,
            XEX_SYSTEM_ACCESS_PII = 0x00002000,
            XEX_SYSTEM_CROSS_PLATFORM_SYSTEM_LINK = 0x00004000,
            XEX_SYSTEM_MULTIDISC_SWAP = 0x00008000,
            XEX_SYSTEM_MULTIDISC_INSECURE_MEDIA = 0x00010000,
            XEX_SYSTEM_AP25_MEDIA = 0x00020000,
            XEX_SYSTEM_NO_CONFIRM_EXIT = 0x00040000,
            XEX_SYSTEM_ALLOW_BACKGROUND_DOWNLOAD = 0x00080000,
            XEX_SYSTEM_CREATE_PERSISTABLE_RAMDRIVE = 0x00100000,
            XEX_SYSTEM_INHERIT_PERSISTENT_RAMDRIVE = 0x00200000,
            XEX_SYSTEM_ALLOW_HUD_VIBRATION = 0x00400000,
            XEX_SYSTEM_ACCESS_UTILITY_PARTITIONS = 0x00800000,
            XEX_SYSTEM_IPTV_INPUT_SUPPORTED = 0x01000000,
            XEX_SYSTEM_PREFER_BIG_BUTTON_INPUT = 0x02000000,
            XEX_SYSTEM_ALLOW_EXTENDED_SYSTEM_RESERVATION = 0x04000000,
            XEX_SYSTEM_MULTIDISC_CROSS_TITLE = 0x08000000,
            XEX_SYSTEM_INSTALL_INCOMPATIBLE = 0x10000000,
            XEX_SYSTEM_ALLOW_AVATAR_GET_METADATA_BY_XUID = 0x20000000,
            XEX_SYSTEM_ALLOW_CONTROLLER_SWAPPING = 0x40000000,
            XEX_SYSTEM_DASH_EXTENSIBILITY_MODULE = 0x80000000,
            // TODO: figure out how stored
            /*XEX_SYSTEM_ALLOW_NETWORK_READ_CANCEL            = 0x0,
            XEX_SYSTEM_UNINTERRUPTABLE_READS                = 0x0,
            XEX_SYSTEM_REQUIRE_FULL_EXPERIENCE              = 0x0,
            XEX_SYSTEM_GAME_VOICE_REQUIRED_UI               = 0x0,
            XEX_SYSTEM_CAMERA_ANGLE                         = 0x0,
            XEX_SYSTEM_SKELETAL_TRACKING_REQUIRED           = 0x0,
            XEX_SYSTEM_SKELETAL_TRACKING_SUPPORTED          = 0x0,*/
        };

        public enum XEXEncryptionType : UInt16
        {
            XEX_ENCRYPTION_NONE = 0,
            XEX_ENCRYPTION_NORMAL = 1,
        };

        public enum XEXCompressionType : UInt16
        {
            XEX_COMPRESSION_NONE = 0,
            XEX_COMPRESSION_BASIC = 1,
            XEX_COMPRESSION_NORMAL = 2,
            XEX_COMPRESSION_DELTA = 3,
        };

    }
}
