#!/usr/bin/env ruby
#
# Copyright 2013 Wincent Colaiuta. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

lib  = File.expand_path('../ruby', File.dirname(__FILE__))
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)

require 'command-t/ext'
require 'benchmark'
require 'ostruct'
require 'yaml'

yaml = File.expand_path('../data/benchmark.yml', File.dirname(__FILE__))
data = YAML.load_file(yaml)

puts "Starting benchmark run (PID: #{Process.pid})"

Benchmark.bmbm do |b|
  data['tests']['match'].each do |test|
    b.report(test['name']) do
      test['paths'].each do |path|
        test['times'].times do
          test['queries'].each { |query| CommandT::Match.new(path, query) }
        end
      end
    end
  end

  data['tests']['matcher'].each do |test|
    scanner = OpenStruct.new(:paths => test['paths'])
    matcher = CommandT::Matcher.new(scanner)
    b.report(test['name']) do
      test['times'].times do
        test['queries'].each { |query| matcher.matches_for(query) }
      end
    end
  end
end
