/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SWIFTLister helps list SWIFTs.
type SWIFTLister interface {
	// List lists all SWIFTs in the indexer.
	List(selector labels.Selector) (ret []*v1.SWIFT, err error)
	// SWIFTs returns an object that can list and get SWIFTs.
	SWIFTs(namespace string) SWIFTNamespaceLister
	SWIFTListerExpansion
}

// sWIFTLister implements the SWIFTLister interface.
type sWIFTLister struct {
	indexer cache.Indexer
}

// NewSWIFTLister returns a new SWIFTLister.
func NewSWIFTLister(indexer cache.Indexer) SWIFTLister {
	return &sWIFTLister{indexer: indexer}
}

// List lists all SWIFTs in the indexer.
func (s *sWIFTLister) List(selector labels.Selector) (ret []*v1.SWIFT, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SWIFT))
	})
	return ret, err
}

// SWIFTs returns an object that can list and get SWIFTs.
func (s *sWIFTLister) SWIFTs(namespace string) SWIFTNamespaceLister {
	return sWIFTNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SWIFTNamespaceLister helps list and get SWIFTs.
type SWIFTNamespaceLister interface {
	// List lists all SWIFTs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.SWIFT, err error)
	// Get retrieves the SWIFT from the indexer for a given namespace and name.
	Get(name string) (*v1.SWIFT, error)
	SWIFTNamespaceListerExpansion
}

// sWIFTNamespaceLister implements the SWIFTNamespaceLister
// interface.
type sWIFTNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SWIFTs in the indexer for a given namespace.
func (s sWIFTNamespaceLister) List(selector labels.Selector) (ret []*v1.SWIFT, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SWIFT))
	})
	return ret, err
}

// Get retrieves the SWIFT from the indexer for a given namespace and name.
func (s sWIFTNamespaceLister) Get(name string) (*v1.SWIFT, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("swift"), name)
	}
	return obj.(*v1.SWIFT), nil
}
