# Bundler benchmark

This is a performance benchmark of the following bundlers:

- Bun
- esbuild
- Parcel 2
- Rollup + Terser
- Webpack

It is an exact copy of [`esbuild`'s benchmark](https://github.com/evanw/esbuild/blob/main/Makefile), aside from the fact that Bun [has been added](https://github.com/colinhacks/esbuild/commit/1b928b7981aa7edfadf77fcf8931bb8d6f38cd96). The benchmark bundles 10 copies of the large [three.js](https://threejs.org/), with minification and source maps enabled.

To run the benchmark:

```sh
$ chmod +x run-bench.sh
$ ./run-bench.sh
```

Various output will be written to the console by each bundler. Scan through the results for lines that look like this underneath each bundler output:

```sh
real <number>
user <number>
sys <number>
```

These lines are generated by the `time` command which is used to benchmark each build.

## Results

The `real` results, as run on a 16-inch M1 Macbook Pro:

| Bundler | Time   |
| ------- | ------ |
| Bun     | 0.17s  |
| esbuild | 0.33s  |
| Rollup  | 18.82s |
| Webpack | 26.21  |
| Parcel  | 17.95s |
