pub const wchar_t = c_int;
pub const la_int64_t = i64;
pub const la_ssize_t = isize;
pub const struct_archive = opaque {};
pub const struct_archive_entry = opaque {};
pub const archive = struct_archive;
pub const archive_entry = struct_archive_entry;
const mode_t = @import("std").c.mode_t;
const FILE = @import("std").c.FILE;
// const time_t = @import("std").c.time_t;
const dev_t = @import("std").c.dev_t;

pub const FileType = enum(mode_t) {
    regular = 0o100000,
    link = 0o120000,
    socket = 0o140000,
    character_oriented_device = 0o020000,
    block_oriented_device = 0o060000,
    directory = 0o040000,
    fifo = 0o010000,
};

pub const SymlinkType = enum(c_int) {
    none = 0,
    file = 1,
    directory = 2,
};
pub const time_t = isize;

pub const ARCHIVE_VERSION_ONLY_STRING = "3.5.3dev";
pub const ARCHIVE_VERSION_STRING = "libarchive " ++ ARCHIVE_VERSION_ONLY_STRING;
pub const ARCHIVE_EOF = @as(c_int, 1);
pub const ARCHIVE_OK = @as(c_int, 0);
pub const ARCHIVE_RETRY = -@as(c_int, 10);
pub const ARCHIVE_WARN = -@as(c_int, 20);
pub const ARCHIVE_FAILED = -@as(c_int, 25);
pub const ARCHIVE_FATAL = -@as(c_int, 30);
pub const ARCHIVE_FILTER_NONE = @as(c_int, 0);
pub const ARCHIVE_FILTER_GZIP = @as(c_int, 1);
pub const ARCHIVE_FILTER_BZIP2 = @as(c_int, 2);
pub const ARCHIVE_FILTER_COMPRESS = @as(c_int, 3);
pub const ARCHIVE_FILTER_PROGRAM = @as(c_int, 4);
pub const ARCHIVE_FILTER_LZMA = @as(c_int, 5);
pub const ARCHIVE_FILTER_XZ = @as(c_int, 6);
pub const ARCHIVE_FILTER_UU = @as(c_int, 7);
pub const ARCHIVE_FILTER_RPM = @as(c_int, 8);
pub const ARCHIVE_FILTER_LZIP = @as(c_int, 9);
pub const ARCHIVE_FILTER_LRZIP = @as(c_int, 10);
pub const ARCHIVE_FILTER_LZOP = @as(c_int, 11);
pub const ARCHIVE_FILTER_GRZIP = @as(c_int, 12);
pub const ARCHIVE_FILTER_LZ4 = @as(c_int, 13);
pub const ARCHIVE_FILTER_ZSTD = @as(c_int, 14);
pub const ARCHIVE_COMPRESSION_NONE = ARCHIVE_FILTER_NONE;
pub const ARCHIVE_COMPRESSION_GZIP = ARCHIVE_FILTER_GZIP;
pub const ARCHIVE_COMPRESSION_BZIP2 = ARCHIVE_FILTER_BZIP2;
pub const ARCHIVE_COMPRESSION_COMPRESS = ARCHIVE_FILTER_COMPRESS;
pub const ARCHIVE_COMPRESSION_PROGRAM = ARCHIVE_FILTER_PROGRAM;
pub const ARCHIVE_COMPRESSION_LZMA = ARCHIVE_FILTER_LZMA;
pub const ARCHIVE_COMPRESSION_XZ = ARCHIVE_FILTER_XZ;
pub const ARCHIVE_COMPRESSION_UU = ARCHIVE_FILTER_UU;
pub const ARCHIVE_COMPRESSION_RPM = ARCHIVE_FILTER_RPM;
pub const ARCHIVE_COMPRESSION_LZIP = ARCHIVE_FILTER_LZIP;
pub const ARCHIVE_COMPRESSION_LRZIP = ARCHIVE_FILTER_LRZIP;
pub const ARCHIVE_FORMAT_BASE_MASK = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0xff0000, .hexadecimal);
pub const ARCHIVE_FORMAT_CPIO = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x10000, .hexadecimal);
pub const ARCHIVE_FORMAT_CPIO_POSIX = ARCHIVE_FORMAT_CPIO | @as(c_int, 1);
pub const ARCHIVE_FORMAT_CPIO_BIN_LE = ARCHIVE_FORMAT_CPIO | @as(c_int, 2);
pub const ARCHIVE_FORMAT_CPIO_BIN_BE = ARCHIVE_FORMAT_CPIO | @as(c_int, 3);
pub const ARCHIVE_FORMAT_CPIO_SVR4_NOCRC = ARCHIVE_FORMAT_CPIO | @as(c_int, 4);
pub const ARCHIVE_FORMAT_CPIO_SVR4_CRC = ARCHIVE_FORMAT_CPIO | @as(c_int, 5);
pub const ARCHIVE_FORMAT_CPIO_AFIO_LARGE = ARCHIVE_FORMAT_CPIO | @as(c_int, 6);
pub const ARCHIVE_FORMAT_CPIO_PWB = ARCHIVE_FORMAT_CPIO | @as(c_int, 7);
pub const ARCHIVE_FORMAT_SHAR = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x20000, .hexadecimal);
pub const ARCHIVE_FORMAT_SHAR_BASE = ARCHIVE_FORMAT_SHAR | @as(c_int, 1);
pub const ARCHIVE_FORMAT_SHAR_DUMP = ARCHIVE_FORMAT_SHAR | @as(c_int, 2);
pub const ARCHIVE_FORMAT_TAR = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x30000, .hexadecimal);
pub const ARCHIVE_FORMAT_TAR_USTAR = ARCHIVE_FORMAT_TAR | @as(c_int, 1);
pub const ARCHIVE_FORMAT_TAR_PAX_INTERCHANGE = ARCHIVE_FORMAT_TAR | @as(c_int, 2);
pub const ARCHIVE_FORMAT_TAR_PAX_RESTRICTED = ARCHIVE_FORMAT_TAR | @as(c_int, 3);
pub const ARCHIVE_FORMAT_TAR_GNUTAR = ARCHIVE_FORMAT_TAR | @as(c_int, 4);
pub const ARCHIVE_FORMAT_ISO9660 = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x40000, .hexadecimal);
pub const ARCHIVE_FORMAT_ISO9660_ROCKRIDGE = ARCHIVE_FORMAT_ISO9660 | @as(c_int, 1);
pub const ARCHIVE_FORMAT_ZIP = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x50000, .hexadecimal);
pub const ARCHIVE_FORMAT_EMPTY = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x60000, .hexadecimal);
pub const ARCHIVE_FORMAT_AR = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x70000, .hexadecimal);
pub const ARCHIVE_FORMAT_AR_GNU = ARCHIVE_FORMAT_AR | @as(c_int, 1);
pub const ARCHIVE_FORMAT_AR_BSD = ARCHIVE_FORMAT_AR | @as(c_int, 2);
pub const ARCHIVE_FORMAT_MTREE = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x80000, .hexadecimal);
pub const ARCHIVE_FORMAT_RAW = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x90000, .hexadecimal);
pub const ARCHIVE_FORMAT_XAR = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0xA0000, .hexadecimal);
pub const ARCHIVE_FORMAT_LHA = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0xB0000, .hexadecimal);
pub const ARCHIVE_FORMAT_CAB = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0xC0000, .hexadecimal);
pub const ARCHIVE_FORMAT_RAR = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0xD0000, .hexadecimal);
pub const ARCHIVE_FORMAT_7ZIP = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0xE0000, .hexadecimal);
pub const ARCHIVE_FORMAT_WARC = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0xF0000, .hexadecimal);
pub const ARCHIVE_FORMAT_RAR_V5 = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x100000, .hexadecimal);
pub const ARCHIVE_READ_FORMAT_CAPS_NONE = @as(c_int, 0);
pub const ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_DATA = @as(c_int, 1) << @as(c_int, 0);
pub const ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_METADATA = @as(c_int, 1) << @as(c_int, 1);
pub const ARCHIVE_READ_FORMAT_ENCRYPTION_UNSUPPORTED = -@as(c_int, 2);
pub const ARCHIVE_READ_FORMAT_ENCRYPTION_DONT_KNOW = -@as(c_int, 1);
pub const ARCHIVE_EXTRACT_OWNER = @as(c_int, 0x0001);
pub const ARCHIVE_EXTRACT_PERM = @as(c_int, 0x0002);
pub const ARCHIVE_EXTRACT_TIME = @as(c_int, 0x0004);
pub const ARCHIVE_EXTRACT_NO_OVERWRITE = @as(c_int, 0x0008);
pub const ARCHIVE_EXTRACT_UNLINK = @as(c_int, 0x0010);
pub const ARCHIVE_EXTRACT_ACL = @as(c_int, 0x0020);
pub const ARCHIVE_EXTRACT_FFLAGS = @as(c_int, 0x0040);
pub const ARCHIVE_EXTRACT_XATTR = @as(c_int, 0x0080);
pub const ARCHIVE_EXTRACT_SECURE_SYMLINKS = @as(c_int, 0x0100);
pub const ARCHIVE_EXTRACT_SECURE_NODOTDOT = @as(c_int, 0x0200);
pub const ARCHIVE_EXTRACT_NO_AUTODIR = @as(c_int, 0x0400);
pub const ARCHIVE_EXTRACT_NO_OVERWRITE_NEWER = @as(c_int, 0x0800);
pub const ARCHIVE_EXTRACT_SPARSE = @as(c_int, 0x1000);
pub const ARCHIVE_EXTRACT_MAC_METADATA = @as(c_int, 0x2000);
pub const ARCHIVE_EXTRACT_NO_HFS_COMPRESSION = @as(c_int, 0x4000);
pub const ARCHIVE_EXTRACT_HFS_COMPRESSION_FORCED = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x8000, .hexadecimal);
pub const ARCHIVE_EXTRACT_SECURE_NOABSOLUTEPATHS = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x10000, .hexadecimal);
pub const ARCHIVE_EXTRACT_CLEAR_NOCHANGE_FFLAGS = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x20000, .hexadecimal);
pub const ARCHIVE_EXTRACT_SAFE_WRITES = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x40000, .hexadecimal);
pub const ARCHIVE_READDISK_RESTORE_ATIME = @as(c_int, 0x0001);
pub const ARCHIVE_READDISK_HONOR_NODUMP = @as(c_int, 0x0002);
pub const ARCHIVE_READDISK_MAC_COPYFILE = @as(c_int, 0x0004);
pub const ARCHIVE_READDISK_NO_TRAVERSE_MOUNTS = @as(c_int, 0x0008);
pub const ARCHIVE_READDISK_NO_XATTR = @as(c_int, 0x0010);
pub const ARCHIVE_READDISK_NO_ACL = @as(c_int, 0x0020);
pub const ARCHIVE_READDISK_NO_FFLAGS = @as(c_int, 0x0040);
pub const ARCHIVE_MATCH_MTIME = @as(c_int, 0x0100);
pub const ARCHIVE_MATCH_CTIME = @as(c_int, 0x0200);
pub const ARCHIVE_MATCH_NEWER = @as(c_int, 0x0001);
pub const ARCHIVE_MATCH_OLDER = @as(c_int, 0x0002);
pub const ARCHIVE_MATCH_EQUAL = @as(c_int, 0x0010);

pub extern fn archive_version_number() c_int;
pub extern fn archive_version_string() [*c]const u8;
pub extern fn archive_version_details() [*c]const u8;
pub extern fn archive_zlib_version() [*c]const u8;
pub extern fn archive_liblzma_version() [*c]const u8;
pub extern fn archive_bzlib_version() [*c]const u8;
pub extern fn archive_liblz4_version() [*c]const u8;
pub extern fn archive_libzstd_version() [*c]const u8;

pub const archive_read_callback = *const fn (*struct_archive, *anyopaque, [*c]*const anyopaque) callconv(.C) la_ssize_t;
pub const archive_skip_callback = *const fn (*struct_archive, *anyopaque, la_int64_t) callconv(.C) la_int64_t;
pub const archive_seek_callback = *const fn (*struct_archive, *anyopaque, la_int64_t, c_int) callconv(.C) la_int64_t;
pub const archive_write_callback = *const fn (*struct_archive, *anyopaque, ?*const anyopaque, usize) callconv(.C) la_ssize_t;
pub const archive_open_callback = *const fn (*struct_archive, *anyopaque) callconv(.C) c_int;
pub const archive_close_callback = *const fn (*struct_archive, *anyopaque) callconv(.C) c_int;
pub const archive_free_callback = *const fn (*struct_archive, *anyopaque) callconv(.C) c_int;
pub const archive_switch_callback = *const fn (*struct_archive, *anyopaque, ?*anyopaque) callconv(.C) c_int;
pub const archive_passphrase_callback = *const fn (*struct_archive, *anyopaque) callconv(.C) [*c]const u8;
pub extern fn archive_read_new() *struct_archive;
pub extern fn archive_read_support_compression_all(*struct_archive) c_int;
pub extern fn archive_read_support_compression_bzip2(*struct_archive) c_int;
pub extern fn archive_read_support_compression_compress(*struct_archive) c_int;
pub extern fn archive_read_support_compression_gzip(*struct_archive) c_int;
pub extern fn archive_read_support_compression_lzip(*struct_archive) c_int;
pub extern fn archive_read_support_compression_lzma(*struct_archive) c_int;
pub extern fn archive_read_support_compression_none(*struct_archive) c_int;
pub extern fn archive_read_support_compression_program(*struct_archive, command: [*c]const u8) c_int;
pub extern fn archive_read_support_compression_program_signature(*struct_archive, [*c]const u8, ?*const anyopaque, usize) c_int;
pub extern fn archive_read_support_compression_rpm(*struct_archive) c_int;
pub extern fn archive_read_support_compression_uu(*struct_archive) c_int;
pub extern fn archive_read_support_compression_xz(*struct_archive) c_int;
pub extern fn archive_read_support_filter_all(*struct_archive) c_int;
pub extern fn archive_read_support_filter_by_code(*struct_archive, c_int) c_int;
pub extern fn archive_read_support_filter_bzip2(*struct_archive) c_int;
pub extern fn archive_read_support_filter_compress(*struct_archive) c_int;
pub extern fn archive_read_support_filter_gzip(*struct_archive) c_int;
pub extern fn archive_read_support_filter_grzip(*struct_archive) c_int;
pub extern fn archive_read_support_filter_lrzip(*struct_archive) c_int;
pub extern fn archive_read_support_filter_lz4(*struct_archive) c_int;
pub extern fn archive_read_support_filter_lzip(*struct_archive) c_int;
pub extern fn archive_read_support_filter_lzma(*struct_archive) c_int;
pub extern fn archive_read_support_filter_lzop(*struct_archive) c_int;
pub extern fn archive_read_support_filter_none(*struct_archive) c_int;
pub extern fn archive_read_support_filter_program(*struct_archive, command: [*c]const u8) c_int;
pub extern fn archive_read_support_filter_program_signature(*struct_archive, [*c]const u8, ?*const anyopaque, usize) c_int;
pub extern fn archive_read_support_filter_rpm(*struct_archive) c_int;
pub extern fn archive_read_support_filter_uu(*struct_archive) c_int;
pub extern fn archive_read_support_filter_xz(*struct_archive) c_int;
pub extern fn archive_read_support_filter_zstd(*struct_archive) c_int;
pub extern fn archive_read_support_format_7zip(*struct_archive) c_int;
pub extern fn archive_read_support_format_all(*struct_archive) c_int;
pub extern fn archive_read_support_format_ar(*struct_archive) c_int;
pub extern fn archive_read_support_format_by_code(*struct_archive, c_int) c_int;
pub extern fn archive_read_support_format_cab(*struct_archive) c_int;
pub extern fn archive_read_support_format_cpio(*struct_archive) c_int;
pub extern fn archive_read_support_format_empty(*struct_archive) c_int;
pub extern fn archive_read_support_format_gnutar(*struct_archive) c_int;
pub extern fn archive_read_support_format_iso9660(*struct_archive) c_int;
pub extern fn archive_read_support_format_lha(*struct_archive) c_int;
pub extern fn archive_read_support_format_mtree(*struct_archive) c_int;
pub extern fn archive_read_support_format_rar(*struct_archive) c_int;
pub extern fn archive_read_support_format_rar5(*struct_archive) c_int;
pub extern fn archive_read_support_format_raw(*struct_archive) c_int;
pub extern fn archive_read_support_format_tar(*struct_archive) c_int;
pub extern fn archive_read_support_format_warc(*struct_archive) c_int;
pub extern fn archive_read_support_format_xar(*struct_archive) c_int;
pub extern fn archive_read_support_format_zip(*struct_archive) c_int;
pub extern fn archive_read_support_format_zip_streamable(*struct_archive) c_int;
pub extern fn archive_read_support_format_zip_seekable(*struct_archive) c_int;
pub extern fn archive_read_set_format(*struct_archive, c_int) c_int;
pub extern fn archive_read_append_filter(*struct_archive, c_int) c_int;
pub extern fn archive_read_append_filter_program(*struct_archive, [*c]const u8) c_int;
pub extern fn archive_read_append_filter_program_signature(*struct_archive, [*c]const u8, ?*const anyopaque, usize) c_int;
pub extern fn archive_read_set_open_callback(*struct_archive, ?archive_open_callback) c_int;
pub extern fn archive_read_set_read_callback(*struct_archive, ?archive_read_callback) c_int;
pub extern fn archive_read_set_seek_callback(*struct_archive, ?archive_seek_callback) c_int;
pub extern fn archive_read_set_skip_callback(*struct_archive, ?archive_skip_callback) c_int;
pub extern fn archive_read_set_close_callback(*struct_archive, ?archive_close_callback) c_int;
pub extern fn archive_read_set_switch_callback(*struct_archive, ?archive_switch_callback) c_int;
pub extern fn archive_read_set_callback_data(*struct_archive, ?*anyopaque) c_int;
pub extern fn archive_read_set_callback_data2(*struct_archive, ?*anyopaque, c_uint) c_int;
pub extern fn archive_read_add_callback_data(*struct_archive, ?*anyopaque, c_uint) c_int;
pub extern fn archive_read_append_callback_data(*struct_archive, ?*anyopaque) c_int;
pub extern fn archive_read_prepend_callback_data(*struct_archive, ?*anyopaque) c_int;
pub extern fn archive_read_open1(*struct_archive) c_int;
pub extern fn archive_read_open(*struct_archive, _client_data: ?*anyopaque, ?archive_open_callback, ?archive_read_callback, ?archive_close_callback) c_int;
pub extern fn archive_read_open2(*struct_archive, _client_data: ?*anyopaque, ?archive_open_callback, ?archive_read_callback, ?archive_skip_callback, ?archive_close_callback) c_int;
pub extern fn archive_read_open_filename(*struct_archive, _filename: [*c]const u8, _block_size: usize) c_int;
pub extern fn archive_read_open_filenames(*struct_archive, _filenames: [*c][*c]const u8, _block_size: usize) c_int;
pub extern fn archive_read_open_filename_w(*struct_archive, _filename: [*c]const wchar_t, _block_size: usize) c_int;
pub extern fn archive_read_open_file(*struct_archive, _filename: [*c]const u8, _block_size: usize) c_int;
pub extern fn archive_read_open_memory(*struct_archive, buff: ?*const anyopaque, size: usize) c_int;
pub extern fn archive_read_open_memory2(a: *struct_archive, buff: ?*const anyopaque, size: usize, read_size: usize) c_int;
pub extern fn archive_read_open_fd(*struct_archive, _fd: c_int, _block_size: usize) c_int;
pub extern fn archive_read_open_FILE(*struct_archive, _file: [*c]FILE) c_int;
pub extern fn archive_read_next_header(*struct_archive, [*c]*struct_archive_entry) c_int;
pub extern fn archive_read_next_header2(*struct_archive, *struct_archive_entry) c_int;
pub extern fn archive_read_header_position(*struct_archive) la_int64_t;
pub extern fn archive_read_has_encrypted_entries(*struct_archive) c_int;
pub extern fn archive_read_format_capabilities(*struct_archive) c_int;
pub extern fn archive_read_data(*struct_archive, ?*anyopaque, usize) la_ssize_t;
pub extern fn archive_seek_data(*struct_archive, la_int64_t, c_int) la_int64_t;
pub extern fn archive_read_data_block(a: *struct_archive, buff: [*c]*const anyopaque, size: [*c]usize, offset: [*c]la_int64_t) c_int;
pub extern fn archive_read_data_skip(*struct_archive) c_int;
pub extern fn archive_read_data_into_fd(*struct_archive, fd: c_int) c_int;
pub extern fn archive_read_set_format_option(_a: *struct_archive, m: [*c]const u8, o: [*c]const u8, v: [*c]const u8) c_int;
pub extern fn archive_read_set_filter_option(_a: *struct_archive, m: [*c]const u8, o: [*c]const u8, v: [*c]const u8) c_int;
pub extern fn archive_read_set_option(_a: *struct_archive, m: [*c]const u8, o: [*c]const u8, v: [*c]const u8) c_int;
pub extern fn archive_read_set_options(_a: *struct_archive, opts: [*c]const u8) c_int;
pub extern fn archive_read_add_passphrase(*struct_archive, [*c]const u8) c_int;
pub extern fn archive_read_set_passphrase_callback(*struct_archive, client_data: ?*anyopaque, ?archive_passphrase_callback) c_int;
pub extern fn archive_read_extract(*struct_archive, *struct_archive_entry, flags: c_int) c_int;
pub extern fn archive_read_extract2(*struct_archive, *struct_archive_entry, *struct_archive) c_int;
pub extern fn archive_read_extract_set_progress_callback(*struct_archive, _progress_func: ?*const fn (?*anyopaque) callconv(.C) void, _user_data: ?*anyopaque) void;
pub extern fn archive_read_extract_set_skip_file(*struct_archive, la_int64_t, la_int64_t) void;
pub extern fn archive_read_close(*struct_archive) c_int;
pub extern fn archive_read_free(*struct_archive) c_int;
pub extern fn archive_read_finish(*struct_archive) c_int;
pub extern fn archive_write_new() *struct_archive;
pub extern fn archive_write_set_bytes_per_block(*struct_archive, bytes_per_block: c_int) c_int;
pub extern fn archive_write_get_bytes_per_block(*struct_archive) c_int;
pub extern fn archive_write_set_bytes_in_last_block(*struct_archive, bytes_in_last_block: c_int) c_int;
pub extern fn archive_write_get_bytes_in_last_block(*struct_archive) c_int;
pub extern fn archive_write_set_skip_file(*struct_archive, la_int64_t, la_int64_t) c_int;
pub extern fn archive_write_set_compression_bzip2(*struct_archive) c_int;
pub extern fn archive_write_set_compression_compress(*struct_archive) c_int;
pub extern fn archive_write_set_compression_gzip(*struct_archive) c_int;
pub extern fn archive_write_set_compression_lzip(*struct_archive) c_int;
pub extern fn archive_write_set_compression_lzma(*struct_archive) c_int;
pub extern fn archive_write_set_compression_none(*struct_archive) c_int;
pub extern fn archive_write_set_compression_program(*struct_archive, cmd: [*c]const u8) c_int;
pub extern fn archive_write_set_compression_xz(*struct_archive) c_int;
pub extern fn archive_write_add_filter(*struct_archive, filter_code: c_int) c_int;
pub extern fn archive_write_add_filter_by_name(*struct_archive, name: [*c]const u8) c_int;
pub extern fn archive_write_add_filter_b64encode(*struct_archive) c_int;
pub extern fn archive_write_add_filter_bzip2(*struct_archive) c_int;
pub extern fn archive_write_add_filter_compress(*struct_archive) c_int;
pub extern fn archive_write_add_filter_grzip(*struct_archive) c_int;
pub extern fn archive_write_add_filter_gzip(*struct_archive) c_int;
pub extern fn archive_write_add_filter_lrzip(*struct_archive) c_int;
pub extern fn archive_write_add_filter_lz4(*struct_archive) c_int;
pub extern fn archive_write_add_filter_lzip(*struct_archive) c_int;
pub extern fn archive_write_add_filter_lzma(*struct_archive) c_int;
pub extern fn archive_write_add_filter_lzop(*struct_archive) c_int;
pub extern fn archive_write_add_filter_none(*struct_archive) c_int;
pub extern fn archive_write_add_filter_program(*struct_archive, cmd: [*c]const u8) c_int;
pub extern fn archive_write_add_filter_uuencode(*struct_archive) c_int;
pub extern fn archive_write_add_filter_xz(*struct_archive) c_int;
pub extern fn archive_write_add_filter_zstd(*struct_archive) c_int;
pub extern fn archive_write_set_format(*struct_archive, format_code: c_int) c_int;
pub extern fn archive_write_set_format_by_name(*struct_archive, name: [*c]const u8) c_int;
pub extern fn archive_write_set_format_7zip(*struct_archive) c_int;
pub extern fn archive_write_set_format_ar_bsd(*struct_archive) c_int;
pub extern fn archive_write_set_format_ar_svr4(*struct_archive) c_int;
pub extern fn archive_write_set_format_cpio(*struct_archive) c_int;
pub extern fn archive_write_set_format_cpio_bin(*struct_archive) c_int;
pub extern fn archive_write_set_format_cpio_newc(*struct_archive) c_int;
pub extern fn archive_write_set_format_cpio_odc(*struct_archive) c_int;
pub extern fn archive_write_set_format_cpio_pwb(*struct_archive) c_int;
pub extern fn archive_write_set_format_gnutar(*struct_archive) c_int;
pub extern fn archive_write_set_format_iso9660(*struct_archive) c_int;
pub extern fn archive_write_set_format_mtree(*struct_archive) c_int;
pub extern fn archive_write_set_format_mtree_classic(*struct_archive) c_int;
pub extern fn archive_write_set_format_pax(*struct_archive) c_int;
pub extern fn archive_write_set_format_pax_restricted(*struct_archive) c_int;
pub extern fn archive_write_set_format_raw(*struct_archive) c_int;
pub extern fn archive_write_set_format_shar(*struct_archive) c_int;
pub extern fn archive_write_set_format_shar_dump(*struct_archive) c_int;
pub extern fn archive_write_set_format_ustar(*struct_archive) c_int;
pub extern fn archive_write_set_format_v7tar(*struct_archive) c_int;
pub extern fn archive_write_set_format_warc(*struct_archive) c_int;
pub extern fn archive_write_set_format_xar(*struct_archive) c_int;
pub extern fn archive_write_set_format_zip(*struct_archive) c_int;
pub extern fn archive_write_set_format_filter_by_ext(a: *struct_archive, filename: [*c]const u8) c_int;
pub extern fn archive_write_set_format_filter_by_ext_def(a: *struct_archive, filename: [*c]const u8, def_ext: [*c]const u8) c_int;
pub extern fn archive_write_zip_set_compression_deflate(*struct_archive) c_int;
pub extern fn archive_write_zip_set_compression_store(*struct_archive) c_int;
pub extern fn archive_write_open(*struct_archive, ?*anyopaque, ?archive_open_callback, ?archive_write_callback, ?archive_close_callback) c_int;
pub extern fn archive_write_open2(*struct_archive, ?*anyopaque, ?archive_open_callback, ?archive_write_callback, ?archive_close_callback, ?archive_free_callback) c_int;
pub extern fn archive_write_open_fd(*struct_archive, _fd: c_int) c_int;
pub extern fn archive_write_open_filename(*struct_archive, _file: [*c]const u8) c_int;
pub extern fn archive_write_open_filename_w(*struct_archive, _file: [*c]const wchar_t) c_int;
pub extern fn archive_write_open_file(*struct_archive, _file: [*c]const u8) c_int;
pub extern fn archive_write_open_FILE(*struct_archive, [*c]FILE) c_int;
pub extern fn archive_write_open_memory(*struct_archive, _buffer: ?*anyopaque, _buffSize: usize, _used: [*c]usize) c_int;
pub extern fn archive_write_header(*struct_archive, *struct_archive_entry) c_int;
pub extern fn archive_write_data(*struct_archive, ?*const anyopaque, usize) la_ssize_t;
pub extern fn archive_write_data_block(*struct_archive, ?*const anyopaque, usize, la_int64_t) la_ssize_t;
pub extern fn archive_write_finish_entry(*struct_archive) c_int;
pub extern fn archive_write_close(*struct_archive) c_int;
pub extern fn archive_write_fail(*struct_archive) c_int;
pub extern fn archive_write_free(*struct_archive) c_int;
pub extern fn archive_write_finish(*struct_archive) c_int;
pub extern fn archive_write_set_format_option(_a: *struct_archive, m: [*c]const u8, o: [*c]const u8, v: [*c]const u8) c_int;
pub extern fn archive_write_set_filter_option(_a: *struct_archive, m: [*c]const u8, o: [*c]const u8, v: [*c]const u8) c_int;
pub extern fn archive_write_set_option(_a: *struct_archive, m: [*c]const u8, o: [*c]const u8, v: [*c]const u8) c_int;
pub extern fn archive_write_set_options(_a: *struct_archive, opts: [*c]const u8) c_int;
pub extern fn archive_write_set_passphrase(_a: *struct_archive, p: [*c]const u8) c_int;
pub extern fn archive_write_set_passphrase_callback(*struct_archive, client_data: ?*anyopaque, ?archive_passphrase_callback) c_int;
pub extern fn archive_write_disk_new() *struct_archive;
pub extern fn archive_write_disk_set_skip_file(*struct_archive, la_int64_t, la_int64_t) c_int;
pub extern fn archive_write_disk_set_options(*struct_archive, flags: c_int) c_int;
pub extern fn archive_write_disk_set_standard_lookup(*struct_archive) c_int;
pub extern fn archive_write_disk_set_group_lookup(*struct_archive, ?*anyopaque, ?*const fn (?*anyopaque, [*c]const u8, la_int64_t) callconv(.C) la_int64_t, ?*const fn (?*anyopaque) callconv(.C) void) c_int;
pub extern fn archive_write_disk_set_user_lookup(*struct_archive, ?*anyopaque, ?*const fn (?*anyopaque, [*c]const u8, la_int64_t) callconv(.C) la_int64_t, ?*const fn (?*anyopaque) callconv(.C) void) c_int;
pub extern fn archive_write_disk_gid(*struct_archive, [*c]const u8, la_int64_t) la_int64_t;
pub extern fn archive_write_disk_uid(*struct_archive, [*c]const u8, la_int64_t) la_int64_t;
pub extern fn archive_read_disk_new() *struct_archive;
pub extern fn archive_read_disk_set_symlink_logical(*struct_archive) c_int;
pub extern fn archive_read_disk_set_symlink_physical(*struct_archive) c_int;
pub extern fn archive_read_disk_set_symlink_hybrid(*struct_archive) c_int;
pub extern fn archive_read_disk_entry_from_file(*struct_archive, *struct_archive_entry, c_int, [*c]const struct_stat) c_int;
pub extern fn archive_read_disk_gname(*struct_archive, la_int64_t) [*c]const u8;
pub extern fn archive_read_disk_uname(*struct_archive, la_int64_t) [*c]const u8;
pub extern fn archive_read_disk_set_standard_lookup(*struct_archive) c_int;
pub extern fn archive_read_disk_set_gname_lookup(*struct_archive, ?*anyopaque, ?*const fn (?*anyopaque, la_int64_t) callconv(.C) [*c]const u8, ?*const fn (?*anyopaque) callconv(.C) void) c_int;
pub extern fn archive_read_disk_set_uname_lookup(*struct_archive, ?*anyopaque, ?*const fn (?*anyopaque, la_int64_t) callconv(.C) [*c]const u8, ?*const fn (?*anyopaque) callconv(.C) void) c_int;
pub extern fn archive_read_disk_open(*struct_archive, [*c]const u8) c_int;
pub extern fn archive_read_disk_open_w(*struct_archive, [*c]const wchar_t) c_int;
pub extern fn archive_read_disk_descend(*struct_archive) c_int;
pub extern fn archive_read_disk_can_descend(*struct_archive) c_int;
pub extern fn archive_read_disk_current_filesystem(*struct_archive) c_int;
pub extern fn archive_read_disk_current_filesystem_is_synthetic(*struct_archive) c_int;
pub extern fn archive_read_disk_current_filesystem_is_remote(*struct_archive) c_int;
pub extern fn archive_read_disk_set_atime_restored(*struct_archive) c_int;
pub extern fn archive_read_disk_set_behavior(*struct_archive, flags: c_int) c_int;
pub extern fn archive_read_disk_set_matching(*struct_archive, _matching: *struct_archive, _excluded_func: ?*const fn (*struct_archive, ?*anyopaque, *struct_archive_entry) callconv(.C) void, _client_data: ?*anyopaque) c_int;
pub extern fn archive_read_disk_set_metadata_filter_callback(*struct_archive, _metadata_filter_func: ?*const fn (*struct_archive, ?*anyopaque, *struct_archive_entry) callconv(.C) c_int, _client_data: ?*anyopaque) c_int;
pub extern fn archive_free(*struct_archive) c_int;
pub extern fn archive_filter_count(*struct_archive) c_int;
pub extern fn archive_filter_bytes(*struct_archive, c_int) la_int64_t;
pub extern fn archive_filter_code(*struct_archive, c_int) c_int;
pub extern fn archive_filter_name(*struct_archive, c_int) [*c]const u8;
pub extern fn archive_position_compressed(*struct_archive) la_int64_t;
pub extern fn archive_position_uncompressed(*struct_archive) la_int64_t;
pub extern fn archive_compression_name(*struct_archive) [*c]const u8;
pub extern fn archive_compression(*struct_archive) c_int;
pub extern fn archive_errno(*struct_archive) c_int;
pub extern fn archive_error_string(*struct_archive) [*c]const u8;
pub extern fn archive_format_name(*struct_archive) [*c]const u8;
pub extern fn archive_format(*struct_archive) c_int;
pub extern fn archive_clear_error(*struct_archive) void;
pub extern fn archive_set_error(*struct_archive, _err: c_int, fmt: [*c]const u8, ...) void;
pub extern fn archive_copy_error(dest: *struct_archive, src: *struct_archive) void;
pub extern fn archive_file_count(*struct_archive) c_int;
pub extern fn archive_match_new() *struct_archive;
pub extern fn archive_match_free(*struct_archive) c_int;
pub extern fn archive_match_excluded(*struct_archive, *struct_archive_entry) c_int;
pub extern fn archive_match_path_excluded(*struct_archive, *struct_archive_entry) c_int;
pub extern fn archive_match_set_inclusion_recursion(*struct_archive, c_int) c_int;
pub extern fn archive_match_exclude_pattern(*struct_archive, [*c]const u8) c_int;
pub extern fn archive_match_exclude_pattern_w(*struct_archive, [*c]const wchar_t) c_int;
pub extern fn archive_match_exclude_pattern_from_file(*struct_archive, [*c]const u8, _nullSeparator: c_int) c_int;
pub extern fn archive_match_exclude_pattern_from_file_w(*struct_archive, [*c]const wchar_t, _nullSeparator: c_int) c_int;
pub extern fn archive_match_include_pattern(*struct_archive, [*c]const u8) c_int;
pub extern fn archive_match_include_pattern_w(*struct_archive, [*c]const wchar_t) c_int;
pub extern fn archive_match_include_pattern_from_file(*struct_archive, [*c]const u8, _nullSeparator: c_int) c_int;
pub extern fn archive_match_include_pattern_from_file_w(*struct_archive, [*c]const wchar_t, _nullSeparator: c_int) c_int;
pub extern fn archive_match_path_unmatched_inclusions(*struct_archive) c_int;
pub extern fn archive_match_path_unmatched_inclusions_next(*struct_archive, [*c][*c]const u8) c_int;
pub extern fn archive_match_path_unmatched_inclusions_next_w(*struct_archive, [*c][*c]const wchar_t) c_int;
pub extern fn archive_match_time_excluded(*struct_archive, *struct_archive_entry) c_int;
pub extern fn archive_match_include_time(*struct_archive, _flag: c_int, _sec: time_t, _nsec: c_long) c_int;
pub extern fn archive_match_include_date(*struct_archive, _flag: c_int, _datestr: [*c]const u8) c_int;
pub extern fn archive_match_include_date_w(*struct_archive, _flag: c_int, _datestr: [*c]const wchar_t) c_int;
pub extern fn archive_match_include_file_time(*struct_archive, _flag: c_int, _pathname: [*c]const u8) c_int;
pub extern fn archive_match_include_file_time_w(*struct_archive, _flag: c_int, _pathname: [*c]const wchar_t) c_int;
pub extern fn archive_match_exclude_entry(*struct_archive, _flag: c_int, *struct_archive_entry) c_int;
pub extern fn archive_match_owner_excluded(*struct_archive, *struct_archive_entry) c_int;
pub extern fn archive_match_include_uid(*struct_archive, la_int64_t) c_int;
pub extern fn archive_match_include_gid(*struct_archive, la_int64_t) c_int;
pub extern fn archive_match_include_uname(*struct_archive, [*c]const u8) c_int;
pub extern fn archive_match_include_uname_w(*struct_archive, [*c]const wchar_t) c_int;
pub extern fn archive_match_include_gname(*struct_archive, [*c]const u8) c_int;
pub extern fn archive_match_include_gname_w(*struct_archive, [*c]const wchar_t) c_int;
pub extern fn archive_utility_string_sort([*c][*c]u8) c_int;

pub extern fn archive_entry_clear(*struct_archive_entry) *struct_archive_entry;
pub extern fn archive_entry_clone(*struct_archive_entry) *struct_archive_entry;
pub extern fn archive_entry_free(*struct_archive_entry) void;
pub extern fn archive_entry_new() *struct_archive_entry;
pub extern fn archive_entry_new2(*struct_archive) *struct_archive_entry;
pub extern fn archive_entry_atime(*struct_archive_entry) time_t;
pub extern fn archive_entry_atime_nsec(*struct_archive_entry) c_long;
pub extern fn archive_entry_atime_is_set(*struct_archive_entry) c_int;
pub extern fn archive_entry_birthtime(*struct_archive_entry) time_t;
pub extern fn archive_entry_birthtime_nsec(*struct_archive_entry) c_long;
pub extern fn archive_entry_birthtime_is_set(*struct_archive_entry) c_int;
pub extern fn archive_entry_ctime(*struct_archive_entry) time_t;
pub extern fn archive_entry_ctime_nsec(*struct_archive_entry) c_long;
pub extern fn archive_entry_ctime_is_set(*struct_archive_entry) c_int;
pub extern fn archive_entry_dev(*struct_archive_entry) dev_t;
pub extern fn archive_entry_dev_is_set(*struct_archive_entry) c_int;
pub extern fn archive_entry_devmajor(*struct_archive_entry) dev_t;
pub extern fn archive_entry_devminor(*struct_archive_entry) dev_t;
pub extern fn archive_entry_filetype(*struct_archive_entry) mode_t;
pub extern fn archive_entry_fflags(*struct_archive_entry, [*c]c_ulong, [*c]c_ulong) void;
pub extern fn archive_entry_fflags_text(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_gid(*struct_archive_entry) la_int64_t;
pub extern fn archive_entry_gname(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_gname_utf8(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_gname_w(*struct_archive_entry) [*c]const wchar_t;
pub extern fn archive_entry_hardlink(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_hardlink_utf8(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_hardlink_w(*struct_archive_entry) [*c]const wchar_t;
pub extern fn archive_entry_ino(*struct_archive_entry) la_int64_t;
pub extern fn archive_entry_ino64(*struct_archive_entry) la_int64_t;
pub extern fn archive_entry_ino_is_set(*struct_archive_entry) c_int;
pub extern fn archive_entry_mode(*struct_archive_entry) mode_t;
pub extern fn archive_entry_mtime(*struct_archive_entry) time_t;
pub extern fn archive_entry_mtime_nsec(*struct_archive_entry) c_long;
pub extern fn archive_entry_mtime_is_set(*struct_archive_entry) c_int;
pub extern fn archive_entry_nlink(*struct_archive_entry) c_uint;
pub extern fn archive_entry_pathname(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_pathname_utf8(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_pathname_w(*struct_archive_entry) [*c]const wchar_t;
pub extern fn archive_entry_perm(*struct_archive_entry) mode_t;
pub extern fn archive_entry_rdev(*struct_archive_entry) dev_t;
pub extern fn archive_entry_rdevmajor(*struct_archive_entry) dev_t;
pub extern fn archive_entry_rdevminor(*struct_archive_entry) dev_t;
pub extern fn archive_entry_sourcepath(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_sourcepath_w(*struct_archive_entry) [*c]const wchar_t;
pub extern fn archive_entry_size(*struct_archive_entry) la_int64_t;
pub extern fn archive_entry_size_is_set(*struct_archive_entry) c_int;
pub extern fn archive_entry_strmode(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_symlink(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_symlink_utf8(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_symlink_type(*struct_archive_entry) SymlinkType;
pub extern fn archive_entry_symlink_w(*struct_archive_entry) [*c]const wchar_t;
pub extern fn archive_entry_uid(*struct_archive_entry) la_int64_t;
pub extern fn archive_entry_uname(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_uname_utf8(*struct_archive_entry) [*c]const u8;
pub extern fn archive_entry_uname_w(*struct_archive_entry) [*c]const wchar_t;
pub extern fn archive_entry_is_data_encrypted(*struct_archive_entry) c_int;
pub extern fn archive_entry_is_metadata_encrypted(*struct_archive_entry) c_int;
pub extern fn archive_entry_is_encrypted(*struct_archive_entry) c_int;
pub extern fn archive_entry_set_atime(*struct_archive_entry, time_t, c_long) void;
pub extern fn archive_entry_unset_atime(*struct_archive_entry) void;
pub extern fn archive_entry_set_birthtime(*struct_archive_entry, time_t, c_long) void;
pub extern fn archive_entry_unset_birthtime(*struct_archive_entry) void;
pub extern fn archive_entry_set_ctime(*struct_archive_entry, time_t, c_long) void;
pub extern fn archive_entry_unset_ctime(*struct_archive_entry) void;
pub extern fn archive_entry_set_dev(*struct_archive_entry, dev_t) void;
pub extern fn archive_entry_set_devmajor(*struct_archive_entry, dev_t) void;
pub extern fn archive_entry_set_devminor(*struct_archive_entry, dev_t) void;
pub extern fn archive_entry_set_filetype(*struct_archive_entry, c_uint) void;
pub extern fn archive_entry_set_fflags(*struct_archive_entry, c_ulong, c_ulong) void;
pub extern fn archive_entry_copy_fflags_text(*struct_archive_entry, [*c]const u8) [*c]const u8;
pub extern fn archive_entry_copy_fflags_text_w(*struct_archive_entry, [*c]const wchar_t) [*c]const wchar_t;
pub extern fn archive_entry_set_gid(*struct_archive_entry, la_int64_t) void;
pub extern fn archive_entry_set_gname(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_set_gname_utf8(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_gname(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_gname_w(*struct_archive_entry, [*c]const wchar_t) void;
pub extern fn archive_entry_update_gname_utf8(*struct_archive_entry, [*c]const u8) c_int;
pub extern fn archive_entry_set_hardlink(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_set_hardlink_utf8(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_hardlink(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_hardlink_w(*struct_archive_entry, [*c]const wchar_t) void;
pub extern fn archive_entry_update_hardlink_utf8(*struct_archive_entry, [*c]const u8) c_int;
pub extern fn archive_entry_set_ino(*struct_archive_entry, la_int64_t) void;
pub extern fn archive_entry_set_ino64(*struct_archive_entry, la_int64_t) void;
pub extern fn archive_entry_set_link(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_set_link_utf8(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_link(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_link_w(*struct_archive_entry, [*c]const wchar_t) void;
pub extern fn archive_entry_update_link_utf8(*struct_archive_entry, [*c]const u8) c_int;
pub extern fn archive_entry_set_mode(*struct_archive_entry, mode_t) void;
pub extern fn archive_entry_set_mtime(*struct_archive_entry, time_t, c_long) void;
pub extern fn archive_entry_unset_mtime(*struct_archive_entry) void;
pub extern fn archive_entry_set_nlink(*struct_archive_entry, c_uint) void;
pub extern fn archive_entry_set_pathname(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_set_pathname_utf8(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_pathname(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_pathname_w(*struct_archive_entry, [*c]const wchar_t) void;
pub extern fn archive_entry_update_pathname_utf8(*struct_archive_entry, [*c]const u8) c_int;
pub extern fn archive_entry_set_perm(*struct_archive_entry, mode_t) void;
pub extern fn archive_entry_set_rdev(*struct_archive_entry, dev_t) void;
pub extern fn archive_entry_set_rdevmajor(*struct_archive_entry, dev_t) void;
pub extern fn archive_entry_set_rdevminor(*struct_archive_entry, dev_t) void;
pub extern fn archive_entry_set_size(*struct_archive_entry, la_int64_t) void;
pub extern fn archive_entry_unset_size(*struct_archive_entry) void;
pub extern fn archive_entry_copy_sourcepath(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_sourcepath_w(*struct_archive_entry, [*c]const wchar_t) void;
pub extern fn archive_entry_set_symlink(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_set_symlink_type(*struct_archive_entry, c_int) void;
pub extern fn archive_entry_set_symlink_utf8(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_symlink(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_symlink_w(*struct_archive_entry, [*c]const wchar_t) void;
pub extern fn archive_entry_update_symlink_utf8(*struct_archive_entry, [*c]const u8) c_int;
pub extern fn archive_entry_set_uid(*struct_archive_entry, la_int64_t) void;
pub extern fn archive_entry_set_uname(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_set_uname_utf8(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_uname(*struct_archive_entry, [*c]const u8) void;
pub extern fn archive_entry_copy_uname_w(*struct_archive_entry, [*c]const wchar_t) void;
pub extern fn archive_entry_update_uname_utf8(*struct_archive_entry, [*c]const u8) c_int;
pub extern fn archive_entry_set_is_data_encrypted(*struct_archive_entry, is_encrypted: u8) void;
pub extern fn archive_entry_set_is_metadata_encrypted(*struct_archive_entry, is_encrypted: u8) void;
pub const struct_stat = opaque {};
pub extern fn archive_entry_stat(*struct_archive_entry) ?*const struct_stat;
pub extern fn archive_entry_copy_stat(*struct_archive_entry, ?*const struct_stat) void;
pub extern fn archive_entry_mac_metadata(*struct_archive_entry, [*c]usize) ?*const anyopaque;
pub extern fn archive_entry_copy_mac_metadata(*struct_archive_entry, ?*const anyopaque, usize) void;
pub extern fn archive_entry_digest(*struct_archive_entry, c_int) [*c]const u8;
pub extern fn archive_entry_acl_clear(*struct_archive_entry) void;
pub extern fn archive_entry_acl_add_entry(*struct_archive_entry, c_int, c_int, c_int, c_int, [*c]const u8) c_int;
pub extern fn archive_entry_acl_add_entry_w(*struct_archive_entry, c_int, c_int, c_int, c_int, [*c]const wchar_t) c_int;
pub extern fn archive_entry_acl_reset(*struct_archive_entry, c_int) c_int;
pub extern fn archive_entry_acl_next(*struct_archive_entry, c_int, [*c]c_int, [*c]c_int, [*c]c_int, [*c]c_int, [*c][*c]const u8) c_int;
pub extern fn archive_entry_acl_to_text_w(*struct_archive_entry, [*c]la_ssize_t, c_int) [*c]wchar_t;
pub extern fn archive_entry_acl_to_text(*struct_archive_entry, [*c]la_ssize_t, c_int) [*c]u8;
pub extern fn archive_entry_acl_from_text_w(*struct_archive_entry, [*c]const wchar_t, c_int) c_int;
pub extern fn archive_entry_acl_from_text(*struct_archive_entry, [*c]const u8, c_int) c_int;
pub extern fn archive_entry_acl_text_w(*struct_archive_entry, c_int) [*c]const wchar_t;
pub extern fn archive_entry_acl_text(*struct_archive_entry, c_int) [*c]const u8;
pub extern fn archive_entry_acl_types(*struct_archive_entry) c_int;
pub extern fn archive_entry_acl_count(*struct_archive_entry, c_int) c_int;
pub const struct_archive_acl = opaque {};
pub extern fn archive_entry_acl(*struct_archive_entry) *struct_archive_acl;
pub extern fn archive_entry_xattr_clear(*struct_archive_entry) void;
pub extern fn archive_entry_xattr_add_entry(*struct_archive_entry, [*c]const u8, ?*const anyopaque, usize) void;
pub extern fn archive_entry_xattr_count(*struct_archive_entry) c_int;
pub extern fn archive_entry_xattr_reset(*struct_archive_entry) c_int;
pub extern fn archive_entry_xattr_next(*struct_archive_entry, [*c][*c]const u8, [*c]?*const anyopaque, [*c]usize) c_int;
pub extern fn archive_entry_sparse_clear(*struct_archive_entry) void;
pub extern fn archive_entry_sparse_add_entry(*struct_archive_entry, la_int64_t, la_int64_t) void;
pub extern fn archive_entry_sparse_count(*struct_archive_entry) c_int;
pub extern fn archive_entry_sparse_reset(*struct_archive_entry) c_int;
pub extern fn archive_entry_sparse_next(*struct_archive_entry, [*c]la_int64_t, [*c]la_int64_t) c_int;
pub const struct_archive_entry_linkresolver = opaque {};
pub extern fn archive_entry_linkresolver_new() *struct_archive_entry_linkresolver;
pub extern fn archive_entry_linkresolver_set_strategy(*struct_archive_entry_linkresolver, c_int) void;
pub extern fn archive_entry_linkresolver_free(*struct_archive_entry_linkresolver) void;
pub extern fn archive_entry_linkify(*struct_archive_entry_linkresolver, [*c]*struct_archive_entry, [*c]*struct_archive_entry) void;
pub extern fn archive_entry_partial_links(res: *struct_archive_entry_linkresolver, links: [*c]c_uint) *struct_archive_entry;

pub const archive_acl = struct_archive_acl;
pub const archive_entry_linkresolver = struct_archive_entry_linkresolver;

pub const AE_SYMLINK_TYPE_UNDEFINED = @as(c_int, 0);
pub const AE_SYMLINK_TYPE_FILE = @as(c_int, 1);
pub const AE_SYMLINK_TYPE_DIRECTORY = @as(c_int, 2);
pub const ARCHIVE_ENTRY_DIGEST_MD5 = @as(c_int, 0x00000001);
pub const ARCHIVE_ENTRY_DIGEST_RMD160 = @as(c_int, 0x00000002);
pub const ARCHIVE_ENTRY_DIGEST_SHA1 = @as(c_int, 0x00000003);
pub const ARCHIVE_ENTRY_DIGEST_SHA256 = @as(c_int, 0x00000004);
pub const ARCHIVE_ENTRY_DIGEST_SHA384 = @as(c_int, 0x00000005);
pub const ARCHIVE_ENTRY_DIGEST_SHA512 = @as(c_int, 0x00000006);
pub const ARCHIVE_ENTRY_ACL_EXECUTE = @as(c_int, 0x00000001);
pub const ARCHIVE_ENTRY_ACL_WRITE = @as(c_int, 0x00000002);
pub const ARCHIVE_ENTRY_ACL_READ = @as(c_int, 0x00000004);
pub const ARCHIVE_ENTRY_ACL_READ_DATA = @as(c_int, 0x00000008);
pub const ARCHIVE_ENTRY_ACL_LIST_DIRECTORY = @as(c_int, 0x00000008);
pub const ARCHIVE_ENTRY_ACL_WRITE_DATA = @as(c_int, 0x00000010);
pub const ARCHIVE_ENTRY_ACL_ADD_FILE = @as(c_int, 0x00000010);
pub const ARCHIVE_ENTRY_ACL_APPEND_DATA = @as(c_int, 0x00000020);
pub const ARCHIVE_ENTRY_ACL_ADD_SUBDIRECTORY = @as(c_int, 0x00000020);
pub const ARCHIVE_ENTRY_ACL_READ_NAMED_ATTRS = @as(c_int, 0x00000040);
pub const ARCHIVE_ENTRY_ACL_WRITE_NAMED_ATTRS = @as(c_int, 0x00000080);
pub const ARCHIVE_ENTRY_ACL_DELETE_CHILD = @as(c_int, 0x00000100);
pub const ARCHIVE_ENTRY_ACL_READ_ATTRIBUTES = @as(c_int, 0x00000200);
pub const ARCHIVE_ENTRY_ACL_WRITE_ATTRIBUTES = @as(c_int, 0x00000400);
pub const ARCHIVE_ENTRY_ACL_DELETE = @as(c_int, 0x00000800);
pub const ARCHIVE_ENTRY_ACL_READ_ACL = @as(c_int, 0x00001000);
pub const ARCHIVE_ENTRY_ACL_WRITE_ACL = @as(c_int, 0x00002000);
pub const ARCHIVE_ENTRY_ACL_WRITE_OWNER = @as(c_int, 0x00004000);
pub const ARCHIVE_ENTRY_ACL_SYNCHRONIZE = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x00008000, .hexadecimal);
pub const ARCHIVE_ENTRY_ACL_PERMS_POSIX1E = (ARCHIVE_ENTRY_ACL_EXECUTE | ARCHIVE_ENTRY_ACL_WRITE) | ARCHIVE_ENTRY_ACL_READ;
pub const ARCHIVE_ENTRY_ACL_PERMS_NFS4 = (((((((((((((((ARCHIVE_ENTRY_ACL_EXECUTE | ARCHIVE_ENTRY_ACL_READ_DATA) | ARCHIVE_ENTRY_ACL_LIST_DIRECTORY) | ARCHIVE_ENTRY_ACL_WRITE_DATA) | ARCHIVE_ENTRY_ACL_ADD_FILE) | ARCHIVE_ENTRY_ACL_APPEND_DATA) | ARCHIVE_ENTRY_ACL_ADD_SUBDIRECTORY) | ARCHIVE_ENTRY_ACL_READ_NAMED_ATTRS) | ARCHIVE_ENTRY_ACL_WRITE_NAMED_ATTRS) | ARCHIVE_ENTRY_ACL_DELETE_CHILD) | ARCHIVE_ENTRY_ACL_READ_ATTRIBUTES) | ARCHIVE_ENTRY_ACL_WRITE_ATTRIBUTES) | ARCHIVE_ENTRY_ACL_DELETE) | ARCHIVE_ENTRY_ACL_READ_ACL) | ARCHIVE_ENTRY_ACL_WRITE_ACL) | ARCHIVE_ENTRY_ACL_WRITE_OWNER) | ARCHIVE_ENTRY_ACL_SYNCHRONIZE;
pub const ARCHIVE_ENTRY_ACL_ENTRY_INHERITED = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x01000000, .hexadecimal);
pub const ARCHIVE_ENTRY_ACL_ENTRY_FILE_INHERIT = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x02000000, .hexadecimal);
pub const ARCHIVE_ENTRY_ACL_ENTRY_DIRECTORY_INHERIT = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x04000000, .hexadecimal);
pub const ARCHIVE_ENTRY_ACL_ENTRY_NO_PROPAGATE_INHERIT = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x08000000, .hexadecimal);
pub const ARCHIVE_ENTRY_ACL_ENTRY_INHERIT_ONLY = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x10000000, .hexadecimal);
pub const ARCHIVE_ENTRY_ACL_ENTRY_SUCCESSFUL_ACCESS = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x20000000, .hexadecimal);
pub const ARCHIVE_ENTRY_ACL_ENTRY_FAILED_ACCESS = @import("std").zig.c_translation.promoteIntLiteral(c_int, 0x40000000, .hexadecimal);
pub const ARCHIVE_ENTRY_ACL_INHERITANCE_NFS4 = (((((ARCHIVE_ENTRY_ACL_ENTRY_FILE_INHERIT | ARCHIVE_ENTRY_ACL_ENTRY_DIRECTORY_INHERIT) | ARCHIVE_ENTRY_ACL_ENTRY_NO_PROPAGATE_INHERIT) | ARCHIVE_ENTRY_ACL_ENTRY_INHERIT_ONLY) | ARCHIVE_ENTRY_ACL_ENTRY_SUCCESSFUL_ACCESS) | ARCHIVE_ENTRY_ACL_ENTRY_FAILED_ACCESS) | ARCHIVE_ENTRY_ACL_ENTRY_INHERITED;
pub const ARCHIVE_ENTRY_ACL_TYPE_ACCESS = @as(c_int, 0x00000100);
pub const ARCHIVE_ENTRY_ACL_TYPE_DEFAULT = @as(c_int, 0x00000200);
pub const ARCHIVE_ENTRY_ACL_TYPE_ALLOW = @as(c_int, 0x00000400);
pub const ARCHIVE_ENTRY_ACL_TYPE_DENY = @as(c_int, 0x00000800);
pub const ARCHIVE_ENTRY_ACL_TYPE_AUDIT = @as(c_int, 0x00001000);
pub const ARCHIVE_ENTRY_ACL_TYPE_ALARM = @as(c_int, 0x00002000);
pub const ARCHIVE_ENTRY_ACL_TYPE_POSIX1E = ARCHIVE_ENTRY_ACL_TYPE_ACCESS | ARCHIVE_ENTRY_ACL_TYPE_DEFAULT;
pub const ARCHIVE_ENTRY_ACL_TYPE_NFS4 = ((ARCHIVE_ENTRY_ACL_TYPE_ALLOW | ARCHIVE_ENTRY_ACL_TYPE_DENY) | ARCHIVE_ENTRY_ACL_TYPE_AUDIT) | ARCHIVE_ENTRY_ACL_TYPE_ALARM;
pub const ARCHIVE_ENTRY_ACL_USER = @as(c_int, 10001);
pub const ARCHIVE_ENTRY_ACL_USER_OBJ = @as(c_int, 10002);
pub const ARCHIVE_ENTRY_ACL_GROUP = @as(c_int, 10003);
pub const ARCHIVE_ENTRY_ACL_GROUP_OBJ = @as(c_int, 10004);
pub const ARCHIVE_ENTRY_ACL_MASK = @as(c_int, 10005);
pub const ARCHIVE_ENTRY_ACL_OTHER = @as(c_int, 10006);
pub const ARCHIVE_ENTRY_ACL_EVERYONE = @as(c_int, 10107);
pub const ARCHIVE_ENTRY_ACL_STYLE_EXTRA_ID = @as(c_int, 0x00000001);
pub const ARCHIVE_ENTRY_ACL_STYLE_MARK_DEFAULT = @as(c_int, 0x00000002);
pub const ARCHIVE_ENTRY_ACL_STYLE_SOLARIS = @as(c_int, 0x00000004);
pub const ARCHIVE_ENTRY_ACL_STYLE_SEPARATOR_COMMA = @as(c_int, 0x00000008);
pub const ARCHIVE_ENTRY_ACL_STYLE_COMPACT = @as(c_int, 0x00000010);
pub const OLD_ARCHIVE_ENTRY_ACL_STYLE_EXTRA_ID = @as(c_int, 1024);
pub const OLD_ARCHIVE_ENTRY_ACL_STYLE_MARK_DEFAULT = @as(c_int, 2048);
