/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.util.DataSink;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class OutputStreamDataSink
implements DataSink {
    private static final int MAX_READ_CHUNK_SIZE = 65536;
    private final OutputStream mOut;

    public OutputStreamDataSink(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("out == null");
        }
        this.mOut = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.mOut;
    }

    @Override
    public void consume(byte[] byArray, int n, int n2) throws IOException {
        this.mOut.write(byArray, n, n2);
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            this.mOut.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.limit());
        } else {
            byte[] byArray = new byte[Math.min(byteBuffer.remaining(), 65536)];
            while (byteBuffer.hasRemaining()) {
                int n = Math.min(byteBuffer.remaining(), byArray.length);
                byteBuffer.get(byArray, 0, n);
                this.mOut.write(byArray, 0, n);
            }
        }
    }
}

