/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.AbstractEvictableRecordStore;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.RecordStoreLoader;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreManager;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;

public class DefaultRecordStore
extends AbstractEvictableRecordStore
implements RecordStore {
    private final ILogger logger;
    private final LockStore lockStore;
    private final MapDataStore<Data, Object> mapDataStore;
    private final MapStoreContext mapStoreContext;
    private final RecordStoreLoader recordStoreLoader;
    private final MapKeyLoader keyLoader;
    private final Collection<Future> loadingFutures = new ConcurrentLinkedQueue<Future>();

    public DefaultRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader, ILogger logger) {
        super(mapContainer, partitionId);
        this.logger = logger;
        this.keyLoader = keyLoader;
        this.lockStore = this.createLockStore();
        this.mapStoreContext = mapContainer.getMapStoreContext();
        MapStoreManager mapStoreManager = this.mapStoreContext.getMapStoreManager();
        this.mapDataStore = mapStoreManager.getMapDataStore(partitionId);
        this.recordStoreLoader = this.createRecordStoreLoader(this.mapStoreContext);
    }

    public void startLoading() {
        if (this.mapStoreContext.isMapLoader()) {
            this.loadingFutures.add(this.keyLoader.startInitialLoad(this.mapStoreContext, this.partitionId));
        }
    }

    @Override
    public boolean isLoaded() {
        return FutureUtil.allDone(this.loadingFutures);
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        this.logger.info("Starting to load all keys for map " + this.name + " on partitionId=" + this.partitionId);
        Future<?> loadingKeysFuture = this.keyLoader.startLoading(this.mapStoreContext, replaceExistingValues);
        this.loadingFutures.add(loadingKeysFuture);
    }

    @Override
    public void loadAllFromStore(List<Data> keys, boolean replaceExistingValues) {
        if (!keys.isEmpty()) {
            Future<?> f = this.recordStoreLoader.loadValues(keys, replaceExistingValues);
            this.loadingFutures.add(f);
        }
        this.keyLoader.trackLoading(false, null);
    }

    @Override
    public void updateLoadStatus(boolean lastBatch, Throwable exception) {
        this.keyLoader.trackLoading(lastBatch, exception);
        if (lastBatch) {
            this.logger.finest("Completed loading map " + this.name + " on partitionId=" + this.partitionId);
        }
    }

    @Override
    public void maybeDoInitialLoad() {
        if (this.keyLoader.shouldDoInitialLoad()) {
            this.loadAll(false);
        }
    }

    @Override
    public void onKeyLoad(ExecutionCallback<Boolean> callback) {
        this.keyLoader.onKeyLoad(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIfLoaded() {
        if (this.loadingFutures.isEmpty()) {
            return;
        }
        if (this.isLoaded()) {
            List<Future> doneFutures = null;
            try {
                doneFutures = FutureUtil.getAllDone(this.loadingFutures);
                FutureUtil.checkAllDone(doneFutures);
            }
            catch (Exception e) {
                this.logger.severe("Exception while loading map " + this.name, e);
                ExceptionUtil.rethrow(e);
            }
            finally {
                this.loadingFutures.removeAll(doneFutures);
            }
        } else {
            this.keyLoader.triggerLoadingWithDelay();
            throw new RetryableHazelcastException("Map " + this.getName() + " is still loading data from external store");
        }
    }

    @Override
    public void flush() {
        long now = this.getNow();
        Collection<Data> processedKeys = this.mapDataStore.flush();
        for (Data key : processedKeys) {
            Record record = this.getRecordOrNull(key, now, false);
            if (record == null) continue;
            record.onStore();
        }
    }

    @Override
    public Record getRecord(Data key) {
        return (Record)this.records.get(key);
    }

    @Override
    public void putRecord(Data key, Record record) {
        this.markRecordStoreExpirable(record.getTtl());
        Record existingRecord = this.records.put(key, record);
        this.updateSizeEstimator(-this.calculateRecordHeapCost(existingRecord));
        this.updateSizeEstimator(this.calculateRecordHeapCost(record));
    }

    @Override
    public Record putBackup(Data key, Object value) {
        return this.putBackup(key, value, -1L, false);
    }

    @Override
    public Record putBackup(Data key, Object value, long ttl, boolean putTransient) {
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, true);
        if (record == null) {
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.updateRecord(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        if (putTransient) {
            this.mapDataStore.addTransient(key, now);
        } else {
            this.mapDataStore.addBackup(key, value, now);
        }
        return record;
    }

    @Override
    public Iterator<Record> iterator() {
        return new AbstractEvictableRecordStore.ReadOnlyRecordIterator(this.records.values());
    }

    @Override
    public Iterator<Record> iterator(long now, boolean backup) {
        return new AbstractEvictableRecordStore.ReadOnlyRecordIterator(this.records.values(), now, backup);
    }

    @Override
    public Iterator<Record> loadAwareIterator(long now, boolean backup) {
        this.checkIfLoaded();
        return this.iterator(now, backup);
    }

    @Override
    public Map<Data, Record> getRecordMap() {
        return this.records;
    }

    @Override
    public void clearPartition() {
        IndexService indexService;
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:mapService", this.name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
        if ((indexService = this.mapContainer.getIndexService()).hasIndex()) {
            for (Data key : this.records.keySet()) {
                indexService.removeEntryIndex(key);
            }
        }
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        this.mapDataStore.clear();
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkIfLoaded();
        return this.records.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkIfLoaded();
        long now = this.getNow();
        for (Record record : this.records.values()) {
            if (this.getOrNullIfExpired(record, now, false) == null || !this.mapServiceContext.compare(this.name, value, record.getValue())) continue;
            return true;
        }
        this.postReadCleanUp(now, false);
        return false;
    }

    @Override
    public boolean txnLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    @Override
    public boolean extendLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, long threadId) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    @Override
    public boolean unlockWithoutCheckingOwnership(Data key, long threadId) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.unlockWithoutCheckingOwnership(key, threadId);
    }

    @Override
    public boolean forceUnlock(Data dataKey) {
        return this.lockStore != null && this.lockStore.forceUnlock(dataKey);
    }

    @Override
    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    @Override
    public boolean isTransactionallyLocked(Data key) {
        return this.lockStore != null && this.lockStore.isTransactionallyLocked(key);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, long threadId) {
        return this.lockStore == null || this.lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public String getLockOwnerInfo(Data key) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(key) : null;
    }

    @Override
    public Set<Map.Entry<Data, Data>> entrySetData() {
        this.checkIfLoaded();
        long now = this.getNow();
        ConcurrentMap records = this.records;
        Collection values = records.values();
        HashMap<Data, Data> tempMap = null;
        for (Record record : values) {
            if ((record = this.getOrNullIfExpired(record, now, false)) == null) continue;
            if (tempMap == null) {
                tempMap = new HashMap<Data, Data>();
            }
            Data key = record.getKey();
            Data value = this.toData(record.getValue());
            tempMap.put(key, value);
        }
        if (tempMap == null) {
            return Collections.emptySet();
        }
        return tempMap.entrySet();
    }

    @Override
    public Map.Entry<Data, Object> getMapEntry(Data key, long now) {
        this.checkIfLoaded();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            record = this.loadRecordOrNull(key, false);
        } else {
            this.accessRecord(record);
        }
        Object value = record != null ? (Object)record.getValue() : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(key, value);
    }

    private Record loadRecordOrNull(Data key, boolean backup) {
        Record record = null;
        Object value = this.mapDataStore.load(key);
        if (value != null) {
            record = this.createRecord(key, value, this.getNow());
            this.records.put(key, record);
            if (!backup) {
                this.saveIndex(record);
            }
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        return record;
    }

    @Override
    public Set<Data> keySet() {
        this.checkIfLoaded();
        long now = this.getNow();
        ConcurrentMap records = this.records;
        Collection values = records.values();
        HashSet<Data> keySet = null;
        for (Record record : values) {
            if ((record = this.getOrNullIfExpired(record, now, false)) == null) continue;
            if (keySet == null) {
                keySet = new HashSet<Data>();
            }
            keySet.add(record.getKey());
        }
        if (keySet == null) {
            return Collections.emptySet();
        }
        return keySet;
    }

    @Override
    public Collection<Data> valuesData() {
        this.checkIfLoaded();
        long now = this.getNow();
        ConcurrentMap records = this.records;
        Collection values = records.values();
        ArrayList<Data> dataValueList = null;
        for (Record record : values) {
            if ((record = this.getOrNullIfExpired(record, now, false)) == null) continue;
            if (dataValueList == null) {
                dataValueList = new ArrayList<Data>();
            }
            Data dataValue = this.toData(record.getValue());
            dataValueList.add(dataValue);
        }
        if (dataValueList == null) {
            return Collections.emptyList();
        }
        return dataValueList;
    }

    @Override
    public int clear() {
        this.checkIfLoaded();
        this.resetSizeEstimator();
        Set<Data> lockedKeys = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, Record> lockedRecords = new HashMap<Data, Record>(lockedKeys.size());
        for (Data key : lockedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockedRecords.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        Set<Data> keysToDelete = this.records.keySet();
        keysToDelete.removeAll(lockedRecords.keySet());
        this.mapDataStore.removeAll(keysToDelete);
        int numOfClearedEntries = keysToDelete.size();
        this.removeIndex(keysToDelete);
        this.clearRecordsMap(lockedRecords);
        this.resetAccessSequenceNumber();
        this.mapDataStore.clear();
        return numOfClearedEntries;
    }

    @Override
    public void reset() {
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        this.mapDataStore.clear();
    }

    @Override
    public Object evict(Data key, boolean backup) {
        return this.evictInternal(key, backup);
    }

    @Override
    Object evictInternal(Data key, boolean backup) {
        Record record = (Record)this.records.get(key);
        Object value = null;
        if (record != null) {
            value = record.getValue();
            long lastUpdateTime = record.getLastUpdateTime();
            this.mapDataStore.flush(key, value, lastUpdateTime, backup);
            if (!backup) {
                this.mapServiceContext.interceptRemove(this.name, value);
            }
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.deleteRecord(key);
            this.removeIndex(key);
        }
        return value;
    }

    @Override
    public int evictAll(boolean backup) {
        this.checkIfLoaded();
        int sizeBeforeEviction = this.size();
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        Map<Data, Record> recordsToPreserve = this.getLockedRecords();
        this.updateSizeEstimator(this.calculateRecordHeapCost(recordsToPreserve.values()));
        this.flush(recordsToPreserve, backup);
        this.removeIndexByPreservingKeys(this.records.keySet(), recordsToPreserve.keySet());
        this.clearRecordsMap(recordsToPreserve);
        return sizeBeforeEviction - recordsToPreserve.size();
    }

    private void flush(Map<Data, Record> excludeRecords, boolean backup) {
        Collection values = this.records.values();
        MapDataStore<Data, Object> mapDataStore = this.mapDataStore;
        for (Record record : values) {
            if (excludeRecords != null && excludeRecords.containsKey(record.getKey())) continue;
            Data key = record.getKey();
            long lastUpdateTime = record.getLastUpdateTime();
            mapDataStore.flush(key, record.getValue(), lastUpdateTime, backup);
        }
    }

    private Map<Data, Record> getLockedRecords() {
        if (this.lockStore == null) {
            return Collections.emptyMap();
        }
        Set<Data> lockedKeys = this.lockStore.getLockedKeys();
        if (lockedKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Data, Record> lockedRecords = new HashMap<Data, Record>(lockedKeys.size());
        for (Data key : lockedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockedRecords.put(key, record);
        }
        return lockedRecords;
    }

    @Override
    public void removeBackup(Data key) {
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, true);
        if (record == null) {
            return;
        }
        this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
        this.deleteRecord(key);
        this.mapDataStore.removeBackup(key, now);
    }

    @Override
    public Object remove(Data key) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue != null) {
                this.removeIndex(key);
                this.mapDataStore.remove(key, now);
            }
        } else {
            oldValue = this.removeRecord(key, record, now);
        }
        return oldValue;
    }

    @Override
    public boolean remove(Data key, Object testValue) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        boolean removed = false;
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue == null) {
                return false;
            }
        } else {
            oldValue = record.getValue();
        }
        if (this.mapServiceContext.compare(this.name, testValue, oldValue)) {
            this.mapServiceContext.interceptRemove(this.name, oldValue);
            this.removeIndex(key);
            this.mapDataStore.remove(key, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.deleteRecord(key);
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean delete(Data key) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record != null) {
            return this.removeRecord(key, record, now) != null;
        }
        this.removeIndex(key);
        this.mapDataStore.remove(key, now);
        return false;
    }

    @Override
    public Object get(Data key, boolean backup) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, backup);
        if (record == null) {
            record = this.loadRecordOrNull(key, backup);
        } else {
            this.accessRecord(record, now);
        }
        Object value = record == null ? null : (Object)record.getValue();
        value = this.mapServiceContext.interceptGet(this.name, value);
        this.postReadCleanUp(now, false);
        return value;
    }

    @Override
    public Data readBackupData(Data key) {
        long now = this.getNow();
        Record record = this.getRecord(key);
        if (record == null) {
            return null;
        }
        boolean expired = this.isExpired(record, now, false);
        if (expired) {
            return null;
        }
        MapServiceContext mapServiceContext = this.mapServiceContext;
        Object value = record.getValue();
        mapServiceContext.interceptAfterGet(this.name, value);
        return mapServiceContext.toData(value);
    }

    @Override
    public MapEntrySet getAll(Set<Data> keys) {
        this.checkIfLoaded();
        long now = this.getNow();
        MapEntrySet mapEntrySet = new MapEntrySet();
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            Record record = this.getRecordOrNull(key, now, false);
            if (record == null) continue;
            this.addMapEntrySet(record.getKey(), record.getValue(), mapEntrySet);
            this.accessRecord(record);
            iterator.remove();
        }
        Map loadedEntries = this.loadEntries(keys);
        this.addMapEntrySet(loadedEntries, mapEntrySet);
        return mapEntrySet;
    }

    private Map loadEntries(Set<Data> keys) {
        Map loadedEntries = this.mapDataStore.loadAll(keys);
        if (loadedEntries == null || loadedEntries.isEmpty()) {
            return Collections.emptyMap();
        }
        Set entrySet = loadedEntries.entrySet();
        Iterator i$ = entrySet.iterator();
        while (i$.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = i$.next();
            this.putFromLoad(this.toData(entry.getKey()), entry.getValue());
        }
        return loadedEntries;
    }

    private void addMapEntrySet(Object key, Object value, MapEntrySet mapEntrySet) {
        if (key == null || value == null) {
            return;
        }
        value = this.mapServiceContext.interceptGet(this.name, value);
        Data dataKey = this.mapServiceContext.toData(key);
        Data dataValue = this.mapServiceContext.toData(value);
        mapEntrySet.add(dataKey, dataValue);
    }

    private void addMapEntrySet(Map<Object, Object> entries, MapEntrySet mapEntrySet) {
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            this.addMapEntrySet(entry.getKey(), entry.getValue(), mapEntrySet);
        }
    }

    @Override
    public boolean containsKey(Data key) {
        boolean contains;
        Object value;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null && (value = this.mapDataStore.load(key)) != null) {
            record = this.createRecord(key, value, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        boolean bl = contains = record != null;
        if (contains) {
            this.accessRecord(record, now);
        }
        this.postReadCleanUp(now, false);
        return contains;
    }

    @Override
    public void put(Map.Entry<Data, Object> entry) {
        this.checkIfLoaded();
        long now = this.getNow();
        Data key = entry.getKey();
        Object value = entry.getValue();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            record = this.createRecord(key, value, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.saveIndex(record);
        } else {
            Object oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.name, oldValue, value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.updateRecord(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.saveIndex(record);
        }
    }

    @Override
    public Object put(Data key, Object value, long ttl) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.saveIndex(record);
        } else {
            oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.name, oldValue, value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.updateRecord(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
            this.saveIndex(record);
        }
        return oldValue;
    }

    @Override
    public boolean set(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        boolean newRecord = false;
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            newRecord = true;
        } else {
            value = this.mapServiceContext.interceptPut(this.name, record.getValue(), value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.updateRecord(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        this.saveIndex(record);
        return newRecord;
    }

    @Override
    public boolean merge(Data key, EntryView mergingEntry, MapMergePolicy mergePolicy) {
        Object newValue;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        mergingEntry = EntryViews.convertToLazyEntryView(mergingEntry, this.serializationService, mergePolicy);
        if (record == null) {
            Object notExistingKey = this.mapServiceContext.toObject(key);
            EntryView nullEntryView = EntryViews.createNullEntryView(notExistingKey);
            newValue = mergePolicy.merge(this.name, mergingEntry, nullEntryView);
            if (newValue == null) {
                return false;
            }
            newValue = this.mapDataStore.add(key, newValue, now);
            record = this.createRecord(key, newValue, now);
            this.mergeRecordExpiration(record, mergingEntry);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            Object oldValue = record.getValue();
            EntryView existingEntry = EntryViews.createLazyEntryView(record.getKey(), record.getValue(), record, this.serializationService, mergePolicy);
            newValue = mergePolicy.merge(this.name, mergingEntry, existingEntry);
            if (newValue == null) {
                this.removeIndex(key);
                this.mapDataStore.remove(key, now);
                this.onStore(record);
                this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
                this.deleteRecord(key);
                return true;
            }
            if (newValue == mergingEntry.getValue()) {
                this.mergeRecordExpiration(record, mergingEntry);
            }
            if (this.mapServiceContext.compare(this.name, newValue, oldValue)) {
                return true;
            }
            newValue = this.mapDataStore.add(key, newValue, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.recordFactory.setValue(record, newValue);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        this.saveIndex(record);
        return newValue != null;
    }

    @Override
    public Object replace(Data key, Object update) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null || record.getValue() == null) {
            return null;
        }
        Object oldValue = record.getValue();
        update = this.mapServiceContext.interceptPut(this.name, oldValue, update);
        update = this.mapDataStore.add(key, update, now);
        this.onStore(record);
        this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
        this.updateRecord(record, update, now);
        this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean replace(Data key, Object expect, Object update) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            return false;
        }
        MapServiceContext mapServiceContext = this.mapServiceContext;
        String mapName = this.name;
        Object current = record.getValue();
        if (!mapServiceContext.compare(mapName, current, expect)) {
            return false;
        }
        update = mapServiceContext.interceptPut(mapName, current, update);
        update = this.mapDataStore.add(key, update, now);
        this.onStore(record);
        this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
        this.updateRecord(record, update, now);
        this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        this.saveIndex(record);
        return true;
    }

    @Override
    public void putTransient(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            value = this.mapServiceContext.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.updateRecord(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        this.saveIndex(record);
        this.mapDataStore.addTransient(key, now);
    }

    @Override
    public Object putFromLoad(Data key, Object value) {
        return this.putFromLoad(key, value, -1L);
    }

    @Override
    public Object putFromLoad(Data key, Object value, long ttl) {
        if (key == null || value == null) {
            return null;
        }
        long now = this.getNow();
        if (this.shouldEvict(now)) {
            return null;
        }
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        Object oldValue = null;
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.updateRecord(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean tryPut(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            value = this.mapServiceContext.interceptPut(this.name, record.getValue(), value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.updateRecord(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        this.saveIndex(record);
        return true;
    }

    @Override
    public Object putIfAbsent(Data key, Object value, long ttl) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.markRecordStoreExpirable(ttl);
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue != null) {
                record = this.createRecord(key, oldValue, now);
                this.records.put(key, record);
                this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            }
        } else {
            this.accessRecord(record, now);
            oldValue = record.getValue();
        }
        if (oldValue == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            ExpirationTimeSetter.updateExpiryTime(record, ttl, this.mapContainer.getMapConfig());
        }
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public MapDataStore<Data, Object> getMapDataStore() {
        return this.mapDataStore;
    }

    private Object removeRecord(Data key, Record record, long now) {
        Object oldValue = record.getValue();
        if ((oldValue = this.mapServiceContext.interceptRemove(this.name, oldValue)) != null) {
            this.removeIndex(key);
            this.mapDataStore.remove(key, now);
            this.onStore(record);
        }
        this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
        this.deleteRecord(key);
        return oldValue;
    }

    @Override
    public Record getRecordOrNull(Data key) {
        long now = this.getNow();
        return this.getRecordOrNull(key, now, false);
    }

    private Record getRecordOrNull(Data key, long now, boolean backup) {
        Record record = (Record)this.records.get(key);
        if (record == null) {
            return null;
        }
        return this.getOrNullIfExpired(record, now, backup);
    }

    private void deleteRecord(Data key) {
        Record record = (Record)this.records.remove(key);
        if (record != null) {
            record.invalidate();
        }
    }
}

