/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.impl.client.RingbufferRequest;
import com.hazelcast.ringbuffer.impl.operations.AddOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class AddAsyncRequest
extends RingbufferRequest {
    private Data item;
    private OverflowPolicy overflowPolicy;

    public AddAsyncRequest() {
    }

    public AddAsyncRequest(String name, Data item, OverflowPolicy overflowPolicy) {
        super(name);
        this.item = item;
        this.overflowPolicy = overflowPolicy;
    }

    @Override
    protected Operation prepareOperation() {
        return new AddOperation(this.name, this.item, this.overflowPolicy);
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("o", this.overflowPolicy.getId());
        writer.getRawDataOutput().writeData(this.item);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.overflowPolicy = OverflowPolicy.getById(reader.readInt("o"));
        this.item = reader.getRawDataInput().readData();
    }
}

