/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Network;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class Hardware {
    private Screen mScreen;
    private EnumSet<Network> mNetworking = EnumSet.noneOf(Network.class);
    private EnumSet<Sensor> mSensors = EnumSet.noneOf(Sensor.class);
    private boolean mMic;
    private List<Camera> mCameras = new ArrayList<Camera>(2);
    private Keyboard mKeyboard;
    private Navigation mNav;
    private Storage mRam;
    private ButtonType mButtons;
    private List<Storage> mInternalStorage = new ArrayList<Storage>();
    private List<Storage> mRemovableStorage = new ArrayList<Storage>();
    private String mCpu;
    private String mGpu;
    private EnumSet<Abi> mAbis = EnumSet.noneOf(Abi.class);
    private EnumSet<UiMode> mUiModes = EnumSet.noneOf(UiMode.class);
    private PowerType mPluggedIn;

    @NonNull
    public Set<Network> getNetworking() {
        return this.mNetworking;
    }

    public void addNetwork(@NonNull Network n) {
        this.mNetworking.add(n);
    }

    public void addAllNetworks(@NonNull Collection<Network> ns) {
        this.mNetworking.addAll(ns);
    }

    @NonNull
    public Set<Sensor> getSensors() {
        return this.mSensors;
    }

    public void addSensor(@NonNull Sensor sensor) {
        this.mSensors.add(sensor);
    }

    public void addAllSensors(@NonNull Collection<Sensor> sensors) {
        this.mSensors.addAll(sensors);
    }

    public boolean hasMic() {
        return this.mMic;
    }

    public void setHasMic(boolean hasMic) {
        this.mMic = hasMic;
    }

    @NonNull
    public List<Camera> getCameras() {
        return this.mCameras;
    }

    public void addCamera(@NonNull Camera c) {
        this.mCameras.add(c);
    }

    public void addAllCameras(@NonNull Collection<Camera> cs) {
        this.mCameras.addAll(cs);
    }

    @NonNull
    public Camera getCamera(int i) {
        return this.mCameras.get(i);
    }

    @Nullable
    public Camera getCamera(@NonNull CameraLocation location) {
        for (Camera c : this.mCameras) {
            if (location != c.getLocation()) continue;
            return c;
        }
        return null;
    }

    public Keyboard getKeyboard() {
        return this.mKeyboard;
    }

    public void setKeyboard(@NonNull Keyboard keyboard) {
        this.mKeyboard = keyboard;
    }

    public Navigation getNav() {
        return this.mNav;
    }

    public void setNav(@NonNull Navigation n) {
        this.mNav = n;
    }

    public Storage getRam() {
        return this.mRam;
    }

    public void setRam(@NonNull Storage ram) {
        this.mRam = ram;
    }

    public ButtonType getButtonType() {
        return this.mButtons;
    }

    public void setButtonType(@NonNull ButtonType bt) {
        this.mButtons = bt;
    }

    @NonNull
    public List<Storage> getInternalStorage() {
        return this.mInternalStorage;
    }

    public void addInternalStorage(@NonNull Storage is) {
        this.mInternalStorage.add(is);
    }

    public void addAllInternalStorage(@NonNull Collection<Storage> is) {
        this.mInternalStorage.addAll(is);
    }

    @NonNull
    public List<Storage> getRemovableStorage() {
        return this.mRemovableStorage;
    }

    public void addRemovableStorage(@NonNull Storage rs) {
        this.mRemovableStorage.add(rs);
    }

    public void addAllRemovableStorage(@NonNull Collection<Storage> rs) {
        this.mRemovableStorage.addAll(rs);
    }

    public String getCpu() {
        return this.mCpu;
    }

    public void setCpu(@NonNull String cpuName) {
        this.mCpu = cpuName;
    }

    public String getGpu() {
        return this.mGpu;
    }

    public void setGpu(@NonNull String gpuName) {
        this.mGpu = gpuName;
    }

    @NonNull
    public Set<Abi> getSupportedAbis() {
        return this.mAbis;
    }

    public void addSupportedAbi(@NonNull Abi abi) {
        this.mAbis.add(abi);
    }

    public void addAllSupportedAbis(@NonNull Collection<Abi> abis) {
        this.mAbis.addAll(abis);
    }

    @NonNull
    public Set<UiMode> getSupportedUiModes() {
        return this.mUiModes;
    }

    public void addSupportedUiMode(@NonNull UiMode uiMode) {
        this.mUiModes.add(uiMode);
    }

    public void addAllSupportedUiModes(@NonNull Collection<UiMode> uiModes) {
        this.mUiModes.addAll(uiModes);
    }

    public PowerType getChargeType() {
        return this.mPluggedIn;
    }

    public void setChargeType(@NonNull PowerType chargeType) {
        this.mPluggedIn = chargeType;
    }

    public Screen getScreen() {
        return this.mScreen;
    }

    public void setScreen(@NonNull Screen s) {
        this.mScreen = s;
    }

    public Hardware deepCopy() {
        Hardware hw = new Hardware();
        hw.mScreen = this.mScreen.deepCopy();
        hw.mNetworking = this.mNetworking.clone();
        hw.mSensors = this.mSensors.clone();
        hw.mMic = this.mMic;
        hw.mCameras = new ArrayList<Camera>();
        for (Camera c : this.mCameras) {
            hw.mCameras.add(c.deepCopy());
        }
        hw.mKeyboard = this.mKeyboard;
        hw.mNav = this.mNav;
        hw.mRam = this.mRam.deepCopy();
        hw.mButtons = this.mButtons;
        hw.mInternalStorage = new ArrayList<Storage>();
        for (Storage s : this.mInternalStorage) {
            hw.mInternalStorage.add(s.deepCopy());
        }
        hw.mRemovableStorage = new ArrayList<Storage>();
        for (Storage s : this.mRemovableStorage) {
            hw.mRemovableStorage.add(s.deepCopy());
        }
        hw.mCpu = this.mCpu;
        hw.mGpu = this.mGpu;
        hw.mAbis = this.mAbis.clone();
        hw.mUiModes = this.mUiModes.clone();
        hw.mPluggedIn = this.mPluggedIn;
        return hw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hardware)) {
            return false;
        }
        Hardware hw = (Hardware)o;
        return this.mScreen.equals(hw.getScreen()) && this.mNetworking.equals(hw.getNetworking()) && this.mSensors.equals(hw.getSensors()) && this.mMic == hw.hasMic() && ((Object)this.mCameras).equals(hw.getCameras()) && this.mKeyboard == hw.getKeyboard() && this.mNav == hw.getNav() && this.mRam.equals(hw.getRam()) && this.mButtons == hw.getButtonType() && ((Object)this.mInternalStorage).equals(hw.getInternalStorage()) && ((Object)this.mRemovableStorage).equals(hw.getRemovableStorage()) && this.mCpu.equals(hw.getCpu()) && this.mGpu.equals(hw.getGpu()) && this.mAbis.equals(hw.getSupportedAbis()) && this.mUiModes.equals(hw.getSupportedUiModes()) && this.mPluggedIn == hw.getChargeType();
    }

    public int hashCode() {
        Character c;
        int i$;
        int hash = 17;
        hash = 31 * hash + this.mScreen.hashCode();
        int temp = 0;
        for (Network n : this.mNetworking) {
            temp |= 1 << n.ordinal();
        }
        hash = 31 * hash + temp;
        temp = 0;
        for (Sensor s : this.mSensors) {
            temp |= 1 << s.ordinal();
        }
        hash = 31 * hash + temp;
        hash = 31 * hash + (this.mMic ? 1 : 0);
        hash = ((Object)this.mCameras).hashCode();
        hash = 31 * hash + this.mKeyboard.ordinal();
        hash = 31 * hash + this.mNav.ordinal();
        hash = 31 * hash + this.mRam.hashCode();
        hash = 31 * hash + this.mButtons.ordinal();
        hash = 31 * hash + ((Object)this.mInternalStorage).hashCode();
        hash = 31 * hash + ((Object)this.mRemovableStorage).hashCode();
        char[] arr$ = this.mCpu.toCharArray();
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            c = Character.valueOf(arr$[i$]);
            hash = 31 * hash + c.charValue();
        }
        arr$ = this.mGpu.toCharArray();
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            c = Character.valueOf(arr$[i$]);
            hash = 31 * hash + c.charValue();
        }
        temp = 0;
        for (Abi a : this.mAbis) {
            temp |= 1 << a.ordinal();
        }
        hash = 31 * hash + temp;
        temp = 0;
        for (UiMode ui : this.mUiModes) {
            temp |= 1 << ui.ordinal();
        }
        hash = 31 * hash + temp;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Hardware <mScreen=");
        sb.append(this.mScreen);
        sb.append(", mNetworking=");
        sb.append(this.mNetworking);
        sb.append(", mSensors=");
        sb.append(this.mSensors);
        sb.append(", mMic=");
        sb.append(this.mMic);
        sb.append(", mCameras=");
        sb.append(this.mCameras);
        sb.append(", mKeyboard=");
        sb.append(this.mKeyboard);
        sb.append(", mNav=");
        sb.append(this.mNav);
        sb.append(", mRam=");
        sb.append(this.mRam);
        sb.append(", mButtons=");
        sb.append((Object)this.mButtons);
        sb.append(", mInternalStorage=");
        sb.append(this.mInternalStorage);
        sb.append(", mRemovableStorage=");
        sb.append(this.mRemovableStorage);
        sb.append(", mCpu=");
        sb.append(this.mCpu);
        sb.append(", mGpu=");
        sb.append(this.mGpu);
        sb.append(", mAbis=");
        sb.append(this.mAbis);
        sb.append(", mUiModes=");
        sb.append(this.mUiModes);
        sb.append(", mPluggedIn=");
        sb.append((Object)this.mPluggedIn);
        sb.append(">");
        return sb.toString();
    }
}

