# Projects

The Herb ecosystem consists of various projects that work together to provide comprehensive HTML+ERB tooling. These projects are organized into three main categories: developer tools that users interact with directly, language bindings that provide access to the parser, and utility libraries that support the ecosystem.

## Developer Tools

These are the user-facing tools that integrate into your development workflow:

* [Herb Language Server](/projects/language-server)
* [Herb Formatter](/projects/formatter)
* [Herb Linter](/projects/linter)
* [Herb CLI](/projects/cli)

## Language Bindings

These libraries provide access to the Herb Parser in different programming languages:

* [Herb Parser (C Library `libherb`)](/projects/parser)
* [Ruby Bindings](/bindings/ruby/)
* [JavaScript/Node.js Bindings](/bindings/javascript/)
* [WebAssembly Build](/projects/webassembly)

## Utility Libraries

These specialized libraries provide additional functionality for working with HTML+ERB:

* [Language Service](/projects/language-service)
* [Highlighter](/projects/highlighter)
* [Syntax Tree Printer](/projects/minifier)
* [Printer](/projects/printer)
* [Core](/projects/core)
