// Copyright (c) 2009-2010 Satoshi Nakamoto
// Copyright (c) 2009-2017 The Bitcoin Core developers
// Copyright (c) 2013-2025 The Goldcoin Core developers
// Distributed under the MIT software license, see the accompanying
// file COPYING or http://www.opensource.org/licenses/mit-license.php.


#ifndef GOLDCOIN_CONSENSUS_CONSENSUS_H
#define GOLDCOIN_CONSENSUS_CONSENSUS_H

#include <stdint.h>

// The maximum allowed size for a serialized block, in bytes (only for buffer size limits)
static constexpr unsigned int MAX_BLOCK_SERIALIZED_SIZE = 32000000;

/** The maximum allowed size for a block, in bytes (network rule) */
static constexpr unsigned int MAX_BLOCK_BASE_SIZE = MAX_BLOCK_SERIALIZED_SIZE;
/** The maximum allowed number of signature check operations in a block (network rule) */
static constexpr int64_t MAX_BLOCK_SIGOPS_COST = 40000 * 16;
/** Coinbase transaction outputs can only be spent after this number of new blocks (network rule) */

static constexpr int COINBASE_MATURITY = 100;

/** Flags for nSequence and nLockTime locks */
enum {
    /* Interpret sequence numbers as relative lock-time constraints. */
    LOCKTIME_VERIFY_SEQUENCE = (1 << 0),

    /* Use GetMedianTimePast() instead of nTime for end point timestamp. */
    LOCKTIME_MEDIAN_TIME_PAST = (1 << 1),
};

#endif // GOLDCOIN_CONSENSUS_CONSENSUS_H
