# Samples

This directory contains samples for Rexl and RexlScript. It comtains the directories
* [notebooks](#notebooks)
* [data](#data)

## Notebooks

The [notebooks](notebooks) directory contains
Jupyter notebook files. To run the notebooks, ensure that Jupyter is properly installed and that
the Rexl kernel is built and registered.

The Jupyter notebook files include:
* [NFL.ipynb](notebooks/NFL.ipynb): demonstrates some tabular data manipulation using NFL game data.
* [Comma.ipynb](notebooks/Comma.ipynb): discusses the _implicit lambda_ pattern and why Rexl doesn't
  need an analog of Excel's `SUMPRODUCT` function.
* [ImageAsTensor.ipynb](notebooks/ImageAsTensor.ipynb): Illustrates representing images as tensors
  and performing some basic transformation.
* [ImageClassification.ipynb](notebooks/ImageClassification.ipynb): Illustrates using some ONNX
  models from Rexl to classify images.
* [ProteinFolding.ipynb](notebooks/ProteinFolding.ipynb): Illustrates a protein folding optimization
  problem formulated as a Rexl module. Solves using three integrated MIP solvers,
  [Gurobi](https://www.gurobi.com/) (requires license), [HiGHS](https://highs.dev/), and
  [GLPK](https://www.gnu.org/software/glpk/).
* [EssentialMedicines.ipynb](notebooks/EssentialMedicines.ipynb): Uses Rexl _module_ functionality
  to formulate an essential medicines optimization problem. Rexl dispatches to the Gurobi solver
  (requires license from Gurobi) to perfom the optimization.
* [HexagonalPuzzleSat.ipynb](notebooks/HexagonalPuzzleSat.ipynb): Illustrates using the SAT
  (boolean satisfiability) solver to find solutions to a tricky geometric puzzle.
* [SudokuSat.ipynb](notebooks/SudokuSat.ipynb): Uses the Rexl SAT solver to solve Sudoku puzzles.
* [SudokuMip.ipynb](notebooks/SudokuMip.ipynb) and [SudokuMipEq.ipynb](notebooks/SudokuMipEq.ipynb.ipynb):
  These use Rexl _module_ functionality and MIP solver integration to solve Sudoku puzzles.

## Data

The [data](data) directory contains data files of various forms used in sample notebooks and scripts.
Some of the files are Rexl scripts that define one or more global symbols. Other files may be binary
data files (such as parquet or rbin files) or images (jpg, png) or just about anything.

The data files include:
* [NFL-2010-Games.rexl](data/NFL-2010-Games.rexl):
  A RexlScript file that defines a global named `Games` containing data for the NFL games played during the
  2010 regular season.
* [Orders.rexl](data/Orders.rexl): A RexlScript file
  that defines a global named `Orders` containing (fictitious) data for customer orders.
* [ChemNodes.rbin](data) and [ReacNodes.rbin](data): These are the tables needed for the
  [EssentialMedicines.ipynb](notebooks/EssentialMedicines.ipynb) notebook.
* [HexagonalPuzzlePieces.jpeg](data/HexagonalPuzzlePieces.jpeg) and
  [HexagonalPuzzleSolution.jpeg](data/HexagonalPuzzleSolution.jpeg): These are images used in the
  [HexagonalPuzzleSat.ipynb](notebooks/HexagonalPuzzleSat.ipynb) notebook.
* [HexagonalPuzzleSlns.rbin](data/HexagonalPuzzleSlns.rbin): This contais the solutions generated by the
  [HexagonalPuzzleSat.ipynb](notebooks/HexagonalPuzzleSat.ipynb) notebook.

 **Note**: when adding a new kind of data file that should use LFS, ensure that the
 [`.gitattributes`](/.gitattributes) file has an entry for the extension.
