
#pragma once

#include <bond/core/bond_version.h>

#if BOND_VERSION < 0x0b00
#error This file was generated by a newer version of the Bond compiler and is incompatible with your version of the Bond library.
#endif

#if BOND_MIN_CODEGEN_VERSION > 0x0d00
#error This file was generated by an older version of the Bond compiler and is incompatible with your version of the Bond library.
#endif

#include <bond/core/config.h>
#include <bond/core/containers.h>



namespace tests
{
    
    struct Foo
    {
        using allocator_type = arena;

        bool o;
        int16_t r;
        double ro;
        
        Foo()
          : o(),
            r(),
            ro()
        {
        }

        
        // Compiler generated copy ctor OK
        Foo(const Foo&) = default;

        Foo(const Foo& other, const arena&)
          : o(other.o),
            r(other.r),
            ro(other.ro)
        {
        }
        
        Foo(Foo&&) = default;

        Foo(Foo&& other, const arena&)
          : o(std::move(other.o)),
            r(std::move(other.r)),
            ro(std::move(other.ro))
        {
        }
        
        explicit
        Foo(const arena&)
          : o(),
            r(),
            ro()
        {
        }
        
        
        // Compiler generated operator= OK
        Foo& operator=(const Foo&) = default;
        Foo& operator=(Foo&&) = default;

        bool operator==(const Foo& other) const
        {
            return true
                && (o == other.o)
                && (r == other.r)
                && (ro == other.ro);
        }

        bool operator!=(const Foo& other) const
        {
            return !(*this == other);
        }

        void swap(Foo& other)
        {
            using std::swap;
            swap(o, other.o);
            swap(r, other.r);
            swap(ro, other.ro);
        }

        struct Schema;

    protected:
        void InitMetadata(const char*, const char*)
        {
        }
    };

    inline void swap(::tests::Foo& left, ::tests::Foo& right)
    {
        left.swap(right);
    }
} // namespace tests
