
#pragma once

#include <bond/core/bond_version.h>

#if BOND_VERSION < 0x0b00
#error This file was generated by a newer version of the Bond compiler and is incompatible with your version of the Bond library.
#endif

#if BOND_MIN_CODEGEN_VERSION > 0x0d00
#error This file was generated by an older version of the Bond compiler and is incompatible with your version of the Bond library.
#endif

#include <bond/core/config.h>
#include <bond/core/containers.h>


#include "dir1/dir2/empty_types.h"

namespace import_test
{
    
    struct HasEmpty
    {
        using allocator_type = arena;

        ::empty::Empty e;
        
        template <int = 0> // Workaround to avoid compilation if not used
        HasEmpty()
        {
        }

        
        // Compiler generated copy ctor OK
        HasEmpty(const HasEmpty&) = default;
        
        HasEmpty(HasEmpty&&) = default;
        
        explicit
        HasEmpty(const arena& allocator)
          : e(allocator)
        {
        }
        
        
        // Compiler generated operator= OK
        HasEmpty& operator=(const HasEmpty&) = default;
        HasEmpty& operator=(HasEmpty&&) = default;

        bool operator==(const HasEmpty& other) const
        {
            return true
                && (e == other.e);
        }

        bool operator!=(const HasEmpty& other) const
        {
            return !(*this == other);
        }

        void swap(HasEmpty& other)
        {
            using std::swap;
            swap(e, other.e);
        }

        struct Schema;

    protected:
        void InitMetadata(const char*, const char*)
        {
        }
    };

    inline void swap(::import_test::HasEmpty& left, ::import_test::HasEmpty& right)
    {
        left.swap(right);
    }
} // namespace import_test
