# Cucumber Community Code of Conduct

Cucumber is used and developed by people from all over the world who have a diverse set of skills, personalities and experiences. This diversity is wonderful, and we are committed to ensuring that the Cucumber community is a safe, enjoyable and thriving environment for everyone.

As a community, we expect any participant to act according to the following ground rules. They ensure that everyone within the community is clear about the behaviour that is expected of them, and that newcomers know what kind of environment they can expect to find.

## Enforcing this code of conduct

If you experience or observe a violation of this code of conduct, or have any other concerns, please contact [the moderators](#who-are-the-moderators) at [mods@cucumber.io](mailto:mods@cucumber.io). We are here to help you. Your reports will be taken seriously, treated in confidence and will not be dismissed or argued with.

As a member of the community, you are also encouraged to help others act according to the following principles.

## Guiding principles

- **We are welcoming**. We believe that a diverse community is stronger, more vibrant and has more potential contributors and more sources for ideas. We aim for more diversity. We strive to welcome people of all backgrounds, identities, and levels of experience. This includes, but is not limited to members of any race, ethnicity, culture, national origin, colour, immigration status, social and economic class, educational level, sex, sexual orientation, gender identity and expression, age, size, family status, political belief, religion, and mental and physical ability.
- **We are kind**. We are warm, courteous, patient, respectful and encouraging. Disagreements, both social and technical, happen all the time and Cucumber is no exception. These differences are where we can learn the most — if everyone thought the same all the time life would be boring! We’re respectful of other people’s opinions, experience, their skills, their commitments and their efforts. We make an effort to be compassionate towards one another, to assume good intention of others, and to seek to understand first before seeking to be understood.
- **We are tolerant**. A diverse group of people has a diverse set of boundaries about what is OK. Sometimes one of us may make a mistake, and do something that inadvertently causes offence. When we observe this happen, we try to give the offender feedback quickly, clearly and constructively. We try to offer them the opportunity to maintain their dignity in the situation, to learn from and rectify their mistake.
- **We do not tolerate unpleasant behaviour**. If someone repeatedly or deliberately acts in an offensive way, we will take decisive action to prevent any further harm.

## What is not OK

This isn’t an exhaustive list of things that you can’t do. Rather, take it in the spirit in which it’s intended - a guide to make all of our daily interactions more straightforward and enriching.

- Aggressive behaviour, whether in words or actions, whether overt or passive, is not OK.
- In other words: don’t be mean, rude, demeaning, condescending or demanding.
- Don’t discriminate against anyone.
- Don’t shame people for their mistakes or inexperience.
- Don’t harass people, sexually or otherwise. If someone has asked you to stop doing whatever you're doing - or if you notice they don't like what you're doing - stop and apologize, even if it seems unreasonable to you. Then remember, they are not under any obligation to accept your apology or interact with you in the future. Harassment includes comments or questions related to personal attributes such as (but not limited to) age, body size, culture, ethnicity, gender expression, gender identity, level of experience, nationality, personal ability or disability, physical appearance, physical or mental difference, race, religion, set of skills, sexual orientation, socio-economic status, and subculture. Harassment also includes sexual images in public spaces, deliberate intimidation, stalking, following, harassing photography or recording, inappropriate physical contact, and unwelcome sexual attention.
- On GitHub, Gitter, Slack and other online or offline communications channels, don't use sexual/racially offensive nicknames or avatars, or other nicknames/avatars that might detract from a friendly, safe and welcoming environment for all.
- Respect that some individuals and cultures consider the casual use of profanity offensive and off-putting.
- Don’t dismiss people who react negatively to someone’s behaviour, especially your own. If someone reacts to something differently than you do, it might not be that they are overreacting. Instead, they might be responding reasonably in the context of their life experiences. Please do your best to anticipate what those sensitivities might be and respond accordingly.
- Unwelcome / non-consensual sexual advances are not okay.
- Derailing, tone arguments and otherwise playing on people’s desires to be nice are not welcome.
- When critiquing other people’s work or ideas, avoid ad hominem or personal attacks.
- Likewise any spamming, trolling, flaming, baiting or other attention-stealing behaviour is not welcome.
- Sponsors of Cucumber events are also subject to this Code of Conduct. In particular, sponsors are required to not use sexualized images, activities, or other material which is in violation of this Code of Conduct.

## Who do these rules apply to?

These rules apply to anyone involved in the Cucumber community, including but not limited to the founders and staff of Cucumber Limited, presenters, organisers and attendees at Cucumber events, maintainers and contributors of open source projects, and community members engaged in discussions on issue trackers, mailing lists or chat rooms.

## Where does this apply?

The rules listed above apply to all official Cucumber venues; including the CukeUp conferences, public training courses, official Slack chat channels; GitHub repositories under cucumber, cucumber-ltd, and the cukes@googlegroups.com community mailing list.

## Consequences

If someone engages in any behaviour violating this Code of Conduct, [the moderators](#who-are-the-moderators) may take any action they deem appropriate, including warning the offender in private or in public, expulsion from the community, exclusion from any interaction and loss of all rights in this community.

Decisions about consequences of violations of this Code of Conduct are made by [the moderators](#who-are-the-moderators) and will not necessarily be discussed with the person responsible for the violation.

## Questions or Feedback

If you have any questions or feedback on this Code of Conduct, [we’re happy to hear from you](mailto:mods@cucumber.io).

## Who are the moderators?

The current moderators of the Cucumber community are:

- Matt Wynne
- Aslak Hellesøy
- Tracey S. Rosenberg
- Jo Laing

You can contact us by email at [mods@cucumber.io](mailto:mods@cucumber.io).

## References / inspiration

We’re grateful to these references for providing us with ideas and inspiration for this document:

- http://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/
- https://www.rust-lang.org/conduct.html
- https://www.djangoproject.com/conduct/
- http://hood.ie/code-of-conduct/
- https://github.com/Homebrew/.github/blob/master/CODE_OF_CONDUCT.md
