<?php

declare(strict_types=1);

/**
 * This code was auto-generated by {this script}[https://github.com/cucumber/common/blob/main/messages/jsonschema/scripts/codegen.rb]
 */

namespace Cucumber\Messages;

use JsonSerializable;
use Cucumber\Messages\DecodingException\SchemaViolationException;

/**
 * Represents the Hook message in Cucumber's message protocol
 * @see https://github.com/cucumber/common/tree/main/messages#readme
 *
 */
final class Hook implements JsonSerializable
{
    use JsonEncodingTrait;

    /**
     * Construct the Hook with all properties
     *
     */
    public function __construct(
        public readonly string $id = '',
        public readonly ?string $name = null,
        public readonly SourceReference $sourceReference = new SourceReference(),
        public readonly ?string $tagExpression = null,
    ) {
    }

    /**
     * @throws SchemaViolationException
     *
     * @internal
     */
    public static function fromArray(array $arr): self
    {
        self::ensureId($arr);
        self::ensureName($arr);
        self::ensureSourceReference($arr);
        self::ensureTagExpression($arr);

        return new self(
            (string) $arr['id'],
            isset($arr['name']) ? (string) $arr['name'] : null,
            SourceReference::fromArray($arr['sourceReference']),
            isset($arr['tagExpression']) ? (string) $arr['tagExpression'] : null,
        );
    }

    /**
     * @psalm-assert array{id: string|int|bool} $arr
     */
    private static function ensureId(array $arr): void
    {
        if (!array_key_exists('id', $arr)) {
            throw new SchemaViolationException('Property \'id\' is required but was not found');
        }
        if (array_key_exists('id', $arr) && is_array($arr['id'])) {
            throw new SchemaViolationException('Property \'id\' was array');
        }
    }

    /**
     * @psalm-assert array{name?: string|int|bool} $arr
     */
    private static function ensureName(array $arr): void
    {
        if (array_key_exists('name', $arr) && is_array($arr['name'])) {
            throw new SchemaViolationException('Property \'name\' was array');
        }
    }

    /**
     * @psalm-assert array{sourceReference: array} $arr
     */
    private static function ensureSourceReference(array $arr): void
    {
        if (!array_key_exists('sourceReference', $arr)) {
            throw new SchemaViolationException('Property \'sourceReference\' is required but was not found');
        }
        if (array_key_exists('sourceReference', $arr) && !is_array($arr['sourceReference'])) {
            throw new SchemaViolationException('Property \'sourceReference\' was not array');
        }
    }

    /**
     * @psalm-assert array{tagExpression?: string|int|bool} $arr
     */
    private static function ensureTagExpression(array $arr): void
    {
        if (array_key_exists('tagExpression', $arr) && is_array($arr['tagExpression'])) {
            throw new SchemaViolationException('Property \'tagExpression\' was array');
        }
    }
}
