<?php

declare(strict_types=1);

/**
 * This code was auto-generated by {this script}[https://github.com/cucumber/common/blob/main/messages/jsonschema/scripts/codegen.rb]
 */

namespace Cucumber\Messages;

use JsonSerializable;
use Cucumber\Messages\DecodingException\SchemaViolationException;

/**
 * Represents the StepMatchArgumentsList message in Cucumber's message protocol
 * @see https://github.com/cucumber/common/tree/main/messages#readme
 *
 */
final class StepMatchArgumentsList implements JsonSerializable
{
    use JsonEncodingTrait;

    /**
     * Construct the StepMatchArgumentsList with all properties
     *
     * @param list<StepMatchArgument> $stepMatchArguments
     */
    public function __construct(
        public readonly array $stepMatchArguments = [],
    ) {
    }

    /**
     * @throws SchemaViolationException
     *
     * @internal
     */
    public static function fromArray(array $arr): self
    {
        self::ensureStepMatchArguments($arr);

        return new self(
            array_values(array_map(fn (array $member) => StepMatchArgument::fromArray($member), $arr['stepMatchArguments'])),
        );
    }

    /**
     * @psalm-assert array{stepMatchArguments: array} $arr
     */
    private static function ensureStepMatchArguments(array $arr): void
    {
        if (!array_key_exists('stepMatchArguments', $arr)) {
            throw new SchemaViolationException('Property \'stepMatchArguments\' is required but was not found');
        }
        if (array_key_exists('stepMatchArguments', $arr) && !is_array($arr['stepMatchArguments'])) {
            throw new SchemaViolationException('Property \'stepMatchArguments\' was not array');
        }
    }
}
