<?php

declare(strict_types=1);

/**
 * This code was auto-generated by {this script}[https://github.com/cucumber/common/blob/main/messages/jsonschema/scripts/codegen.rb]
 */

namespace Cucumber\Messages;

use JsonSerializable;
use Cucumber\Messages\DecodingException\SchemaViolationException;

/**
 * Represents the TableCell message in Cucumber's message protocol
 * @see https://github.com/cucumber/common/tree/main/messages#readme
 *
 * A cell in a `TableRow` */
final class TableCell implements JsonSerializable
{
    use JsonEncodingTrait;

    /**
     * Construct the TableCell with all properties
     *
     */
    public function __construct(

        /**
         * The location of the cell
         */
        public readonly Location $location = new Location(),

        /**
         * The value of the cell
         */
        public readonly string $value = '',
    ) {
    }

    /**
     * @throws SchemaViolationException
     *
     * @internal
     */
    public static function fromArray(array $arr): self
    {
        self::ensureLocation($arr);
        self::ensureValue($arr);

        return new self(
            Location::fromArray($arr['location']),
            (string) $arr['value'],
        );
    }

    /**
     * @psalm-assert array{location: array} $arr
     */
    private static function ensureLocation(array $arr): void
    {
        if (!array_key_exists('location', $arr)) {
            throw new SchemaViolationException('Property \'location\' is required but was not found');
        }
        if (array_key_exists('location', $arr) && !is_array($arr['location'])) {
            throw new SchemaViolationException('Property \'location\' was not array');
        }
    }

    /**
     * @psalm-assert array{value: string|int|bool} $arr
     */
    private static function ensureValue(array $arr): void
    {
        if (!array_key_exists('value', $arr)) {
            throw new SchemaViolationException('Property \'value\' is required but was not found');
        }
        if (array_key_exists('value', $arr) && is_array($arr['value'])) {
            throw new SchemaViolationException('Property \'value\' was array');
        }
    }
}
