/*!
 * Decoda v1.3.1
 * Copyright 2012, Miles Johnson - http://milesj.me/code/mootools/decoda
 * MIT - https://github.com/milesj/decoda.js/blob/master/license.md
 */
!function(a){"use strict";a.Decoda=new Class({Implements:[Events,Options],editor:null,toolbar:null,textarea:null,form:null,container:null,preview:null,help:null,tags:[],options:{open:"[",close:"]",namespace:"",previewUrl:"",maxNewLines:3,onSubmit:null,onInsert:null,onInitialize:null,onRenderToolbar:null,onRenderPreview:null,onRenderHelp:null},initialize:function(a,b){if(this.setOptions(b),this.textarea=document.id(a),!this.textarea)throw new Error("Invalid textarea");this.form=this.textarea.getParent("form"),this.editor=new Element("div.decoda-editor"),this.toolbar=new Element("div.decoda-toolbars"),this.container=new Element("div.decoda-textarea"),this.preview=new Element("div.decoda-preview").hide(),this.help=new Element("div.decoda-help").hide(),this.container.wraps(this.textarea),this.editor.grab(this.toolbar).wraps(this.container).adopt([this.preview,this.help]),this.options.namespace&&this.editor.addClass(this.options.namespace),this.$events.submit&&this.form.addEvent("submit",this.$events.submit[0].bind(this)),this.fireEvent("initialize")},defaults:function(a){return this.addFilters(null,null,a),this.addControls(null,null,a),this},addControls:function(a,b,c){return b?this.buildToolbar(a,b,c):Object.each(Decoda.controls,function(a,b){this.addControls(b,a,c)}.bind(this)),this},addFilters:function(a,b,c){if(b)this.buildToolbar(a,b,c),Object.each(b,function(a){this.tags.push(a)}.bind(this));else{var d=Object.clone(Decoda.filters);delete d.email,delete d.url,delete d.image,delete d.video,Object.each(d,function(a,b){this.addFilters(b,a,c)}.bind(this))}return this},buildToolbar:function(a,b,c){c=Array.from(c)||[];var d,e,f,g,h=new Element("ul.decoda-toolbar").addClass("toolbar-"+a);Object.each(b,function(a){c.indexOf(a.tag)>=0||(d=new Element("li"),e=new Element("button.tag-"+a.tag,{html:"<span></span>",title:a.title,type:"button"}),e.addEvent("click",(a.onClick||this.insertTag).bind(this,a,e)),a.key&&(e.set("title",e.get("title")+" (Ctrl + "+a.key.toUpperCase()+")"),this.textarea.addEvent("keydown",function(b){this._listenKeydown.attempt([b,a,e],this)}.bind(this))),a.className&&e.addClass(a.className),d.grab(e),a.options&&(f=new Element("ul.decoda-menu").addClass("menu-"+a.tag),a.options.each(function(b){b=Object.merge({},a,b),c.indexOf(b.tag)>=0||(g=new Element("a",{href:"javascript:;",html:"<span></span>"+b.title,title:b.title}),g.addEvent("click",(b.onClick||this.insertTag).bind(this,b,g)),b.className&&g.addClass(b.className),f.grab(new Element("li").grab(g)))}.bind(this)),d.grab(f)),h.grab(d))}.bind(this)),h.hasChildNodes()&&(this.toolbar.grab(h),this.fireEvent("renderToolbar",h));var i=this.toolbar.getElements(".decoda-toolbar"),j=i.length;return i.each(function(a){a.setStyle("z-index",j),j--}),this},disableToolbar:function(){return this.toolbar.getElements("button").each(function(a){a.set("disabled",!0),a.getParent("li").addClass("disabled")}),this},enableToolbar:function(){return this.toolbar.getElements("button").each(function(a){a.set("disabled",!1),a.getParent("li").removeClass("disabled")}),this},clean:function(){var a=String.from(this.textarea.get("value")),b=this.options.maxNewLines;return a=a.replace(/\r\n/g,"\n"),a=a.replace(/\r/g,"\n"),b&&(a=a.replace(new RegExp("\n{"+(b+1)+",}","g"),"\n".repeat(b))),a=a.trim(),a=a.tidy(),this.textarea.set("value",a),!0},insertTag:function(a){var b,c,d=this.textarea.getSelectedText(),e=a.promptFor||"default";if(a.prompt){if(c=prompt(a.prompt),null===c)return this;"function"===typeOf(a.onInsert)&&(c=a.onInsert(c,e)),"default"===e?b=c:d=c}var f=this.formatTag(a,b,d);if(this.textarea.getSelectedText())a.selfClose?this.textarea.insertAroundCursor({before:"",after:f,defaultMiddle:""}):this.textarea.insertAtCursor(f);else if(this.textarea.insertAtCursor(f,!1),!a.selfClose){var g=this.formatTag(a,b,d,"close");this.textarea.setCaretPosition(this.textarea.getCaretPosition()-g.length)}return this.fireEvent("insert",f),this},formatTag:function(a,b,c,d){b=b||a.defaultValue||"",c=c||a.placeholder||"";var e,f=a.tag,g=this.options.open,h=this.options.close,i=g+f,j=g+"/"+f+h;return a.hasDefault&&(e=a.promptFor||"default",a.prompt&&"default"===e?b&&(i+='="'+b+'"'):i+='="'+b+'"'),a.selfClose?i+"/"+h:(i+=h,"open"===d?i:"close"===d?j:i+c+j)},renderHelp:function(){var a,b,c,d=new Element("table"),e=new Element("thead"),f=new Element("tbody");a=new Element("tr"),a.grab(new Element("th",{text:"Tag"})),a.grab(new Element("th",{text:"Attributes"})),a.grab(new Element("th",{text:"Examples"})),e.grab(a),this.tags.each(function(d){c=(d.attributes||[]).join(", "),b=(d.examples||[this.formatTag(d)]).join("<br>"),a=new Element("tr"),a.grab(new Element("td",{html:d.title}).addClass("tag-title")),a.grab(new Element("td",{html:c}).addClass("tag-attributes")),a.grab(new Element("td",{html:b}).addClass("tag-examples")),f.grab(a)}.bind(this)),d.adopt([e,f]),this.help.grab(d),this.fireEvent("renderHelp",d)},renderPreview:function(){this.preview.addClass("loading"),new Request({url:this.options.previewUrl,data:{input:this.textarea.get("value")},onSuccess:function(a){this.preview.removeClass("loading").set("html",a)}.bind(this),onFailure:function(){this.container.show(),this.enableToolbar(),alert("An error has occurred while rendering the preview")}.bind(this)}).post(),this.fireEvent("renderPreview")},_listenKeydown:function(a,b,c){return a.control&&a.key===b.key?(a.stop(),b.onClick?b.onClick.attempt([b,c],this):this.insertTag(b,c),!1):void 0}}),Decoda.filters={},Decoda.controls={},Decoda.filters.defaults={b:{tag:"b",title:"Bold",key:"b"},i:{tag:"i",title:"Italics",key:"i"},u:{tag:"u",title:"Underline",key:"u"},s:{tag:"s",title:"Strike-Through",key:"s"},sub:{tag:"sub",title:"Subscript"},sup:{tag:"sup",title:"Superscript"},abbr:{tag:"abbr",title:"Abbreviation",hasDefault:!0,prompt:"Title:",attributes:["default"],examples:['[abbr="Hyper-Text Markup Language"]HTML[/abbr]']},time:{tag:"time",title:"Timestamp",prompt:"Date:",promptFor:"content"},br:{tag:"br",title:"Line Break",selfClose:!0},hr:{tag:"hr",title:"Horizontal Break",selfClose:!0}},Decoda.filters.text={font:{tag:"font",title:"Font Family",prompt:"Font:",hasDefault:!0,attributes:["default"],examples:['[font="Arial"][/font]'],options:[{title:"Arial",defaultValue:"Arial",className:"font-arial",prompt:!1},{title:"Tahoma",defaultValue:"Tahoma",className:"font-tahoma",prompt:!1},{title:"Verdana",defaultValue:"Verdana",className:"font-verdana",prompt:!1},{title:"Courier",defaultValue:"Courier",className:"font-courier",prompt:!1},{title:"Times",defaultValue:"Times",className:"font-times",prompt:!1},{title:"Helvetica",defaultValue:"Helvetica",className:"font-helvetica",prompt:!1}]},size:{tag:"size",title:"Text Size",prompt:"Size:",hasDefault:!0,attributes:["default"],examples:['[size="12"][/size]'],options:[{title:"Small",defaultValue:"10",className:"size-small",prompt:!1},{title:"Normal",defaultValue:"12",className:"size-normal",prompt:!1},{title:"Medium",defaultValue:"18",className:"size-medium",prompt:!1},{title:"Large",defaultValue:"24",className:"size-large",prompt:!1}],onInsert:function(a,b){return"default"===b?Number.from(a).limit(10,29):a}},color:{tag:"color",title:"Text Color",prompt:"Hex Code:",hasDefault:!0,attributes:["default"],examples:['[color="red"][/color]'],options:[{title:"Yellow",defaultValue:"yellow",className:"color-yellow",prompt:!1},{title:"Orange",defaultValue:"orange",className:"color-orange",prompt:!1},{title:"Red",defaultValue:"red",className:"color-red",prompt:!1},{title:"Blue",defaultValue:"blue",className:"color-blue",prompt:!1},{title:"Purple",defaultValue:"purple",className:"color-purple",prompt:!1},{title:"Green",defaultValue:"green",className:"color-green",prompt:!1},{title:"White",defaultValue:"white",className:"color-white",prompt:!1},{title:"Gray",defaultValue:"gray",className:"color-gray",prompt:!1},{title:"Black",defaultValue:"black",className:"color-black",prompt:!1}],onInsert:function(a,b){return"default"===b?/(?:#[0-9a-f]{3,6}|[a-z]+)/i.exec(a)?a:null:a}},heading:{tag:"h1",title:"Heading",examples:["[h1][/h1], [h2][/h2], [h3][/h3], [h4][/h4], [h5][/h5], [h6][/h6]"],options:[{tag:"h1",title:"1st",className:"heading-h1"},{tag:"h2",title:"2nd",className:"heading-h2"},{tag:"h3",title:"3rd",className:"heading-h3"},{tag:"h4",title:"4th",className:"heading-h4"},{tag:"h5",title:"5th",className:"heading-h5"},{tag:"h6",title:"6th",className:"heading-h6"}]}},Decoda.filters.block={left:{tag:"left",title:"Left Align"},center:{tag:"center",title:"Center Align"},right:{tag:"right",title:"Right Align"},justify:{tag:"justify",title:"Justify Align"},hide:{tag:"hide",title:"Hide"},spoiler:{tag:"spoiler",title:"Spoiler"}},Decoda.filters.list={list:{tag:"list",title:"Unordered List",examples:["[list][/list]",'[list="upper-alpha"][/list]'],attributes:["default <span>(optional)</span>"]},olist:{tag:"olist",title:"Ordered List",examples:["[olist][/olist]",'[olist="lower-roman"][/olist]'],attributes:["default <span>(optional)</span>"]},li:{tag:"li",title:"List Item"}},Decoda.filters.quote={quote:{tag:"quote",title:"Quote Block",prompt:"Author:",hasDefault:!0,examples:["[quote][/quote]",'[quote="Author"][/quote]','[quote date="12/12/2012"][/quote]'],attributes:["default <span>(optional)</span>","date <span>(optional)</span>"]}},Decoda.filters.code={code:{tag:"code",title:"Code Block",examples:["[code][/code]",'[code="html"][/code]','[code hl="1,5,10"][/code]'],attributes:["default <span>(optional)</span>","hl <span>(optional)</span>"]},source:{tag:"source",title:"Code Snippet"},"var":{tag:"var",title:"Variable"}},Decoda.filters.email={email:{tag:"email",title:"Email",prompt:"Email Address:",hasDefault:!0,examples:["[email]email@domain.com[/email]",'[email="email@domain.com"][/email]'],attributes:["default <span>(optional)</span>"]}},Decoda.filters.url={url:{tag:"url",title:"URL",prompt:"Web Address:",hasDefault:!0,examples:["[url]http://domain.com[/url]",'[url="http://domain.com"][/url]'],attributes:["default <span>(optional)</span>"]}},Decoda.filters.image={img:{tag:"img",title:"Image",prompt:"Image URL:",promptFor:"content",examples:["[img][/img]",'[img="200x200"][/img]','[img width="250" height="15%"][/img]'],attributes:["default <span>(optional)</span>","width <span>(optional)</span>","height <span>(optional)</span>","alt <span>(optional)</span>"]}},Decoda.filters.video={video:{tag:"video",title:"Video",prompt:"Video ID:",promptFor:"content",hasDefault:!0,examples:['[video="youtube"]ID[/video]','[youtube size="large"]ID[/youtube]','[veoh size="small"]ID[/veoh]'],attributes:["default","size <span>(optional)</span>"],options:[{tag:"youtube",title:"YouTube",hasDefault:!1,className:"video-youtube"},{tag:"vimeo",title:"Vimeo",hasDefault:!1,className:"video-vimeo"},{tag:"veoh",title:"Veoh",hasDefault:!1,className:"video-veoh"},{tag:"vevo",title:"Vevo",hasDefault:!1,className:"video-vevo"},{tag:"liveleak",title:"LiveLeak",hasDefault:!1,className:"video-liveleak"},{tag:"dailymotion",title:"Daily Motion",hasDefault:!1,className:"video-dailymotion"},{tag:"funnyordie",title:"Funny or Die",hasDefault:!1,className:"video-funnyordie"},{tag:"collegehumor",title:"College Humor",hasDefault:!1,className:"video-collegehumor"},{tag:"myspace",title:"MySpace",hasDefault:!1,className:"video-myspace"},{tag:"wegame",title:"WeGame",hasDefault:!1,className:"video-wegame"}]}},Decoda.filters.table={table:{tag:"table",title:"Table",examples:["[table][/table]",'[table="sortable"][/table] <span>(class)</span>'],attributes:["default <span>(optional)</span>"]},thead:{tag:"thead",title:"Table Head"},tbody:{tag:"tbody",title:"Table Body"},tfoot:{tag:"tfoot",title:"Table Foot"},tr:{tag:"tr",title:"Table Row"},td:{tag:"td",title:"Table Cell",examples:["[td][/td]",'[td="3"][/td] <span>(colspan)</span>'],attributes:["default <span>(optional)</span>"]},th:{tag:"th",title:"Table Header",examples:["[th][/th]",'[th="3"][/th] <span>(colspan)</span>'],attributes:["default <span>(optional)</span>"]}},Decoda.filters.media=Object.merge({},Decoda.filters.email,Decoda.filters.url,Decoda.filters.image,Decoda.filters.video),Decoda.controls.editor={preview:{tag:"preview",key:"e",title:"Preview",onClick:function(a,b){return this.options.previewUrl?(this.container.hide(),this.help.hide(),this.preview.isVisible()?(this.preview.hide().empty(),this.container.show(),this.enableToolbar()):(this.preview.show(),this.disableToolbar(),this.renderPreview()),b.set("disabled",!1),void 0):(alert("Preview functionality has not been enabled"),void 0)}},clean:{tag:"clean",title:"Clean",onClick:function(){this.disableToolbar(),this.clean()&&a.setTimeout(function(){this.enableToolbar()}.bind(this),500)}},help:{tag:"help",title:"Help",onClick:function(a,b){return this.tags.length?(this.container.hide(),this.preview.hide(),this.help.hasChildNodes()||this.renderHelp(),this.help.isVisible()?(this.help.hide(),this.container.show(),this.enableToolbar()):(this.help.show(),this.disableToolbar()),b.set("disabled",!1),void 0):(alert("No tag filters have been loaded"),void 0)}}}}(window);