## How to contribute to the PMIx Reference Server

General information about contributing to the PMIx project can be found at the [Contributing to PMIx webpage](https://pmix.org/code/contribute/).
The instructions below are specifically for opening issues and pull requests against the PMIx Reference Server.

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/pmix/pmix-reference-server/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/pmix/pmix-reference-server/issues/new).

* For more detailed information on submitting a bug report and creating an issue, visit our [FAQ](https://pmix.org/support/faq).

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. If there is an existing GitHub issue open describing this bug, please include it in the description so we can close it.

* Before submitting, please read the [Contributing to the PMIx Project FAQ](https://pmix.org/support/faq/contributing) and the [SubmittingPullRequests](https://pmix.org/support/faq/submitting-pull-requests) web pages.  In particular, note that all git commits contributed to PMIx (including the reference server) require a Signed-off by line.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change on the [devel mail list](https://groups.google.com/forum/#!forum/pmix) and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

#### **Do you have questions about the source code?**

* We are working to provide more online info about the PMIx code.  A paper describing the [multi-component architecture](https://www.open-mpi.org/papers/ics-2004/ics-2004.pdf)  of Open MPI (also used in PMIx and the reference server) may also be helpful.  The [devel mail list](https://groups.google.com/forum/#!forum/pmix) is a good place to post questions about the source code as well.

Thanks

The PMIx Team
