## 组件文档如何编写

#### 文件格式

组件文档采用 markdown 格式，和普通 markdown 最大的区别是示例代码是直接写在 markdown 文件里面，所以请确保你写的示例代码是可以正确运行的。

#### 文档内的标题规范

文档标题从 `h2`（即 `##` 标题 ）开始，每往下一级多加一个 `#` 号；一般到 `h3` (两级标题) 或`h4` (三级标题)即可，不要出现过多的标题层级。

#### 组件描述

大标题下面是对组件的一句话简要描述。

#### 使用指南（可选）

如果组件需要使用指南，放在组件描述下方，另起一个二级标题。

#### 代码演示

另起一个二级标题，示例的结构如下:

  ```javascript
    export default {
      data() {
        return {
          size: 'large'
        };
      }
    };
  ```

  ```html
    <van-button :size="size">
      Large
    </van-button>
  ```
    
代码演示的几个书写原则：

- 从简单用法开始介绍，不要上来就同时使用一大堆 API，会让人觉得难以上手
- 正交性原则，一个示例只演示一个（或者一类）API 的使用方法，如无特殊需求不要在一个示例中同时演示多个 API 混合使用
- 如果示例的一句话描述无法完整描述整个场景，可以在 `:::demo` 之前写一段详细的说明性文字
