/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteOrder;
import java.util.Arrays;
import sun.misc.Unsafe;

@SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH", "SF_SWITCH_NO_DEFAULT"})
public final class HashUtil {
    private static final boolean LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN == ByteOrder.nativeOrder();
    private static final int DEFAULT_MURMUR_SEED = 16777619;

    public static int MurmurHash3_x86_32(byte[] data, int offset, int len) {
        return HashUtil.MurmurHash3_x86_32(data, offset, len, 16777619);
    }

    public static int MurmurHash3_x86_32(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= c1;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= len;
        h1 = HashUtil.MurmurHash3_fmix(h1);
        return h1;
    }

    public static int MurmurHash3_x86_32_direct(long address, int offset, int len) {
        return HashUtil.MurmurHash3_x86_32_direct(address, offset, len, 16777619);
    }

    public static int MurmurHash3_x86_32_direct(long address, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        Unsafe unsafe = UnsafeHelper.UNSAFE;
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = LITTLE_ENDIAN ? unsafe.getInt(address + (long)i) : unsafe.getByte(address + (long)i) & 0xFF | (unsafe.getByte(address + (long)i + 1L) & 0xFF) << 8 | (unsafe.getByte(address + (long)i + 2L) & 0xFF) << 16 | unsafe.getByte(address + (long)i + 3L) << 24;
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (unsafe.getByte(address + (long)roundedEnd + 2L) & 0xFF) << 16;
            }
            case 2: {
                k1 |= (unsafe.getByte(address + (long)roundedEnd + 1L) & 0xFF) << 8;
            }
            case 1: {
                k1 |= unsafe.getByte(address + (long)roundedEnd) & 0xFF;
                k1 *= c1;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= len;
        h1 = HashUtil.MurmurHash3_fmix(h1);
        return h1;
    }

    public static long MurmurHash3_x64_64(byte[] data, int offset, int len) {
        return HashUtil.MurmurHash3_x64_64(data, offset, len, 16777619);
    }

    public static long MurmurHash3_x64_64(byte[] data, int offset, int len, int seed) {
        long h1 = 0x9368E53C2F6AF274L ^ (long)seed;
        long h2 = 0x586DCD208F7CD3FDL ^ (long)seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long k1 = 0L;
        long k2 = 0L;
        for (int i = 0; i < len / 16; ++i) {
            k1 = HashUtil.MurmurHash3_getBlock(data, i * 2 * 8 + offset);
            k2 = HashUtil.MurmurHash3_getBlock(data, (i * 2 + 1) * 8 + offset);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        k1 = 0L;
        k2 = 0L;
        int tail = (len >>> 4 << 4) + offset;
        switch (len & 0xF) {
            case 15: {
                k2 ^= (long)data[tail + 14] << 48;
            }
            case 14: {
                k2 ^= (long)data[tail + 13] << 40;
            }
            case 13: {
                k2 ^= (long)data[tail + 12] << 32;
            }
            case 12: {
                k2 ^= (long)data[tail + 11] << 24;
            }
            case 11: {
                k2 ^= (long)data[tail + 10] << 16;
            }
            case 10: {
                k2 ^= (long)data[tail + 9] << 8;
            }
            case 9: {
                k2 ^= (long)data[tail + 8];
            }
            case 8: {
                k1 ^= (long)data[tail + 7] << 56;
            }
            case 7: {
                k1 ^= (long)data[tail + 6] << 48;
            }
            case 6: {
                k1 ^= (long)data[tail + 5] << 40;
            }
            case 5: {
                k1 ^= (long)data[tail + 4] << 32;
            }
            case 4: {
                k1 ^= (long)data[tail + 3] << 24;
            }
            case 3: {
                k1 ^= (long)data[tail + 2] << 16;
            }
            case 2: {
                k1 ^= (long)data[tail + 1] << 8;
            }
            case 1: {
                k1 ^= (long)data[tail];
                k1 *= c1;
                k1 = k1 << 23 | k1 >>> 41;
                h1 ^= (k1 *= c2);
                h1 += h2;
                h2 = h2 << 41 | h2 >>> 23;
                k2 *= c2;
                k2 = k2 << 23 | k2 >>> 41;
                h2 ^= (k2 *= c1);
                h2 += h1;
                h1 = h1 * 3L + 1390208809L;
                h2 = h2 * 3L + 944331445L;
            }
        }
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = HashUtil.MurmurHash3_fmix(h1);
        h2 = HashUtil.MurmurHash3_fmix(h2);
        return h1 += h2;
    }

    public static long MurmurHash3_x64_64_direct(long address, int offset, int len) {
        return HashUtil.MurmurHash3_x64_64_direct(address, offset, len, 16777619);
    }

    public static long MurmurHash3_x64_64_direct(long address, int offset, int len, int seed) {
        long h1 = 0x9368E53C2F6AF274L ^ (long)seed;
        long h2 = 0x586DCD208F7CD3FDL ^ (long)seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long k1 = 0L;
        long k2 = 0L;
        for (int i = 0; i < len / 16; ++i) {
            k1 = HashUtil.MurmurHash3_getBlock_direct(address, i * 2 * 8 + offset);
            k2 = HashUtil.MurmurHash3_getBlock_direct(address, (i * 2 + 1) * 8 + offset);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        k1 = 0L;
        k2 = 0L;
        int tail = (len >>> 4 << 4) + offset;
        Unsafe unsafe = UnsafeHelper.UNSAFE;
        switch (len & 0xF) {
            case 15: {
                k2 ^= (long)unsafe.getByte(address + (long)tail + 14L) << 48;
            }
            case 14: {
                k2 ^= (long)unsafe.getByte(address + (long)tail + 13L) << 40;
            }
            case 13: {
                k2 ^= (long)unsafe.getByte(address + (long)tail + 12L) << 32;
            }
            case 12: {
                k2 ^= (long)unsafe.getByte(address + (long)tail + 11L) << 24;
            }
            case 11: {
                k2 ^= (long)unsafe.getByte(address + (long)tail + 10L) << 16;
            }
            case 10: {
                k2 ^= (long)unsafe.getByte(address + (long)tail + 9L) << 8;
            }
            case 9: {
                k2 ^= (long)unsafe.getByte(address + (long)tail + 8L);
            }
            case 8: {
                k1 ^= (long)unsafe.getByte(address + (long)tail + 7L) << 56;
            }
            case 7: {
                k1 ^= (long)unsafe.getByte(address + (long)tail + 6L) << 48;
            }
            case 6: {
                k1 ^= (long)unsafe.getByte(address + (long)tail + 5L) << 40;
            }
            case 5: {
                k1 ^= (long)unsafe.getByte(address + (long)tail + 4L) << 32;
            }
            case 4: {
                k1 ^= (long)unsafe.getByte(address + (long)tail + 3L) << 24;
            }
            case 3: {
                k1 ^= (long)unsafe.getByte(address + (long)tail + 2L) << 16;
            }
            case 2: {
                k1 ^= (long)unsafe.getByte(address + (long)tail + 1L) << 8;
            }
            case 1: {
                k1 ^= (long)unsafe.getByte(address + (long)tail);
                k1 *= c1;
                k1 = k1 << 23 | k1 >>> 41;
                h1 ^= (k1 *= c2);
                h1 += h2;
                h2 = h2 << 41 | h2 >>> 23;
                k2 *= c2;
                k2 = k2 << 23 | k2 >>> 41;
                h2 ^= (k2 *= c1);
                h2 += h1;
                h1 = h1 * 3L + 1390208809L;
                h2 = h2 * 3L + 944331445L;
            }
        }
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = HashUtil.MurmurHash3_fmix(h1);
        h2 = HashUtil.MurmurHash3_fmix(h2);
        return h1 += h2;
    }

    private static long MurmurHash3_getBlock(byte[] key, int i) {
        return (long)key[i] & 0xFFL | ((long)key[i + 1] & 0xFFL) << 8 | ((long)key[i + 2] & 0xFFL) << 16 | ((long)key[i + 3] & 0xFFL) << 24 | ((long)key[i + 4] & 0xFFL) << 32 | ((long)key[i + 5] & 0xFFL) << 40 | ((long)key[i + 6] & 0xFFL) << 48 | ((long)key[i + 7] & 0xFFL) << 56;
    }

    private static long MurmurHash3_getBlock_direct(long address, int i) {
        Unsafe unsafe = UnsafeHelper.UNSAFE;
        if (LITTLE_ENDIAN) {
            return unsafe.getLong(address + (long)i);
        }
        return (long)unsafe.getByte(address + (long)i) & 0xFFL | ((long)unsafe.getByte(address + (long)i + 1L) & 0xFFL) << 8 | ((long)unsafe.getByte(address + (long)i + 2L) & 0xFFL) << 16 | ((long)unsafe.getByte(address + (long)i + 3L) & 0xFFL) << 24 | ((long)unsafe.getByte(address + (long)i + 4L) & 0xFFL) << 32 | ((long)unsafe.getByte(address + (long)i + 5L) & 0xFFL) << 40 | ((long)unsafe.getByte(address + (long)i + 6L) & 0xFFL) << 48 | ((long)unsafe.getByte(address + (long)i + 7L) & 0xFFL) << 56;
    }

    public static int MurmurHash3_fmix(int k) {
        k ^= k >>> 16;
        k *= -2048144789;
        k ^= k >>> 13;
        k *= -1028477387;
        k ^= k >>> 16;
        return k;
    }

    public static long MurmurHash3_fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static long fastLongMix(long k) {
        long phi = -7046029254386353131L;
        long h = k * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }

    public static int fastIntMix(int k) {
        int phi = -1640531527;
        int h = k * -1640531527;
        return h ^ h >>> 16;
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static int hashToIndex(int hash, int length) {
        Preconditions.checkPositive(length, "mod must be larger than 0");
        hash = hash == Integer.MIN_VALUE ? 0 : Math.abs(hash);
        return hash % length;
    }

    private HashUtil() {
    }
}

