/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ValidationException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;

public class BugPatternValidator {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    public static void validate(BugPattern pattern) throws ValidationException {
        if (pattern == null) {
            throw new ValidationException("No @BugPattern provided");
        }
        switch (pattern.linkType()) {
            case CUSTOM: {
                if (!pattern.link().isEmpty()) break;
                throw new ValidationException("Expected a custom link but none was provided");
            }
            case AUTOGENERATED: 
            case NONE: {
                if (pattern.link().isEmpty()) break;
                throw new ValidationException("Expected no custom link but found: " + pattern.link());
            }
        }
        HashSet<Class<? extends Annotation>> customSuppressionAnnotations = new HashSet<Class<? extends Annotation>>(Arrays.asList(pattern.customSuppressionAnnotations()));
        switch (pattern.suppressibility()) {
            case CUSTOM_ANNOTATION: {
                if (customSuppressionAnnotations.isEmpty()) {
                    throw new ValidationException("Expected a custom suppression annotation but none was provided");
                }
                if (!customSuppressionAnnotations.contains(SuppressWarnings.class)) break;
                throw new ValidationException("Custom suppression annotation may not use @SuppressWarnings");
            }
            case SUPPRESS_WARNINGS: 
            case UNSUPPRESSIBLE: {
                if (customSuppressionAnnotations.isEmpty()) break;
                throw new ValidationException(String.format("Expected no custom suppression annotations but found these: %s", COMMA_JOINER.join((Iterable)Collections2.transform(customSuppressionAnnotations, Class::getCanonicalName))));
            }
        }
    }
}

