/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.overloading;

import com.google.common.base.Preconditions;
import com.google.errorprone.bugpatterns.overloading.AutoValue_ParameterTree;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

abstract class ParameterTree {
    ParameterTree() {
    }

    public abstract Name getName();

    public abstract Tree getType();

    public abstract boolean isVarArgs();

    public static ParameterTree create(VariableTree variableTree) {
        Preconditions.checkArgument((boolean)ParameterTree.isValidParameterTree(variableTree));
        Name name = variableTree.getName();
        Tree type = variableTree.getType();
        boolean isVarargs = ParameterTree.isVariableTreeVarArgs(variableTree);
        return new AutoValue_ParameterTree(name, type, isVarargs);
    }

    private static boolean isValidParameterTree(VariableTree variableTree) {
        if (variableTree.getInitializer() != null) {
            return false;
        }
        Set<Modifier> flags = variableTree.getModifiers().getFlags();
        return flags.isEmpty() || flags.size() == 1 && flags.contains((Object)Modifier.FINAL);
    }

    public String toString() {
        String type = this.getType().toString();
        String name = this.getName().toString();
        if (this.isVarArgs()) {
            type = type.substring(0, type.length() - 2) + "...";
        }
        return type + " " + name;
    }

    private static boolean isVariableTreeVarArgs(VariableTree variableTree) {
        return (ASTHelpers.getSymbol((VariableTree)variableTree).flags() & 0x400000000L) != 0L;
    }
}

