// ****************************************************************************
// NOTICE
//
// This is the copyright work of The MITRE Corporation, and was produced
// for the U. S. Government under Contract Number DTFAWA-10-C-00080, and
// is subject to Federal Aviation Administration Acquisition Management
// System Clause 3.5-13, Rights In Data-General, Alt. III and Alt. IV
// (Oct. 1996).  No other use other than that granted to the U. S.
// Government, or to those acting on behalf of the U. S. Government,
// under that Clause is authorized without the express written
// permission of The MITRE Corporation. For further information, please
// contact The MITRE Corporation, Contracts Office, 7515 Colshire Drive,
// McLean, VA  22102-7539, (703) 983-6000. 
//
// Copyright 2018 The MITRE Corporation. All Rights Reserved.
// ****************************************************************************

#include "utility/ProcessingTimeStats.h"
#include <iostream>


ProcessingTimeStats::ProcessingTimeStats(void)
      : hdr("") {
   // Basic constructor.

   ms = 0.0;
   entries = 0;
}

ProcessingTimeStats::ProcessingTimeStats(std::string str)
      : hdr(str) {
   // Copy constructor.

   ms = 0.0;
   entries = 0;
}

ProcessingTimeStats::~ProcessingTimeStats(void) {
   // Destructor.  Dumps collected stats.

   dump();
}

void ProcessingTimeStats::setHdr(std::string str) {
   // Header setter.

   hdr = str;
}

void ProcessingTimeStats::start(void) {
   // Gets time to start from.

   t0 = clock();
}

void ProcessingTimeStats::stop(void) {
   // Gets time at stop point and gathers time between start and stop time.

   t1 = clock();
   gather();
}

void ProcessingTimeStats::gather(void) {
   // Gathers stats between start and stop time.

   double diffticks = t1 - t0;

   double denom = ((double) CLOCKS_PER_SEC) / 1000.0;

   double diffms = diffticks / denom;

   ms += diffms;
   ++entries;

}

void ProcessingTimeStats::dump(void) {
   // Dumps stats.

   double avgms = ms / (double) entries;

   std::cout << std::endl << "Final timing stats for "
             << hdr.c_str() << std::endl;
   std::cout << "Entries  " << entries << std::endl;
   std::cout << "Total ms " << ms << std::endl;
   std::cout << "Avg ms   " << avgms << std::endl << std::endl;
}
