(herald dhca (algebra diffie-hellman))

(comment "CPSA 2.5.0")
(comment "All input read from dh-ca.lsp")

(defprotocol dhca diffie-hellman
  (defrole init
    (vars (x expn) (a b ca name) (h base) (n text))
    (trace (recv (enc (exp (gen) x) a (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (recv (cat h (enc h b (privk ca)) (enc n (exp h x))))
      (send (enc "check" n (exp h x))))
    (non-orig (privk ca)))
  (defrole resp
    (vars (y expn) (a b ca name) (h base) (n text))
    (trace (recv (enc (exp (gen) y) b (privk ca)))
      (recv (cat h (enc h a (privk ca))))
      (send
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca))
          (enc n (exp h y)))) (recv (enc "check" n (exp h y))))
    (non-orig (privk ca)))
  (defrole ca
    (vars (subject ca name) (z expn))
    (trace (send (enc (exp (gen) z) subject (privk ca))))
    (non-orig z))
  (comment "A diffie-hellman exchange which uses a certificate"
    "authority to certify long-term DH values."))

(defskeleton dhca
  (vars (n text) (a b ca name) (h base) (x expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h h) (x x))
  (non-orig (privk ca))
  (comment
    "Full initiator point-of-view.  No need to make extra assumptions.")
  (traces
    ((recv (enc (exp (gen) x) a (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (recv (cat h (enc h b (privk ca)) (enc n (exp h x))))
      (send (enc "check" n (exp h x)))))
  (label 0)
  (unrealized (0 0) (0 2))
  (origs)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (h base) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h h) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 0) (0 0)))
  (non-orig (privk ca) z)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv (cat h (enc h b (privk ca)) (enc n (exp h z))))
      (send (enc "check" n (exp h z))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 1)
  (parent 0)
  (unrealized (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 0) (0 0)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 2 1 ca 1)
    (enc (exp (gen) z-0) b (privk ca)) (0 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 2)
  (parent 1)
  (unrealized (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b (privk ca)) (0 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca)))))
  (label 3)
  (parent 1)
  (unrealized (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a ca a-0 b ca-0 name) (z y expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca-0)
    (h (exp (gen) (mul z z (rec y)))) (y y))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (added-strand resp 3)
    (enc n (exp (gen) (mul z z))) (0 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) y) b (privk ca-0)))
      (recv
        (cat (exp (gen) (mul z z (rec y)))
          (enc (exp (gen) (mul z z (rec y))) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca-0))
          (enc n (exp (gen) (mul z z)))))))
  (label 4)
  (parent 2)
  (unrealized (2 0) (2 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (deflistener (exp (gen) (mul z z)))
  (precedes ((1 0) (0 0)) ((2 1) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (added-listener (exp (gen) (mul z z)))
    (enc n (exp (gen) (mul z z))) (0 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (exp (gen) (mul z z))) (send (exp (gen) (mul z z)))))
  (label 5)
  (parent 2)
  (unrealized (2 0))
  (comment "empty cohort"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 y expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z-0 (rec y)))) (y y))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (added-strand resp 3)
    (enc n (exp (gen) (mul z z-0))) (0 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) y) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) (mul z z-0 (rec y)))
          (enc (exp (gen) (mul z z-0 (rec y))) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) y) (enc (exp (gen) y) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))))
  (label 6)
  (parent 3)
  (unrealized (3 0) (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (deflistener (exp (gen) (mul z z-0)))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 1) (0 2)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (added-listener (exp (gen) (mul z z-0)))
    (enc n (exp (gen) (mul z z-0))) (0 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (exp (gen) (mul z z-0))) (send (exp (gen) (mul z z-0)))))
  (label 7)
  (parent 3)
  (unrealized (3 0))
  (comment "empty cohort"))

(defskeleton dhca
  (vars (n text) (a ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (2 0)) ((2 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 3 1 ca 1)
    (enc (exp (gen) z-0) b (privk ca-0)) (2 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 8)
  (parent 4)
  (unrealized (2 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a ca a-0 b ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca-0)
    (h (exp (gen) (mul z z (rec z-0)))) (y z-0))
  (defstrand ca 1 (subject b) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 0) (2 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b (privk ca-0)) (2 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z-0) b (privk ca-0)))
      (recv
        (cat (exp (gen) (mul z z (rec z-0)))
          (enc (exp (gen) (mul z z (rec z-0))) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z-0) b (privk ca-0)))))
  (label 9)
  (parent 4)
  (unrealized (2 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z))
    (y z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 2)) ((3 2) (0 2)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z-1) b-0 (privk ca-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))))
  (label 10)
  (parent 6)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z))
    (y z-0))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((3 2) (0 2)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z-1) b-0 (privk ca-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))))
  (label 11)
  (parent 6)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 z-1 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z-0 (rec z-1)))) (y z-1))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z-1))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z z-0 z-1)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-1) b-0 (privk ca-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z-1) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) (mul z z-0 (rec z-1)))
          (enc (exp (gen) (mul z z-0 (rec z-1))) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z-1) (enc (exp (gen) z-1) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-1) b-0 (privk ca-0)))))
  (label 12)
  (parent 6)
  (unrealized (3 1))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dhca
  (vars (n text) (a ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (2 0)) ((2 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 3 1 ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (2 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 13)
  (parent 8)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b a) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (2 0)) ((2 2) (0 2)) ((3 0) (2 1)))
  (non-orig (privk ca) z)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (2 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 14)
  (parent 8)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b a) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a ca a-0 b ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca-0) (h (exp (gen) z))
    (y z))
  (defstrand ca 1 (subject b) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 0) (2 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (displaced 4 3 ca 1) (exp (gen) z) (2 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b (privk ca-0)))))
  (label 15)
  (parent 9)
  (unrealized (2 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 2)) ((3 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 1 ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 16)
  (parent 10)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z-0))
    (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (3 1)) ((3 2) (0 2)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 4 2 ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))))
  (label 17)
  (parent 10)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 subject ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (added-strand ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) subject (privk ca-0)))))
  (label 18)
  (parent 10)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (3 0)) ((3 2) (0 2)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 4 1 ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))))
  (label 19)
  (parent 11)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((3 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 2 ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 20)
  (parent 11)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 subject ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((3 2) (0 2)) ((4 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (added-strand ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) subject (privk ca-0)))))
  (label 21)
  (parent 11)
  (unrealized (3 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (3 1)) ((3 2) (0 2)) ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (displaced 5 2 ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 22)
  (parent 12)
  (unrealized (3 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 subject ca-1 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject subject) (ca ca-1) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (added-strand ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) subject (privk ca-1)))))
  (label 23)
  (parent 12)
  (unrealized (3 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (displaced 5 1 ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 24)
  (parent 12)
  (unrealized (3 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (displaced 5 4 ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 25)
  (parent 12)
  (unrealized (3 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 subject ca-1 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject subject) (ca ca-1) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (added-strand ca 1) (exp (gen) z-0) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) subject (privk ca-1)))))
  (label 26)
  (parent 12)
  (seen 54)
  (unrealized (3 1))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a ca b name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (2 1)) ((2 2) (0 2)) ((3 0) (2 0)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z) a-0 (privk ca-0)) (2 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 27)
  (parent 15)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b a) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a ca b ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b) (b b) (ca ca-0) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 0) (2 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (displaced 4 3 ca 1)
    (enc (exp (gen) z) a-0 (privk ca-0)) (2 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b (privk ca-0)))))
  (label 28)
  (parent 15)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b a) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a ca a-0 b ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca-0) (h (exp (gen) z))
    (y z))
  (defstrand ca 1 (subject b) (ca ca-0) (z z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 0) (2 0)) ((4 0) (2 1)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a-0 (privk ca-0)) (2 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b (privk ca-0))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 29)
  (parent 15)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b a) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 2)) ((3 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 30)
  (parent 16)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b b) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (3 1)) ((3 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 31)
  (parent 16)
  (seen 34)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 1)))
  (non-orig (privk ca) z)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 32)
  (parent 16)
  (seen 37)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (3 1)) ((3 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 33)
  (parent 17)
  (seen 30)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a b) (b a) (ca ca) (h (exp (gen) z-0)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (3 1)) ((3 2) (0 2)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))))
  (label 34)
  (parent 17)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (3 1)) ((3 2) (0 2))
    ((4 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca)))))
  (label 35)
  (parent 17)
  (seen 37)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca subject ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 1)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 5 1 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) subject (privk ca-0)))))
  (label 36)
  (parent 18)
  (seen 30)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b subject ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a subject) (b a) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject subject) (ca ca) (z z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) subject (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) subject (privk ca)))))
  (label 37)
  (parent 18)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca a-0 subject ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z-0))
  (defstrand ca 1 (subject a-0) (ca ca) (z z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 1)) ((5 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) subject (privk ca-0))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca)))))
  (label 38)
  (parent 18)
  (seen 37)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (3 0)) ((3 2) (0 2)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))))
  (label 39)
  (parent 19)
  (unrealized)
  (shape)
  (maps ((0) ((x z-0) (a a) (b b) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (3 0)) ((3 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 40)
  (parent 19)
  (seen 43)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (3 0)) ((3 2) (0 2))
    ((4 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca)))))
  (label 41)
  (parent 19)
  (seen 47)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (3 0)) ((3 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 42)
  (parent 20)
  (seen 39)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((3 2) (0 2)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))))
  (label 43)
  (parent 20)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b b) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((3 2) (0 2)) ((4 0) (3 1)))
  (non-orig (privk ca) z)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 44)
  (parent 20)
  (seen 47)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca subject ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (3 0)) ((3 2) (0 2))
    ((4 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 5 1 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) subject (privk ca-0)))))
  (label 45)
  (parent 21)
  (seen 39)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca subject ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((3 2) (0 2)) ((4 0) (3 1)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) subject (privk ca-0)))))
  (label 46)
  (parent 21)
  (seen 43)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b subject ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a subject) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject subject) (ca ca) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((3 2) (0 2)) ((4 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) subject (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) subject (privk ca)))))
  (label 47)
  (parent 21)
  (unrealized)
  (shape)
  (maps ((0) ((x z-0) (a a) (b b) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca a-0 subject ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z-0))
  (defstrand ca 1 (subject a-0) (ca ca) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((3 2) (0 2)) ((4 0) (3 1))
    ((5 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z-0) subject (privk ca-0))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca)))))
  (label 48)
  (parent 21)
  (seen 47)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (3 1)) ((3 2) (0 2))
    ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 5 1 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 49)
  (parent 22)
  (seen 61)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (3 1)) ((3 2) (0 2)) ((4 0) (3 0)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 50)
  (parent 22)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b-0) (b b-0) (ca ca-0) (h (exp (gen) z))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (3 1)) ((3 2) (0 2)) ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 51)
  (parent 22)
  (seen 63)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (3 1)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca-0)))))
  (label 52)
  (parent 22)
  (seen 55)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 subject ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 0)) ((5 0) (3 1)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 6 1 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-1)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca))))
    ((send (enc (exp (gen) z) subject (privk ca-0)))))
  (label 53)
  (parent 23)
  (seen 61)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 ca-0 subject ca-1 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b-0) (b b-0) (ca ca-0) (h (exp (gen) z))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject subject) (ca ca-1) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (displaced 6 4 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z) subject (privk ca-1)))))
  (label 54)
  (parent 23)
  (seen 63)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 subject ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a subject) (b b-0) (ca ca-0)
    (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-1)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0)
          (enc (exp (gen) z-0) subject (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) subject (privk ca-0)))))
  (label 55)
  (parent 23)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 subject ca-1 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject subject) (ca ca-1) (z z-0))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)) ((6 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) subject (privk ca-1))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca-0)))))
  (label 56)
  (parent 23)
  (seen 55)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 0)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 5 1 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 57)
  (parent 24)
  (unrealized)
  (shape)
  (maps ((0) ((x z-0) (a a) (b b) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (3 1)) ((3 2) (0 2))
    ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 58)
  (parent 24)
  (seen 62)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b-0) (b b-0) (ca ca-0) (h (exp (gen) z))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 59)
  (parent 24)
  (seen 63)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 0)) ((5 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca-0)))))
  (label 60)
  (parent 24)
  (seen 66)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 5 1 ca 1)
    (enc (exp (gen) z) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 61)
  (parent 25)
  (seen 57)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (3 1)) ((3 2) (0 2)) ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 62)
  (parent 25)
  (seen 50)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a b-0) (b b-0) (ca ca-0) (h (exp (gen) z))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 63)
  (parent 25)
  (unrealized)
  (shape)
  (maps ((0) ((x z) (a a) (b b) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 64)
  (parent 25)
  (seen 55)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 subject ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((1 0) (3 1)) ((2 0) (0 2)) ((3 2) (0 2))
    ((4 0) (3 0)) ((5 0) (3 1)))
  (non-orig (privk ca) z z-0)
  (operation encryption-test (displaced 6 1 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-1)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca))))
    ((send (enc (exp (gen) z-0) subject (privk ca-0)))))
  (label 65)
  (parent 26)
  (seen 57)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 subject ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a subject) (b b-0) (ca ca-0)
    (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject subject) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-1)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0)
          (enc (exp (gen) z-0) subject (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) subject (privk ca-0)))))
  (label 66)
  (parent 26)
  (unrealized)
  (shape)
  (maps ((0) ((x z-0) (a a) (b b) (ca ca) (h (exp (gen) z)) (n n))))
  (origs))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 subject ca-1 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand resp 3 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject subject) (ca ca-1) (z z-0))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (0 2)) ((3 2) (0 2)) ((4 0) (3 0))
    ((5 0) (3 1)) ((6 0) (3 1)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (3 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca-0)))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0))))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) subject (privk ca-1))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca-0)))))
  (label 67)
  (parent 26)
  (seen 66)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Nothing left to do")

(defprotocol dhca diffie-hellman
  (defrole init
    (vars (x expn) (a b ca name) (h base) (n text))
    (trace (recv (enc (exp (gen) x) a (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (recv (cat h (enc h b (privk ca)) (enc n (exp h x))))
      (send (enc "check" n (exp h x))))
    (non-orig (privk ca)))
  (defrole resp
    (vars (y expn) (a b ca name) (h base) (n text))
    (trace (recv (enc (exp (gen) y) b (privk ca)))
      (recv (cat h (enc h a (privk ca))))
      (send
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca))
          (enc n (exp h y)))) (recv (enc "check" n (exp h y))))
    (non-orig (privk ca)))
  (defrole ca
    (vars (subject ca name) (z expn))
    (trace (send (enc (exp (gen) z) subject (privk ca))))
    (non-orig z))
  (comment "A diffie-hellman exchange which uses a certificate"
    "authority to certify long-term DH values."))

(defskeleton dhca
  (vars (n text) (a b ca name) (h base) (y expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h h) (y y))
  (non-orig (privk ca))
  (uniq-orig n)
  (comment "Full responder point of view with freshly chosen n")
  (traces
    ((recv (enc (exp (gen) y) b (privk ca)))
      (recv (cat h (enc h a (privk ca))))
      (send
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca))
          (enc n (exp h y)))) (recv (enc "check" n (exp h y)))))
  (label 68)
  (unrealized (0 0) (0 1))
  (origs (n (0 2)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (h base) (z expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h h) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat h (enc h a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp h z)))) (recv (enc "check" n (exp h z))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 69)
  (parent 68)
  (unrealized (0 1) (0 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 2 1 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 1))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 70)
  (parent 69)
  (unrealized (0 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 0) (0 0)) ((2 0) (0 1)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 1))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 71)
  (parent 69)
  (unrealized (0 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z x expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z (rec x)))) (x x))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((2 3) (0 3)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (added-strand init 4)
    (enc "check" n (exp (gen) (mul z z))) (0 3))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) x) a (privk ca-0)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca-0))))
      (recv
        (cat (exp (gen) (mul z z (rec x)))
          (enc (exp (gen) (mul z z (rec x))) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 72)
  (parent 70)
  (unrealized (2 0) (2 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (deflistener (exp (gen) (mul z z)))
  (precedes ((1 0) (0 0)) ((2 1) (0 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-listener (exp (gen) (mul z z)))
    (enc "check" n (exp (gen) (mul z z))) (0 3))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (exp (gen) (mul z z))) (send (exp (gen) (mul z z)))))
  (label 73)
  (parent 70)
  (unrealized (2 0))
  (comment "empty cohort"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 x expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z-0 (rec x)))) (x x))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand init 4)
    (enc "check" n (exp (gen) (mul z z-0))) (0 3))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) x) a-0 (privk ca-0)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) (mul z z-0 (rec x)))
          (enc (exp (gen) (mul z z-0 (rec x))) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 74)
  (parent 71)
  (unrealized (3 0) (3 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (deflistener (exp (gen) (mul z z-0)))
  (precedes ((1 0) (0 0)) ((2 0) (0 1)) ((3 1) (0 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-listener (exp (gen) (mul z z-0)))
    (enc "check" n (exp (gen) (mul z z-0))) (0 3))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (exp (gen) (mul z z-0))) (send (exp (gen) (mul z z-0)))))
  (label 75)
  (parent 71)
  (unrealized (3 0))
  (comment "empty cohort"))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((1 0) (2 0)) ((2 3) (0 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 3 1 ca 1)
    (enc (exp (gen) z-0) a (privk ca-0)) (2 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 76)
  (parent 72)
  (unrealized (2 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z (rec z-0)))) (x z-0))
  (defstrand ca 1 (subject a) (ca ca-0) (z z-0))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((2 3) (0 3)) ((3 0) (2 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca-0)) (2 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca-0)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca-0))))
      (recv
        (cat (exp (gen) (mul z z (rec z-0)))
          (enc (exp (gen) (mul z z (rec z-0))) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z-0) a (privk ca-0)))))
  (label 77)
  (parent 72)
  (unrealized (2 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z))
    (x z-0))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 1))
    ((3 3) (0 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z-1) a-0 (privk ca-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 78)
  (parent 74)
  (unrealized (3 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z))
    (x z-0))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((2 0) (3 0))
    ((3 3) (0 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z-1) a-0 (privk ca-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 79)
  (parent 74)
  (unrealized (3 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 z-1 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z-0 (rec z-1)))) (x z-1))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z-1))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z z-0 z-1)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-1) a-0 (privk ca-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-1) a-0 (privk ca-0)))
      (send
        (cat (exp (gen) z-1) (enc (exp (gen) z-1) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) (mul z z-0 (rec z-1)))
          (enc (exp (gen) (mul z z-0 (rec z-1))) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-1) a-0 (privk ca-0)))))
  (label 80)
  (parent 74)
  (unrealized (3 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((1 0) (2 0)) ((2 3) (0 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 3 1 ca 1)
    (enc (exp (gen) z) b-0 (privk ca)) (2 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 81)
  (parent 76)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a b) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((1 0) (2 0)) ((2 3) (0 3))
    ((3 0) (2 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b-0 (privk ca)) (2 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 82)
  (parent 76)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a b) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((2 3) (0 3)) ((3 0) (2 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 3 ca 1) (exp (gen) z) (2 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0)))))
  (label 83)
  (parent 77)
  (unrealized (2 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 1))
    ((3 3) (0 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 84)
  (parent 78)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a a) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b a) (ca ca) (h (exp (gen) z-0)) (x z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 1))
    ((3 3) (0 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 85)
  (parent 78)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a a) (b b) (ca ca) (h (exp (gen) z-0)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((1 0) (3 0)) ((2 0) (0 1))
    ((3 3) (0 3)) ((4 0) (3 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 86)
  (parent 78)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a a) (b b) (ca ca) (h (exp (gen) z-0)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((2 0) (3 0))
    ((3 3) (0 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (3 2))
  (traces
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 87)
  (parent 79)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z-0) (a a) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((2 0) (3 0))
    ((3 3) (0 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 88)
  (parent 79)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a a) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((2 0) (3 0))
    ((3 3) (0 3)) ((4 0) (3 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (3 2))
  (traces
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 89)
  (parent 79)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z-0) (a a) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1) (exp (gen) z-0) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 90)
  (parent 80)
  (unrealized (3 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 1 ca 1) (exp (gen) z-0) (3 2))
  (traces
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 91)
  (parent 80)
  (seen 97)
  (unrealized (3 2))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((2 3) (0 3)) ((3 0) (2 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 1 ca 1)
    (enc (exp (gen) z) b-0 (privk ca-0)) (2 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 92)
  (parent 83)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a b) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (b ca a ca-0 name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca-0) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((2 3) (0 3)) ((3 0) (2 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 3 ca 1)
    (enc (exp (gen) z) b-0 (privk ca-0)) (2 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0)))))
  (label 93)
  (parent 83)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a b) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z expn))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((0 2) (2 2)) ((1 0) (0 0)) ((2 3) (0 3)) ((3 0) (2 0))
    ((4 0) (2 2)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b-0 (privk ca-0)) (2 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 94)
  (parent 83)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a b) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 1 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 95)
  (parent 90)
  (seen 99)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 96)
  (parent 90)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a a) (b b) (ca ca) (h (exp (gen) z-0)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 ca-0 name) (z expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b a-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 97)
  (parent 90)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a a) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z-0))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)) ((5 0) (3 2)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca-0)))))
  (label 98)
  (parent 90)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z) (a a) (b b) (ca ca) (h (exp (gen) z-0)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 1 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 99)
  (parent 91)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z-0) (a a) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 100)
  (parent 91)
  (seen 96)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z-0))
  (precedes ((0 2) (3 2)) ((1 0) (0 0)) ((2 0) (0 1)) ((3 3) (0 3))
    ((4 0) (3 0)) ((5 0) (3 2)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca-0)))))
  (label 101)
  (parent 91)
  (unrealized)
  (shape)
  (maps ((0) ((n n) (y z-0) (a a) (b b) (ca ca) (h (exp (gen) z)))))
  (origs (n (0 2))))

(comment "Nothing left to do")

(defprotocol dhca diffie-hellman
  (defrole init
    (vars (x expn) (a b ca name) (h base) (n text))
    (trace (recv (enc (exp (gen) x) a (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (recv (cat h (enc h b (privk ca)) (enc n (exp h x))))
      (send (enc "check" n (exp h x))))
    (non-orig (privk ca)))
  (defrole resp
    (vars (y expn) (a b ca name) (h base) (n text))
    (trace (recv (enc (exp (gen) y) b (privk ca)))
      (recv (cat h (enc h a (privk ca))))
      (send
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca))
          (enc n (exp h y)))) (recv (enc "check" n (exp h y))))
    (non-orig (privk ca)))
  (defrole ca
    (vars (subject ca name) (z expn))
    (trace (send (enc (exp (gen) z) subject (privk ca))))
    (non-orig z))
  (comment "A diffie-hellman exchange which uses a certificate"
    "authority to certify long-term DH values."))

(defskeleton dhca
  (vars (n text) (a b ca name) (x y expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) y)) (x x))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) x)) (y y))
  (non-orig (privk ca))
  (uniq-orig n)
  (comment "point of view in which init and resp each complete and"
    "they agree on the relevant parameters.")
  (traces
    ((recv (enc (exp (gen) x) a (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (recv
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca))
          (enc n (exp (gen) (mul x y)))))
      (send (enc "check" n (exp (gen) (mul x y)))))
    ((recv (enc (exp (gen) y) b (privk ca)))
      (recv (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (send
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca))
          (enc n (exp (gen) (mul x y)))))
      (recv (enc "check" n (exp (gen) (mul x y))))))
  (label 102)
  (unrealized (0 0) (0 2) (1 0) (1 1))
  (preskeleton)
  (comment "Not a skeleton"))

(defskeleton dhca
  (vars (n text) (a b ca name) (x y expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) y)) (x x))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) x)) (y y))
  (precedes ((1 2) (0 2)))
  (non-orig (privk ca))
  (uniq-orig n)
  (traces
    ((recv (enc (exp (gen) x) a (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (recv
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca))
          (enc n (exp (gen) (mul x y)))))
      (send (enc "check" n (exp (gen) (mul x y)))))
    ((recv (enc (exp (gen) y) b (privk ca)))
      (recv (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (send
        (cat (exp (gen) y) (enc (exp (gen) y) b (privk ca))
          (enc n (exp (gen) (mul x y)))))
      (recv (enc "check" n (exp (gen) (mul x y))))))
  (label 103)
  (parent 102)
  (unrealized (0 0) (1 0) (1 1))
  (origs (n (1 2)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (x z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x x))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) x)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((2 0) (1 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b (privk ca)) (1 0))
  (traces
    ((recv (enc (exp (gen) x) a (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul x z)))))
      (send (enc "check" n (exp (gen) (mul x z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul x z)))))
      (recv (enc "check" n (exp (gen) (mul x z)))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 104)
  (parent 103)
  (unrealized (0 0) (1 1) (1 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((2 0) (1 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 3 2 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (1 1))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 105)
  (parent 104)
  (unrealized (0 0) (1 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((2 0) (1 0)) ((3 0) (1 1)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (1 1))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 106)
  (parent 104)
  (unrealized (0 0) (1 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (x expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) x)) (x x))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) x)) (y x))
  (defstrand ca 1 (subject b) (ca ca) (z x))
  (precedes ((0 3) (1 3)) ((1 2) (0 2)) ((2 0) (1 0)))
  (non-orig (privk ca) x)
  (uniq-orig n)
  (operation encryption-test (displaced 3 0 init 4)
    (enc "check" n (exp (gen) (mul z z))) (1 3))
  (traces
    ((recv (enc (exp (gen) x) b (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) b (privk ca))))
      (recv
        (cat (exp (gen) x) (enc (exp (gen) x) b (privk ca))
          (enc n (exp (gen) (mul x x)))))
      (send (enc "check" n (exp (gen) (mul x x)))))
    ((recv (enc (exp (gen) x) b (privk ca)))
      (recv (cat (exp (gen) x) (enc (exp (gen) x) b (privk ca))))
      (send
        (cat (exp (gen) x) (enc (exp (gen) x) b (privk ca))
          (enc n (exp (gen) (mul x x)))))
      (recv (enc "check" n (exp (gen) (mul x x)))))
    ((send (enc (exp (gen) x) b (privk ca)))))
  (label 107)
  (parent 105)
  (unrealized (0 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z x expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z (rec x)))) (x x))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (added-strand init 4)
    (enc "check" n (exp (gen) (mul z z))) (1 3))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) x) a (privk ca-0)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca-0))))
      (recv
        (cat (exp (gen) (mul z z (rec x)))
          (enc (exp (gen) (mul z z (rec x))) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 108)
  (parent 105)
  (unrealized (0 0) (3 0) (3 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (deflistener (exp (gen) (mul z z)))
  (precedes ((1 2) (0 2)) ((2 0) (1 0)) ((3 1) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-listener (exp (gen) (mul z z)))
    (enc "check" n (exp (gen) (mul z z))) (1 3))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (exp (gen) (mul z z))) (send (exp (gen) (mul z z)))))
  (label 109)
  (parent 105)
  (unrealized (0 0) (3 0))
  (comment "empty cohort"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z x expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x x))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) x)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z x))
  (precedes ((0 3) (1 3)) ((1 2) (0 2)) ((2 0) (1 0)) ((3 0) (1 1)))
  (non-orig (privk ca) z x)
  (uniq-orig n)
  (operation encryption-test (displaced 4 0 init 4)
    (enc "check" n (exp (gen) (mul z z-0))) (1 3))
  (traces
    ((recv (enc (exp (gen) x) a (privk ca)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z x)))))
      (send (enc "check" n (exp (gen) (mul z x)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) x) (enc (exp (gen) x) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z x)))))
      (recv (enc "check" n (exp (gen) (mul z x)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) x) a (privk ca)))))
  (label 110)
  (parent 106)
  (unrealized (0 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 x expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z-0 (rec x)))) (x x))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand init 4)
    (enc "check" n (exp (gen) (mul z z-0))) (1 3))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) x) a-0 (privk ca-0)))
      (send (cat (exp (gen) x) (enc (exp (gen) x) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) (mul z z-0 (rec x)))
          (enc (exp (gen) (mul z z-0 (rec x))) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 111)
  (parent 106)
  (unrealized (0 0) (4 0) (4 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (deflistener (exp (gen) (mul z z-0)))
  (precedes ((1 2) (0 2)) ((2 0) (1 0)) ((3 0) (1 1)) ((4 1) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-listener (exp (gen) (mul z z-0)))
    (enc "check" n (exp (gen) (mul z z-0))) (1 3))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (exp (gen) (mul z z-0))) (send (exp (gen) (mul z z-0)))))
  (label 112)
  (parent 106)
  (unrealized (0 0) (4 0))
  (comment "empty cohort"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((0 3) (1 3)) ((1 2) (0 2)) ((2 0) (0 0)) ((2 0) (1 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 3 2 ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 113)
  (parent 107)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((0 3) (1 3)) ((1 2) (0 2)) ((2 0) (1 0)) ((3 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 114)
  (parent 107)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((2 0) (3 0))
    ((3 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z-0) a (privk ca-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 115)
  (parent 108)
  (unrealized (0 0) (3 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z (rec z-0)))) (x z-0))
  (defstrand ca 1 (subject a) (ca ca-0) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca-0)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca-0))))
      (recv
        (cat (exp (gen) (mul z z (rec z-0)))
          (enc (exp (gen) (mul z z (rec z-0))) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z-0) a (privk ca-0)))))
  (label 116)
  (parent 108)
  (unrealized (0 0) (3 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((0 3) (1 3)) ((1 2) (0 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (1 1)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 117)
  (parent 110)
  (seen 113)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((0 3) (1 3)) ((1 2) (0 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 4 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 118)
  (parent 110)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((0 3) (1 3)) ((1 2) (0 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 0) (0 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 119)
  (parent 110)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z))
    (x z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-1) a-0 (privk ca-0)) (4 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 120)
  (parent 111)
  (unrealized (0 0) (4 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z))
    (x z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 3 ca 1)
    (enc (exp (gen) z-1) a-0 (privk ca-0)) (4 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 121)
  (parent 111)
  (unrealized (0 0) (4 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 z-1 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0)
    (h (exp (gen) (mul z z-0 (rec z-1)))) (x z-1))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z-1))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) (privk ca-0) z z-0 z-1)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-1) a-0 (privk ca-0)) (4 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-1) a-0 (privk ca-0)))
      (send
        (cat (exp (gen) z-1) (enc (exp (gen) z-1) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) (mul z z-0 (rec z-1)))
          (enc (exp (gen) (mul z z-0 (rec z-1))) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-1) a-0 (privk ca-0)))))
  (label 122)
  (parent 111)
  (unrealized (0 0) (4 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((2 0) (3 0))
    ((3 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z) b-0 (privk ca)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 123)
  (parent 115)
  (unrealized (0 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((2 0) (3 0))
    ((3 3) (1 3)) ((4 0) (3 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b-0 (privk ca)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 124)
  (parent 115)
  (unrealized (0 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 4 ca 1) (exp (gen) z) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0)))))
  (label 125)
  (parent 116)
  (unrealized (0 0) (3 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 126)
  (parent 120)
  (unrealized (0 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b a) (ca ca) (h (exp (gen) z-0)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 3 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (4 2))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 127)
  (parent 120)
  (seen 142)
  (unrealized (0 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (4 2))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 128)
  (parent 120)
  (unrealized (0 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 129)
  (parent 121)
  (unrealized (0 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 3 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 130)
  (parent 121)
  (seen 151)
  (unrealized (0 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 131)
  (parent 121)
  (unrealized (0 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1) (exp (gen) z-0) (4 2))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 132)
  (parent 122)
  (unrealized (0 0) (4 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 2 ca 1) (exp (gen) z-0) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 133)
  (parent 122)
  (seen 162)
  (unrealized (0 0) (4 2))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((2 0) (3 0)) ((3 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 4 2 ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 134)
  (parent 123)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((2 0) (3 0))
    ((3 3) (1 3)) ((4 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 135)
  (parent 123)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((2 0) (3 0)) ((3 3) (1 3)) ((4 0) (3 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 136)
  (parent 124)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (ca b name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((2 0) (3 0))
    ((3 3) (1 3)) ((4 0) (0 0)) ((4 0) (3 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z) b-0 (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 137)
  (parent 124)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((2 0) (3 0))
    ((3 3) (1 3)) ((4 0) (3 2)) ((5 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 138)
  (parent 124)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 139)
  (parent 125)
  (unrealized (0 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca-0) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0)))))
  (label 140)
  (parent 125)
  (seen 169)
  (unrealized (0 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)) ((5 0) (3 2)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b-0 (privk ca-0)) (3 2))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 141)
  (parent 125)
  (unrealized (0 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((2 0) (4 0)) ((3 0) (1 1)) ((4 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 142)
  (parent 126)
  (seen 134)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (0 0)) ((3 0) (1 1)) ((4 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 3 ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 143)
  (parent 126)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 144)
  (parent 126)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b a) (ca ca) (h (exp (gen) z-0)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (0 0)) ((3 0) (1 1)) ((4 3) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 145)
  (parent 127)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b a) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (0 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 146)
  (parent 127)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((2 0) (4 0)) ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 2 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 147)
  (parent 128)
  (seen 136)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (0 0)) ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 148)
  (parent 128)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand resp 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (4 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) b-0 (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 149)
  (parent 128)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 2)) ((6 0) (0 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 150)
  (parent 128)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (1 1)) ((3 0) (4 0)) ((4 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 151)
  (parent 129)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((3 0) (4 0)) ((4 3) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 5 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0))))))
  (label 152)
  (parent 129)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (0 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 153)
  (parent 129)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((3 0) (4 0)) ((4 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 3 ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 154)
  (parent 130)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 155)
  (parent 130)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (1 1)) ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 2 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 156)
  (parent 131)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 157)
  (parent 131)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (defstrand init 4 (n n) (a b-0) (b b-0) (ca ca) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (4 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b-0 (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 158)
  (parent 131)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (4 2)) ((6 0) (0 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b-0 (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 159)
  (parent 131)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 2 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 160)
  (parent 132)
  (unrealized (0 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (4 2))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 161)
  (parent 132)
  (seen 181)
  (unrealized (0 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b a-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 162)
  (parent 132)
  (seen 186)
  (unrealized (0 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (4 2)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (4 2))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca-0)))))
  (label 163)
  (parent 132)
  (unrealized (0 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 2 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 164)
  (parent 133)
  (seen 181)
  (unrealized (0 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 165)
  (parent 133)
  (seen 181 186)
  (unrealized (0 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z-0))
  (defstrand ca 1 (subject b) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (4 2)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) b-0 (privk ca-0)) (4 2))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z-0) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca-0)))))
  (label 166)
  (parent 133)
  (seen 191)
  (unrealized (0 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dhca
  (vars (n text) (ca b name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((2 0) (3 0))
    ((3 3) (1 3)) ((4 0) (0 0)) ((4 0) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization weakened ((4 0) (3 2)))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 167)
  (parent 137)
  (seen 135)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 3) (1 3)) ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 168)
  (parent 139)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (ca a name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (0 0)) ((4 0) (3 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 4 ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 169)
  (parent 139)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b a) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)) ((5 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 170)
  (parent 139)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca-0) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 3) (1 3)) ((4 0) (3 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 5 2 ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0)))))
  (label 171)
  (parent 140)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca-0) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)) ((5 0) (0 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 172)
  (parent 140)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 3) (1 3)) ((4 0) (3 0)) ((5 0) (3 2)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 2 ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 173)
  (parent 141)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (0 0)) ((4 0) (3 0)) ((5 0) (3 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 4 ca 1)
    (enc (exp (gen) z) b-0 (privk ca-0)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 174)
  (parent 141)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b a) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)) ((5 0) (0 0)) ((5 0) (3 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z) b-0 (privk ca-0)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 175)
  (parent 141)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)) ((5 0) (3 2)) ((6 0) (0 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) b (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 176)
  (parent 141)
  (unrealized)
  (shape)
  (maps ((0 1) ((a b) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand resp 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((2 0) (4 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation generalization weakened ((5 0) (4 2)))
  (traces
    ((recv (enc (exp (gen) z-0) b-0 (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 177)
  (parent 149)
  (seen 146)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (0 2)) ((3 0) (4 0)) ((4 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization weakened ((3 0) (1 1)))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 178)
  (parent 151)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (0 2)) ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization weakened ((3 0) (1 1)))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 179)
  (parent 156)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (defstrand init 4 (n n) (a b-0) (b b-0) (ca ca) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization weakened ((5 0) (4 2)))
  (traces
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b-0 (privk ca))))
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 180)
  (parent 158)
  (seen 155)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 2 ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 181)
  (parent 160)
  (seen 168)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 182)
  (parent 160)
  (seen 196)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca a name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (4 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 183)
  (parent 160)
  (seen 197)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 184)
  (parent 160)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 185)
  (parent 161)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (4 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 186)
  (parent 161)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 187)
  (parent 161)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b a) (ca ca-0) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 2 ca 1)
    (enc (exp (gen) z) a-0 (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0)))))
  (label 188)
  (parent 162)
  (seen 171)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b a-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0)))))
  (label 189)
  (parent 162)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b a-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 190)
  (parent 162)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a b-0 ca-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject a) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (4 2)))
  (non-orig (privk ca) (privk ca-0) z)
  (uniq-orig n)
  (operation encryption-test (displaced 7 2 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca-0))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 191)
  (parent 163)
  (seen 173)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (4 2)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 7 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca-0)))))
  (label 192)
  (parent 163)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b a b-0 ca name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (4 0)) ((6 0) (4 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 7 5 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 193)
  (parent 163)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b a b-0 ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand resp 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)) ((6 0) (4 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 7 6 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) b-0 (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 194)
  (parent 163)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand ca 1 (subject a-0) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a-0 (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca)))))
  (label 196)
  (parent 164)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b ca a name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (4 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 6 5 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 197)
  (parent 164)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand ca 1 (subject a-0) (ca ca) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a-0 (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 198)
  (parent 164)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 6 3 ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca)))))
  (label 199)
  (parent 165)
  (seen 185)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 name) (z expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand init 4 (n n) (a a-0) (b a) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a-0) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a-0 (privk ca))))
    ((send (enc (exp (gen) z) a (privk ca)))))
  (label 200)
  (parent 165)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z-0))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z-0))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (0 0))
    ((3 0) (1 1)) ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (4 2)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 7 3 ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a-0 (privk ca-0)))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0)))))
  (label 201)
  (parent 166)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b a b-0 ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (0 0)) ((5 0) (4 0)) ((6 0) (4 2)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation encryption-test (displaced 7 5 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 202)
  (parent 166)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (ca ca) (x z-0) (y z) (n n))))
  (origs (n (1 2))))

(defskeleton dhca
  (vars (n text) (b a b-0 ca name) (z expn))
  (defstrand init 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)) ((6 0) (4 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation encryption-test (displaced 7 6 ca 1)
    (enc (exp (gen) z-0) a-0 (privk ca-0)) (0 0))
  (traces
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b-0 (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 203)
  (parent 166)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (a b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (3 2)) ((2 0) (1 0)) ((3 3) (1 3))
    ((4 0) (3 0)) ((5 0) (0 0)) ((5 0) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization weakened ((5 0) (3 2)))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca)))))
  (label 205)
  (parent 175)
  (seen 170)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (4 0)) ((4 3) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization weakened ((3 0) (0 2)))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z))))))
  (label 206)
  (parent 178)
  (seen 168)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca b-0 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand init 4 (n n) (a b) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization weakened ((3 0) (0 2)))
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 207)
  (parent 179)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhca
  (vars (n text) (b a b-0 ca name) (z z-0 expn))
  (defstrand init 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z))
    (x z-0))
  (defstrand resp 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z-0))
    (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)) ((6 0) (1 3)))
  (non-orig (privk ca) z z-0)
  (uniq-orig n)
  (operation generalization weakened ((6 0) (4 2)))
  (traces
    ((recv (enc (exp (gen) z-0) b-0 (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca)))))
  (label 208)
  (parent 194)
  (seen 187)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (b a b-0 ca name) (z expn))
  (defstrand init 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b-0) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (defstrand init 4 (n n) (a a) (b b-0) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand ca 1 (subject a) (ca ca) (z z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (0 0)) ((6 0) (1 3)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization weakened ((6 0) (4 2)))
  (traces
    ((recv (enc (exp (gen) z) b-0 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b-0 (privk ca))))
    ((recv (enc (exp (gen) z) a (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) a (privk ca))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 209)
  (parent 203)
  (seen 200)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhca
  (vars (n text) (b ca b-0 b-1 name) (z expn))
  (defstrand init 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (x z))
  (defstrand resp 4 (n n) (a b) (b b) (ca ca) (h (exp (gen) z)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject b-1) (ca ca) (z z))
  (defstrand init 4 (n n) (a b-1) (b b-0) (ca ca) (h (exp (gen) z))
    (x z))
  (defstrand ca 1 (subject b-0) (ca ca) (z z))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (0 0)) ((2 0) (1 0))
    ((3 0) (4 0)) ((4 3) (1 3)) ((5 0) (4 2)))
  (non-orig (privk ca) z)
  (uniq-orig n)
  (operation generalization separated b-1)
  (traces
    ((recv (enc (exp (gen) z) b (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (recv (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z) b-1 (privk ca))))
    ((recv (enc (exp (gen) z) b-1 (privk ca)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) b-1 (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca))
          (enc n (exp (gen) (mul z z)))))
      (send (enc "check" n (exp (gen) (mul z z)))))
    ((send (enc (exp (gen) z) b-0 (privk ca)))))
  (label 210)
  (parent 207)
  (seen 173)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Strand bound exceeded--aborting run")

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z-0))
    (x z))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z-0))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (4 2)) ((7 0) (0 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z) a-0 (privk ca-0)))
      (send (cat (exp (gen) z) (enc (exp (gen) z) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 195)
  (parent 163)
  (unrealized)
  (comment "aborted"))

(defskeleton dhca
  (vars (n text) (a b ca a-0 b-0 ca-0 name) (z z-0 expn))
  (defstrand init 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z)) (x z-0))
  (defstrand resp 4 (n n) (a a) (b b) (ca ca) (h (exp (gen) z-0)) (y z))
  (defstrand ca 1 (subject b) (ca ca) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (defstrand init 4 (n n) (a a-0) (b b-0) (ca ca-0) (h (exp (gen) z))
    (x z-0))
  (defstrand ca 1 (subject a-0) (ca ca-0) (z z-0))
  (defstrand ca 1 (subject b-0) (ca ca-0) (z z))
  (defstrand ca 1 (subject a) (ca ca) (z z-0))
  (precedes ((1 2) (0 2)) ((1 2) (4 2)) ((2 0) (1 0)) ((3 0) (1 1))
    ((4 3) (1 3)) ((5 0) (4 0)) ((6 0) (4 2)) ((7 0) (0 0)))
  (non-orig (privk ca) (privk ca-0) z z-0)
  (uniq-orig n)
  (operation encryption-test (added-strand ca 1)
    (enc (exp (gen) z-0) a (privk ca)) (0 0))
  (traces
    ((recv (enc (exp (gen) z-0) a (privk ca)))
      (send (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((recv (enc (exp (gen) z) b (privk ca)))
      (recv (cat (exp (gen) z-0) (enc (exp (gen) z-0) a (privk ca))))
      (send
        (cat (exp (gen) z) (enc (exp (gen) z) b (privk ca))
          (enc n (exp (gen) (mul z z-0)))))
      (recv (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z) b (privk ca))))
    ((send (enc (exp (gen) z-0) a (privk ca))))
    ((recv (enc (exp (gen) z-0) a-0 (privk ca-0)))
      (send
        (cat (exp (gen) z-0) (enc (exp (gen) z-0) a-0 (privk ca-0))))
      (recv
        (cat (exp (gen) z) (enc (exp (gen) z) b-0 (privk ca-0))
          (enc n (exp (gen) (mul z z-0)))))
      (send (enc "check" n (exp (gen) (mul z z-0)))))
    ((send (enc (exp (gen) z-0) a-0 (privk ca-0))))
    ((send (enc (exp (gen) z) b-0 (privk ca-0))))
    ((send (enc (exp (gen) z-0) a (privk ca)))))
  (label 204)
  (parent 166)
  (unrealized)
  (comment "aborted"))
