(herald "Diffie-Hellman Key Exchange" (algebra diffie-hellman))

(comment "CPSA 2.5.0")
(comment "All input read from dhke.scm")

(defprotocol dhke diffie-hellman
  (defrole init
    (vars (a b name) (h base) (x expn))
    (trace (send (enc "i" (exp (gen) x) (privk a)))
      (recv (cat (enc h (privk b)) (enc a b (exp h x))))
      (send (enc "i" a b (exp h x))))
    (non-orig x)
    (uniq-orig (exp (gen) x)))
  (defrole resp
    (vars (a b name) (h base) (y expn))
    (trace (recv (enc "i" h (privk a)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a b (exp h y))))
      (recv (enc "i" a b (exp h y))))
    (non-orig y)
    (uniq-orig (exp (gen) y))))

(defskeleton dhke
  (vars (a b name) (h base) (y expn))
  (defstrand resp 3 (a a) (b b) (h h) (y y))
  (non-orig (privk a) (privk b) y)
  (uniq-orig (exp (gen) y))
  (traces
    ((recv (enc "i" h (privk a)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a b (exp h y))))
      (recv (enc "i" a b (exp h y)))))
  (label 0)
  (unrealized (0 0) (0 2))
  (origs ((exp (gen) y) (0 1)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhke
  (vars (a b name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)))
  (non-orig (privk a) (privk b) y x)
  (uniq-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (0 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 1)
  (parent 0)
  (unrealized (0 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (a b name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (precedes ((0 1) (1 1)) ((1 0) (0 0)) ((1 2) (0 2)))
  (non-orig (privk a) (privk b) y x)
  (uniq-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 1 2 init 3)
    (enc "i" a b (exp (gen) (mul y x-0))) (0 2))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x))))))
  (label 2)
  (parent 1)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs ((exp (gen) x) (1 0)) ((exp (gen) y) (0 1))))

(defskeleton dhke
  (vars (a b name) (y x x-0 expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) (mul y x (rec x-0))))
    (x x-0))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)))
  (non-orig (privk a) (privk b) y x x-0)
  (uniq-orig (exp (gen) y) (exp (gen) x) (exp (gen) x-0))
  (operation encryption-test (added-strand init 3)
    (enc "i" a b (exp (gen) (mul y x))) (0 2))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x-0) (privk a)))
      (recv
        (cat (enc (exp (gen) (mul y x (rec x-0))) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x))))))
  (label 3)
  (parent 1)
  (unrealized (2 1))
  (comment "empty cohort"))

(defskeleton dhke
  (vars (a b name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (deflistener (exp (gen) (mul y x)))
  (precedes ((1 0) (0 0)) ((2 1) (0 2)))
  (non-orig (privk a) (privk b) y x)
  (uniq-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-listener (exp (gen) (mul y x)))
    (enc "i" a b (exp (gen) (mul y x))) (0 2))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((recv (exp (gen) (mul y x))) (send (exp (gen) (mul y x)))))
  (label 4)
  (parent 1)
  (unrealized (2 0))
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol dhke diffie-hellman
  (defrole init
    (vars (a b name) (h base) (x expn))
    (trace (send (enc "i" (exp (gen) x) (privk a)))
      (recv (cat (enc h (privk b)) (enc a b (exp h x))))
      (send (enc "i" a b (exp h x))))
    (non-orig x)
    (uniq-orig (exp (gen) x)))
  (defrole resp
    (vars (a b name) (h base) (y expn))
    (trace (recv (enc "i" h (privk a)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a b (exp h y))))
      (recv (enc "i" a b (exp h y))))
    (non-orig y)
    (uniq-orig (exp (gen) y))))

(defskeleton dhke
  (vars (a b name) (h base) (x expn))
  (defstrand init 2 (a a) (b b) (h h) (x x))
  (non-orig (privk a) (privk b) x)
  (uniq-orig (exp (gen) x))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv (cat (enc h (privk b)) (enc a b (exp h x))))))
  (label 5)
  (unrealized (0 1))
  (origs ((exp (gen) x) (0 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (precedes ((1 1) (0 1)))
  (non-orig (privk a) (privk b) x y)
  (uniq-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-strand resp 2)
    (enc (exp (gen) y) (privk b)) (0 1))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y))))))
  (label 6)
  (parent 5)
  (unrealized (0 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (b a name) (x y expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk b) (privk a) x y)
  (uniq-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 2 1 resp 2)
    (enc a-0 b (exp (gen) (mul x y-0))) (0 1))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y))))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 7)
  (parent 6)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) y)) (x x))))
  (origs ((exp (gen) y) (1 1)) ((exp (gen) x) (0 0))))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y y-0 expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) (mul x y (rec y-0))))
    (y y-0))
  (precedes ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a) (privk b) x y y-0)
  (uniq-orig (exp (gen) x) (exp (gen) y) (exp (gen) y-0))
  (operation encryption-test (added-strand resp 2)
    (enc a b (exp (gen) (mul x y))) (0 1))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) (mul x y (rec y-0))) (privk a)))
      (send
        (cat (enc (exp (gen) y-0) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 8)
  (parent 6)
  (unrealized (2 0))
  (comment "empty cohort"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (deflistener (exp (gen) (mul x y)))
  (precedes ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a) (privk b) x y)
  (uniq-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-listener (exp (gen) (mul x y)))
    (enc a b (exp (gen) (mul x y))) (0 1))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (exp (gen) (mul x y))) (send (exp (gen) (mul x y)))))
  (label 9)
  (parent 6)
  (unrealized (2 0))
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol dh-mim diffie-hellman
  (defrole init
    (vars (h base) (x expn) (n text))
    (trace (send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    (non-orig x)
    (uniq-orig n (exp (gen) x)))
  (defrole resp
    (vars (h base) (y expn) (n text))
    (trace (recv h) (send (exp (gen) y)) (recv (enc n (exp h y))))
    (non-orig y)
    (uniq-orig (exp (gen) y)))
  (comment "Diffie-Hellman without signatures"
    "has a man-in-the-middle attack"))

(defskeleton dh-mim
  (vars (n text) (h base) (x expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (non-orig x)
  (uniq-orig n (exp (gen) x))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n)))
  (label 10)
  (unrealized (1 0))
  (preskeleton)
  (comment "Not a skeleton"))

(defskeleton dh-mim
  (vars (n text) (h base) (x expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (precedes ((0 2) (1 0)))
  (non-orig x)
  (uniq-orig n (exp (gen) x))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n)))
  (label 11)
  (parent 10)
  (unrealized (1 0))
  (origs ((exp (gen) x) (0 0)) (n (0 2)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h base) (x expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (deflistener (exp h x))
  (precedes ((0 2) (1 0)) ((2 1) (1 0)))
  (non-orig x)
  (uniq-orig n (exp (gen) x))
  (operation nonce-test (added-listener (exp h x)) n (1 0)
    (enc n (exp h x)))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n)) ((recv (exp h x)) (send (exp h x))))
  (label 12)
  (parent 11)
  (unrealized (2 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (x expn))
  (defstrand init 3 (n n) (h (gen)) (x x))
  (deflistener n)
  (deflistener (exp (gen) x))
  (precedes ((0 0) (2 0)) ((0 2) (1 0)) ((2 1) (1 0)))
  (non-orig x)
  (uniq-orig n (exp (gen) x))
  (operation encryption-test (displaced 3 0 init 1) (exp (gen) x-0)
    (2 0))
  (traces
    ((send (exp (gen) x)) (recv (gen)) (send (enc n (exp (gen) x))))
    ((recv n) (send n)) ((recv (exp (gen) x)) (send (exp (gen) x))))
  (label 13)
  (parent 12)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (x x-0 expn))
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x) x-0))) (x x))
  (deflistener n)
  (deflistener (exp (gen) x-0))
  (defstrand init 1 (x x-0))
  (precedes ((0 2) (1 0)) ((2 1) (1 0)) ((3 0) (2 0)))
  (non-orig x x-0)
  (uniq-orig n (exp (gen) x) (exp (gen) x-0))
  (operation encryption-test (added-strand init 1) (exp (gen) x-0)
    (2 0))
  (traces
    ((send (exp (gen) x)) (recv (exp (gen) (mul (rec x) x-0)))
      (send (enc n (exp (gen) x-0)))) ((recv n) (send n))
    ((recv (exp (gen) x-0)) (send (exp (gen) x-0)))
    ((send (exp (gen) x-0))))
  (label 14)
  (parent 12)
  (unrealized (0 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (h base) (x y expn))
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x) y))) (x x))
  (deflistener n)
  (deflistener (exp (gen) y))
  (defstrand resp 2 (h h) (y y))
  (precedes ((0 2) (1 0)) ((2 1) (1 0)) ((3 1) (2 0)))
  (non-orig x y)
  (uniq-orig n (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-strand resp 2) (exp (gen) y) (2 0))
  (traces
    ((send (exp (gen) x)) (recv (exp (gen) (mul (rec x) y)))
      (send (enc n (exp (gen) y)))) ((recv n) (send n))
    ((recv (exp (gen) y)) (send (exp (gen) y)))
    ((recv h) (send (exp (gen) y))))
  (label 15)
  (parent 12)
  (unrealized (0 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (x expn))
  (defstrand init 3 (n n) (h (gen)) (x x))
  (deflistener n)
  (precedes ((0 2) (1 0)))
  (non-orig x)
  (uniq-orig n (exp (gen) x))
  (operation generalization deleted (2 0))
  (traces
    ((send (exp (gen) x)) (recv (gen)) (send (enc n (exp (gen) x))))
    ((recv n) (send n)))
  (label 16)
  (parent 13)
  (unrealized)
  (shape)
  (maps ((0 1) ((n n) (h (gen)) (x x))))
  (origs ((exp (gen) x) (0 0)) (n (0 2))))

(comment "Nothing left to do")
