(herald "DHKE using penetrator non-origination assuptions"
  (algebra diffie-hellman))

(comment "CPSA 2.5.0")
(comment "All input read from dhke_pen_non.scm")

(defprotocol dhke diffie-hellman
  (defrole init
    (vars (a b name) (h base) (x expn))
    (trace (send (enc "i" (exp (gen) x) (privk a)))
      (recv (cat (enc h (privk b)) (enc a b (exp h x))))
      (send (enc "i" a b (exp h x))))
    (non-orig x)
    (pen-non-orig (exp (gen) x)))
  (defrole resp
    (vars (a b name) (h base) (y expn))
    (trace (recv (enc "i" h (privk a)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a b (exp h y))))
      (recv (enc "i" a b (exp h y))))
    (non-orig y)
    (pen-non-orig (exp (gen) y))))

(defskeleton dhke
  (vars (a b name) (h base) (y expn))
  (defstrand resp 3 (a a) (b b) (h h) (y y))
  (non-orig (privk a) (privk b) y)
  (pen-non-orig (exp (gen) y))
  (traces
    ((recv (enc "i" h (privk a)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a b (exp h y))))
      (recv (enc "i" a b (exp h y)))))
  (label 0)
  (unrealized (0 0) (0 2))
  (origs)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhke
  (vars (a b name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (0 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 1)
  (parent 0)
  (unrealized (0 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (a b name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (precedes ((1 0) (0 0)) ((1 2) (0 2)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 1 2 init 3)
    (enc "i" a b (exp (gen) (mul y x-0))) (0 2))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x))))))
  (label 2)
  (parent 1)
  (unrealized (1 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhke
  (vars (a b name) (y x x-0 expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) (mul y x (rec x-0))))
    (x x-0))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)))
  (non-orig (privk a) (privk b) y x x-0)
  (pen-non-orig (exp (gen) y) (exp (gen) x) (exp (gen) x-0))
  (operation encryption-test (added-strand init 3)
    (enc "i" a b (exp (gen) (mul y x))) (0 2))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x-0) (privk a)))
      (recv
        (cat (enc (exp (gen) (mul y x (rec x-0))) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x))))))
  (label 3)
  (parent 1)
  (unrealized (2 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (a b name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (deflistener (exp (gen) (mul y x)))
  (precedes ((1 0) (0 0)) ((2 1) (0 2)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-listener (exp (gen) (mul y x)))
    (enc "i" a b (exp (gen) (mul y x))) (0 2))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((recv (exp (gen) (mul y x))) (send (exp (gen) (mul y x)))))
  (label 4)
  (parent 1)
  (unrealized (2 0))
  (comment "empty cohort"))

(defskeleton dhke
  (vars (a b name) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (precedes ((0 1) (1 1)) ((1 0) (0 0)) ((1 2) (0 2)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 2 0 resp 2)
    (enc (exp (gen) y) (privk b)) (1 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y))))))
  (label 5)
  (parent 2)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (precedes ((1 0) (0 0)) ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-strand resp 2)
    (enc (exp (gen) y) (privk b)) (1 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y))))))
  (label 6)
  (parent 2)
  (unrealized (1 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-strand resp 2)
    (enc (exp (gen) y) (privk b)) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y))))))
  (label 7)
  (parent 3)
  (unrealized (2 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhke
  (vars (a b name) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (precedes ((0 1) (2 1)) ((1 0) (0 0)) ((2 2) (0 2)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 3 0 resp 2)
    (enc (exp (gen) y) (privk b)) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y))))))
  (label 8)
  (parent 3)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-strand resp 2)
    (enc (exp (gen) y) (privk b)) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y))))))
  (label 9)
  (parent 3)
  (unrealized (2 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (precedes ((0 1) (1 1)) ((1 0) (0 0)) ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 3 0 resp 2)
    (enc a b (exp (gen) (mul x y-0))) (1 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y))))))
  (label 10)
  (parent 6)
  (seen 5)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (b a name) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b) (privk a) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 3 2 resp 2)
    (enc a-0 b (exp (gen) (mul x y-0))) (1 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 11)
  (parent 6)
  (unrealized (2 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y y-0 expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) (mul x y (rec y-0))))
    (y y-0))
  (precedes ((1 0) (0 0)) ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1)))
  (non-orig (privk a) (privk b) x y y-0)
  (pen-non-orig (exp (gen) x) (exp (gen) y) (exp (gen) y-0))
  (operation encryption-test (added-strand resp 2)
    (enc a b (exp (gen) (mul x y))) (1 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) (mul x y (rec y-0))) (privk a)))
      (send
        (cat (enc (exp (gen) y-0) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 12)
  (parent 6)
  (unrealized (3 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (deflistener (exp (gen) (mul x y)))
  (precedes ((1 0) (0 0)) ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-listener (exp (gen) (mul x y)))
    (enc a b (exp (gen) (mul x y))) (1 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (exp (gen) (mul x y))) (send (exp (gen) (mul x y)))))
  (label 13)
  (parent 6)
  (unrealized (3 0))
  (comment "empty cohort"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y y-0 expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y y-0))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x y-0))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (precedes ((0 1) (2 1)) ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk a) (privk b) y y-0)
  (pen-non-orig (exp (gen) y) (exp (gen) y-0))
  (operation encryption-test (displaced 4 0 resp 2)
    (enc a b (exp (gen) (mul x y))) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) y-0) (privk b))
          (enc a b (exp (gen) (mul y y-0)))))
      (recv (enc "i" a b (exp (gen) (mul y y-0)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) y-0) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y y-0)))))
      (send (enc "i" a b (exp (gen) (mul y y-0)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y))))))
  (label 14)
  (parent 7)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) y)) (y y-0))))
  (origs))

(defskeleton dhke
  (vars (b a name) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk b) (privk a) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 4 3 resp 2)
    (enc a-0 b (exp (gen) (mul x y-0))) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 15)
  (parent 7)
  (unrealized (3 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y y-0 expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) (mul x y (rec y-0))))
    (y y-0))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 1) (2 1)))
  (non-orig (privk a) (privk b) x y y-0)
  (pen-non-orig (exp (gen) x) (exp (gen) y) (exp (gen) y-0))
  (operation encryption-test (added-strand resp 2)
    (enc a b (exp (gen) (mul x y))) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) (mul x y (rec y-0))) (privk a)))
      (send
        (cat (enc (exp (gen) y-0) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 16)
  (parent 7)
  (unrealized (4 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (deflistener (exp (gen) (mul x y)))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 1) (2 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-listener (exp (gen) (mul x y)))
    (enc a b (exp (gen) (mul x y))) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (exp (gen) (mul x y))) (send (exp (gen) (mul x y)))))
  (label 17)
  (parent 7)
  (unrealized (4 0))
  (comment "empty cohort"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (precedes ((0 1) (2 1)) ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 4 0 resp 2)
    (enc a b (exp (gen) (mul x y-0))) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y))))))
  (label 18)
  (parent 9)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (b a name) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk b) (privk a) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 4 3 resp 2)
    (enc a-0 b (exp (gen) (mul x y-0))) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 19)
  (parent 9)
  (unrealized (3 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y y-0 expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) (mul x y (rec y-0))))
    (y y-0))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 1) (2 1)))
  (non-orig (privk a) (privk b) x y y-0)
  (pen-non-orig (exp (gen) x) (exp (gen) y) (exp (gen) y-0))
  (operation encryption-test (added-strand resp 2)
    (enc a b (exp (gen) (mul x y))) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) (mul x y (rec y-0))) (privk a)))
      (send
        (cat (enc (exp (gen) y-0) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 20)
  (parent 9)
  (unrealized (4 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (deflistener (exp (gen) (mul x y)))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 1) (2 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-listener (exp (gen) (mul x y)))
    (enc a b (exp (gen) (mul x y))) (2 1))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (recv (enc "i" a b (exp (gen) (mul x y)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))
      (send (enc "i" a b (exp (gen) (mul x y)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (exp (gen) (mul x y))) (send (exp (gen) (mul x y)))))
  (label 21)
  (parent 9)
  (unrealized (4 0))
  (comment "empty cohort"))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((1 0) (2 0)) ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 3 1 init 1)
    (enc "i" (exp (gen) x) (privk a)) (2 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 22)
  (parent 11)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((1 2) (0 2)) ((2 1) (1 1)) ((3 0) (2 0)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (2 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 23)
  (parent 11)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) x)) (x y))
  (defstrand resp 2 (a a-0) (b b) (h h) (y x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1))
    ((4 0) (3 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) y) (privk a)))
      (recv
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) x) (privk b)) (enc a-0 b (exp h x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 24)
  (parent 12)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) y)) (y x))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((1 2) (0 2)) ((2 1) (1 1))
    ((3 1) (1 1)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 4 1 init 1)
    (enc "i" (exp (gen) x) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 25)
  (parent 12)
  (seen 22)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1))
    ((4 0) (3 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 26)
  (parent 12)
  (seen 23)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (b a name) (x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y x))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) x)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y x))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk b) (privk a) x)
  (pen-non-orig (exp (gen) x))
  (operation encryption-test (displaced 4 1 init 1)
    (enc "i" (exp (gen) x-0) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul x x)))))
      (recv (enc "i" a b (exp (gen) (mul x x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul x x)))))
      (send (enc "i" a b (exp (gen) (mul x x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul x x)))))))
  (label 27)
  (parent 15)
  (seen 34)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 4 2 init 1)
    (enc "i" (exp (gen) x) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 28)
  (parent 15)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) y)) (y x))))
  (origs))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 0) (3 0)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 29)
  (parent 15)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) y)) (y x))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) x)) (x y))
  (defstrand resp 2 (a a-0) (b b) (h h) (y x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((1 0) (4 0)) ((2 2) (0 2)) ((3 1) (2 1))
    ((4 1) (2 1)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 5 1 init 1)
    (enc "i" (exp (gen) x) (privk a)) (4 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) y) (privk a)))
      (recv
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) x) (privk b)) (enc a-0 b (exp h x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 30)
  (parent 16)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) x)) (x y))
  (defstrand resp 2 (a a-0) (b b) (h h) (y x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 1) (2 1))
    ((5 0) (4 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (4 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) y) (privk a)))
      (recv
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) x) (privk b)) (enc a-0 b (exp h x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 31)
  (parent 16)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((2 0) (4 0)) ((2 2) (0 2)) ((3 1) (2 1))
    ((4 1) (2 1)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 5 2 init 1)
    (enc "i" (exp (gen) x) (privk a)) (4 0))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 32)
  (parent 16)
  (seen 28)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 1) (2 1))
    ((5 0) (4 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (4 0))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 33)
  (parent 16)
  (seen 29)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((1 0) (3 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 4 1 init 1)
    (enc "i" (exp (gen) x) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 34)
  (parent 19)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((2 0) (3 0)) ((2 2) (0 2)) ((3 1) (2 1)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 4 2 init 1)
    (enc "i" (exp (gen) x) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 35)
  (parent 19)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 0) (3 0)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (3 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 36)
  (parent 19)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (y y))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) y)) (y x))
  (defstrand init 1 (a a) (x y))
  (defstrand init 3 (a a) (b b) (h (exp (gen) x)) (x y))
  (defstrand resp 2 (a a-0) (b b) (h h) (y x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 1) (2 1))
    ((5 0) (4 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (4 0))
  (traces
    ((recv (enc "i" (exp (gen) y) (privk a)))
      (send
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) y) (privk a))))
    ((send (enc "i" (exp (gen) y) (privk a)))
      (recv
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) x) (privk b)) (enc a-0 b (exp h x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 37)
  (parent 20)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) y)) (y x))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((1 0) (4 0)) ((2 2) (0 2)) ((3 1) (2 1))
    ((4 1) (2 1)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 5 1 init 1)
    (enc "i" (exp (gen) x) (privk a)) (4 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 38)
  (parent 20)
  (seen 34)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 0) (0 0)) ((2 0) (4 0)) ((2 2) (0 2)) ((3 1) (2 1))
    ((4 1) (2 1)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 5 2 init 1)
    (enc "i" (exp (gen) x) (privk a)) (4 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 39)
  (parent 20)
  (seen 35)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand resp 3 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (defstrand init 3 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 0) (0 0)) ((2 2) (0 2)) ((3 1) (2 1)) ((4 1) (2 1))
    ((5 0) (4 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (4 0))
  (traces
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (recv (enc "i" a b (exp (gen) (mul y x)))))
    ((send (enc "i" (exp (gen) x) (privk a))))
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))
      (send (enc "i" a b (exp (gen) (mul y x)))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 40)
  (parent 20)
  (seen 36)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Nothing left to do")

(defprotocol dhke diffie-hellman
  (defrole init
    (vars (a b name) (h base) (x expn))
    (trace (send (enc "i" (exp (gen) x) (privk a)))
      (recv (cat (enc h (privk b)) (enc a b (exp h x))))
      (send (enc "i" a b (exp h x))))
    (non-orig x)
    (pen-non-orig (exp (gen) x)))
  (defrole resp
    (vars (a b name) (h base) (y expn))
    (trace (recv (enc "i" h (privk a)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a b (exp h y))))
      (recv (enc "i" a b (exp h y))))
    (non-orig y)
    (pen-non-orig (exp (gen) y))))

(defskeleton dhke
  (vars (a b name) (h base) (x expn))
  (defstrand init 2 (a a) (b b) (h h) (x x))
  (non-orig (privk a) (privk b) x)
  (pen-non-orig (exp (gen) x))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv (cat (enc h (privk b)) (enc a b (exp h x))))))
  (label 41)
  (unrealized (0 1))
  (origs)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (precedes ((1 1) (0 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-strand resp 2)
    (enc (exp (gen) y) (privk b)) (0 1))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y))))))
  (label 42)
  (parent 41)
  (unrealized (0 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (b a name) (x y expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((1 1) (0 1)))
  (non-orig (privk b) (privk a) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (displaced 2 1 resp 2)
    (enc a-0 b (exp (gen) (mul x y-0))) (0 1))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y))))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 43)
  (parent 42)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y y-0 expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) (mul x y (rec y-0))))
    (y y-0))
  (precedes ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a) (privk b) x y y-0)
  (pen-non-orig (exp (gen) x) (exp (gen) y) (exp (gen) y-0))
  (operation encryption-test (added-strand resp 2)
    (enc a b (exp (gen) (mul x y))) (0 1))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) (mul x y (rec y-0))) (privk a)))
      (send
        (cat (enc (exp (gen) y-0) (privk b))
          (enc a b (exp (gen) (mul x y)))))))
  (label 44)
  (parent 42)
  (unrealized (2 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (x y expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (deflistener (exp (gen) (mul x y)))
  (precedes ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a) (privk b) x y)
  (pen-non-orig (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-listener (exp (gen) (mul x y)))
    (enc a b (exp (gen) (mul x y))) (0 1))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul x y))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (exp (gen) (mul x y))) (send (exp (gen) (mul x y)))))
  (label 45)
  (parent 42)
  (unrealized (2 0))
  (comment "empty cohort"))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 2 0 init 1)
    (enc "i" (exp (gen) x) (privk a)) (1 0))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 46)
  (parent 43)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) y)) (x x))))
  (origs))

(defskeleton dhke
  (vars (b a name) (y x expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 1) (0 1)) ((2 0) (1 0)))
  (non-orig (privk b) (privk a) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (1 0))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 47)
  (parent 43)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) y)) (x x))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) x)) (x y))
  (defstrand resp 2 (a a-0) (b b) (h h) (y x))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 1) (0 1)) ((2 1) (0 1)) ((3 0) (2 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (2 0))
  (traces
    ((send (enc "i" (exp (gen) y) (privk a)))
      (recv
        (cat (enc (exp (gen) x) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) x) (privk b)) (enc a-0 b (exp h x)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 48)
  (parent 44)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (b b) (h (exp (gen) x)) (x y))))
  (origs))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (displaced 3 0 init 1)
    (enc "i" (exp (gen) x) (privk a)) (2 0))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x)))))))
  (label 49)
  (parent 44)
  (seen 46)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dhke
  (vars (a b a-0 name) (h base) (y x expn))
  (defstrand init 2 (a a) (b b) (h (exp (gen) y)) (x x))
  (defstrand resp 2 (a a-0) (b b) (h h) (y y))
  (defstrand resp 2 (a a) (b b) (h (exp (gen) x)) (y y))
  (defstrand init 1 (a a) (x x))
  (precedes ((1 1) (0 1)) ((2 1) (0 1)) ((3 0) (2 0)))
  (non-orig (privk a) (privk b) y x)
  (pen-non-orig (exp (gen) y) (exp (gen) x))
  (operation encryption-test (added-strand init 1)
    (enc "i" (exp (gen) x) (privk a)) (2 0))
  (traces
    ((send (enc "i" (exp (gen) x) (privk a)))
      (recv
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((recv (enc "i" h (privk a-0)))
      (send (cat (enc (exp (gen) y) (privk b)) (enc a-0 b (exp h y)))))
    ((recv (enc "i" (exp (gen) x) (privk a)))
      (send
        (cat (enc (exp (gen) y) (privk b))
          (enc a b (exp (gen) (mul y x))))))
    ((send (enc "i" (exp (gen) x) (privk a)))))
  (label 50)
  (parent 44)
  (seen 47)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Nothing left to do")

(defprotocol dh-mim diffie-hellman
  (defrole init
    (vars (h base) (x expn) (n text))
    (trace (send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    (non-orig x)
    (pen-non-orig n (exp (gen) x)))
  (defrole resp
    (vars (h base) (y expn) (n text))
    (trace (recv h) (send (exp (gen) y)) (recv (enc n (exp h y))))
    (non-orig y)
    (pen-non-orig (exp (gen) y)))
  (comment "Diffie-Hellman without signatures"
    "has a man-in-the-middle attack"))

(defskeleton dh-mim
  (vars (n text) (h base) (x expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (non-orig x)
  (pen-non-orig n (exp (gen) x))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n)))
  (label 51)
  (unrealized (1 0))
  (origs)
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h base) (x expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (precedes ((0 2) (1 0)))
  (non-orig x)
  (pen-non-orig n (exp (gen) x))
  (operation nonce-test (displaced 2 0 init 3) n (1 0))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n)))
  (label 52)
  (parent 51)
  (unrealized (1 0))
  (origs)
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h h-0 base) (x x-0 expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h h-0) (x x-0))
  (precedes ((2 2) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation nonce-test (added-strand init 3) n (1 0))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv h-0) (send (enc n (exp h-0 x-0)))))
  (label 53)
  (parent 51)
  (seen 54)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h h-0 base) (x x-0 expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h h-0) (x x-0))
  (precedes ((0 2) (1 0)) ((2 2) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation nonce-test (added-strand init 3) n (1 0) (enc n (exp h x)))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv h-0) (send (enc n (exp h-0 x-0)))))
  (label 54)
  (parent 52)
  (seen 57)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h base) (x expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (deflistener (exp h x))
  (precedes ((0 2) (1 0)) ((2 1) (1 0)))
  (non-orig x)
  (pen-non-orig n (exp (gen) x))
  (operation nonce-test (added-listener (exp h x)) n (1 0)
    (enc n (exp h x)))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n)) ((recv (exp h x)) (send (exp h x))))
  (label 55)
  (parent 52)
  (unrealized (2 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h h-0 base) (x x-0 expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h h-0) (x x-0))
  (deflistener (exp h-0 x-0))
  (precedes ((2 2) (1 0)) ((3 1) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation nonce-test (added-listener (exp h-0 x-0)) n (1 0)
    (enc n (exp h-0 x-0)))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv h-0) (send (enc n (exp h-0 x-0))))
    ((recv (exp h-0 x-0)) (send (exp h-0 x-0))))
  (label 56)
  (parent 53)
  (unrealized (3 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h h-0 base) (x x-0 expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h h-0) (x x-0))
  (deflistener (exp h x))
  (precedes ((0 2) (1 0)) ((2 2) (1 0)) ((3 1) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation nonce-test (added-listener (exp h x)) n (1 0)
    (enc n (exp h x)) (enc n (exp h-0 x-0)))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv h-0) (send (enc n (exp h-0 x-0))))
    ((recv (exp h x)) (send (exp h x))))
  (label 57)
  (parent 54)
  (unrealized (3 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (x expn))
  (defstrand init 3 (n n) (h (gen)) (x x))
  (deflistener n)
  (deflistener (exp (gen) x))
  (precedes ((0 0) (2 0)) ((0 2) (1 0)) ((2 1) (1 0)))
  (non-orig x)
  (pen-non-orig n (exp (gen) x))
  (operation encryption-test (displaced 3 0 init 1) (exp (gen) x-0)
    (2 0))
  (traces
    ((send (exp (gen) x)) (recv (gen)) (send (enc n (exp (gen) x))))
    ((recv n) (send n)) ((recv (exp (gen) x)) (send (exp (gen) x))))
  (label 58)
  (parent 55)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (x x-0 expn))
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x) x-0))) (x x))
  (deflistener n)
  (deflistener (exp (gen) x-0))
  (defstrand init 1 (x x-0))
  (precedes ((0 2) (1 0)) ((2 1) (1 0)) ((3 0) (2 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation encryption-test (added-strand init 1) (exp (gen) x-0)
    (2 0))
  (traces
    ((send (exp (gen) x)) (recv (exp (gen) (mul (rec x) x-0)))
      (send (enc n (exp (gen) x-0)))) ((recv n) (send n))
    ((recv (exp (gen) x-0)) (send (exp (gen) x-0)))
    ((send (exp (gen) x-0))))
  (label 59)
  (parent 55)
  (unrealized (0 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (h base) (x y expn))
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x) y))) (x x))
  (deflistener n)
  (deflistener (exp (gen) y))
  (defstrand resp 2 (h h) (y y))
  (precedes ((0 2) (1 0)) ((2 1) (1 0)) ((3 1) (2 0)))
  (non-orig x y)
  (pen-non-orig n (exp (gen) x) (exp (gen) y))
  (operation encryption-test (added-strand resp 2) (exp (gen) y) (2 0))
  (traces
    ((send (exp (gen) x)) (recv (exp (gen) (mul (rec x) y)))
      (send (enc n (exp (gen) y)))) ((recv n) (send n))
    ((recv (exp (gen) y)) (send (exp (gen) y)))
    ((recv h) (send (exp (gen) y))))
  (label 60)
  (parent 55)
  (unrealized (0 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (h base) (x x-0 expn))
  (defstrand init 3 (n n) (h h) (x x-0))
  (deflistener n)
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x) x-0))) (x x))
  (deflistener (exp (gen) x-0))
  (precedes ((0 0) (3 0)) ((2 2) (1 0)) ((3 1) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation encryption-test (displaced 4 0 init 1) (exp (gen) x-1)
    (3 0))
  (traces ((send (exp (gen) x-0)) (recv h) (send (enc n (exp h x-0))))
    ((recv n) (send n))
    ((send (exp (gen) x)) (recv (exp (gen) (mul (rec x) x-0)))
      (send (enc n (exp (gen) x-0))))
    ((recv (exp (gen) x-0)) (send (exp (gen) x-0))))
  (label 61)
  (parent 56)
  (unrealized (2 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (h base) (x x-0 expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h (gen)) (x x-0))
  (deflistener (exp (gen) x-0))
  (precedes ((2 0) (3 0)) ((2 2) (1 0)) ((3 1) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation encryption-test (displaced 4 2 init 1) (exp (gen) x-1)
    (3 0))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv (gen)) (send (enc n (exp (gen) x-0))))
    ((recv (exp (gen) x-0)) (send (exp (gen) x-0))))
  (label 62)
  (parent 56)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h base) (x x-0 x-1 expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x-0) x-1))) (x x-0))
  (deflistener (exp (gen) x-1))
  (defstrand init 1 (x x-1))
  (precedes ((2 2) (1 0)) ((3 1) (1 0)) ((4 0) (3 0)))
  (non-orig x x-0 x-1)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0) (exp (gen) x-1))
  (operation encryption-test (added-strand init 1) (exp (gen) x-1)
    (3 0))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv (exp (gen) (mul (rec x-0) x-1)))
      (send (enc n (exp (gen) x-1))))
    ((recv (exp (gen) x-1)) (send (exp (gen) x-1)))
    ((send (exp (gen) x-1))))
  (label 63)
  (parent 56)
  (unrealized (2 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (h h-0 base) (x x-0 y expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x-0) y))) (x x-0))
  (deflistener (exp (gen) y))
  (defstrand resp 2 (h h-0) (y y))
  (precedes ((2 2) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)))
  (non-orig x x-0 y)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0) (exp (gen) y))
  (operation encryption-test (added-strand resp 2) (exp (gen) y) (3 0))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv (exp (gen) (mul (rec x-0) y)))
      (send (enc n (exp (gen) y))))
    ((recv (exp (gen) y)) (send (exp (gen) y)))
    ((recv h-0) (send (exp (gen) y))))
  (label 64)
  (parent 56)
  (unrealized (2 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (h base) (x x-0 expn))
  (defstrand init 3 (n n) (h (gen)) (x x-0))
  (deflistener n)
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener (exp (gen) x-0))
  (precedes ((0 0) (3 0)) ((0 2) (1 0)) ((2 2) (1 0)) ((3 1) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation encryption-test (displaced 4 0 init 1) (exp (gen) x-1)
    (3 0))
  (traces
    ((send (exp (gen) x-0)) (recv (gen)) (send (enc n (exp (gen) x-0))))
    ((recv n) (send n))
    ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv (exp (gen) x-0)) (send (exp (gen) x-0))))
  (label 65)
  (parent 57)
  (seen 58)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dh-mim
  (vars (n text) (h base) (x x-0 expn))
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x) x-0))) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h h) (x x-0))
  (deflistener (exp (gen) x-0))
  (precedes ((0 2) (1 0)) ((2 0) (3 0)) ((2 2) (1 0)) ((3 1) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation encryption-test (displaced 4 2 init 1) (exp (gen) x-1)
    (3 0))
  (traces
    ((send (exp (gen) x)) (recv (exp (gen) (mul (rec x) x-0)))
      (send (enc n (exp (gen) x-0)))) ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv h) (send (enc n (exp h x-0))))
    ((recv (exp (gen) x-0)) (send (exp (gen) x-0))))
  (label 66)
  (parent 57)
  (unrealized (0 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (h base) (x x-0 x-1 expn))
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x) x-1))) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h h) (x x-0))
  (deflistener (exp (gen) x-1))
  (defstrand init 1 (x x-1))
  (precedes ((0 2) (1 0)) ((2 2) (1 0)) ((3 1) (1 0)) ((4 0) (3 0)))
  (non-orig x x-0 x-1)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0) (exp (gen) x-1))
  (operation encryption-test (added-strand init 1) (exp (gen) x-1)
    (3 0))
  (traces
    ((send (exp (gen) x)) (recv (exp (gen) (mul (rec x) x-1)))
      (send (enc n (exp (gen) x-1)))) ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv h) (send (enc n (exp h x-0))))
    ((recv (exp (gen) x-1)) (send (exp (gen) x-1)))
    ((send (exp (gen) x-1))))
  (label 67)
  (parent 57)
  (unrealized (0 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (h h-0 base) (x x-0 y expn))
  (defstrand init 3 (n n) (h (exp (gen) (mul (rec x) y))) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h h) (x x-0))
  (deflistener (exp (gen) y))
  (defstrand resp 2 (h h-0) (y y))
  (precedes ((0 2) (1 0)) ((2 2) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)))
  (non-orig x x-0 y)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0) (exp (gen) y))
  (operation encryption-test (added-strand resp 2) (exp (gen) y) (3 0))
  (traces
    ((send (exp (gen) x)) (recv (exp (gen) (mul (rec x) y)))
      (send (enc n (exp (gen) y)))) ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv h) (send (enc n (exp h x-0))))
    ((recv (exp (gen) y)) (send (exp (gen) y)))
    ((recv h-0) (send (exp (gen) y))))
  (label 68)
  (parent 57)
  (unrealized (0 1))
  (comment "empty cohort"))

(defskeleton dh-mim
  (vars (n text) (x expn))
  (defstrand init 3 (n n) (h (gen)) (x x))
  (deflistener n)
  (precedes ((0 2) (1 0)))
  (non-orig x)
  (pen-non-orig n (exp (gen) x))
  (operation generalization deleted (2 0))
  (traces
    ((send (exp (gen) x)) (recv (gen)) (send (enc n (exp (gen) x))))
    ((recv n) (send n)))
  (label 69)
  (parent 58)
  (unrealized)
  (shape)
  (maps ((0 1) ((n n) (h (gen)) (x x))))
  (origs))

(defskeleton dh-mim
  (vars (n text) (h base) (x x-0 expn))
  (defstrand init 3 (n n) (h h) (x x))
  (deflistener n)
  (defstrand init 3 (n n) (h (gen)) (x x-0))
  (precedes ((2 2) (1 0)))
  (non-orig x x-0)
  (pen-non-orig n (exp (gen) x) (exp (gen) x-0))
  (operation generalization deleted (3 0))
  (traces ((send (exp (gen) x)) (recv h) (send (enc n (exp h x))))
    ((recv n) (send n))
    ((send (exp (gen) x-0)) (recv (gen))
      (send (enc n (exp (gen) x-0)))))
  (label 70)
  (parent 62)
  (unrealized)
  (shape)
  (maps ((0 1) ((n n) (h h) (x x))))
  (origs))

(comment "Nothing left to do")
