(herald "Tor Circuit-Level Handshake Protocol" (algebra diffie-hellman)
  (comment "Achieves unilateral authentication"))

(comment "CPSA 2.5.0")
(comment "All input read from tor.scm")

(defprotocol tor diffie-hellman
  (defrole init
    (vars (x y expn) (b name) (n text))
    (trace (send (enc (exp (gen) x) (pubk b)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    (pen-non-orig x)
    (uniq-orig n))
  (defrole resp
    (vars (x y expn) (b name) (n text))
    (trace (recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    (pen-non-orig y)))

(defskeleton tor
  (vars (b name) (x y expn))
  (defstrand init 2 (b b) (x x) (y y))
  (non-orig (privk b))
  (pen-non-orig x)
  (traces
    ((send (enc (exp (gen) x) (pubk b)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))))
  (label 0)
  (unrealized (0 1))
  (origs)
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton tor
  (vars (b b-0 name) (x y expn))
  (defstrand init 2 (b b) (x x) (y y))
  (defstrand resp 2 (b b-0) (x x) (y y))
  (precedes ((1 1) (0 1)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (operation encryption-test (added-strand resp 2)
    (enc "hash" (exp (gen) (mul x y))) (0 1))
  (traces
    ((send (enc (exp (gen) x) (pubk b)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y))))))
    ((recv (enc (exp (gen) x) (pubk b-0)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))))
  (label 1)
  (parent 0)
  (unrealized)
  (shape)
  (maps ((0) ((b b) (x x) (y y))))
  (origs))

(defskeleton tor
  (vars (b b-0 name) (x y expn))
  (defstrand init 2 (b b) (x y) (y x))
  (defstrand resp 2 (b b-0) (x x) (y y))
  (precedes ((1 1) (0 1)))
  (non-orig (privk b))
  (pen-non-orig y)
  (operation encryption-test (added-strand resp 2)
    (enc "hash" (exp (gen) (mul x y))) (0 1))
  (traces
    ((send (enc (exp (gen) y) (pubk b)))
      (recv (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x y))))))
    ((recv (enc (exp (gen) x) (pubk b-0)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))))
  (label 2)
  (parent 0)
  (unrealized)
  (shape)
  (maps ((0) ((b b) (x y) (y x))))
  (origs))

(comment "Nothing left to do")

(defprotocol tor diffie-hellman
  (defrole init
    (vars (x y expn) (b name) (n text))
    (trace (send (enc (exp (gen) x) (pubk b)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    (pen-non-orig x)
    (uniq-orig n))
  (defrole resp
    (vars (x y expn) (b name) (n text))
    (trace (recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    (pen-non-orig y)))

(defskeleton tor
  (vars (n text) (b name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (non-orig (privk b))
  (pen-non-orig y)
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y))))))
  (label 3)
  (unrealized (0 2))
  (origs)
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (precedes ((1 2) (0 2)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (added-strand init 3)
    (enc n (exp (gen) (mul x y))) (0 2))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y))))))
  (label 4)
  (parent 3)
  (unrealized (1 1))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x y) (y x))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (precedes ((1 2) (0 2)))
  (non-orig (privk b))
  (pen-non-orig x)
  (uniq-orig n)
  (operation encryption-test (added-strand init 3)
    (enc n (exp (gen) (mul x y))) (0 2))
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y))))))
  (label 5)
  (parent 3)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 name) (x expn))
  (defstrand resp 3 (n n) (b b) (x x) (y x))
  (defstrand init 3 (n n) (b b-0) (x x) (y x))
  (precedes ((1 2) (0 2)))
  (non-orig (privk b))
  (pen-non-orig x)
  (uniq-orig n)
  (operation encryption-test (displaced 2 1 init 1) (exp (gen) x-0)
    (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x x)))))
      (recv (enc n (exp (gen) (mul x x)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x x)))))
      (send (enc n (exp (gen) (mul x x))))))
  (label 6)
  (parent 4)
  (unrealized (1 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 expn))
  (defstrand resp 3 (n n) (b b) (x x) (y x-0))
  (defstrand init 3 (n n) (b b-0) (x x) (y x-0))
  (defstrand init 1 (b b-1) (x x-0))
  (precedes ((1 2) (0 2)) ((2 0) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x x-0)
  (uniq-orig n)
  (operation encryption-test (added-strand init 1) (exp (gen) x-0)
    (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0)))))
      (recv (enc n (exp (gen) (mul x x-0)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0)))))
      (send (enc n (exp (gen) (mul x x-0)))))
    ((send (enc (exp (gen) x-0) (pubk b-1)))))
  (label 7)
  (parent 4)
  (unrealized (1 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 name) (y x expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (precedes ((0 1) (1 1)) ((1 2) (0 2)))
  (non-orig (privk b))
  (pen-non-orig y x)
  (uniq-orig n)
  (operation encryption-test (displaced 2 0 resp 2) (exp (gen) y) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y x)))))
      (recv (enc n (exp (gen) (mul y x)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y x)))))
      (send (enc n (exp (gen) (mul y x))))))
  (label 8)
  (parent 4)
  (unrealized)
  (shape)
  (maps ((0) ((b b) (x x) (y y) (n n))))
  (origs (n (1 2))))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (defstrand resp 2 (b b-1) (x x-0) (y y))
  (precedes ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (added-strand resp 2) (exp (gen) y) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    ((recv (enc (exp (gen) x-0) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y)))))))
  (label 9)
  (parent 4)
  (unrealized (1 1))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (deflistener y)
  (precedes ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (added-listener y) (exp (gen) y) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y))))) ((recv y) (send y)))
  (label 10)
  (parent 4)
  (unrealized (2 0))
  (comment "empty cohort"))

(defskeleton tor
  (vars (n text) (b b-0 name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x y) (y x))
  (defstrand init 1 (b b-0) (x x))
  (precedes ((1 0) (0 2)))
  (non-orig (privk b))
  (pen-non-orig x)
  (uniq-orig n)
  (operation generalization deleted (1 1))
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))))
  (label 11)
  (parent 5)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 name) (y expn))
  (defstrand resp 3 (n n) (b b) (x y) (y y))
  (defstrand init 3 (n n) (b b-0) (x y) (y y))
  (precedes ((0 1) (1 1)) ((1 2) (0 2)))
  (non-orig (privk b))
  (pen-non-orig y)
  (uniq-orig n)
  (operation encryption-test (displaced 2 0 resp 2)
    (enc "hash" (exp (gen) (mul y y))) (1 1))
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y y)))))
      (recv (enc n (exp (gen) (mul y y)))))
    ((send (enc (exp (gen) y) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y y)))))
      (send (enc n (exp (gen) (mul y y))))))
  (label 12)
  (parent 6)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (y expn))
  (defstrand resp 3 (n n) (b b) (x y) (y y))
  (defstrand init 3 (n n) (b b-0) (x y) (y y))
  (defstrand resp 2 (b b-1) (x y) (y y))
  (precedes ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig y)
  (uniq-orig n)
  (operation encryption-test (added-strand resp 2)
    (enc "hash" (exp (gen) (mul y y))) (1 1))
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y y)))))
      (recv (enc n (exp (gen) (mul y y)))))
    ((send (enc (exp (gen) y) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y y)))))
      (send (enc n (exp (gen) (mul y y)))))
    ((recv (enc (exp (gen) y) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y y)))))))
  (label 13)
  (parent 6)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 name) (x expn))
  (defstrand resp 3 (n n) (b b) (x x) (y x))
  (defstrand init 3 (n n) (b b-0) (x x) (y x))
  (deflistener (exp (gen) (mul x x)))
  (precedes ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x)
  (uniq-orig n)
  (operation encryption-test (added-listener (exp (gen) (mul x x)))
    (enc "hash" (exp (gen) (mul x x))) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x x)))))
      (recv (enc n (exp (gen) (mul x x)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x x)))))
      (send (enc n (exp (gen) (mul x x)))))
    ((recv (exp (gen) (mul x x))) (send (exp (gen) (mul x x)))))
  (label 14)
  (parent 6)
  (unrealized (2 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (defstrand init 1 (b b-1) (x y))
  (precedes ((0 1) (1 1)) ((1 2) (0 2)) ((2 0) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (displaced 3 0 resp 2)
    (enc "hash" (exp (gen) (mul x y))) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) y) (pubk b-1)))))
  (label 15)
  (parent 7)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 b-2 name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (defstrand init 1 (b b-1) (x y))
  (defstrand resp 2 (b b-2) (x x) (y y))
  (precedes ((1 2) (0 2)) ((2 0) (1 1)) ((3 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (added-strand resp 2)
    (enc "hash" (exp (gen) (mul x y))) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) y) (pubk b-1))))
    ((recv (enc (exp (gen) x) (pubk b-2)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))))
  (label 16)
  (parent 7)
  (seen 20)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 b-2 name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x y) (y x))
  (defstrand init 3 (n n) (b b-0) (x y) (y x))
  (defstrand init 1 (b b-1) (x x))
  (defstrand resp 2 (b b-2) (x x) (y y))
  (precedes ((1 2) (0 2)) ((2 0) (1 1)) ((3 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (added-strand resp 2)
    (enc "hash" (exp (gen) (mul x y))) (1 1))
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) y) (pubk b-0)))
      (recv (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-1))))
    ((recv (enc (exp (gen) x) (pubk b-2)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))))
  (label 17)
  (parent 7)
  (seen 26)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 expn))
  (defstrand resp 3 (n n) (b b) (x x) (y x-0))
  (defstrand init 3 (n n) (b b-0) (x x) (y x-0))
  (defstrand init 1 (b b-1) (x x-0))
  (deflistener (exp (gen) (mul x x-0)))
  (precedes ((1 2) (0 2)) ((2 0) (1 1)) ((3 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x x-0)
  (uniq-orig n)
  (operation encryption-test (added-listener (exp (gen) (mul x x-0)))
    (enc "hash" (exp (gen) (mul x x-0))) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0)))))
      (recv (enc n (exp (gen) (mul x x-0)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0)))))
      (send (enc n (exp (gen) (mul x x-0)))))
    ((send (enc (exp (gen) x-0) (pubk b-1))))
    ((recv (exp (gen) (mul x x-0))) (send (exp (gen) (mul x x-0)))))
  (label 18)
  (parent 7)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 y expn))
  (defstrand resp 3 (n n) (b b) (x x-0) (y y))
  (defstrand init 3 (n n) (b b-0) (x x-0) (y y))
  (defstrand resp 2 (b b-1) (x x) (y y))
  (precedes ((0 1) (1 1)) ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x-0 y)
  (uniq-orig n)
  (operation encryption-test (displaced 3 0 resp 2)
    (enc "hash" (exp (gen) (mul x-0 y))) (1 1))
  (traces
    ((recv (enc (exp (gen) x-0) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y)))))
      (recv (enc n (exp (gen) (mul x-0 y)))))
    ((send (enc (exp (gen) x-0) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y)))))
      (send (enc n (exp (gen) (mul x-0 y)))))
    ((recv (enc (exp (gen) x) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))))
  (label 19)
  (parent 9)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (y x expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (defstrand resp 2 (b b-1) (x x) (y y))
  (precedes ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig y x)
  (uniq-orig n)
  (operation encryption-test (displaced 3 2 resp 2)
    (enc "hash" (exp (gen) (mul x-0 y))) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y x)))))
      (recv (enc n (exp (gen) (mul y x)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y x)))))
      (send (enc n (exp (gen) (mul y x)))))
    ((recv (enc (exp (gen) x) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y x)))))))
  (label 20)
  (parent 9)
  (unrealized)
  (shape)
  (maps ((0) ((b b) (x x) (y y) (n n))))
  (origs (n (1 2))))

(defskeleton tor
  (vars (n text) (b b-0 b-1 b-2 name) (x x-0 y expn))
  (defstrand resp 3 (n n) (b b) (x x-0) (y y))
  (defstrand init 3 (n n) (b b-0) (x x-0) (y y))
  (defstrand resp 2 (b b-1) (x x) (y y))
  (defstrand resp 2 (b b-2) (x x-0) (y y))
  (precedes ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x-0 y)
  (uniq-orig n)
  (operation encryption-test (added-strand resp 2)
    (enc "hash" (exp (gen) (mul x-0 y))) (1 1))
  (traces
    ((recv (enc (exp (gen) x-0) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y)))))
      (recv (enc n (exp (gen) (mul x-0 y)))))
    ((send (enc (exp (gen) x-0) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y)))))
      (send (enc n (exp (gen) (mul x-0 y)))))
    ((recv (enc (exp (gen) x) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y))))))
    ((recv (enc (exp (gen) x-0) (pubk b-2)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y)))))))
  (label 21)
  (parent 9)
  (seen 20)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 b-2 name) (x x-0 y expn))
  (defstrand resp 3 (n n) (b b) (x y) (y x-0))
  (defstrand init 3 (n n) (b b-0) (x y) (y x-0))
  (defstrand resp 2 (b b-1) (x x) (y x-0))
  (defstrand resp 2 (b b-2) (x x-0) (y y))
  (precedes ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x-0 y)
  (uniq-orig n)
  (operation encryption-test (added-strand resp 2)
    (enc "hash" (exp (gen) (mul x-0 y))) (1 1))
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x-0 y)))))
      (recv (enc n (exp (gen) (mul x-0 y)))))
    ((send (enc (exp (gen) y) (pubk b-0)))
      (recv (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x-0 y)))))
      (send (enc n (exp (gen) (mul x-0 y)))))
    ((recv (enc (exp (gen) x) (pubk b-1)))
      (send (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0))))))
    ((recv (enc (exp (gen) x-0) (pubk b-2)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y)))))))
  (label 22)
  (parent 9)
  (seen 26)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (defstrand resp 2 (b b-1) (x x-0) (y y))
  (deflistener (exp (gen) (mul x y)))
  (precedes ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (added-listener (exp (gen) (mul x y)))
    (enc "hash" (exp (gen) (mul x y))) (1 1))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    ((recv (enc (exp (gen) x-0) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y))))))
    ((recv (exp (gen) (mul x y))) (send (exp (gen) (mul x y)))))
  (label 23)
  (parent 9)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 name) (x y expn))
  (defstrand resp 3 (n n) (b b) (x y) (y x))
  (defstrand init 1 (b b-0) (x x))
  (precedes ((1 0) (0 2)))
  (non-orig (privk b))
  (pen-non-orig x)
  (operation generalization forgot n)
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))))
  (label 24)
  (parent 11)
  (unrealized)
  (shape)
  (maps ((0) ((b b) (x y) (y x) (n n))))
  (origs))

(defskeleton tor
  (vars (n text) (b b-0 name) (y y-0 expn))
  (defstrand resp 3 (n n) (b b) (x y) (y y-0))
  (defstrand init 3 (n n) (b b-0) (x y-0) (y y))
  (precedes ((0 1) (1 1)) ((1 2) (0 2)))
  (non-orig (privk b))
  (pen-non-orig y y-0)
  (uniq-orig n)
  (operation generalization separated y-0)
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) y-0) (enc "hash" (exp (gen) (mul y y-0)))))
      (recv (enc n (exp (gen) (mul y y-0)))))
    ((send (enc (exp (gen) y-0) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y y-0)))))
      (send (enc n (exp (gen) (mul y y-0))))))
  (label 25)
  (parent 12)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (y y-0 expn))
  (defstrand resp 3 (n n) (b b) (x y) (y y-0))
  (defstrand init 3 (n n) (b b-0) (x y) (y y-0))
  (defstrand resp 2 (b b-1) (x y-0) (y y))
  (precedes ((1 2) (0 2)) ((2 1) (1 1)))
  (non-orig (privk b))
  (pen-non-orig y y-0)
  (uniq-orig n)
  (operation generalization separated y-0)
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) y-0) (enc "hash" (exp (gen) (mul y y-0)))))
      (recv (enc n (exp (gen) (mul y y-0)))))
    ((send (enc (exp (gen) y) (pubk b-0)))
      (recv (cat (exp (gen) y-0) (enc "hash" (exp (gen) (mul y y-0)))))
      (send (enc n (exp (gen) (mul y y-0)))))
    ((recv (enc (exp (gen) y-0) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y y-0)))))))
  (label 26)
  (parent 13)
  (unrealized)
  (shape)
  (maps ((0) ((b b) (x y) (y y-0) (n n))))
  (origs (n (1 2))))

(defskeleton tor
  (vars (n text) (b b-0 name) (x expn))
  (defstrand resp 3 (n n) (b b) (x x) (y x))
  (defstrand init 3 (n n) (b b-0) (x x) (y x))
  (deflistener (exp (gen) (mul x x)))
  (deflistener x)
  (precedes ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (2 0)))
  (non-orig (privk b))
  (pen-non-orig x)
  (uniq-orig n)
  (operation encryption-test (added-listener x) (exp (gen) (mul x x))
    (2 0))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x x)))))
      (recv (enc n (exp (gen) (mul x x)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) x) (enc "hash" (exp (gen) (mul x x)))))
      (send (enc n (exp (gen) (mul x x)))))
    ((recv (exp (gen) (mul x x))) (send (exp (gen) (mul x x))))
    ((recv x) (send x)))
  (label 27)
  (parent 14)
  (unrealized (2 0) (3 0))
  (comment "empty cohort"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 expn))
  (defstrand resp 3 (n n) (b b) (x x) (y x-0))
  (defstrand init 3 (n n) (b b-0) (x x) (y x-0))
  (defstrand init 1 (b b-1) (x x-0))
  (deflistener (exp (gen) (mul x x-0)))
  (deflistener x)
  (precedes ((1 2) (0 2)) ((2 0) (1 1)) ((3 1) (1 1)) ((4 1) (3 0)))
  (non-orig (privk b))
  (pen-non-orig x x-0)
  (uniq-orig n)
  (operation encryption-test (added-listener x) (exp (gen) (mul x x-0))
    (3 0))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0)))))
      (recv (enc n (exp (gen) (mul x x-0)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0)))))
      (send (enc n (exp (gen) (mul x x-0)))))
    ((send (enc (exp (gen) x-0) (pubk b-1))))
    ((recv (exp (gen) (mul x x-0))) (send (exp (gen) (mul x x-0))))
    ((recv x) (send x)))
  (label 28)
  (parent 18)
  (unrealized (3 0) (4 0))
  (comment "empty cohort"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 expn))
  (defstrand resp 3 (n n) (b b) (x x) (y x-0))
  (defstrand init 3 (n n) (b b-0) (x x) (y x-0))
  (defstrand init 1 (b b-1) (x x-0))
  (deflistener (exp (gen) (mul x x-0)))
  (deflistener x-0)
  (precedes ((1 2) (0 2)) ((2 0) (1 1)) ((3 1) (1 1)) ((4 1) (3 0)))
  (non-orig (privk b))
  (pen-non-orig x x-0)
  (uniq-orig n)
  (operation encryption-test (added-listener x-0)
    (exp (gen) (mul x x-0)) (3 0))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0)))))
      (recv (enc n (exp (gen) (mul x x-0)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) x-0) (enc "hash" (exp (gen) (mul x x-0)))))
      (send (enc n (exp (gen) (mul x x-0)))))
    ((send (enc (exp (gen) x-0) (pubk b-1))))
    ((recv (exp (gen) (mul x x-0))) (send (exp (gen) (mul x x-0))))
    ((recv x-0) (send x-0)))
  (label 29)
  (parent 18)
  (unrealized (3 0) (4 0))
  (comment "empty cohort"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (defstrand resp 2 (b b-1) (x x-0) (y y))
  (deflistener (exp (gen) (mul x y)))
  (deflistener x)
  (precedes ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1)) ((4 1) (3 0)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (added-listener x) (exp (gen) (mul x y))
    (3 0))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    ((recv (enc (exp (gen) x-0) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y))))))
    ((recv (exp (gen) (mul x y))) (send (exp (gen) (mul x y))))
    ((recv x) (send x)))
  (label 30)
  (parent 23)
  (unrealized (1 1) (3 0) (4 0))
  (comment "empty cohort"))

(defskeleton tor
  (vars (n text) (b b-0 b-1 name) (x x-0 y expn))
  (defstrand resp 3 (n n) (b b) (x x) (y y))
  (defstrand init 3 (n n) (b b-0) (x x) (y y))
  (defstrand resp 2 (b b-1) (x x-0) (y y))
  (deflistener (exp (gen) (mul x y)))
  (deflistener y)
  (precedes ((1 2) (0 2)) ((2 1) (1 1)) ((3 1) (1 1)) ((4 1) (3 0)))
  (non-orig (privk b))
  (pen-non-orig x y)
  (uniq-orig n)
  (operation encryption-test (added-listener y) (exp (gen) (mul x y))
    (3 0))
  (traces
    ((recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    ((send (enc (exp (gen) x) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    ((recv (enc (exp (gen) x-0) (pubk b-1)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x-0 y))))))
    ((recv (exp (gen) (mul x y))) (send (exp (gen) (mul x y))))
    ((recv y) (send y)))
  (label 31)
  (parent 23)
  (unrealized (3 0) (4 0))
  (comment "empty cohort"))

(defskeleton tor
  (vars (n text) (b b-0 name) (y y-0 expn))
  (defstrand resp 3 (n n) (b b) (x y) (y y-0))
  (defstrand init 3 (n n) (b b-0) (x y-0) (y y))
  (precedes ((0 1) (1 1)) ((1 2) (0 2)))
  (non-orig (privk b))
  (pen-non-orig y-0)
  (uniq-orig n)
  (operation generalization forgot y)
  (traces
    ((recv (enc (exp (gen) y) (pubk b)))
      (send (cat (exp (gen) y-0) (enc "hash" (exp (gen) (mul y y-0)))))
      (recv (enc n (exp (gen) (mul y y-0)))))
    ((send (enc (exp (gen) y-0) (pubk b-0)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul y y-0)))))
      (send (enc n (exp (gen) (mul y y-0))))))
  (label 32)
  (parent 25)
  (seen 11)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Nothing left to do")

(defprotocol tor diffie-hellman
  (defrole init
    (vars (x y expn) (b name) (n text))
    (trace (send (enc (exp (gen) x) (pubk b)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y)))))
    (pen-non-orig x)
    (uniq-orig n))
  (defrole resp
    (vars (x y expn) (b name) (n text))
    (trace (recv (enc (exp (gen) x) (pubk b)))
      (send (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (recv (enc n (exp (gen) (mul x y)))))
    (pen-non-orig y)))

(defskeleton tor
  (vars (n text) (b name) (x y expn))
  (defstrand init 3 (n n) (b b) (x x) (y y))
  (deflistener n)
  (non-orig (privk b))
  (pen-non-orig x)
  (uniq-orig n)
  (traces
    ((send (enc (exp (gen) x) (pubk b)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y))))) ((recv n) (send n)))
  (label 33)
  (unrealized (0 1) (1 0))
  (preskeleton)
  (comment "Not a skeleton"))

(defskeleton tor
  (vars (n text) (b name) (x y expn))
  (defstrand init 3 (n n) (b b) (x x) (y y))
  (deflistener n)
  (precedes ((0 2) (1 0)))
  (non-orig (privk b))
  (pen-non-orig x)
  (uniq-orig n)
  (traces
    ((send (enc (exp (gen) x) (pubk b)))
      (recv (cat (exp (gen) y) (enc "hash" (exp (gen) (mul x y)))))
      (send (enc n (exp (gen) (mul x y))))) ((recv n) (send n)))
  (label 34)
  (parent 33)
  (unrealized (0 1) (1 0))
  (origs (n (0 2)))
  (comment "empty cohort"))

(comment "Nothing left to do")
