(herald "Yahalom Protocol Without Forwarding" (bound 15))

(comment "CPSA 4.3.0")
(comment "All input read from tst/chan-yahalom.scm")
(comment "Strand count bounded at 15")

(defprotocol yahalom basic
  (defrole init
    (vars (a b name) (n-a n-b text) (k skey) (ch chan))
    (trace (send (cat a n-a)) (recv ch (cat a b k n-a n-b))
      (send (enc n-b k))))
  (defrole resp
    (vars (b a name) (n-a n-b text) (k skey) (ch1 ch2 chan))
    (trace (recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k))))
  (defrole serv
    (vars (a b name) (n-a n-b text) (k skey) (ch1 ch2 ch3 chan))
    (trace (recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b))
      (send ch2 (cat a b k)))
    (uniq-orig k)
    (conf ch2 ch3)
    (auth ch2))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k skey) (ch1 ch2 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (uniq-orig n-b)
  (conf ch1)
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k))))
  (label 0)
  (unrealized (0 3))
  (origs (n-b (0 1)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 skey) (ch1 ch2 ch3 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch3 ch3))
  (precedes ((0 1) (1 0)) ((1 1) (0 3)))
  (uniq-orig n-b k-0)
  (conf ch1 ch3)
  (operation nonce-test (added-strand serv 2) n-b (0 3)
    (ch-msg ch1 (cat a b n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k-0 n-a n-b))))
  (label 1)
  (parent 0)
  (unrealized (0 3))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 skey) (ch1 ch2 ch3 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch3 ch3))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch ch3))
  (precedes ((0 1) (1 0)) ((1 1) (2 1)) ((2 2) (0 3)))
  (uniq-orig n-b k-0)
  (conf ch1 ch3)
  (operation nonce-test (added-strand init 3) n-b (0 3)
    (ch-msg ch1 (cat a b n-a n-b)) (ch-msg ch3 (cat a b k-0 n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k-0 n-a n-b)))
    ((send (cat a n-a)) (recv ch3 (cat a b k-0 n-a n-b))
      (send (enc n-b k-0))))
  (label 2)
  (parent 1)
  (unrealized (0 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k skey) (ch1 ch2 ch3 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch1 ch1)
    (ch3 ch3))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch ch3))
  (precedes ((0 1) (1 0)) ((1 1) (0 2)) ((1 1) (2 1)) ((2 2) (0 3)))
  (uniq-orig n-b k)
  (conf ch1 ch3)
  (operation nonce-test (contracted (k-0 k)) n-b (0 3) (enc n-b k)
    (ch-msg ch1 (cat a b n-a n-b)) (ch-msg ch3 (cat a b k n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b)))
    ((send (cat a n-a)) (recv ch3 (cat a b k n-a n-b))
      (send (enc n-b k))))
  (label 3)
  (parent 2)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 k-1 skey)
    (ch1 ch2 ch3 ch3-0 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch3 ch3))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch ch3))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-1) (ch1 ch1)
    (ch3 ch3-0))
  (precedes ((0 1) (1 0)) ((0 1) (3 0)) ((1 1) (2 1)) ((2 2) (0 3))
    ((3 1) (0 3)))
  (uniq-orig n-b k-0 k-1)
  (conf ch1 ch3 ch3-0)
  (operation nonce-test (added-strand serv 2) n-b (0 3) (enc n-b k-0)
    (ch-msg ch1 (cat a b n-a n-b)) (ch-msg ch3 (cat a b k-0 n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k-0 n-a n-b)))
    ((send (cat a n-a)) (recv ch3 (cat a b k-0 n-a n-b))
      (send (enc n-b k-0)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3-0 (cat a b k-1 n-a n-b))))
  (label 4)
  (parent 2)
  (unrealized (0 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 skey) (ch1 ch2 ch3 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch3 ch3))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch ch3))
  (deflistener k-0)
  (precedes ((0 1) (1 0)) ((1 1) (2 1)) ((1 1) (3 0)) ((2 2) (0 3))
    ((3 1) (0 3)))
  (uniq-orig n-b k-0)
  (conf ch1 ch3)
  (operation nonce-test (added-listener k-0) n-b (0 3) (enc n-b k-0)
    (ch-msg ch1 (cat a b n-a n-b)) (ch-msg ch3 (cat a b k-0 n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k-0 n-a n-b)))
    ((send (cat a n-a)) (recv ch3 (cat a b k-0 n-a n-b))
      (send (enc n-b k-0))) ((recv k-0) (send k-0)))
  (label 5)
  (parent 2)
  (unrealized (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k skey) (ch2 ch3 ch1 ch2-0 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch ch3))
  (defstrand serv 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch1 ch1)
    (ch2 ch2-0) (ch3 ch3))
  (precedes ((0 1) (2 0)) ((1 2) (0 3)) ((2 1) (1 1)) ((2 2) (0 2)))
  (uniq-orig n-b k)
  (conf ch3 ch1 ch2-0)
  (auth ch2-0)
  (operation nonce-test (displaced 1 3 serv 3) k (0 2)
    (ch-msg ch3 (cat a b k n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((send (cat a n-a)) (recv ch3 (cat a b k n-a n-b))
      (send (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b))
      (send ch2-0 (cat a b k))))
  (label 6)
  (parent 3)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 skey) (ch1 ch2 ch3 ch3-0 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch1 ch1)
    (ch3 ch3))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch ch3))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch3 ch3-0))
  (precedes ((0 1) (1 0)) ((0 1) (3 0)) ((1 1) (0 2)) ((1 1) (2 1))
    ((2 2) (0 3)) ((3 1) (0 3)))
  (uniq-orig n-b k k-0)
  (conf ch1 ch3 ch3-0)
  (operation nonce-test (contracted (k-1 k)) n-b (0 3) (enc n-b k)
    (ch-msg ch1 (cat a b n-a n-b)) (ch-msg ch3 (cat a b k n-a n-b))
    (ch-msg ch3-0 (cat a b k-0 n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b)))
    ((send (cat a n-a)) (recv ch3 (cat a b k n-a n-b))
      (send (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3-0 (cat a b k-0 n-a n-b))))
  (label 7)
  (parent 4)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 k-1 skey)
    (ch1 ch2 ch3 ch3-0 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch3 ch3))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch ch3))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-1) (ch1 ch1)
    (ch3 ch3-0))
  (deflistener k-0)
  (precedes ((0 1) (1 0)) ((0 1) (3 0)) ((1 1) (2 1)) ((1 1) (4 0))
    ((2 2) (0 3)) ((3 1) (0 3)) ((4 1) (0 3)))
  (uniq-orig n-b k-0 k-1)
  (conf ch1 ch3 ch3-0)
  (operation nonce-test (added-listener k-0) n-b (0 3) (enc n-b k-0)
    (ch-msg ch1 (cat a b n-a n-b)) (ch-msg ch3 (cat a b k-0 n-a n-b))
    (ch-msg ch3-0 (cat a b k-1 n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k-0 n-a n-b)))
    ((send (cat a n-a)) (recv ch3 (cat a b k-0 n-a n-b))
      (send (enc n-b k-0)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3-0 (cat a b k-1 n-a n-b)))
    ((recv k-0) (send k-0)))
  (label 8)
  (parent 4)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 skey) (ch2 ch3 ch1 ch2-0 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch ch3))
  (deflistener k-0)
  (defstrand serv 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch2 ch2-0) (ch3 ch3))
  (precedes ((0 1) (3 0)) ((1 2) (0 3)) ((2 1) (0 3)) ((3 1) (1 1))
    ((3 2) (2 0)))
  (uniq-orig n-b k-0)
  (conf ch3 ch1 ch2-0)
  (auth ch2-0)
  (operation nonce-test (displaced 1 4 serv 3) k-0 (3 0)
    (ch-msg ch3 (cat a b k-0 n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((send (cat a n-a)) (recv ch3 (cat a b k-0 n-a n-b))
      (send (enc n-b k-0))) ((recv k-0) (send k-0))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k-0 n-a n-b))
      (send ch2-0 (cat a b k-0))))
  (label 9)
  (parent 5)
  (unrealized (2 0))
  (dead)
  (comment "empty cohort"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k skey) (ch3 ch1 ch2 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch ch3))
  (defstrand serv 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch1 ch1)
    (ch2 ch2) (ch3 ch3))
  (precedes ((0 1) (2 0)) ((1 2) (0 3)) ((2 1) (1 1)) ((2 2) (0 2)))
  (uniq-orig n-b k)
  (conf ch3 ch1 ch2)
  (auth ch2)
  (operation nonce-test (contracted (ch2-0 ch2)) k (0 2)
    (ch-msg ch3 (cat a b k n-a n-b)) (ch-msg ch2 (cat a b k)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((send (cat a n-a)) (recv ch3 (cat a b k n-a n-b))
      (send (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b))
      (send ch2 (cat a b k))))
  (label 10)
  (parent 6)
  (unrealized)
  (shape)
  (maps
    ((0) ((a a) (b b) (n-b n-b) (ch1 ch1) (ch2 ch2) (n-a n-a) (k k))))
  (origs (k (2 1)) (n-b (0 1))))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 skey)
    (ch2 ch3 ch3-0 ch1 ch2-0 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch ch3))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch3 ch3-0))
  (defstrand serv 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch1 ch1)
    (ch2 ch2-0) (ch3 ch3))
  (precedes ((0 1) (2 0)) ((0 1) (3 0)) ((1 2) (0 3)) ((2 1) (0 3))
    ((3 1) (1 1)) ((3 2) (0 2)))
  (uniq-orig n-b k k-0)
  (conf ch3 ch3-0 ch1 ch2-0)
  (auth ch2-0)
  (operation nonce-test (displaced 1 4 serv 3) k (0 2)
    (ch-msg ch3 (cat a b k n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((send (cat a n-a)) (recv ch3 (cat a b k n-a n-b))
      (send (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3-0 (cat a b k-0 n-a n-b)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b))
      (send ch2-0 (cat a b k))))
  (label 11)
  (parent 7)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 k-1 skey)
    (ch2 ch3 ch3-0 ch1 ch2-0 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch ch3))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-1) (ch1 ch1)
    (ch3 ch3-0))
  (deflistener k-0)
  (defstrand serv 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch2 ch2-0) (ch3 ch3))
  (precedes ((0 1) (2 0)) ((0 1) (4 0)) ((1 2) (0 3)) ((2 1) (0 3))
    ((3 1) (0 3)) ((4 1) (1 1)) ((4 2) (3 0)))
  (uniq-orig n-b k-0 k-1)
  (conf ch3 ch3-0 ch1 ch2-0)
  (auth ch2-0)
  (operation nonce-test (displaced 1 5 serv 3) k-0 (4 0)
    (ch-msg ch3 (cat a b k-0 n-a n-b)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((send (cat a n-a)) (recv ch3 (cat a b k-0 n-a n-b))
      (send (enc n-b k-0)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3-0 (cat a b k-1 n-a n-b)))
    ((recv k-0) (send k-0))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k-0 n-a n-b))
      (send ch2-0 (cat a b k-0))))
  (label 12)
  (parent 8)
  (unrealized (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k k-0 skey) (ch3 ch3-0 ch1 ch2 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch ch3))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k-0) (ch1 ch1)
    (ch3 ch3-0))
  (defstrand serv 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch1 ch1)
    (ch2 ch2) (ch3 ch3))
  (precedes ((0 1) (2 0)) ((0 1) (3 0)) ((1 2) (0 3)) ((2 1) (0 3))
    ((3 1) (1 1)) ((3 2) (0 2)))
  (uniq-orig n-b k k-0)
  (conf ch3 ch3-0 ch1 ch2)
  (auth ch2)
  (operation nonce-test (contracted (ch2-0 ch2)) k (0 2)
    (ch-msg ch3 (cat a b k n-a n-b)) (ch-msg ch2 (cat a b k)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k)))
    ((send (cat a n-a)) (recv ch3 (cat a b k n-a n-b))
      (send (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3-0 (cat a b k-0 n-a n-b)))
    ((recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b))
      (send ch2 (cat a b k))))
  (label 13)
  (parent 11)
  (seen 10)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Nothing left to do")

(defprotocol yahalom basic
  (defrole init
    (vars (a b name) (n-a n-b text) (k skey) (ch chan))
    (trace (send (cat a n-a)) (recv ch (cat a b k n-a n-b))
      (send (enc n-b k))))
  (defrole resp
    (vars (b a name) (n-a n-b text) (k skey) (ch1 ch2 chan))
    (trace (recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k))))
  (defrole serv
    (vars (a b name) (n-a n-b text) (k skey) (ch1 ch2 ch3 chan))
    (trace (recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b))
      (send ch2 (cat a b k)))
    (uniq-orig k)
    (conf ch2 ch3)
    (auth ch2))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton yahalom
  (vars (n-b n-a text) (a b name) (k skey) (ch1 ch2 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (deflistener k)
  (uniq-orig n-b)
  (conf ch1 ch2)
  (auth ch2)
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k))) ((recv k) (send k)))
  (label 14)
  (unrealized (0 2) (0 3))
  (origs (n-b (0 1)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a n-a-0 n-b-0 text) (a b name) (k skey)
    (ch1 ch2 ch1-0 ch3 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (deflistener k)
  (defstrand serv 3 (n-a n-a-0) (n-b n-b-0) (a a) (b b) (k k)
    (ch1 ch1-0) (ch2 ch2) (ch3 ch3))
  (precedes ((2 1) (1 0)) ((2 2) (0 2)))
  (uniq-orig n-b k)
  (conf ch1 ch2 ch3)
  (auth ch2)
  (operation channel-test (added-strand serv 3) (ch-msg ch2 (cat a b k))
    (0 2))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k))) ((recv k) (send k))
    ((recv ch1-0 (cat a b n-a-0 n-b-0))
      (send ch3 (cat a b k n-a-0 n-b-0)) (send ch2 (cat a b k))))
  (label 15)
  (parent 14)
  (unrealized (0 3) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-b n-a n-a-0 n-b-0 text) (a b name) (k skey)
    (ch1 ch2 ch1-0 ch3 chan))
  (defstrand resp 4 (n-a n-a) (n-b n-b) (b b) (a a) (k k) (ch1 ch1)
    (ch2 ch2))
  (deflistener k)
  (defstrand serv 3 (n-a n-a-0) (n-b n-b-0) (a a) (b b) (k k)
    (ch1 ch1-0) (ch2 ch2) (ch3 ch3))
  (precedes ((2 2) (0 2)) ((2 2) (1 0)))
  (uniq-orig n-b k)
  (conf ch1 ch2 ch3)
  (auth ch2)
  (operation nonce-test (displaced 3 2 serv 3) k (1 0)
    (ch-msg ch3 (cat a b k n-a-0 n-b-0)))
  (traces
    ((recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k))) ((recv k) (send k))
    ((recv ch1-0 (cat a b n-a-0 n-b-0))
      (send ch3 (cat a b k n-a-0 n-b-0)) (send ch2 (cat a b k))))
  (label 16)
  (parent 15)
  (unrealized (0 3) (1 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol yahalom basic
  (defrole init
    (vars (a b name) (n-a n-b text) (k skey) (ch chan))
    (trace (send (cat a n-a)) (recv ch (cat a b k n-a n-b))
      (send (enc n-b k))))
  (defrole resp
    (vars (b a name) (n-a n-b text) (k skey) (ch1 ch2 chan))
    (trace (recv (cat a n-a)) (send ch1 (cat a b n-a n-b))
      (recv ch2 (cat a b k)) (recv (enc n-b k))))
  (defrole serv
    (vars (a b name) (n-a n-b text) (k skey) (ch1 ch2 ch3 chan))
    (trace (recv ch1 (cat a b n-a n-b)) (send ch3 (cat a b k n-a n-b))
      (send ch2 (cat a b k)))
    (uniq-orig k)
    (conf ch2 ch3)
    (auth ch2))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton yahalom
  (vars (n-a n-b text) (a b name) (k skey) (ch chan))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch ch))
  (conf ch)
  (auth ch)
  (traces
    ((send (cat a n-a)) (recv ch (cat a b k n-a n-b))
      (send (enc n-b k))))
  (label 17)
  (unrealized (0 1))
  (origs)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton yahalom
  (vars (n-a n-b text) (a b name) (k skey) (ch ch1 chan))
  (defstrand init 3 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch ch))
  (defstrand serv 2 (n-a n-a) (n-b n-b) (a a) (b b) (k k) (ch1 ch1)
    (ch3 ch))
  (precedes ((1 1) (0 1)))
  (uniq-orig k)
  (conf ch)
  (auth ch)
  (operation channel-test (added-strand serv 2)
    (ch-msg ch (cat a b k n-a n-b)) (0 1))
  (traces
    ((send (cat a n-a)) (recv ch (cat a b k n-a n-b))
      (send (enc n-b k)))
    ((recv ch1 (cat a b n-a n-b)) (send ch (cat a b k n-a n-b))))
  (label 18)
  (parent 17)
  (unrealized)
  (shape)
  (maps ((0) ((ch ch) (a a) (b b) (n-a n-a) (n-b n-b) (k k))))
  (origs (k (1 1))))

(comment "Nothing left to do")
