(herald "Example 1.3 from 1983 Dolev-Yao Paper" (bound 12))

(comment "CPSA 4.3.0")
(comment "All input read from tst/dy.lsp")
(comment "Strand count bounded at 12")

(defprotocol dy basic
  (defrole init
    (vars (a b name) (m text))
    (trace (send (enc (enc m (pubk b)) a (pubk b)))
      (recv (enc (enc m (pubk a)) b (pubk a)))))
  (defrole resp
    (vars (a b name) (m mesg))
    (trace (recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton dy
  (vars (m text) (a b name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (traces ((send (enc (enc m (pubk b)) a (pubk b))))
    ((recv m) (send m)))
  (label 0)
  (unrealized (1 0))
  (preskeleton)
  (origs (m (0 0)))
  (comment "Not a skeleton"))

(defskeleton dy
  (vars (m text) (a b name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (precedes ((0 0) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (traces ((send (enc (enc m (pubk b)) a (pubk b))))
    ((recv m) (send m)))
  (label 1)
  (parent 0)
  (unrealized (1 0))
  (origs (m (0 0)))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (precedes ((0 0) (2 0)) ((2 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0)))))
  (label 2)
  (parent 1)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((2 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 3)
  (parent 1)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 4)
  (parent 2)
  (seen 5)
  (unrealized (3 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0)))))
  (label 5)
  (parent 3)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0)))))
  (label 6)
  (parent 3)
  (unrealized (1 0) (3 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((2 1) (3 0)) ((3 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 4 2 resp 2) m (3 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 7)
  (parent 4)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (m m))))
  (origs (m (0 0))))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 8)
  (parent 4)
  (seen 7)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 9)
  (parent 4)
  (seen 5)
  (unrealized (3 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1)))))
  (label 10)
  (parent 5)
  (seen 12 13)
  (unrealized (1 0) (4 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 11)
  (parent 5)
  (seen 5)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1)))))
  (label 12)
  (parent 6)
  (seen 13)
  (unrealized (1 0) (3 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-0 b)) m (3 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a)))))
  (label 13)
  (parent 6)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (precedes ((0 0) (2 0)) ((2 1) (3 0)) ((3 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 4 2 resp 2) m (3 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0)))))
  (label 14)
  (parent 6)
  (seen 20)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 15)
  (parent 6)
  (seen 21)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 5 2 resp 2) m (3 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 16)
  (parent 9)
  (seen 7)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 17)
  (parent 9)
  (seen 16)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 18)
  (parent 9)
  (unrealized (3 0) (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 19)
  (parent 10)
  (seen 13)
  (unrealized (1 0) (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((3 1) (1 0))
    ((4 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 5 2 resp 2) m (4 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1)))))
  (label 20)
  (parent 10)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 21)
  (parent 10)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 5 2 resp 2) m (3 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1)))))
  (label 22)
  (parent 12)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 23)
  (parent 12)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0)))))
  (label 24)
  (parent 13)
  (seen 13)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 25)
  (parent 14)
  (unrealized (4 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 26)
  (parent 15)
  (seen 46 48)
  (unrealized (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (5 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 27)
  (parent 18)
  (unrealized (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 28)
  (parent 18)
  (seen 52)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 29)
  (parent 18)
  (seen 28)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 30)
  (parent 18)
  (unrealized (3 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 31)
  (parent 18)
  (unrealized (3 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 32)
  (parent 19)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 33)
  (parent 19)
  (seen 42)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 34)
  (parent 20)
  (seen 21)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 35)
  (parent 20)
  (seen 13 45)
  (unrealized (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 36)
  (parent 21)
  (seen 21)
  (unrealized (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 37)
  (parent 21)
  (seen 49 80)
  (unrealized (6 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 38)
  (parent 22)
  (seen 41)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 39)
  (parent 22)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 40)
  (parent 23)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 41)
  (parent 23)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 42)
  (parent 23)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (5 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 43)
  (parent 23)
  (seen 22)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 44)
  (parent 23)
  (seen 41)
  (unrealized (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 45)
  (parent 25)
  (unrealized (4 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-0 b) (a-1 b)) m (4 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 46)
  (parent 25)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((2 1) (3 0)) ((2 1) (4 0)) ((3 1) (1 0))
    ((4 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 5 2 resp 2) m (4 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 47)
  (parent 25)
  (seen 102)
  (unrealized (4 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 48)
  (parent 25)
  (seen 46)
  (unrealized (4 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 49)
  (parent 26)
  (seen 109)
  (unrealized (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 50)
  (parent 26)
  (seen 113)
  (unrealized (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 51)
  (parent 26)
  (seen 46)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 52)
  (parent 27)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (5 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 53)
  (parent 27)
  (seen 16)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 54)
  (parent 27)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 55)
  (parent 29)
  (seen 53)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 56)
  (parent 29)
  (seen 125)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 57)
  (parent 30)
  (seen 16)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1)))))
  (label 58)
  (parent 30)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 59)
  (parent 30)
  (seen 57)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (3 0)
    (enc m (pubk a-2)) (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 60)
  (parent 30)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 61)
  (parent 30)
  (seen 60)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 62)
  (parent 31)
  (seen 57)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 63)
  (parent 31)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 64)
  (parent 31)
  (seen 62)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 6 resp 2) m (3 0)
    (enc m (pubk a-2)) (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 65)
  (parent 31)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 66)
  (parent 31)
  (seen 65 139)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 67)
  (parent 32)
  (seen 70 86)
  (unrealized (6 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 68)
  (parent 32)
  (seen 91)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 69)
  (parent 33)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 70)
  (parent 33)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 71)
  (parent 33)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 72)
  (parent 33)
  (seen 32)
  (unrealized (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 73)
  (parent 33)
  (seen 70 99)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((3 1) (5 0))
    ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 3 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 74)
  (parent 34)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 75)
  (parent 34)
  (seen 74)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 76)
  (parent 34)
  (seen 30)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 77)
  (parent 34)
  (seen 13 21 31)
  (unrealized (5 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 78)
  (parent 35)
  (unrealized (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 79)
  (parent 35)
  (seen 102 172)
  (unrealized (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 80)
  (parent 35)
  (seen 13 109)
  (unrealized (5 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 81)
  (parent 37)
  (seen 178)
  (unrealized (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b) (a-2 b)) m (6 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 82)
  (parent 37)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((5 1) (6 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 83)
  (parent 37)
  (seen 113 182)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 84)
  (parent 37)
  (seen 82 119)
  (unrealized (6 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 85)
  (parent 38)
  (seen 163)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 86)
  (parent 38)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 87)
  (parent 38)
  (unrealized (5 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 88)
  (parent 38)
  (seen 41)
  (unrealized (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 89)
  (parent 39)
  (unrealized (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b) (a-2 b)) m (5 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 90)
  (parent 39)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 91)
  (parent 39)
  (unrealized (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 92)
  (parent 39)
  (seen 201 205)
  (unrealized (5 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 93)
  (parent 39)
  (seen 90)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (4 0)) ((4 1) (2 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 94)
  (parent 40)
  (seen 7)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 95)
  (parent 41)
  (seen 41)
  (unrealized (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 96)
  (parent 41)
  (seen 90 93)
  (unrealized (6 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 1) (2 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 97)
  (parent 42)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 98)
  (parent 44)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 99)
  (parent 44)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 100)
  (parent 44)
  (unrealized (5 0) (7 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 101)
  (parent 45)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 102)
  (parent 45)
  (unrealized (4 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 103)
  (parent 45)
  (seen 109)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0)))))
  (label 104)
  (parent 46)
  (seen 46)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((2 1) (3 0)) ((2 1) (4 0)) ((3 1) (1 0))
    ((4 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b)) m (4 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 105)
  (parent 47)
  (seen 174)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((2 1) (3 0)) ((3 1) (4 0)) ((4 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 5 3 resp 2) m (4 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 106)
  (parent 47)
  (unrealized)
  (shape)
  (maps ((0 1) ((a a) (b b) (m m))))
  (origs (m (0 0))))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 107)
  (parent 47)
  (seen 228)
  (unrealized (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b)) m (4 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 108)
  (parent 48)
  (seen 177)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 109)
  (parent 48)
  (unrealized (4 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (4 0))
    ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 3 resp 2) m (4 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 110)
  (parent 48)
  (seen 106)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 111)
  (parent 48)
  (seen 242)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 112)
  (parent 49)
  (seen 101)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 113)
  (parent 49)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 114)
  (parent 49)
  (seen 119 234)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b)) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 115)
  (parent 50)
  (seen 185)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (5 0))
    ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 3 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 116)
  (parent 50)
  (seen 106)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 117)
  (parent 50)
  (seen 238 251)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b)) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 118)
  (parent 51)
  (seen 188)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 119)
  (parent 51)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (5 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 120)
  (parent 51)
  (seen 110)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 121)
  (parent 51)
  (seen 248 265)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (precedes ((0 0) (2 0)) ((2 1) (3 0)) ((3 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (4 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0)))))
  (label 122)
  (parent 52)
  (seen 7)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 123)
  (parent 54)
  (seen 40)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 124)
  (parent 54)
  (seen 53)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 125)
  (parent 54)
  (seen 123)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (5 0)) ((3 1) (1 0))
    ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 126)
  (parent 54)
  (seen 53)
  (unrealized (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 127)
  (parent 54)
  (seen 124)
  (unrealized (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 128)
  (parent 56)
  (seen 123)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-4 a)) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 129)
  (parent 56)
  (seen 124)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-5 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-5)) b (pubk a-5)))))
  (label 130)
  (parent 56)
  (seen 125)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (7 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 131)
  (parent 56)
  (seen 55)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 132)
  (parent 56)
  (seen 129 273)
  (unrealized (7 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 133)
  (parent 58)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 134)
  (parent 58)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (precedes ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (4 0)) ((4 1) (2 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0)))))
  (label 135)
  (parent 60)
  (seen 122)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 136)
  (parent 61)
  (seen 52)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 137)
  (parent 61)
  (unrealized (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 138)
  (parent 61)
  (seen 60 288 291)
  (unrealized (6 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 139)
  (parent 61)
  (seen 65)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 140)
  (parent 63)
  (unrealized (7 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 141)
  (parent 63)
  (unrealized (7 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 1) (2 0)) ((5 1) (4 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 142)
  (parent 65)
  (seen 135)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 143)
  (parent 66)
  (seen 296)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 144)
  (parent 66)
  (seen 52 297)
  (unrealized (7 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((6 1) (7 0)) ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 145)
  (parent 66)
  (seen 314 316)
  (unrealized (7 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 146)
  (parent 66)
  (seen 65)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((5 1) (6 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 147)
  (parent 67)
  (seen 85)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 148)
  (parent 67)
  (seen 86)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 149)
  (parent 67)
  (seen 195)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 150)
  (parent 67)
  (seen 70 198)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((5 1) (6 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 151)
  (parent 68)
  (unrealized (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b) (a-3 b)) m (6 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 152)
  (parent 68)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 153)
  (parent 68)
  (unrealized (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 154)
  (parent 68)
  (seen 205 334 338)
  (unrealized (6 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 155)
  (parent 68)
  (seen 152 211)
  (unrealized (6 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 156)
  (parent 69)
  (seen 94)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((0 0) (7 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 157)
  (parent 70)
  (seen 70)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((0 0) (7 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 158)
  (parent 70)
  (seen 152 155 213)
  (unrealized (7 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 159)
  (parent 71)
  (seen 97)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (6 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 160)
  (parent 73)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 161)
  (parent 73)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 162)
  (parent 73)
  (seen 219)
  (unrealized (6 0) (8 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (4 0))
    ((4 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (4 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 163)
  (parent 74)
  (seen 7)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (5 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 3 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 164)
  (parent 76)
  (seen 16)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 165)
  (parent 76)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 166)
  (parent 76)
  (seen 164)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 167)
  (parent 76)
  (unrealized (5 0) (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (5 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 168)
  (parent 77)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 169)
  (parent 77)
  (seen 168)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 170)
  (parent 77)
  (unrealized (5 0) (7 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 171)
  (parent 78)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 172)
  (parent 78)
  (seen 361)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 173)
  (parent 78)
  (seen 178 232)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 174)
  (parent 79)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 175)
  (parent 79)
  (seen 106)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 176)
  (parent 79)
  (seen 236 361)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 177)
  (parent 80)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 178)
  (parent 80)
  (seen 368)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 179)
  (parent 80)
  (seen 110)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 180)
  (parent 80)
  (seen 245 368)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 181)
  (parent 81)
  (seen 171)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 182)
  (parent 81)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 183)
  (parent 81)
  (seen 189 254 380)
  (unrealized (8 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 184)
  (parent 82)
  (seen 82)
  (unrealized (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((5 1) (6 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 185)
  (parent 83)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (6 0)) ((5 1) (4 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 186)
  (parent 83)
  (seen 175)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 187)
  (parent 83)
  (seen 259 385 398)
  (unrealized (7 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 188)
  (parent 84)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 189)
  (parent 84)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (6 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 190)
  (parent 84)
  (seen 179)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 191)
  (parent 84)
  (seen 268 395 414)
  (unrealized (8 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (3 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 192)
  (parent 86)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 193)
  (parent 87)
  (seen 16)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 194)
  (parent 87)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 195)
  (parent 87)
  (seen 17)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 196)
  (parent 87)
  (unrealized (5 0) (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 197)
  (parent 88)
  (seen 365)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 198)
  (parent 88)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 199)
  (parent 88)
  (unrealized (5 0) (7 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 200)
  (parent 89)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 201)
  (parent 89)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 202)
  (parent 89)
  (seen 210)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 203)
  (parent 90)
  (seen 90)
  (unrealized (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 204)
  (parent 91)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 205)
  (parent 91)
  (seen 424)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 206)
  (parent 91)
  (seen 211)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 207)
  (parent 92)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 208)
  (parent 92)
  (seen 424)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 209)
  (parent 93)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 210)
  (parent 93)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 211)
  (parent 93)
  (seen 431)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 212)
  (parent 93)
  (seen 431)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 213)
  (parent 96)
  (seen 211)
  (unrealized (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 214)
  (parent 96)
  (seen 210)
  (unrealized (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((5 1) (6 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 215)
  (parent 96)
  (seen 479 482)
  (unrealized (6 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 216)
  (parent 96)
  (seen 90)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0)) ((3 1) (4 0))
    ((4 1) (2 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 217)
  (parent 98)
  (seen 16)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (2 0)) ((4 1) (2 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 218)
  (parent 99)
  (seen 17)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 219)
  (parent 100)
  (seen 221)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (7 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 220)
  (parent 100)
  (unrealized (7 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (7 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 221)
  (parent 100)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 222)
  (parent 100)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 223)
  (parent 100)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 224)
  (parent 100)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 225)
  (parent 101)
  (seen 122)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (4 0))
    ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 3 resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 226)
  (parent 102)
  (seen 106)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1)))))
  (label 227)
  (parent 102)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 5 resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 228)
  (parent 102)
  (seen 225)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 229)
  (parent 102)
  (seen 228 236)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 230)
  (parent 102)
  (seen 233)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 231)
  (parent 103)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 232)
  (parent 103)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 233)
  (parent 103)
  (seen 228)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 234)
  (parent 103)
  (seen 109 242)
  (unrealized (6 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 235)
  (parent 105)
  (unrealized (5 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (6 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 236)
  (parent 107)
  (seen 228)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((2 1) (3 0)) ((2 1) (5 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 237)
  (parent 107)
  (seen 106)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (6 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 238)
  (parent 107)
  (seen 110)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 239)
  (parent 108)
  (seen 46)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 240)
  (parent 109)
  (seen 226)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1)))))
  (label 241)
  (parent 109)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 6 resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 242)
  (parent 109)
  (seen 28)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 243)
  (parent 109)
  (seen 242 245)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (4 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 244)
  (parent 109)
  (seen 109)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 245)
  (parent 111)
  (seen 242)
  (unrealized (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 246)
  (parent 111)
  (seen 110)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 247)
  (parent 111)
  (seen 116)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 248)
  (parent 111)
  (seen 120)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (5 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 249)
  (parent 113)
  (seen 226)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1)))))
  (label 250)
  (parent 113)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 6 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 251)
  (parent 113)
  (seen 228)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 252)
  (parent 113)
  (seen 251 259 517)
  (unrealized (7 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 253)
  (parent 113)
  (seen 256 521)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 254)
  (parent 114)
  (seen 232)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 255)
  (parent 114)
  (seen 231)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 256)
  (parent 114)
  (seen 251)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 257)
  (parent 114)
  (seen 119 265)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 258)
  (parent 115)
  (seen 534 536)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 259)
  (parent 117)
  (seen 251)
  (unrealized (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((4 1) (6 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 260)
  (parent 117)
  (seen 237)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 261)
  (parent 117)
  (seen 238)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 262)
  (parent 118)
  (seen 46 542)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (5 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 3 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 263)
  (parent 119)
  (seen 240)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1)))))
  (label 264)
  (parent 119)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 7 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1)))))
  (label 265)
  (parent 119)
  (seen 242)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 266)
  (parent 119)
  (seen 265 268 548)
  (unrealized (8 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 267)
  (parent 119)
  (seen 119)
  (unrealized (8 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 268)
  (parent 121)
  (seen 265)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 269)
  (parent 121)
  (seen 246)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 270)
  (parent 121)
  (seen 247)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 271)
  (parent 121)
  (seen 248)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 272)
  (parent 127)
  (seen 98)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 273)
  (parent 127)
  (seen 272)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 274)
  (parent 127)
  (unrealized (6 0) (8 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (7 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 6 resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 275)
  (parent 132)
  (seen 272)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-5 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-5)) b (pubk a-5)))))
  (label 276)
  (parent 132)
  (seen 273)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-5) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-5 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-5)) a (pubk a-5)))))
  (label 277)
  (parent 132)
  (seen 590)
  (unrealized (7 0) (9 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 278)
  (parent 133)
  (seen 74)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 279)
  (parent 133)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 280)
  (parent 133)
  (seen 278)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 281)
  (parent 133)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 282)
  (parent 133)
  (seen 279)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 283)
  (parent 134)
  (unrealized (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b) (a-2 b)) m (6 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 284)
  (parent 134)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 285)
  (parent 134)
  (seen 13)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 286)
  (parent 134)
  (seen 614 617)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 287)
  (parent 134)
  (seen 284)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 288)
  (parent 136)
  (seen 52)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 289)
  (parent 136)
  (seen 297)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-4 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-3)) b (pubk a-3)))))
  (label 290)
  (parent 137)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 291)
  (parent 137)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5)))))
  (label 292)
  (parent 137)
  (seen 296 633)
  (unrealized (8 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 293)
  (parent 138)
  (unrealized (3 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (6 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 294)
  (parent 138)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 295)
  (parent 138)
  (seen 60)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 296)
  (parent 139)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 297)
  (parent 139)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 298)
  (parent 139)
  (seen 65)
  (unrealized (3 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (6 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 299)
  (parent 139)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 300)
  (parent 139)
  (seen 65)
  (unrealized (8 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 301)
  (parent 140)
  (seen 302)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 302)
  (parent 140)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 303)
  (parent 140)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 304)
  (parent 140)
  (unrealized (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((6 1) (7 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 305)
  (parent 140)
  (unrealized (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 306)
  (parent 140)
  (seen 303)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 307)
  (parent 141)
  (unrealized (7 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 308)
  (parent 141)
  (unrealized (7 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-1 b) (a-2 b)) m (7 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 309)
  (parent 141)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 310)
  (parent 141)
  (seen 694 698)
  (unrealized (7 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((6 1) (7 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 311)
  (parent 141)
  (seen 696 700)
  (unrealized (7 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (1 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 312)
  (parent 141)
  (seen 309)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-4 b)) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-3)) b (pubk a-3)))))
  (label 313)
  (parent 143)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((6 1) (7 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 6 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 314)
  (parent 143)
  (unrealized (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5)))))
  (label 315)
  (parent 143)
  (seen 323 646)
  (unrealized (9 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((6 1) (7 0)) ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 316)
  (parent 144)
  (seen 52)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 317)
  (parent 144)
  (seen 321 635 721)
  (unrealized (8 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((6 1) (7 0)) ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 318)
  (parent 145)
  (unrealized (3 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (7 0)) ((6 1) (5 0))
    ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 319)
  (parent 145)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((6 1) (7 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 320)
  (parent 145)
  (seen 656 717)
  (unrealized (8 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 2 resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 321)
  (parent 146)
  (unrealized (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 322)
  (parent 146)
  (seen 65)
  (unrealized (3 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 323)
  (parent 146)
  (unrealized (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (7 0))
    ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 5 resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 324)
  (parent 146)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (3 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 325)
  (parent 146)
  (seen 676 753)
  (unrealized (9 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 326)
  (parent 149)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 327)
  (parent 149)
  (seen 193)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 328)
  (parent 149)
  (seen 195)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 329)
  (parent 149)
  (seen 425)
  (unrealized (6 0) (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 330)
  (parent 150)
  (seen 197)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 331)
  (parent 150)
  (seen 198)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 332)
  (parent 150)
  (seen 429)
  (unrealized (6 0) (8 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((5 1) (6 0))
    ((6 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 333)
  (parent 151)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 334)
  (parent 151)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 335)
  (parent 151)
  (seen 343 443)
  (unrealized (7 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((0 0) (7 0)) ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 336)
  (parent 152)
  (seen 152)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-4 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-3)) b (pubk a-3)))))
  (label 337)
  (parent 153)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 338)
  (parent 153)
  (seen 765)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5)))))
  (label 339)
  (parent 153)
  (seen 344 453)
  (unrealized (8 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (4 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 340)
  (parent 154)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 341)
  (parent 154)
  (seen 459 765)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 342)
  (parent 155)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 343)
  (parent 155)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 344)
  (parent 155)
  (seen 770)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 345)
  (parent 155)
  (seen 473 770)
  (unrealized (8 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (7 0)) ((6 1) (4 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 346)
  (parent 158)
  (seen 343)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (1 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 347)
  (parent 158)
  (seen 344)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((6 1) (7 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 348)
  (parent 158)
  (seen 479 819 822)
  (unrealized (7 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (1 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 349)
  (parent 158)
  (seen 152 488)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 350)
  (parent 160)
  (seen 217)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 351)
  (parent 161)
  (seen 218)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (8 0))
    ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 5 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 352)
  (parent 162)
  (unrealized (8 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-4 b)) m (8 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-3)) b (pubk a-3)))))
  (label 353)
  (parent 162)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (8 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 2 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 354)
  (parent 162)
  (seen 500)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0))
    ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-5 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-5)) b (pubk a-5)))))
  (label 355)
  (parent 162)
  (seen 353)
  (unrealized (8 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (8 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 7 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 356)
  (parent 162)
  (seen 505)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0))
    ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 357)
  (parent 162)
  (seen 510)
  (unrealized (6 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 358)
  (parent 165)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 359)
  (parent 165)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (6 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 360)
  (parent 167)
  (seen 228)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 361)
  (parent 167)
  (seen 372)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (7 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 362)
  (parent 167)
  (seen 361)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 363)
  (parent 167)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (7 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 364)
  (parent 167)
  (unrealized (5 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (4 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 365)
  (parent 168)
  (seen 16)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 366)
  (parent 170)
  (seen 368)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (7 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 3 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 367)
  (parent 170)
  (seen 242)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (7 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 368)
  (parent 170)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 369)
  (parent 170)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 370)
  (parent 170)
  (seen 13 21)
  (unrealized (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 371)
  (parent 170)
  (unrealized (5 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 372)
  (parent 171)
  (seen 225)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 373)
  (parent 172)
  (seen 226)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 374)
  (parent 172)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 375)
  (parent 172)
  (seen 361 383 515)
  (unrealized (7 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 376)
  (parent 172)
  (seen 379 520)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 377)
  (parent 173)
  (seen 231)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-5 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-5)) b (pubk a-5)))))
  (label 378)
  (parent 173)
  (seen 232)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 379)
  (parent 173)
  (seen 361 524)
  (unrealized (7 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 380)
  (parent 173)
  (seen 178 368 529)
  (unrealized (7 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 381)
  (parent 174)
  (seen 185)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 382)
  (parent 174)
  (seen 533 859)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (7 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 383)
  (parent 176)
  (seen 361)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((2 1) (4 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 384)
  (parent 176)
  (seen 237)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (7 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 385)
  (parent 176)
  (seen 238)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 386)
  (parent 177)
  (seen 188)
  (unrealized (7 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 387)
  (parent 177)
  (seen 13 539)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 388)
  (parent 178)
  (seen 240)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 389)
  (parent 178)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 390)
  (parent 178)
  (seen 368 392 545)
  (unrealized (8 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 391)
  (parent 178)
  (seen 178)
  (unrealized (8 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 392)
  (parent 180)
  (seen 368)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 393)
  (parent 180)
  (seen 246)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 394)
  (parent 180)
  (seen 247)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 395)
  (parent 180)
  (seen 248)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (6 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 396)
  (parent 182)
  (seen 373)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 397)
  (parent 182)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 7 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a-3)) b (pubk a-3))
    (enc (enc m (pubk b)) a-3 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 398)
  (parent 182)
  (seen 361)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0))
    ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 399)
  (parent 182)
  (seen 398 407 554 903)
  (unrealized (8 0))
  (comment "7 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0))
    ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 400)
  (parent 182)
  (seen 403 557 907)
  (unrealized (8 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (8 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 7 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 401)
  (parent 183)
  (seen 377)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0))
    ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-5 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-5)) b (pubk a-5)))))
  (label 402)
  (parent 183)
  (seen 378)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (8 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 5 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 403)
  (parent 183)
  (seen 398 561)
  (unrealized (8 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0))
    ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 404)
  (parent 183)
  (seen 189 414 566)
  (unrealized (8 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 405)
  (parent 185)
  (seen 185)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 406)
  (parent 185)
  (seen 570 859 923)
  (unrealized (7 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 407)
  (parent 187)
  (seen 398)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((5 1) (7 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 408)
  (parent 187)
  (seen 384)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 409)
  (parent 187)
  (seen 385)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 410)
  (parent 188)
  (seen 188 926)
  (unrealized (8 0))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 411)
  (parent 188)
  (seen 82 576 935)
  (unrealized (8 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (6 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 4 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 412)
  (parent 189)
  (seen 388)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 413)
  (parent 189)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 8 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a-3)) b (pubk a-3))
    (enc (enc m (pubk b)) a-3 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 414)
  (parent 189)
  (seen 368)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0))
    ((8 1) (6 0)) ((9 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 415)
  (parent 189)
  (seen 414 417 582 941)
  (unrealized (9 0))
  (comment "8 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0))
    ((8 1) (6 0)) ((9 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 416)
  (parent 189)
  (seen 189)
  (unrealized (9 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0))
    ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 417)
  (parent 191)
  (seen 414)
  (unrealized (8 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((5 1) (8 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 5 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 418)
  (parent 191)
  (seen 393)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)) ((7 1) (8 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 7 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 419)
  (parent 191)
  (seen 394)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0))
    ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 420)
  (parent 191)
  (seen 395)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 421)
  (parent 194)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 422)
  (parent 194)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (6 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 423)
  (parent 196)
  (unrealized (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 424)
  (parent 196)
  (seen 446)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 425)
  (parent 196)
  (seen 424)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 426)
  (parent 196)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 427)
  (parent 196)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (3 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 428)
  (parent 198)
  (seen 17)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 429)
  (parent 199)
  (seen 431)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 430)
  (parent 199)
  (unrealized (7 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (7 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 431)
  (parent 199)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 432)
  (parent 199)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 433)
  (parent 199)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 434)
  (parent 199)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (2 0)) ((3 1) (4 0))
    ((4 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 435)
  (parent 200)
  (seen 122)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (5 0))
    ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 3 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 436)
  (parent 201)
  (seen 106)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 437)
  (parent 201)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 4 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 438)
  (parent 201)
  (seen 435)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 439)
  (parent 201)
  (seen 458)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 440)
  (parent 201)
  (seen 442 444)
  (unrealized (6 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((4 1) (6 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 441)
  (parent 202)
  (seen 522)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b a))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) a)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) a)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (5 0))
    ((4 1) (3 0)) ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk a)) a (pubk a)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk a)) a (pubk a)))
      (send (enc (enc m (pubk a)) a (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) a (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) a (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk a)) a (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) a (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 442)
  (parent 202)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 443)
  (parent 202)
  (seen 523)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 444)
  (parent 202)
  (seen 438)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 445)
  (parent 202)
  (seen 210 466)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (3 0)) ((0 0) (5 0)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 446)
  (parent 204)
  (seen 225)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (5 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 447)
  (parent 205)
  (seen 226)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 448)
  (parent 205)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 449)
  (parent 205)
  (seen 424 459)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 450)
  (parent 205)
  (seen 454)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 451)
  (parent 206)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 452)
  (parent 206)
  (seen 523)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-5 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-5)) b (pubk a-5)))))
  (label 453)
  (parent 206)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 454)
  (parent 206)
  (seen 424)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 455)
  (parent 206)
  (seen 211 431)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 456)
  (parent 207)
  (seen 484)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 457)
  (parent 207)
  (seen 989)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (6 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 458)
  (parent 208)
  (seen 993)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 459)
  (parent 208)
  (seen 424)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 460)
  (parent 208)
  (seen 175)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 461)
  (parent 208)
  (seen 179)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 462)
  (parent 209)
  (seen 486)
  (unrealized (7 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 463)
  (parent 209)
  (seen 90)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (5 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 464)
  (parent 210)
  (seen 110)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 465)
  (parent 210)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 466)
  (parent 210)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 467)
  (parent 210)
  (seen 474)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 468)
  (parent 210)
  (seen 210)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (5 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 3 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 469)
  (parent 211)
  (seen 240)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 470)
  (parent 211)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 471)
  (parent 211)
  (seen 431 473)
  (unrealized (8 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 472)
  (parent 211)
  (seen 211)
  (unrealized (8 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 473)
  (parent 212)
  (seen 431)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 474)
  (parent 212)
  (seen 1012)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 475)
  (parent 212)
  (seen 179)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 476)
  (parent 212)
  (seen 186)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 477)
  (parent 212)
  (seen 190)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 478)
  (parent 213)
  (seen 204)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 479)
  (parent 213)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 480)
  (parent 213)
  (seen 455 488)
  (unrealized (8 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 481)
  (parent 214)
  (seen 200)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((5 1) (6 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 482)
  (parent 214)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (6 0))
    ((5 1) (3 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 483)
  (parent 214)
  (seen 445 487 1084)
  (unrealized (7 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((5 1) (6 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 484)
  (parent 215)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((5 1) (6 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 485)
  (parent 215)
  (seen 461 1117)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 486)
  (parent 216)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (6 0))
    ((5 1) (3 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 487)
  (parent 216)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 488)
  (parent 216)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (5 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 489)
  (parent 216)
  (seen 477 1149)
  (unrealized (8 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 2 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 490)
  (parent 219)
  (seen 129)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (7 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 6 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 491)
  (parent 219)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5)))))
  (label 492)
  (parent 219)
  (unrealized (9 0))
  (comment "7 in cohort - 7 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (7 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 493)
  (parent 220)
  (seen 124)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 494)
  (parent 220)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (7 0)) ((5 1) (3 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 495)
  (parent 220)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (7 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 496)
  (parent 220)
  (seen 1159)
  (unrealized (8 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (3 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (2 0)) ((4 1) (2 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 497)
  (parent 221)
  (seen 28)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 498)
  (parent 222)
  (seen 62)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 499)
  (parent 222)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 500)
  (parent 222)
  (seen 64)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (7 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (5 0)
    (enc m (pubk a-3)) (enc (enc m (pubk a-3)) b (pubk a-3))
    (enc (enc m (pubk b)) a-3 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 501)
  (parent 222)
  (seen 497)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk a)) a-4 (pubk a)))
      (send (enc (enc m (pubk a-4)) a (pubk a-4)))))
  (label 502)
  (parent 222)
  (seen 501)
  (unrealized (8 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 503)
  (parent 223)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2)))))
  (label 504)
  (parent 223)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (7 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 505)
  (parent 223)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (7 0))
    ((7 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (5 0)
    (enc m (pubk a-3)) (enc (enc m (pubk a-3)) b (pubk a-3))
    (enc (enc m (pubk b)) a-3 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 506)
  (parent 223)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (7 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk a)) a-4 (pubk a)))
      (send (enc (enc m (pubk a-4)) a (pubk a-4)))))
  (label 507)
  (parent 223)
  (seen 506 1177)
  (unrealized (8 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 4 resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 508)
  (parent 224)
  (seen 498)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 509)
  (parent 224)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 510)
  (parent 224)
  (seen 500)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 8 resp 2) m (5 0)
    (enc m (pubk a-3)) (enc (enc m (pubk a-3)) b (pubk a-3))
    (enc (enc m (pubk b)) a-3 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 511)
  (parent 224)
  (seen 501)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-4 (pubk a)))
      (send (enc (enc m (pubk a-4)) a (pubk a-4)))))
  (label 512)
  (parent 224)
  (seen 511 1178 1187)
  (unrealized (9 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 513)
  (parent 227)
  (seen 250)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 514)
  (parent 227)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 515)
  (parent 229)
  (seen 228)
  (unrealized (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 516)
  (parent 229)
  (seen 226)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 517)
  (parent 229)
  (seen 240)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 518)
  (parent 230)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 519)
  (parent 230)
  (seen 240)
  (unrealized (4 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 520)
  (parent 230)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 521)
  (parent 230)
  (seen 519 531)
  (unrealized (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (3 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-0 (pubk a)))
      (send (enc (enc m (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 522)
  (parent 231)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (3 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-0 (pubk a)))
      (send (enc (enc m (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 523)
  (parent 232)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 524)
  (parent 233)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 525)
  (parent 233)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 526)
  (parent 233)
  (unrealized (4 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (6 0))
    ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 3 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 527)
  (parent 233)
  (seen 631)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 528)
  (parent 233)
  (unrealized (6 0) (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 529)
  (parent 234)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (6 0)) ((6 1) (4 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 530)
  (parent 234)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (6 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (4 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 3 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 531)
  (parent 234)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 532)
  (parent 234)
  (unrealized (6 0) (8 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (6 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 533)
  (parent 235)
  (unrealized (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (b a name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-0 b) (a-1 b)) m (5 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 534)
  (parent 235)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 6 2 resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 535)
  (parent 235)
  (seen 105)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (6 0)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 536)
  (parent 235)
  (seen 534)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (6 0)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 537)
  (parent 236)
  (seen 436)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (6 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (5 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 538)
  (parent 236)
  (seen 573)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 539)
  (parent 239)
  (seen 112)
  (unrealized (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 540)
  (parent 239)
  (seen 251 534 1249 1257)
  (unrealized (6 0))
  (comment "7 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)) ((5 1) (6 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 541)
  (parent 239)
  (seen 46 108)
  (unrealized (6 0))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 542)
  (parent 239)
  (seen 46)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 543)
  (parent 241)
  (seen 264)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 544)
  (parent 241)
  (unrealized (7 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (4 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 545)
  (parent 243)
  (seen 242)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 546)
  (parent 243)
  (seen 240)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (7 0)) ((6 1) (4 0))
    ((7 1) (4 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 547)
  (parent 243)
  (seen 249)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (4 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 548)
  (parent 243)
  (seen 263)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((2 1) (6 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 549)
  (parent 245)
  (seen 464)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (6 0)) ((6 1) (4 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 550)
  (parent 245)
  (seen 1125)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (5 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (4 0))
    ((6 1) (4 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 551)
  (parent 245)
  (seen 586)
  (unrealized (8 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 552)
  (parent 250)
  (seen 250)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 553)
  (parent 250)
  (seen 1199 1202)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 554)
  (parent 252)
  (seen 251)
  (unrealized (7 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 555)
  (parent 252)
  (seen 516)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 556)
  (parent 252)
  (seen 517)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 557)
  (parent 253)
  (seen 520)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (7 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 558)
  (parent 253)
  (seen 518)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 559)
  (parent 253)
  (seen 263)
  (unrealized (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 560)
  (parent 253)
  (seen 559 568)
  (unrealized (7 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 561)
  (parent 256)
  (seen 524)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (7 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 562)
  (parent 256)
  (seen 525)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 a)) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 563)
  (parent 256)
  (unrealized (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (7 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0))
    ((7 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 3 resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 564)
  (parent 256)
  (unrealized (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 565)
  (parent 256)
  (seen 1231)
  (unrealized (7 0) (8 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 566)
  (parent 257)
  (seen 529)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (7 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 6 resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 567)
  (parent 257)
  (seen 530)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (7 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 3 resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 568)
  (parent 257)
  (unrealized (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 569)
  (parent 257)
  (seen 1244)
  (unrealized (7 0) (9 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 570)
  (parent 258)
  (seen 1250)
  (unrealized (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (1 0))
    ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 571)
  (parent 258)
  (seen 115)
  (unrealized (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 572)
  (parent 258)
  (seen 534)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 573)
  (parent 259)
  (seen 464)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (6 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 574)
  (parent 259)
  (seen 537)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 575)
  (parent 259)
  (seen 1256)
  (unrealized (8 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (1 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2)))))
  (label 576)
  (parent 262)
  (seen 112 1264)
  (unrealized (7 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 577)
  (parent 262)
  (seen 251 534 1260 1329 1338)
  (unrealized (7 0))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0)) ((6 1) (5 0))
    ((6 1) (7 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 6 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1)))))
  (label 578)
  (parent 262)
  (seen 46 118)
  (unrealized (7 0))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (1 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 579)
  (parent 262)
  (unrealized (7 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 580)
  (parent 264)
  (seen 264)
  (unrealized (8 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (8 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 581)
  (parent 264)
  (seen 1274 1277)
  (unrealized (8 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0))
    ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 582)
  (parent 266)
  (seen 265)
  (unrealized (8 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (8 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 4 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 583)
  (parent 266)
  (seen 546)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (8 0)) ((7 1) (5 0)) ((8 1) (5 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 6 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 584)
  (parent 266)
  (seen 547)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (5 0))
    ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 585)
  (parent 266)
  (seen 548)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (7 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 2 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 586)
  (parent 268)
  (seen 1142)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((4 1) (7 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 4 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 587)
  (parent 268)
  (seen 549)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (1 0))
    ((6 1) (7 0)) ((7 1) (5 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 6 resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 588)
  (parent 268)
  (seen 550)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 589)
  (parent 268)
  (seen 1285)
  (unrealized (9 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (9 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (6 0)) ((8 1) (6 0)) ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-5 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-5)) b (pubk a-5)))))
  (label 590)
  (parent 274)
  (seen 592)
  (unrealized (8 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (8 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 2 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 591)
  (parent 274)
  (unrealized (8 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-4 b)) m (8 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-3)) b (pubk a-3)))))
  (label 592)
  (parent 274)
  (seen 1363)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (8 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 4 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 593)
  (parent 274)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0)) ((6 1) (5 0))
    ((7 1) (8 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 7 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 594)
  (parent 274)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (9 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (6 0)) ((8 1) (6 0)) ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 595)
  (parent 274)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-5) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (9 0)) ((7 1) (5 0)) ((8 1) (7 0)) ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 10 6 resp 2) m (9 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-5 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-5)) a (pubk a-5)))))
  (label 596)
  (parent 277)
  (unrealized (9 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (9 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-5 b)) m (9 0)
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-4)) b (pubk a-4)))))
  (label 597)
  (parent 277)
  (seen 592)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-5) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (9 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0)) ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 10 4 resp 2) m (9 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-5 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-5)) a (pubk a-5)))))
  (label 598)
  (parent 277)
  (seen 1368)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 a-6 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-5) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-6) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (10 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)) ((10 1) (9 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (9 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-5 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-5)) a (pubk a-5))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-6 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-6)) b (pubk a-6)))))
  (label 599)
  (parent 277)
  (seen 597)
  (unrealized (9 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-5) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 1) (3 0))
    ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (9 0)) ((9 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 10 8 resp 2) m (9 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-5 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-5)) a (pubk a-5)))))
  (label 600)
  (parent 277)
  (seen 1373)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-5) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (8 0))
    ((0 0) (10 0)) ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (3 0)) ((6 1) (5 0)) ((7 1) (5 0)) ((8 1) (7 0))
    ((9 1) (7 0)) ((10 1) (9 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (9 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-5 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-5)) a (pubk a-5))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 601)
  (parent 277)
  (seen 1378)
  (unrealized (7 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 602)
  (parent 279)
  (seen 279)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk a))
    (enc m (pubk b)) (enc (enc m (pubk a)) b (pubk a))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 603)
  (parent 279)
  (seen 284 287)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 604)
  (parent 281)
  (seen 164)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 605)
  (parent 281)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 606)
  (parent 281)
  (seen 604)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)) ((5 1) (6 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2)))))
  (label 607)
  (parent 281)
  (seen 58)
  (unrealized (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 608)
  (parent 281)
  (unrealized (6 0) (7 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 609)
  (parent 282)
  (seen 168)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 610)
  (parent 282)
  (seen 609)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((5 1) (6 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 611)
  (parent 282)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 612)
  (parent 282)
  (unrealized (6 0) (8 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 613)
  (parent 283)
  (seen 101)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 614)
  (parent 283)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a-3 (pubk b)))
      (send (enc (enc m (pubk a-3)) b (pubk a-3)))))
  (label 615)
  (parent 283)
  (seen 622)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((0 0) (7 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (1 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (1 0) (enc m (pubk b))
    (enc (enc m (pubk b)) b (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1)))))
  (label 616)
  (parent 284)
  (seen 284)
  (unrealized (7 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 617)
  (parent 285)
  (seen 1410)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 618)
  (parent 285)
  (seen 624 1431)
  (unrealized (8 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 619)
  (parent 286)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)) ((5 1) (6 0)) ((6 1) (1 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 620)
  (parent 286)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 621)
  (parent 286)
  (seen 1410)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 622)
  (parent 287)
  (unrealized (6 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 b)) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 623)
  (parent 287)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 624)
  (parent 287)
  (seen 1421)
  (unrealized (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((5 1) (6 0))
    ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 625)
  (parent 287)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (1 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0)
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-3)) a (pubk a-3)))))
  (label 626)
  (parent 287)
  (seen 1421)
  (unrealized (8 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-3 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 627)
  (parent 288)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (6 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 5 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 628)
  (parent 288)
  (seen 652)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 629)
  (parent 288)
  (seen 653)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 630)
  (parent 288)
  (seen 631 634)
  (unrealized (7 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b a))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk a)) a)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) a)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (6 0)) ((6 1) (3 0)))
  (non-orig (privk a))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk a)) a (pubk a)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk a)) a (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) a (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a (pubk a)))
      (send (enc (enc m (pubk a)) a (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) a (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) a (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 631)
  (parent 289)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (7 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 632)
  (parent 289)
  (seen 231)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (8 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-5 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-5)) b (pubk a-5)))))
  (label 633)
  (parent 289)
  (seen 632)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (7 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 4 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4)))))
  (label 634)
  (parent 289)
  (seen 631)
  (unrealized (7 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (8 0)) ((2 1) (6 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)) ((8 1) (7 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk b)) a-4 (pubk b)))
      (send (enc (enc m (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 635)
  (parent 289)
  (seen 297 662 1237)
  (unrealized (7 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-2) (b b))
  (precedes ((0 0) (3 0)) ((0 0) (6 0)) ((2 1) (1 0)) ((3 1) (4 0))
    ((4 1) (2 0)) ((5 1) (2 0)) ((6 1) (5 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-2 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-2)) b (pubk a-2)))))
  (label 636)
  (parent 290)
  (seen 101)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (6 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 5 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4)))))
  (label 637)
  (parent 291)
  (seen 628)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-4 b)) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 638)
  (parent 291)
  (seen 627)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a-2) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 7 resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a-4)) b (pubk a-4))
    (enc (enc m (pubk b)) a-4 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a-2 (pubk b)))
      (send (enc (enc m (pubk a-2)) b (pubk a-2))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-3)) b (pubk a-3)))))
  (label 639)
  (parent 291)
  (seen 1479)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-5) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0))
    ((5 1) (3 0)) ((6 1) (3 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-5 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-5)) a (pubk a-5)))))
  (label 640)
  (parent 291)
  (seen 654 872 1468)
  (unrealized (8 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (8 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0))
    ((5 1) (3 0)) ((6 1) (3 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (6 0) (enc m (pubk b))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5)))))
  (label 641)
  (parent 291)
  (seen 642 645 1473)
  (unrealized (8 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b a))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk a)) a)) (a a-0) (b a))
  (defstrand resp 2 (m m) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) a)) (a a-2) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) a)) (a a-3) (b a))
  (defstrand resp 2 (m m) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (6 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (7 0)) ((6 1) (3 0))
    ((7 1) (3 0)))
  (non-orig (privk a))
  (uniq-orig m)
  (operation nonce-test (displaced 9 5 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk a)) a (pubk a)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk a)) a (pubk a)) a-0 (pubk a)))
      (send (enc (enc (enc m (pubk a)) a (pubk a-0)) a (pubk a-0))))
    ((recv (enc (enc m (pubk a)) a-1 (pubk a)))
      (send (enc (enc m (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a (pubk a)))
      (send (enc (enc m (pubk a)) a (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) a (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) a (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc (enc m (pubk a)) a (pubk a)) a-3 (pubk a)))
      (send (enc (enc (enc m (pubk a)) a (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc m (pubk a)) a-4 (pubk a)))
      (send (enc (enc m (pubk a-4)) a (pubk a-4)))))
  (label 642)
  (parent 292)
  (seen 631)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 a-6 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-6) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (9 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)) ((8 1) (6 0)) ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-6 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-6)) b (pubk a-6)))))
  (label 643)
  (parent 292)
  (seen 633)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (8 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 7 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5)))))
  (label 644)
  (parent 292)
  (seen 632)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (8 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)) ((8 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 9 4 resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5)))))
  (label 645)
  (parent 292)
  (seen 639 642 1476)
  (unrealized (8 0))
  (comment "8 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-4) (b b))
  (defstrand resp 2 (m m) (a a-5) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((0 0) (9 0))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (6 0)) ((8 1) (6 0)) ((9 1) (8 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (8 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-4 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-4)) b (pubk a-4))))
    ((recv (enc (enc m (pubk b)) a-5 (pubk b)))
      (send (enc (enc m (pubk a-5)) b (pubk a-5))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a)))))
  (label 646)
  (parent 292)
  (seen 296 659 1482)
  (unrealized (8 0))
  (comment "8 in cohort - 5 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 2 resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 647)
  (parent 293)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (contracted (a-2 a)) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b)))))
  (label 648)
  (parent 293)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-3) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-3 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-3)) b (pubk a-3)))))
  (label 649)
  (parent 293)
  (seen 647)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (b a a-0 a-1 name))
  (defstrand init 1 (m m) (a b) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a) (b b))
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk b)) b)) (a a-1) (b b))
  (defstrand resp 2 (m m) (a b) (b b))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (3 0)))
  (non-orig (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 7 4 resp 2) m (3 0)
    (enc m (pubk a-2)) (enc (enc m (pubk a-2)) b (pubk a-2))
    (enc (enc m (pubk b)) a-2 (pubk b)))
  (traces ((send (enc (enc m (pubk b)) b (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a)) b (pubk a))))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b))))
    ((recv (enc (enc (enc m (pubk b)) b (pubk b)) a-1 (pubk b)))
      (send (enc (enc (enc m (pubk b)) b (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) b (pubk b)))
      (send (enc (enc m (pubk b)) b (pubk b)))))
  (label 650)
  (parent 293)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a b) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((0 0) (7 0)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0))
    ((6 1) (3 0)) ((7 1) (3 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (added-strand resp 2) m (3 0) (enc m (pubk a))
    (enc (enc m (pubk a)) b (pubk a)) (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) b (pubk a)))
      (send (enc (enc m (pubk b)) a (pubk b))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3)))))
  (label 651)
  (parent 293)
  (seen 735)
  (unrealized (7 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m m) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-1) (b a))
  (defstrand resp 2 (m m) (a a-2) (b a))
  (precedes ((0 0) (3 0)) ((2 1) (1 0)) ((3 1) (4 0)) ((4 1) (5 0))
    ((5 1) (2 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation generalization deleted (2 0))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc m (pubk b)) a-0 (pubk b)))
      (send (enc (enc m (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-1 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-1)) a (pubk a-1))))
    ((recv (enc (enc m (pubk a)) a-2 (pubk a)))
      (send (enc (enc m (pubk a-2)) a (pubk a-2)))))
  (label 652)
  (parent 294)
  (seen 106)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3) (b a))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-4) (b a))
  (precedes ((0 0) (2 0)) ((0 0) (4 0)) ((2 1) (7 0)) ((3 1) (1 0))
    ((4 1) (5 0)) ((4 1) (6 0)) ((5 1) (3 0)) ((6 1) (3 0))
    ((7 1) (6 0)))
  (non-orig (privk a) (privk b))
  (uniq-orig m)
  (operation nonce-test (displaced 8 2 resp 2) m (7 0)
    (enc (enc m (pubk b)) a (pubk b)))
  (traces ((send (enc (enc m (pubk b)) a (pubk b)))) ((recv m) (send m))
    ((recv (enc (enc (enc m (pubk b)) a (pubk b)) a-0 (pubk b)))
      (send (enc (enc (enc m (pubk b)) a (pubk a-0)) b (pubk a-0))))
    ((recv (enc (enc m (pubk b)) a-1 (pubk b)))
      (send (enc (enc m (pubk a-1)) b (pubk a-1))))
    ((recv (enc (enc m (pubk b)) a (pubk b)))
      (send (enc (enc m (pubk a)) b (pubk a))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-2 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-2)) a (pubk a-2))))
    ((recv (enc (enc m (pubk a)) a-3 (pubk a)))
      (send (enc (enc m (pubk a-3)) a (pubk a-3))))
    ((recv (enc (enc (enc m (pubk a)) b (pubk a)) a-4 (pubk a)))
      (send (enc (enc (enc m (pubk a)) b (pubk a-4)) a (pubk a-4)))))
  (label 653)
  (parent 295)
  (seen 1479)
  (unrealized (7 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton dy
  (vars (m text) (a b a-0 a-1 a-2 a-3 a-4 a-5 name))
  (defstrand init 1 (m m) (a a) (b b))
  (deflistener m)
  (defstrand resp 2 (m (cat (enc m (pubk b)) a)) (a a-0) (b b))
  (defstrand resp 2 (m m) (a a-1) (b b))
  (defstrand resp 2 (m m) (a a) (b b))
  (defstrand resp 2 (m (cat (enc m (pubk a)) b)) (a a-2) (b a))
  (defstrand resp 2 (m m) (a a-3)