(herald "Envelope Protocol" (bound 15))

(comment "CPSA 4.3.0")
(comment "All input read from tst/envelope.scm")
(comment "Strand count bounded at 15")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig v n)
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 0)
  (unrealized (0 0) (1 2))
  (preskeleton)
  (origs (v (1 3)) (n (1 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((1 3) (0 0)))
  (non-orig esk aik)
  (uniq-orig v n)
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 1)
  (parent 0)
  (unrealized (1 2))
  (origs (v (1 3)) (n (1 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (1 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 2)
  (parent 1)
  (unrealized (0 0) (2 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 3 1 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (2 0))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 3)
  (parent 2)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (pcrvals mesg) (v n data) (esk pcrkey skey) (k aik aik-0 akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals pcrvals) (pcrkey pcrkey) (k k)
    (aik aik-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0)))
  (non-orig esk pcrkey aik aik-0 (invk k))
  (uniq-orig v n k)
  (operation nonce-test (added-strand tpm-decrypt 4) v (0 0) (enc v k))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k pcrvals aik-0))
      (recv (enc pcrvals (hash pcrkey))) (send v)))
  (label 4)
  (parent 3)
  (unrealized (3 1) (3 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 4 2 tpm-create-key 2)
    (enc "created" k pcrvals aik-0) (3 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v)))
  (label 5)
  (parent 4)
  (unrealized (3 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 6)
  (parent 5)
  (unrealized (4 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend-enc 3 (value "obtain")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (enc "extend" "obtain" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 7)
  (parent 5)
  (unrealized (4 0) (4 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 1) (3 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 8)
  (parent 5)
  (unrealized (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend 3 (value n) (current-value "0") (pcrkey pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (cat "extend" n)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 9)
  (parent 6)
  (unrealized (5 0) (5 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 10)
  (parent 6)
  (unrealized (5 0) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)) ((5 1) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 11)
  (parent 6)
  (unrealized (4 1) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 6 1 alice 1)
    (enc "extend" n esk-0) (5 0))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 12)
  (parent 10)
  (unrealized (5 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (5 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 13)
  (parent 12)
  (unrealized)
  (shape)
  (maps ((0 1) ((v v) (n n) (esk esk) (k k) (aik aik))))
  (origs (n (1 0)) (k (2 1)) (v (1 3))))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (5 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 14)
  (parent 12)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 15)
  (unrealized (0 0) (1 2))
  (preskeleton)
  (origs (v (1 3)) (n (1 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((1 3) (0 0)))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 16)
  (parent 15)
  (unrealized (0 0) (1 2))
  (origs (v (1 3)) (n (1 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (1 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 17)
  (parent 16)
  (unrealized (0 0) (2 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 3 1 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (2 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 18)
  (parent 17)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-quote 3)
    (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik) (0 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))))
  (label 19)
  (parent 18)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey)))))
  (label 20)
  (parent 19)
  (unrealized (4 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend-enc 3 (value "refuse")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (enc "extend" "refuse" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey)))))
  (label 21)
  (parent 19)
  (unrealized (4 0) (4 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 1) (3 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 22)
  (parent 19)
  (unrealized (3 1) (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend 3 (value n) (current-value "0") (pcrkey pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (cat "extend" n)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 23)
  (parent 20)
  (unrealized (5 0) (5 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 24)
  (parent 20)
  (unrealized (5 0) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)) ((5 1) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 25)
  (parent 20)
  (unrealized (4 1) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 6 1 alice 1)
    (enc "extend" n esk-0) (5 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 26)
  (parent 24)
  (unrealized (5 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 27)
  (parent 26)
  (unrealized)
  (shape)
  (maps ((0 1) ((n n) (v v) (k k) (aik aik) (esk esk))))
  (origs (n (1 0)) (k (2 1)) (v (1 3))))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 28)
  (parent 26)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 29)
  (unrealized (0 0) (1 0) (2 2))
  (preskeleton)
  (origs (v (2 3)) (n (2 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((2 3) (0 0)) ((2 3) (1 0)))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 30)
  (parent 29)
  (unrealized (0 0) (2 2))
  (origs (v (2 3)) (n (2 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((2 3) (0 0)) ((2 3) (1 0)) ((3 1) (2 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (2 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 31)
  (parent 30)
  (unrealized (0 0) (1 0) (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (1 0)) ((3 1) (2 2)))
  (non-orig esk aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 4 2 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (3 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 32)
  (parent 31)
  (unrealized (0 0) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (pcrvals mesg) (n v data) (esk pcrkey skey) (k aik aik-0 akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals pcrvals) (pcrkey pcrkey) (k k)
    (aik aik-0))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)))
  (non-orig esk pcrkey aik aik-0 (invk k))
  (uniq-orig n v k)
  (operation nonce-test (added-strand tpm-decrypt 4) v (1 0) (enc v k))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k pcrvals aik-0))
      (recv (enc pcrvals (hash pcrkey))) (send v)))
  (label 33)
  (parent 32)
  (unrealized (0 0) (4 1) (4 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 5 3 tpm-create-key 2)
    (enc "created" k pcrvals aik-0) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v)))
  (label 34)
  (parent 33)
  (unrealized (0 0) (4 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 35)
  (parent 34)
  (unrealized (0 0) (5 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend-enc 3 (value "obtain")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (enc "extend" "obtain" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 36)
  (parent 34)
  (unrealized (0 0) (5 0) (5 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 1) (4 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 37)
  (parent 34)
  (unrealized (0 0) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend 3 (value n) (current-value "0") (pcrkey pcrkey))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash "0" n) (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (cat "extend" n)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 38)
  (parent 35)
  (unrealized (0 0) (6 0) (6 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 39)
  (parent 35)
  (unrealized (0 0) (6 0) (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 40)
  (parent 35)
  (unrealized (0 0) (5 1) (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 7 2 alice 1)
    (enc "extend" n esk-0) (6 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 41)
  (parent 39)
  (unrealized (0 0) (6 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (6 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 42)
  (parent 41)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (6 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 43)
  (parent 41)
  (unrealized (0 0) (7 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-quote 3)
    (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik) (0 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))))
  (label 44)
  (parent 42)
  (unrealized (8 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))))
  (label 45)
  (parent 44)
  (unrealized (9 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend-enc 3 (value "refuse")
    (current-value (hash "0" n)) (pcrkey pcrkey-0) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)))
  (non-orig esk pcrkey pcrkey-0 esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (enc "extend" "refuse" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))))
  (label 46)
  (parent 44)
  (unrealized (9 0) (9 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (deflistener (hash pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 1) (8 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey-0))
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (hash pcrkey-0)) (send (hash pcrkey-0))))
  (label 47)
  (parent 44)
  (unrealized (8 1) (9 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((6 2) (9 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 10 6 tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey-0)) (9 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey)))))
  (label 48)
  (parent 45)
  (unrealized)
  (shape)
  (maps ((0 1 2) ((n n) (v v) (k k) (aik aik) (esk esk))))
  (origs (n (2 0)) (k (3 1)) (v (2 3))))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend 3 (value n) (current-value "0")
    (pcrkey pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash "0" n) (hash pcrkey-0)) (9 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (cat "extend" n)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0)))))
  (label 49)
  (parent 45)
  (unrealized (10 0) (10 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)))
  (non-orig esk pcrkey pcrkey-0 esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey-0)) (9 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0)))))
  (label 50)
  (parent 45)
  (unrealized (10 0) (10 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (deflistener (hash pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)) ((10 1) (9 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey-0))
    (enc (hash "0" n) (hash pcrkey-0)) (9 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (hash pcrkey-0)) (send (hash pcrkey-0))))
  (label 51)
  (parent 45)
  (unrealized (9 1) (10 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 11 2 alice 1)
    (enc "extend" n esk-0) (10 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0)))))
  (label 52)
  (parent 50)
  (unrealized (10 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((7 1) (10 1)) ((8 2) (0 0))
    ((9 2) (8 1)) ((10 2) (9 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 11 7 tpm-power-on 2)
    (enc "0" (hash pcrkey-0)) (10 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 53)
  (parent 52)
  (unrealized)
  (shape)
  (maps ((0 1 2) ((n n) (v v) (k k) (aik aik) (esk esk))))
  (origs (n (2 0)) (k (3 1)) (v (2 3))))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)) ((11 1) (10 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey-0)) (10 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0))))
    ((recv "power on") (send (enc "0" (hash pcrkey-0)))))
  (label 54)
  (parent 52)
  (unrealized)
  (shape)
  (maps ((0 1 2) ((n n) (v v) (k k) (aik aik) (esk esk))))
  (origs (n (2 0)) (k (3 1)) (v (2 3))))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk))
  (deflistener (hash pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)) ((11 1) (10 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey-0))
    (enc "0" (hash pcrkey-0)) (10 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0))))
    ((recv (hash pcrkey-0)) (send (hash pcrkey-0))))
  (label 55)
  (parent 52)
  (unrealized (11 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1)))))
  (defrule ordered-extends
    (forall ((y z strd) (pcrkey skey))
      (implies
        (and (p "tpm-extend" y 3) (p "tpm-extend" z 3)
          (p "tpm-extend" "pcrkey" y pcrkey)
          (p "tpm-extend" "pcrkey" z pcrkey))
        (or (= y z) (prec y 2 z 3) (prec z 2 y 3))))))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig v n)
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 56)
  (unrealized (0 0) (1 2))
  (preskeleton)
  (origs (v (1 3)) (n (1 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((1 3) (0 0)))
  (non-orig esk aik)
  (uniq-orig v n)
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 57)
  (parent 56)
  (unrealized (1 2))
  (origs (v (1 3)) (n (1 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (1 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 58)
  (parent 57)
  (unrealized (0 0) (2 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 3 1 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (2 0))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 59)
  (parent 58)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (pcrvals mesg) (v n data) (esk pcrkey skey) (k aik aik-0 akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals pcrvals) (pcrkey pcrkey) (k k)
    (aik aik-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0)))
  (non-orig esk pcrkey aik aik-0 (invk k))
  (uniq-orig v n k)
  (operation nonce-test (added-strand tpm-decrypt 4) v (0 0) (enc v k))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k pcrvals aik-0))
      (recv (enc pcrvals (hash pcrkey))) (send v)))
  (label 60)
  (parent 59)
  (unrealized (3 1) (3 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 4 2 tpm-create-key 2)
    (enc "created" k pcrvals aik-0) (3 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v)))
  (label 61)
  (parent 60)
  (unrealized (3 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 62)
  (parent 61)
  (unrealized (4 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend-enc 3 (value "obtain")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (enc "extend" "obtain" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 63)
  (parent 61)
  (unrealized (4 0) (4 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 1) (3 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 64)
  (parent 61)
  (unrealized (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 65)
  (parent 62)
  (unrealized (5 0) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)) ((5 1) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 66)
  (parent 62)
  (unrealized (4 1) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 6 1 alice 1)
    (enc "extend" n esk-0) (5 0))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 67)
  (parent 65)
  (unrealized (5 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (5 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 68)
  (parent 67)
  (unrealized)
  (shape)
  (maps ((0 1) ((v v) (n n) (esk esk) (k k) (aik aik))))
  (origs (n (1 0)) (k (2 1)) (v (1 3))))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (5 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 69)
  (parent 67)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1)))))
  (defrule ordered-extends
    (forall ((y z strd) (pcrkey skey))
      (implies
        (and (p "tpm-extend" y 3) (p "tpm-extend" z 3)
          (p "tpm-extend" "pcrkey" y pcrkey)
          (p "tpm-extend" "pcrkey" z pcrkey))
        (or (= y z) (prec y 2 z 3) (prec z 2 y 3))))))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 70)
  (unrealized (0 0) (1 2))
  (preskeleton)
  (origs (v (1 3)) (n (1 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((1 3) (0 0)))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 71)
  (parent 70)
  (unrealized (0 0) (1 2))
  (origs (v (1 3)) (n (1 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (1 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 72)
  (parent 71)
  (unrealized (0 0) (2 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 3 1 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (2 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 73)
  (parent 72)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-quote 3)
    (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik) (0 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))))
  (label 74)
  (parent 73)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey)))))
  (label 75)
  (parent 74)
  (unrealized (4 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend-enc 3 (value "refuse")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (enc "extend" "refuse" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey)))))
  (label 76)
  (parent 74)
  (unrealized (4 0) (4 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 1) (3 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 77)
  (parent 74)
  (unrealized (3 1) (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 78)
  (parent 75)
  (unrealized (5 0) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)) ((5 1) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 79)
  (parent 75)
  (unrealized (4 1) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 6 1 alice 1)
    (enc "extend" n esk-0) (5 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 80)
  (parent 78)
  (unrealized (5 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 81)
  (parent 80)
  (unrealized)
  (shape)
  (maps ((0 1) ((n n) (v v) (k k) (aik aik) (esk esk))))
  (origs (n (1 0)) (k (2 1)) (v (1 3))))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 82)
  (parent 80)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1)))))
  (defrule ordered-extends
    (forall ((y z strd) (pcrkey skey))
      (implies
        (and (p "tpm-extend" y 3) (p "tpm-extend" z 3)
          (p "tpm-extend" "pcrkey" y pcrkey)
          (p "tpm-extend" "pcrkey" z pcrkey))
        (or (= y z) (prec y 2 z 3) (prec z 2 y 3))))))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 83)
  (unrealized (0 0) (1 0) (2 2))
  (preskeleton)
  (origs (v (2 3)) (n (2 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((2 3) (0 0)) ((2 3) (1 0)))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 84)
  (parent 83)
  (unrealized (0 0) (2 2))
  (origs (v (2 3)) (n (2 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((2 3) (0 0)) ((2 3) (1 0)) ((3 1) (2 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (2 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 85)
  (parent 84)
  (unrealized (0 0) (1 0) (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (1 0)) ((3 1) (2 2)))
  (non-orig esk aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 4 2 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (3 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 86)
  (parent 85)
  (unrealized (0 0) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (pcrvals mesg) (n v data) (esk pcrkey skey) (k aik aik-0 akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals pcrvals) (pcrkey pcrkey) (k k)
    (aik aik-0))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)))
  (non-orig esk pcrkey aik aik-0 (invk k))
  (uniq-orig n v k)
  (operation nonce-test (added-strand tpm-decrypt 4) v (1 0) (enc v k))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k pcrvals aik-0))
      (recv (enc pcrvals (hash pcrkey))) (send v)))
  (label 87)
  (parent 86)
  (unrealized (0 0) (4 1) (4 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 5 3 tpm-create-key 2)
    (enc "created" k pcrvals aik-0) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v)))
  (label 88)
  (parent 87)
  (unrealized (0 0) (4 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 89)
  (parent 88)
  (unrealized (0 0) (5 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend-enc 3 (value "obtain")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (enc "extend" "obtain" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 90)
  (parent 88)
  (unrealized (0 0) (5 0) (5 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 1) (4 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 91)
  (parent 88)
  (unrealized (0 0) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 92)
  (parent 89)
  (unrealized (0 0) (6 0) (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 93)
  (parent 89)
  (unrealized (0 0) (5 1) (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 7 2 alice 1)
    (enc "extend" n esk-0) (6 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 94)
  (parent 92)
  (unrealized (0 0) (6 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (6 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 95)
  (parent 94)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (6 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 96)
  (parent 94)
  (unrealized (0 0) (7 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-quote 3)
    (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik) (0 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))))
  (label 97)
  (parent 95)
  (unrealized (8 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))))
  (label 98)
  (parent 97)
  (unrealized (9 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend-enc 3 (value "refuse")
    (current-value (hash "0" n)) (pcrkey pcrkey-0) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)))
  (non-orig esk pcrkey pcrkey-0 esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (enc "extend" "refuse" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))))
  (label 99)
  (parent 97)
  (unrealized (9 0) (9 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (deflistener (hash pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 1) (8 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey-0))
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (hash pcrkey-0)) (send (hash pcrkey-0))))
  (label 100)
  (parent 97)
  (unrealized (8 1) (9 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)))
  (non-orig esk pcrkey pcrkey-0 esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey-0)) (9 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0)))))
  (label 101)
  (parent 98)
  (unrealized (10 0) (10 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (deflistener (hash pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)) ((10 1) (9 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey-0))
    (enc (hash "0" n) (hash pcrkey-0)) (9 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (hash pcrkey-0)) (send (hash pcrkey-0))))
  (label 102)
  (parent 98)
  (unrealized (9 1) (10 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 11 2 alice 1)
    (enc "extend" n esk-0) (10 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0)))))
  (label 103)
  (parent 101)
  (unrealized (10 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)) ((11 1) (10 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey-0)) (10 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0))))
    ((recv "power on") (send (enc "0" (hash pcrkey-0)))))
  (label 104)
  (parent 103)
  (unrealized)
  (shape)
  (maps ((0 1 2) ((n n) (v v) (k k) (aik aik) (esk esk))))
  (origs (n (2 0)) (k (3 1)) (v (2 3))))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk))
  (deflistener (hash pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)) ((11 1) (10 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey-0))
    (enc "0" (hash pcrkey-0)) (10 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0))))
    ((recv (hash pcrkey-0)) (send (hash pcrkey-0))))
  (label 105)
  (parent 103)
  (unrealized (11 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule esk-same-as-pcrkey
    (forall ((y z strd) (esk pcrkey pcrkey-0 skey))
      (implies
        (and (p "tpm-extend-enc" y 3) (p "tpm-extend-enc" z 3)
          (p "tpm-extend-enc" "esk" y esk)
          (p "tpm-extend-enc" "esk" z esk)
          (p "tpm-extend-enc" "pcrkey" y pcrkey)
          (p "tpm-extend-enc" "pcrkey" z pcrkey-0))
        (= pcrkey pcrkey-0))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1)))))
  (defrule ordered-extends
    (forall ((y z strd) (pcrkey skey))
      (implies
        (and (p "tpm-extend" y 3) (p "tpm-extend" z 3)
          (p "tpm-extend" "pcrkey" y pcrkey)
          (p "tpm-extend" "pcrkey" z pcrkey))
        (or (= y z) (prec y 2 z 3) (prec z 2 y 3))))))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig v n)
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 106)
  (unrealized (0 0) (1 2))
  (preskeleton)
  (origs (v (1 3)) (n (1 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((1 3) (0 0)))
  (non-orig esk aik)
  (uniq-orig v n)
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 107)
  (parent 106)
  (unrealized (1 2))
  (origs (v (1 3)) (n (1 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (1 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 108)
  (parent 107)
  (unrealized (0 0) (2 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 3 1 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (2 0))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 109)
  (parent 108)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (pcrvals mesg) (v n data) (esk pcrkey skey) (k aik aik-0 akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals pcrvals) (pcrkey pcrkey) (k k)
    (aik aik-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0)))
  (non-orig esk pcrkey aik aik-0 (invk k))
  (uniq-orig v n k)
  (operation nonce-test (added-strand tpm-decrypt 4) v (0 0) (enc v k))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k pcrvals aik-0))
      (recv (enc pcrvals (hash pcrkey))) (send v)))
  (label 110)
  (parent 109)
  (unrealized (3 1) (3 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 4 2 tpm-create-key 2)
    (enc "created" k pcrvals aik-0) (3 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v)))
  (label 111)
  (parent 110)
  (unrealized (3 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 112)
  (parent 111)
  (unrealized (4 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend-enc 3 (value "obtain")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (enc "extend" "obtain" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 113)
  (parent 111)
  (unrealized (4 0) (4 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 1) (3 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (3 2))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 114)
  (parent 111)
  (unrealized (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 115)
  (parent 112)
  (unrealized (5 0) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 3) (0 0))
    ((4 2) (3 2)) ((5 1) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 116)
  (parent 112)
  (unrealized (4 1) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (displaced 6 1 alice 1)
    (enc "extend" n esk-0) (5 0))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 117)
  (parent 115)
  (unrealized (5 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (5 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 118)
  (parent 117)
  (unrealized)
  (shape)
  (maps ((0 1) ((v v) (n n) (esk esk) (k k) (aik aik))))
  (origs (n (1 0)) (k (2 1)) (v (1 3))))

(defskeleton envelope
  (vars (v n data) (esk pcrkey skey) (k aik akey))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 3) (0 0)) ((4 2) (3 2)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig v n k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (5 1))
  (traces ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 119)
  (parent 117)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule esk-same-as-pcrkey
    (forall ((y z strd) (esk pcrkey pcrkey-0 skey))
      (implies
        (and (p "tpm-extend-enc" y 3) (p "tpm-extend-enc" z 3)
          (p "tpm-extend-enc" "esk" y esk)
          (p "tpm-extend-enc" "esk" z esk)
          (p "tpm-extend-enc" "pcrkey" y pcrkey)
          (p "tpm-extend-enc" "pcrkey" z pcrkey-0))
        (= pcrkey pcrkey-0))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1)))))
  (defrule ordered-extends
    (forall ((y z strd) (pcrkey skey))
      (implies
        (and (p "tpm-extend" y 3) (p "tpm-extend" z 3)
          (p "tpm-extend" "pcrkey" y pcrkey)
          (p "tpm-extend" "pcrkey" z pcrkey))
        (or (= y z) (prec y 2 z 3) (prec z 2 y 3))))))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 120)
  (unrealized (0 0) (1 2))
  (preskeleton)
  (origs (v (1 3)) (n (1 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((1 3) (0 0)))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 121)
  (parent 120)
  (unrealized (0 0) (1 2))
  (origs (v (1 3)) (n (1 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (1 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 122)
  (parent 121)
  (unrealized (0 0) (2 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (0 0)) ((2 1) (1 2)))
  (non-orig esk aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 3 1 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (2 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 123)
  (parent 122)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-quote 3)
    (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik) (0 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))))
  (label 124)
  (parent 123)
  (unrealized (3 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey)))))
  (label 125)
  (parent 124)
  (unrealized (4 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend-enc 3 (value "refuse")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (enc "extend" "refuse" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey)))))
  (label 126)
  (parent 124)
  (unrealized (4 0) (4 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 1) (3 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "refuse") (hash pcrkey)) (3 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 127)
  (parent 124)
  (unrealized (3 1) (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 128)
  (parent 125)
  (unrealized (5 0) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2)) ((3 2) (0 0))
    ((4 2) (3 1)) ((5 1) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 129)
  (parent 125)
  (unrealized (4 1) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 6 1 alice 1)
    (enc "extend" n esk-0) (5 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 130)
  (parent 128)
  (unrealized (5 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 131)
  (parent 130)
  (unrealized)
  (shape)
  (maps ((0 1) ((n n) (v v) (k k) (aik aik) (esk esk))))
  (origs (n (1 0)) (k (2 1)) (v (1 3))))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((1 0) (5 0)) ((1 1) (2 0)) ((1 3) (3 0)) ((2 1) (1 2))
    ((3 2) (0 0)) ((4 2) (3 1)) ((5 2) (4 1)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 132)
  (parent 130)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol envelope basic
  (defrole tpm-power-on
    (vars (pcrkey skey))
    (trace (recv "power on") (send (enc "0" (hash pcrkey))))
    (non-orig pcrkey))
  (defrole tpm-extend
    (vars (value current-value mesg) (pcrkey skey))
    (trace (recv (cat "extend" value))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey))
  (defrole tpm-extend-enc
    (vars (value current-value mesg) (pcrkey esk skey))
    (trace (recv (enc "extend" value esk))
      (recv (enc current-value (hash pcrkey)))
      (send (enc (hash current-value value) (hash pcrkey)))
      (send "ext ok"))
    (non-orig pcrkey esk))
  (defrole tpm-quote
    (vars (nonce current-value mesg) (pcrkey skey) (aik akey))
    (trace (recv (cat "quote" nonce))
      (recv (enc current-value (hash pcrkey)))
      (send (enc "quote" current-value nonce aik)))
    (non-orig pcrkey aik))
  (defrole tpm-create-key
    (vars (k aik akey) (pcrval mesg) (esk skey))
    (trace (recv (enc "create key" pcrval esk))
      (send (enc "created" k pcrval aik)))
    (non-orig esk aik (invk k))
    (uniq-orig k))
  (defrole tpm-decrypt
    (vars (m pcrvals mesg) (k aik akey) (pcrkey skey))
    (trace (recv (cat "decrypt" (enc m k)))
      (recv (enc "created" k pcrvals aik))
      (recv (enc pcrvals (hash pcrkey))) (send m))
    (non-orig pcrkey aik))
  (defrole alice
    (vars (n v data) (esk skey) (k aik akey))
    (trace (send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    (non-orig esk aik)
    (uniq-orig n v))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule esk-same-as-pcrkey
    (forall ((y z strd) (esk pcrkey pcrkey-0 skey))
      (implies
        (and (p "tpm-extend-enc" y 3) (p "tpm-extend-enc" z 3)
          (p "tpm-extend-enc" "esk" y esk)
          (p "tpm-extend-enc" "esk" z esk)
          (p "tpm-extend-enc" "pcrkey" y pcrkey)
          (p "tpm-extend-enc" "pcrkey" z pcrkey-0))
        (= pcrkey pcrkey-0))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1)))))
  (defrule ordered-extends
    (forall ((y z strd) (pcrkey skey))
      (implies
        (and (p "tpm-extend" y 3) (p "tpm-extend" z 3)
          (p "tpm-extend" "pcrkey" y pcrkey)
          (p "tpm-extend" "pcrkey" z pcrkey))
        (or (= y z) (prec y 2 z 3) (prec z 2 y 3))))))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 133)
  (unrealized (0 0) (1 0) (2 2))
  (preskeleton)
  (origs (v (2 3)) (n (2 0)))
  (comment "Not a skeleton"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (precedes ((2 3) (0 0)) ((2 3) (1 0)))
  (non-orig esk aik)
  (uniq-orig n v)
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k))))
  (label 134)
  (parent 133)
  (unrealized (0 0) (2 2))
  (origs (v (2 3)) (n (2 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk-0) (k k) (aik aik))
  (precedes ((2 3) (0 0)) ((2 3) (1 0)) ((3 1) (2 2)))
  (non-orig esk esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-create-key 2)
    (enc "created" k (hash (hash "0" n) "obtain") aik) (2 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk-0))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 135)
  (parent 134)
  (unrealized (0 0) (1 0) (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (1 0)) ((3 1) (2 2)))
  (non-orig esk aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 4 2 alice 2)
    (enc "create key" (hash (hash "0" n) "obtain") esk-0) (3 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik))))
  (label 136)
  (parent 135)
  (unrealized (0 0) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (pcrvals mesg) (n v data) (esk pcrkey skey) (k aik aik-0 akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals pcrvals) (pcrkey pcrkey) (k k)
    (aik aik-0))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)))
  (non-orig esk pcrkey aik aik-0 (invk k))
  (uniq-orig n v k)
  (operation nonce-test (added-strand tpm-decrypt 4) v (1 0) (enc v k))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k pcrvals aik-0))
      (recv (enc pcrvals (hash pcrkey))) (send v)))
  (label 137)
  (parent 136)
  (unrealized (0 0) (4 1) (4 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 5 3 tpm-create-key 2)
    (enc "created" k pcrvals aik-0) (4 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v)))
  (label 138)
  (parent 137)
  (unrealized (0 0) (4 2))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 139)
  (parent 138)
  (unrealized (0 0) (5 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend-enc 3 (value "obtain")
    (current-value (hash "0" n)) (pcrkey pcrkey) (esk esk-0))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (enc "extend" "obtain" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey)))))
  (label 140)
  (parent 138)
  (unrealized (0 0) (5 0) (5 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (deflistener (hash pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 1) (4 2)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash (hash "0" n) "obtain") (hash pcrkey)) (4 2))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 141)
  (parent 138)
  (unrealized (0 0) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1)))
  (non-orig esk pcrkey esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 142)
  (parent 139)
  (unrealized (0 0) (6 0) (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (deflistener (hash pcrkey))
  (precedes ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0)) ((3 1) (2 2))
    ((4 3) (1 0)) ((5 2) (4 2)) ((6 1) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc (hash "0" n) (hash pcrkey)) (5 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 143)
  (parent 139)
  (unrealized (0 0) (5 1) (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (displaced 7 2 alice 1)
    (enc "extend" n esk-0) (6 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey)))))
  (label 144)
  (parent 142)
  (unrealized (0 0) (6 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-power-on 2)
    (enc "0" (hash pcrkey)) (6 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey)))))
  (label 145)
  (parent 144)
  (unrealized (0 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (deflistener (hash pcrkey))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (0 0)) ((2 3) (4 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)))
  (non-orig esk pcrkey aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey))
    (enc "0" (hash pcrkey)) (6 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv (hash pcrkey)) (send (hash pcrkey))))
  (label 146)
  (parent 144)
  (unrealized (0 0) (7 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-quote 3)
    (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik) (0 0))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))))
  (label 147)
  (parent 145)
  (unrealized (8 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))))
  (label 148)
  (parent 147)
  (unrealized (9 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend-enc 3 (value "refuse")
    (current-value (hash "0" n)) (pcrkey pcrkey-0) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)))
  (non-orig esk pcrkey pcrkey-0 esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (enc "extend" "refuse" esk-0))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))))
  (label 149)
  (parent 147)
  (unrealized (9 0) (9 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (deflistener (hash pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 1) (8 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey-0))
    (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)) (8 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (hash pcrkey-0)) (send (hash pcrkey-0))))
  (label 150)
  (parent 147)
  (unrealized (8 1) (9 0))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 esk-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey-0) (esk esk-0))
  (precedes ((2 0) (6 0)) ((2 0) (10 0)) ((2 1) (3 0)) ((2 3) (4 0))
    ((2 3) (8 0)) ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2))
    ((6 2) (5 1)) ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1))
    ((10 2) (9 1)))
  (non-orig esk pcrkey pcrkey-0 esk-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-strand tpm-extend-enc 3)
    (enc (hash "0" n) (hash pcrkey-0)) (9 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (enc "extend" n esk-0)) (recv (enc "0" (hash pcrkey-0)))
      (send (enc (hash "0" n) (hash pcrkey-0)))))
  (label 151)
  (parent 148)
  (unrealized (10 0) (10 1))
  (dead)
  (comment "empty cohort"))

(defskeleton envelope
  (vars (n v data) (esk pcrkey pcrkey-0 skey) (k aik akey))
  (deflistener (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
  (deflistener v)
  (defstrand alice 4 (n n) (v v) (esk esk) (k k) (aik aik))
  (defstrand tpm-create-key 2 (pcrval (hash (hash "0" n) "obtain"))
    (esk esk) (k k) (aik aik))
  (defstrand tpm-decrypt 4 (m v) (pcrvals (hash (hash "0" n) "obtain"))
    (pcrkey pcrkey) (k k) (aik aik))
  (defstrand tpm-extend 3 (value "obtain") (current-value (hash "0" n))
    (pcrkey pcrkey))
  (defstrand tpm-extend-enc 3 (value n) (current-value "0")
    (pcrkey pcrkey) (esk esk))
  (defstrand tpm-power-on 2 (pcrkey pcrkey))
  (defstrand tpm-quote 3 (nonce (enc v k))
    (current-value (hash (hash "0" n) "refuse")) (pcrkey pcrkey-0)
    (aik aik))
  (defstrand tpm-extend 3 (value "refuse") (current-value (hash "0" n))
    (pcrkey pcrkey-0))
  (deflistener (hash pcrkey-0))
  (precedes ((2 0) (6 0)) ((2 1) (3 0)) ((2 3) (4 0)) ((2 3) (8 0))
    ((3 1) (2 2)) ((4 3) (1 0)) ((5 2) (4 2)) ((6 2) (5 1))
    ((7 1) (6 1)) ((8 2) (0 0)) ((9 2) (8 1)) ((10 1) (9 1)))
  (non-orig esk pcrkey pcrkey-0 aik (invk k))
  (uniq-orig n v k)
  (operation encryption-test (added-listener (hash pcrkey-0))
    (enc (hash "0" n) (hash pcrkey-0)) (9 1))
  (traces
    ((recv (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv v) (send v))
    ((send (enc "extend" n esk))
      (send (enc "create key" (hash (hash "0" n) "obtain") esk))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (send (enc v k)))
    ((recv (enc "create key" (hash (hash "0" n) "obtain") esk))
      (send (enc "created" k (hash (hash "0" n) "obtain") aik)))
    ((recv (cat "decrypt" (enc v k)))
      (recv (enc "created" k (hash (hash "0" n) "obtain") aik))
      (recv (enc (hash (hash "0" n) "obtain") (hash pcrkey))) (send v))
    ((recv (cat "extend" "obtain"))
      (recv (enc (hash "0" n) (hash pcrkey)))
      (send (enc (hash (hash "0" n) "obtain") (hash pcrkey))))
    ((recv (enc "extend" n esk)) (recv (enc "0" (hash pcrkey)))
      (send (enc (hash "0" n) (hash pcrkey))))
    ((recv "power on") (send (enc "0" (hash pcrkey))))
    ((recv (cat "quote" (enc v k)))
      (recv (enc (hash (hash "0" n) "refuse") (hash pcrkey-0)))
      (send (enc "quote" (hash (hash "0" n) "refuse") (enc v k) aik)))
    ((recv (cat "extend" "refuse"))
      (recv (enc (hash "0" n) (hash pcrkey-0)))
      (send (enc (hash (hash "0" n) "refuse") (hash pcrkey-0))))
    ((recv (hash pcrkey-0)) (send (hash pcrkey-0))))
  (label 152)
  (parent 148)
  (unrealized (9 1) (10 0))
  (dead)
  (comment "empty cohort"))

(comment "Nothing left to do")
