(herald "Electronic Purchase with Money Order Protocol Variant"
  (bound 12) (limit 5000)
  (comment "This version includes account numbers in exchanges"))

(comment "CPSA 2.3.1")
(comment "All input read from epmo_acctnum.scm")
(comment "Step count limited to 5000")
(comment "Strand count bounded at 12")

(defprotocol epmo_acctnum basic
  (defrole bank
    (vars (b c m name) (acctnum text) (hash name) (nc nm nb price text))
    (trace (recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (recv (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    (non-orig (privk hash))
    (annotations b
      (1
        (forall ((pm name))
          (implies
            (and (authtransfer c acctnum b price pm nm)
              (reqtransfer pm b price pm nm))
            (dotransfer acctnum b price pm nm))))
      (2
        (and (says c (authtransfer c acctnum b price m nm))
          (says m (reqtransfer m b price m nm))))))
  (defrole customer
    (vars (b c m hash name) (acctnum nb nc nm goods price text))
    (trace (send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb)))
    (non-orig (privk b) (privk hash))
    (uniq-orig nc)
    (annotations c
      (1
        (says m
          (implies
            (exists ((acctnum2 text))
              (dotransfer acctnum2 b price m nm)) (doship m goods c))))
      (3
        (says b
          (forall ((pm name))
            (implies
              (and (authtransfer c acctnum b price m nm)
                (reqtransfer pm b price pm nm))
              (dotransfer acctnum b price pm nm)))))
      (4 (authtransfer c acctnum b price m nm))))
  (defrole merchant
    (vars (b c m hash name) (nb nc nm goods price text))
    (trace (recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    (non-orig (privk hash))
    (uniq-orig nm)
    (annotations m
      (1
        (implies
          (exists ((acctnum2 text)) (dotransfer acctnum2 b price m nm))
          (doship m goods c)))
      (2
        (and
          (says b
            (forall ((pm name))
              (exists ((acctnum2 text))
                (implies
                  (and (authtransfer c acctnum2 b price m nm)
                    (reqtransfer pm b price pm nm))
                  (dotransfer acctnum2 b price pm nm)))))
          (says c
            (exists ((acctnum2 text))
              (authtransfer c acctnum2 b price m nm)))))
      (3 (and (reqtransfer m b price m nm) (doship m goods c))))))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price text) (b m c hash name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (non-orig (privk b) (privk m) (privk c) (privk hash))
  (uniq-orig nm nc nb)
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m)))))
  (label 0)
  (unrealized (0 2))
  (origs (nm (0 1)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price acctnum text) (b m c hash name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (precedes ((0 1) (1 0)) ((1 1) (0 2)))
  (non-orig (privk b) (privk m) (privk c) (privk hash))
  (uniq-orig nm nc nb)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b)) (0 2))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))))
  (label 1)
  (parent 0)
  (unrealized (0 2) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm nm)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0))
  (uniq-orig nm nc nb)
  (operation nonce-test (added-strand customer 3) nm (1 0)
    (enc nc nm m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum-0 price (pubk b-0)))))
  (label 2)
  (parent 1)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price acctnum goods-0 text) (m c hash b name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nm)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b))
  (uniq-orig nm nc nb)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nm
    (1 0) (enc nc nm m price (pubk c))
    (enc c nc nm acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b)))))
  (label 3)
  (parent 2)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm nm)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nm) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((0 1) (3 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (1 0)) ((3 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nm nc nb)
  (operation nonce-test (added-strand bank 2) nm (1 0)
    (enc nc nm m price (pubk c))
    (enc c nc nm acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum-0 price (pubk b-0))))
    ((recv (enc c nc nm acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nm price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 4)
  (parent 2)
  (unrealized (0 0) (0 2) (1 0) (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb price acctnum goods text) (m c hash b name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b))
  (uniq-orig nm nc nb)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b)))))
  (label 5)
  (parent 3)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price acctnum goods-0 nm-0 price-0 text)
    (m c hash b name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nm)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand merchant 2 (nc nc) (nm nm-0) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (3 0)) ((2 2) (1 0))
    ((3 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b))
  (uniq-orig nm nc nb nm-0)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm-0 m price-0 (pubk c)))))
  (label 6)
  (parent 3)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm nm)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nm) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nm nc nb)
  (operation nonce-test (displaced 4 2 customer 3) nm (3 0)
    (enc nc nm m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum-0 price (pubk b-0))))
    ((recv (enc c nc nm acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nm price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 7)
  (parent 4)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb price acctnum goods text) (c hash b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm nm)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (2 1)) ((1 1) (2 3)) ((2 0) (0 0)) ((2 2) (1 0))
    ((2 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk b) (privk m))
  (uniq-orig nm nc nb)
  (operation nonce-test (displaced 2 3 customer 5) nb (0 2)
    (enc "hash" c nc nb nm price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))))
  (label 8)
  (parent 5)
  (unrealized)
  (shape)
  (maps
    ((0)
      ((b b) (m m) (c c) (nm nm) (nc nc) (nb nb) (hash hash)
        (goods goods) (price price))))
  (origs (nc (2 0)) (nm (0 1)) (nb (1 1))))

(defskeleton epmo_acctnum
  (vars (nm nc nb price acctnum goods nm-0 price-0 text)
    (m c hash b name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m))
  (defstrand merchant 2 (nc nc) (nm nm-0) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (3 0)) ((2 2) (1 0))
    ((3 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b))
  (uniq-orig nm nc nb nm-0)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm-0 m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm-0 m price-0 (pubk c)))))
  (label 9)
  (parent 6)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price acctnum goods-0 nb-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nm)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nm nc nb)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nm
    (1 0) (enc "hash" c nc nb-0 nm price (pubk hash-0))
    (enc nc nm m price (pubk c)) (enc c nc nm acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nm price (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c))))))
  (label 10)
  (parent 7)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price m price (pubk c))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 11)
  (parent 7)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 4 3 bank 2) nm (1 0)
    (enc "hash" c nc nb-0 nm price (pubk hash-0))
    (enc nc nm m price (pubk c))
    (enc c nc nm acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 12)
  (parent 7)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb price nm-0 price-0 acctnum goods text)
    (c hash b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand merchant 2 (nc nc) (nm nm-0) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm nm)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (0 0)) ((3 0) (2 0))
    ((3 2) (1 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk b) (privk m))
  (uniq-orig nm nc nb nm-0)
  (operation nonce-test (displaced 2 4 customer 5) nb (0 2)
    (enc "hash" c nc nb nm price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm-0 m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))))
  (label 13)
  (parent 9)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb price acctnum goods nb-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nm nc nb)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nm price (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c))))))
  (label 14)
  (parent 10)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb goods price acctnum goods-0 nb-0 nm-0 price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nm)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm-0) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nm nc nb nm-0)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nm price (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm-0 m price-0 (pubk c)))))
  (label 15)
  (parent 10)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 5 0 merchant 2) price (4 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 16)
  (parent 11)
  (unrealized (0 0) (0 2) (1 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))))
  (label 17)
  (parent 12)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (added-strand bank 2) nb-0 (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 18)
  (parent 12)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 2 4 customer 5) nb-0 (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 19)
  (parent 12)
  (unrealized (0 0) (0 2) (1 0) (3 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb price nb-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm nm)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nm nc nb)
  (operation nonce-test (displaced 2 4 customer 5) nb (0 2)
    (enc "hash" c nc nb nm price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nm price (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))))
  (label 20)
  (parent 14)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb price acctnum goods nb-0 nm-0 price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm-0) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nm nc nb nm-0)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm-0 m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nm price (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm-0 m price-0 (pubk c)))))
  (label 21)
  (parent 15)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nc
    (1 0) (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc price m price (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc price acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))))
  (label 22)
  (parent 16)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc price m price (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 23)
  (parent 16)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc price m price (pubk c))
    (enc c nc goods-0 (pubk m))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 24)
  (parent 16)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 2 4 customer 5) nb-0 (1 0)
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 nb-0 (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 25)
  (parent 16)
  (unrealized (0 0) (0 2) (1 0) (3 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (1 0)
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc price m price (pubk c))
    (enc c nc goods-0 (pubk m))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 26)
  (parent 16)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))))
  (label 27)
  (parent 17)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 28)
  (parent 17)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 5 2 customer 3) nb-0 (4 0)
    (enc nc nb-0 m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 29)
  (parent 18)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation encryption-test (displaced 4 2 bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0)) (privk b-0))
    (3 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 30)
  (parent 19)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (3 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (3 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0)) (privk b-0))
    (3 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 31)
  (parent 19)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nm nc nb price nb-0 nm-0 price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nm) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nm) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm-0) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm nm)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (0 0))
    ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nm nc nb nm-0)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb nm price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nm (pubk hash)) (privk m))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nm acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nm price (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm-0 m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nm m price (pubk c)))
      (send (enc c nc nm acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nm price (pubk hash)) (privk b))
          nb))))
  (label 32)
  (parent 21)
  (seen 13)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))))
  (label 33)
  (parent 22)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 34)
  (parent 22)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 5 2 customer 3) nc (4 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 35)
  (parent 23)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (5 0)) ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (4 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 36)
  (parent 23)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (4 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 5 3 bank 2) nc (4 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c))))))
  (label 37)
  (parent 24)
  (unrealized (0 0) (0 2) (1 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 5 2 customer 3) nc (4 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 38)
  (parent 24)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price acctnum-0)
  (operation nonce-test (displaced 5 2 customer 3) nc (4 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb price price (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 price m price (pubk c)))
      (send (enc c acctnum-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc
            (enc "hash" c acctnum-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c))))))
  (label 39)
  (parent 24)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (5 0)) ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (4 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 40)
  (parent 24)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price nb-0)
  (operation encryption-test (displaced 4 2 bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (3 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 41)
  (parent 25)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (3 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (3 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price nb-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (3 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 42)
  (parent 25)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nc
    (1 0) (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc price m price (pubk c))
    (enc nc nm m price-0 (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 43)
  (parent 26)
  (seen 34)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (4 0)) ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc price m price (pubk c))
    (enc nc nm m price-0 (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 44)
  (parent 26)
  (seen 36)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (4 0)) ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc price m price (pubk c))
    (enc nc nm m price-0 (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 45)
  (parent 26)
  (seen 40 67)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 5 customer 5) nb-0 (1 0)
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 nb-0 (pubk c)) (enc nb-0 price m price (pubk c))
    (enc nb-0 nm m price-0 (pubk c)) (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 46)
  (parent 26)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 acctnum goods text) (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 2 4 customer 5) nb (0 2)
    (enc "hash" c nc nb nb-0 price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))))
  (label 47)
  (parent 27)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 48)
  (parent 28)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nb-1 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c))))))
  (label 49)
  (parent 29)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nc price price price (pubk hash-0))
    (enc "hash" c nc nb-0 price price (pubk hash-1))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 price price (pubk hash-2))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 50)
  (parent 29)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 2 5 customer 5) nb-0 (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-1))
            (privk b-0)) nb-0))))
  (label 51)
  (parent 29)
  (seen 30 31)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 2 5 customer 5) nb-0 (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 52)
  (parent 29)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nc
    (1 0) (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc nb-0 acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0))))
  (label 53)
  (parent 30)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 1) (3 3))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 54)
  (parent 30)
  (seen 88)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 0) (4 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 55)
  (parent 30)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (3 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 5 3 customer 3) nb-0 (4 0)
    (enc nc nb-0 m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 56)
  (parent 31)
  (seen 30)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 acctnum goods text) (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 2 4 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 57)
  (parent 33)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 58)
  (parent 34)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price goods-0 nb-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))))
  (label 59)
  (parent 35)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 2 5 customer 5) nb-0 (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 60)
  (parent 35)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 2 5 customer 5) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price))))
  (label 61)
  (parent 35)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 6 2 customer 3) nc (4 0)
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 62)
  (parent 36)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (4 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c))))))
  (label 63)
  (parent 37)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) nb-0 (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 64)
  (parent 37)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 2 5 customer 5) nb-0 (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 65)
  (parent 37)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation nonce-test (displaced 2 5 customer 5) goods-0 (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 goods-0 (pubk c)) (enc goods-0 price m price (pubk c))
    (enc c goods-0 goods-0 (pubk m))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0))))
  (label 66)
  (parent 37)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nb-0 (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 67)
  (parent 37)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price m price (pubk c))
    (enc c nc price acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b)) (enc nc goods-0 (pubk c))))))
  (label 68)
  (parent 38)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 69)
  (parent 38)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price acctnum)
  (operation nonce-test
    (contracted (b-0 b) (acctnum-0 acctnum) (hash-1 hash-0)
      (nb-0 goods-0)) price (1 0)
    (enc "hash" c acctnum goods-0 price price (pubk hash-0))
    (enc acctnum price m price (pubk c))
    (enc c acctnum price acctnum price (pubk b)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 price price (pubk hash-0))
            (privk b)) (enc acctnum goods-0 (pubk c))))))
  (label 70)
  (parent 39)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0)
  (operation nonce-test (displaced 5 3 bank 2) price (1 0)
    (enc "hash" c acctnum-0 goods-0 price price (pubk hash-1))
    (enc "hash" c acctnum-0 nb-0 price price (pubk hash-0))
    (enc acctnum-0 price m price (pubk c))
    (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c))))))
  (label 71)
  (parent 39)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 6 3 bank 2) nc (4 0)
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 72)
  (parent 40)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 6 2 customer 3) nc (4 0)
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 73)
  (parent 40)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price acctnum-0 nm)
  (operation nonce-test (displaced 6 2 customer 3) nc (4 0)
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb price price (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 price m price (pubk c)))
      (send (enc c acctnum-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc
            (enc "hash" c acctnum-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price-0 (pubk c)))))
  (label 74)
  (parent 40)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0))))
  (label 75)
  (parent 41)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 1) (3 3))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 76)
  (parent 41)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (3 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 5 3 customer 3) price (4 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 77)
  (parent 42)
  (seen 41)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 78)
  (parent 43)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 6 2 customer 3) nc (5 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 79)
  (parent 44)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 6 2 customer 3) nc (5 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 80)
  (parent 45)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price acctnum-0 nm)
  (operation nonce-test (displaced 6 2 customer 3) nc (5 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb price price (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 price m price (pubk c)))
      (send (enc c acctnum-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price-0 (pubk c))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc
            (enc "hash" c acctnum-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c))))))
  (label 81)
  (parent 45)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price nb-0 nm)
  (operation encryption-test (displaced 5 2 bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 82)
  (parent 46)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 acctnum-1
      text) (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price nb-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 83)
  (parent 46)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (0 0))
    ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb nb-0 price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))))
  (label 84)
  (parent 48)
  (seen 13)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 nb-1 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c))))))
  (label 85)
  (parent 49)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nb-1 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 86)
  (parent 49)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 6 0 merchant 2) price (5 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 87)
  (parent 50)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation encryption-test (displaced 5 2 bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 88)
  (parent 52)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation encryption-test (displaced 5 3 bank 2)
    (enc (enc "hash" c nc nb-1 nb-1 price (pubk hash-1)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 89)
  (parent 52)
  (seen 53 54 55)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 acctnum-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 90)
  (parent 52)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum nb-0 goods text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0))))
  (label 91)
  (parent 53)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (4 0))
    ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 92)
  (parent 53)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 0) (4 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nc
    (1 0) (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc nc nm m price-0 (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 93)
  (parent 55)
  (seen 91 92)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 goods-0 nm price-0 nb-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 3))
    ((3 0) (0 0)) ((3 0) (4 0)) ((3 2) (2 0)) ((3 4) (1 0))
    ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m price (pubk c))
    (enc nc nm m price-0 (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 94)
  (parent 55)
  (seen 160)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 goods-0 acctnum-1 nb-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0))
    ((4 1) (3 3)) ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (added-strand bank 2) nb-0 (4 0)
    (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 95)
  (parent 56)
  (unrealized (0 0) (0 2) (1 0) (4 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods text) (c hash b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (2 1)) ((1 1) (2 3)) ((2 0) (0 0)) ((2 2) (1 0))
    ((2 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk b) (privk m))
  (uniq-orig nc nb price)
  (operation generalization deleted (2 0))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 96)
  (parent 57)
  (seen 8)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (0 0))
    ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 97)
  (parent 58)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price goods nb-0 text) (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))))
  (label 98)
  (parent 59)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 99)
  (parent 59)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation encryption-test (displaced 5 3 bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 100)
  (parent 60)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (3 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (3 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 101)
  (parent 60)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation encryption-test (displaced 5 2 bank 2)
    (enc (enc "hash" c nc price price price (pubk hash-1)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 102)
  (parent 61)
  (seen 168 169 170)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation encryption-test (displaced 5 3 bank 2)
    (enc (enc "hash" c nc price price price (pubk hash-1)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price))))
  (label 103)
  (parent 61)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc price price price (pubk hash-1)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 104)
  (parent 61)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 105)
  (parent 62)
  (seen 99)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb-0 (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 106)
  (parent 62)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 6 customer 5) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price))))
  (label 107)
  (parent 62)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (4 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c))))))
  (label 108)
  (parent 63)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nb-0 (0 0)
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 109)
  (parent 63)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (5 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 2 customer 3) nb-0 (5 0)
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 110)
  (parent 64)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (6 0)) ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nb-0 (5 0)
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 111)
  (parent 64)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation encryption-test (displaced 5 2 bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 112)
  (parent 65)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 113)
  (parent 65)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price goods-0)
  (operation encryption-test (displaced 5 2 bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (4 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) goods-0))))
  (label 114)
  (parent 66)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation encryption-test (displaced 5 3 bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (4 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0))))
  (label 115)
  (parent 66)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (4 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))))
  (label 116)
  (parent 66)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 117)
  (parent 67)
  (seen 109)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (5 0)) ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand bank 2) nb-0 (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 118)
  (parent 67)
  (seen 111)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb-0 (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 119)
  (parent 67)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) goods-0 (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 goods-0 (pubk c)) (enc goods-0 price m price (pubk c))
    (enc goods-0 nm m price-0 (pubk c)) (enc c goods-0 goods-0 (pubk m))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0))))
  (label 120)
  (parent 67)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c))))))
  (label 121)
  (parent 68)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 122)
  (parent 68)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 5 2 customer 3) price (4 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 123)
  (parent 69)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((3 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price acctnum)
  (operation nonce-test (contracted (goods-0 goods)) acctnum (0 0)
    (enc c acctnum goods (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods price price (pubk hash-0))
            (privk b)) (enc acctnum goods (pubk c))))))
  (label 124)
  (parent 70)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price acctnum nm)
  (operation nonce-test (added-strand merchant 2) acctnum (0 0)
    (enc c acctnum goods-0 (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 price price (pubk hash-0))
            (privk b)) (enc acctnum goods-0 (pubk c)))))
    ((recv (enc c acctnum goods-0 (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c)))))
  (label 125)
  (parent 70)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum goods-0 nb-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (nb goods-0) (price nb-0) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
    (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
    (enc acctnum nb-0 (pubk c)) (enc acctnum nb-0 m nb-0 (pubk c))
    (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods-0 (pubk c))))))
  (label 126)
  (parent 71)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0)
  (operation nonce-test (displaced 2 5 customer 5) nb-0 (1 0)
    (enc "hash" c acctnum-0 goods-1 nb-0 nb-0 (pubk hash-1))
    (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
    (enc acctnum-0 nb-0 (pubk c)) (enc acctnum-0 nb-0 m nb-0 (pubk c))
    (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 127)
  (parent 71)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 128)
  (parent 72)
  (seen 109)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (5 0)) ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand bank 2) nb-0 (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 129)
  (parent 72)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb-0 (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 goods-0 (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 130)
  (parent 72)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) goods-0 (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 goods-0 (pubk c)) (enc goods-0 price m price (pubk c))
    (enc goods-0 nm m price-0 (pubk c)) (enc c goods-0 goods-0 (pubk m))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0))))
  (label 131)
  (parent 72)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price m price (pubk c))
    (enc c nc price acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 132)
  (parent 73)
  (seen 122)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (4 0)) ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 133)
  (parent 73)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price acctnum nm)
  (operation nonce-test
    (contracted (b-0 b) (acctnum-0 acctnum) (hash-1 hash-0)
      (nb-0 goods-0)) price (1 0)
    (enc "hash" c acctnum goods-0 price price (pubk hash-0))
    (enc acctnum price m price (pubk c))
    (enc c acctnum price acctnum price (pubk b)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 price price (pubk hash-0))
            (privk b)) (enc acctnum goods-0 (pubk c)))))
    ((recv (enc c acctnum goods-0 (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c)))))
  (label 134)
  (parent 74)
  (seen 125)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 goods-0 nb-0 nm price text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0 nm)
  (operation nonce-test (displaced 6 3 bank 2) price-0 (1 0)
    (enc "hash" c acctnum-0 goods-0 price-0 price-0 (pubk hash-1))
    (enc "hash" c acctnum-0 nb-0 price-0 price-0 (pubk hash-0))
    (enc acctnum-0 price-0 m price-0 (pubk c))
    (enc c acctnum-0 price-0 acctnum-0 price-0 (pubk b-0)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price (pubk c)))))
  (label 135)
  (parent 74)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0))))
  (label 136)
  (parent 75)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (4 0))
    ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nb-0 (0 0)
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 137)
  (parent 75)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 5 3 customer 3) price (4 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 138)
  (parent 76)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0))
    ((4 1) (3 3)) ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) price (4 0)
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 139)
  (parent 77)
  (unrealized (0 0) (0 2) (1 0) (4 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 140)
  (parent 78)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))))
  (label 141)
  (parent 79)
  (seen 99)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0)) ((5 2) (2 0))
    ((5 2) (4 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb-0 (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 142)
  (parent 79)
  (seen 170)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0)) ((5 2) (2 0))
    ((5 2) (4 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 6 customer 5) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price))))
  (label 143)
  (parent 79)
  (seen 174)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price m price (pubk c))
    (enc c nc price acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b)) (enc nc goods-0 (pubk c))))))
  (label 144)
  (parent 80)
  (seen 122)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 145)
  (parent 80)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price acctnum nm)
  (operation nonce-test
    (contracted (b-0 b) (acctnum-0 acctnum) (hash-1 hash-0)
      (nb-0 goods-0)) price (1 0)
    (enc "hash" c acctnum goods-0 price price (pubk hash-0))
    (enc acctnum price m price (pubk c))
    (enc c acctnum price acctnum price (pubk b)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b))))
    ((recv (enc c acctnum goods-0 (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 price price (pubk hash-0))
            (privk b)) (enc acctnum goods-0 (pubk c))))))
  (label 146)
  (parent 81)
  (seen 125)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 goods-0 nb-0 nm price text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0 nm)
  (operation nonce-test (displaced 6 3 bank 2) price-0 (1 0)
    (enc "hash" c acctnum-0 goods-0 price-0 price-0 (pubk hash-1))
    (enc "hash" c acctnum-0 nb-0 price-0 price-0 (pubk hash-0))
    (enc acctnum-0 price-0 m price-0 (pubk c))
    (enc c acctnum-0 price-0 acctnum-0 price-0 (pubk b-0)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price (pubk c))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c))))))
  (label 147)
  (parent 81)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0))))
  (label 148)
  (parent 82)
  (seen 137)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 149)
  (parent 82)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 acctnum-1
      text) (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 150)
  (parent 83)
  (seen 82)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 nb-1 acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb nb-0 price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))))
  (label 151)
  (parent 85)
  (seen 20)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 nb-1 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 152)
  (parent 86)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nc
    (1 0) (enc "hash" c nc price price price (pubk hash-0))
    (enc "hash" c nc nb-0 price price (pubk hash-1))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b)) (enc nc nb-0 (pubk c))))))
  (label 153)
  (parent 87)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-0))
    (enc "hash" c nc nb-0 price price (pubk hash-1))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 154)
  (parent 87)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 2 5 customer 5) nb-0 (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-0))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
    (enc nb-0 price (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-0))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) nb-0))))
  (label 155)
  (parent 87)
  (seen 229)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-0))
    (enc "hash" c nc nb-0 price price (pubk hash-1))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 156)
  (parent 87)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 nb-1 goods-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nc
    (1 0) (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-1 (pubk c))
    (enc nc nb-0 m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0))))
  (label 157)
  (parent 88)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-1 (pubk c))
    (enc nc nb-0 m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 nb-0 price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 158)
  (parent 88)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 nb-2 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc price) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc price) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc price)
    (nm nb-0) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-2)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c price nb-1 nb-0 price (pubk hash-1))
    (enc price nb-0 (pubk c)) (enc price nb-1 (pubk c))
    (enc price nb-0 m price (pubk c)) (enc c price goods-0 (pubk m))
    (enc c price nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c price goods (pubk m)))
      (send (enc price nb-0 m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c price nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          (enc price nb (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc price nb-1 (pubk c)))))
    ((send (enc c price goods-0 (pubk m)))
      (recv (enc price nb-0 m price (pubk c)))
      (send (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-2 nb-0 price (pubk hash-2))
            (privk b-0)) (enc price nb-2 (pubk c))))))
  (label 159)
  (parent 88)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 nm price-0
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (5 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-1 (pubk c))
    (enc nc nb-0 m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 160)
  (parent 88)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 nb-0 goods-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc price) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc price) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc price)
    (nm nb-0) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (4 3)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
    (enc price nb-0 (pubk c)) (enc price nb-0 m price (pubk c))
    (enc c price goods-0 (pubk m))
    (enc c price nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c price goods (pubk m)))
      (send (enc price nb-0 m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c price nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          (enc price nb (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c)))))
    ((send (enc c price goods-0 (pubk m)))
      (recv (enc price nb-0 m price (pubk c)))
      (send (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc price nb-1 (pubk c))))))
  (label 161)
  (parent 89)
  (seen 261)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 acctnum-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 6 4 customer 3) nb-0 (5 0)
    (enc nc nb-0 m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 162)
  (parent 90)
  (seen 88 164)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum nb-0 goods nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (4 0))
    ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 163)
  (parent 92)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 goods-0 acctnum-1 nb-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (5 0)) ((3 4) (1 0)) ((4 1) (3 3))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 6 3 customer 3) nb-0 (5 0)
    (enc nc nb-0 m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 164)
  (parent 95)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nm price-0 acctnum goods text) (c hash b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (0 0)) ((3 0) (2 0))
    ((3 2) (1 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk b) (privk m))
  (uniq-orig nc nb price nm)
  (operation generalization deleted (2 0))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 165)
  (parent 97)
  (seen 96)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb nb-0 acctnum goods text) (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm acctnum) (goods goods)
    (price acctnum) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb)
    (price acctnum) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb-0)
    (price acctnum) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb acctnum)
    (price acctnum) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm acctnum)
    (goods goods) (price acctnum) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nc nb acctnum)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc acctnum m acctnum (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb acctnum (pubk hash)) (privk m))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c)))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 acctnum acctnum (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc acctnum acctnum acctnum (pubk hash-1))
            (privk b)) (enc nc acctnum (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc acctnum m acctnum (pubk c)))
      (send (enc c nc acctnum acctnum acctnum (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))))
  (label 166)
  (parent 98)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price goods nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 167)
  (parent 99)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods nb-0 goods-0 text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum nb-0)) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc nb-0 nb-0 nb-0 (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          nb-0))))
  (label 168)
  (parent 100)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-1)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((0 1) (4 0)) ((1 1) (0 2)) ((2 1) (3 3))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 169)
  (parent 100)
  (seen 103)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 nm price text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 0) (4 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c)))))
  (label 170)
  (parent 100)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (3 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 5 3 customer 3) nb-0 (4 0)
    (enc nc nb-0 m nb-0 (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 171)
  (parent 101)
  (seen 100)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price nb-0 goods-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) price))))
  (label 172)
  (parent 103)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (4 3)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 173)
  (parent 103)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 0) (5 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 174)
  (parent 103)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 175)
  (parent 104)
  (seen 103)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price goods nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 176)
  (parent 105)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (5 3)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation encryption-test (displaced 6 2 bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 177)
  (parent 106)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 2) (3 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 178)
  (parent 106)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (5 3)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation encryption-test (displaced 6 2 bank 2)
    (enc (enc "hash" c nc price-0 price-0 price-0 (pubk hash-1))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 179)
  (parent 107)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (5 3))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation encryption-test (displaced 6 3 bank 2)
    (enc (enc "hash" c nc price price price (pubk hash-1)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price))))
  (label 180)
  (parent 107)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum nb-0 nm price-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 2) (3 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc price price price (pubk hash-1)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 181)
  (parent 107)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price nb-0 acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nb-0 nb price price (pubk hash))
    (enc nb-0 nb (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))))
  (label 182)
  (parent 108)
  (seen 202)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc nb-0 nm m price-0 (pubk c)) (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 183)
  (parent 109)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price goods-0 nb-0 text)
    (m c hash b hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (5 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-2))
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b)) (enc nb-0 price (pubk c))))))
  (label 184)
  (parent 110)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand customer 5 (acctnum price) (nb price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-2))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 2) (2 0)) ((5 2) (4 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 2 6 customer 5) price (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-2))
    (enc "hash" c nb-0 goods-1 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) price))))
  (label 185)
  (parent 110)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (6 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 7 2 customer 3) nb-0 (5 0)
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 186)
  (parent 111)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0))))
  (label 187)
  (parent 112)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((2 1) (4 3)) ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 188)
  (parent 112)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 189)
  (parent 113)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price goods-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) goods-0))))
  (label 190)
  (parent 114)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((2 1) (4 3)) ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 191)
  (parent 114)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) goods-0))))
  (label 192)
  (parent 115)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (4 3)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price goods-0)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-2))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 193)
  (parent 115)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc goods-0 price m price (pubk c)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))))
  (label 194)
  (parent 116)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 195)
  (parent 117)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (6 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 7 2 customer 3) nb-0 (6 0)
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 196)
  (parent 118)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation encryption-test (displaced 6 2 bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 197)
  (parent 119)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 acctnum-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 198)
  (parent 119)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price goods-0 nm)
  (operation encryption-test (displaced 6 2 bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) goods-0))))
  (label 199)
  (parent 120)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (5 3))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation encryption-test (displaced 6 3 bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0))))
  (label 200)
  (parent 120)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nm price-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))))
  (label 201)
  (parent 120)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods text) (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 2 4 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 202)
  (parent 121)
  (seen 96)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 203)
  (parent 122)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price goods-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))))
  (label 204)
  (parent 123)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 2 5 customer 5) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc goods-1 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price))))
  (label 205)
  (parent 123)
  (seen 282)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods text) (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc acctnum)
    (nm price) (goods goods) (price price) (b b) (c c) (m m)
    (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nb price acctnum)
  (operation nonce-test (displaced 2 4 customer 5) nb (0 2)
    (enc "hash" c acctnum-0 nb price price (pubk hash))
    (enc acctnum-0 nb (pubk c)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods price price (pubk hash-0))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))))
  (label 206)
  (parent 124)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (4 0)) ((2 2) (3 0))
    ((3 1) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price acctnum nm)
  (operation nonce-test (contracted (goods-0 goods)) acctnum (0 0)
    (enc acctnum nm m price-0 (pubk c)) (enc c acctnum goods (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods price price (pubk hash-0))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c)))))
  (label 207)
  (parent 125)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb acctnum goods nb-0 text) (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (goods goods) (price nb-0) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb goods)
    (price nb-0) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0)
  (operation nonce-test (contracted (goods-0 goods)) acctnum (0 0)
    (enc c acctnum goods (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods (pubk c))))))
  (label 208)
  (parent 126)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum goods-0 nb-0 nm price text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (nb goods-0) (price nb-0) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0 nm)
  (operation nonce-test (added-strand merchant 2) acctnum (0 0)
    (enc c acctnum goods-0 (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods-0 (pubk c)))))
    ((recv (enc c acctnum goods-0 (pubk m)))
      (send (enc acctnum nm m price (pubk c)))))
  (label 209)
  (parent 126)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0)
  (operation encryption-test (displaced 5 2 bank 2)
    (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
      (privk b-0)) (4 3))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 210)
  (parent 127)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
      (privk b-0)) (4 3))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c acctnum-0 nb-0 acctnum-1 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))))
  (label 211)
  (parent 127)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (4 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 212)
  (parent 128)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (6 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 7 2 customer 3) nb-0 (6 0)
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 213)
  (parent 129)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (5 0)) ((2 2) (3 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((5 1) (6 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 7 5 merchant 2) nb-0 (6 0)
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 214)
  (parent 129)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum goods-0 nb-0 nm price-0 nm-0 price-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nb-0) (nm nm-0) (goods goods-0)
    (price price-1) (c c) (m m))
  (precedes ((0 1) (2 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (5 0)) ((2 0) (7 0)) ((2 2) (3 0)) ((3 1) (4 0))
    ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm nm-0)
  (operation nonce-test (added-strand merchant 2) nb-0 (6 0)
    (enc nb-0 price m price (pubk c)) (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm-0 m price-1 (pubk c)))))
  (label 215)
  (parent 129)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation encryption-test (displaced 6 2 bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 216)
  (parent 130)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 acctnum-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 217)
  (parent 130)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nb price goods-0 nm)
  (operation encryption-test (displaced 6 2 bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) goods-0))))
  (label 218)
  (parent 131)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (5 3))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation encryption-test (displaced 6 3 bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0))))
  (label 219)
  (parent 131)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nm price-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))))
  (label 220)
  (parent 131)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 221)
  (parent 132)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 6 2 customer 3) price (5 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 222)
  (parent 133)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((3 1) (1 0)) ((4 1) (3 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price acctnum nm)
  (operation nonce-test (contracted (goods-0 goods)) acctnum (0 0)
    (enc c acctnum goods (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods price price (pubk hash-0))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c)))))
  (label 223)
  (parent 134)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum goods-0 nb-0 nm price text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (nb goods-0) (price nb-0) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
    (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
    (enc acctnum nb-0 (pubk c)) (enc acctnum nb-0 m nb-0 (pubk c))
    (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods-0 (pubk c)))))
    ((recv (enc c acctnum goods-0 (pubk m)))
      (send (enc acctnum nm m price (pubk c)))))
  (label 224)
  (parent 135)
  (seen 209)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 nm price goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb-0 (1 0)
    (enc "hash" c acctnum-0 goods-1 nb-0 nb-0 (pubk hash-1))
    (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
    (enc acctnum-0 nb-0 (pubk c)) (enc acctnum-0 nb-0 m nb-0 (pubk c))
    (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price (pubk c))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 225)
  (parent 135)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (4 0))
    ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc nb-0 nm m price-0 (pubk c)) (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 226)
  (parent 137)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nb-1 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b)) (enc nb-0 nb-1 (pubk c))))))
  (label 227)
  (parent 138)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum price) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (3 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 3))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0))
    ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 228)
  (parent 138)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm nb-1) (goods goods)
    (price nb-1) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm nb-1) (nb nb)
    (price nb-1) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-0)
    (price nb-1) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm nb-1) (goods goods-0) (price nb-1) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-1)
    (price nb-1) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb nb-0 nb-1)
  (operation nonce-test (displaced 5 4 bank 2) price (1 0)
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nb-1 m nb-1 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-1 (pubk hash)) (privk m))))
    ((recv (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 nb-1 m nb-1 (pubk c)))
      (send (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 nb-1 nb-1 (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 229)
  (parent 138)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (5 0)) ((3 4) (1 0)) ((4 1) (3 3))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 3 customer 3) price (5 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 230)
  (parent 139)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nm price-0 acctnum goods text) (c hash b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 0) (2 0)) ((3 2) (1 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk b) (privk m))
  (uniq-orig nc nb price nm)
  (operation generalization deleted (2 0))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 231)
  (parent 140)
  (seen 96)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price goods nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))))
  (label 232)
  (parent 141)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 233)
  (parent 142)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (5 3)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0)) ((5 2) (2 0))
    ((5 2) (4 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation encryption-test (displaced 6 2 bank 2)
    (enc (enc "hash" c nc price-0 price-0 price-0 (pubk hash-1))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 234)
  (parent 143)
  (seen 276 277)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum nb-0 nm price-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0))
    ((5 2) (2 0)) ((5 2) (4 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc price price price (pubk hash-1)) (privk b-0))
    (5 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 235)
  (parent 143)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c))))))
  (label 236)
  (parent 144)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (3 0))
    ((2 2) (4 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 6 2 customer 3) price (5 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 237)
  (parent 145)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price acctnum nm)
  (operation nonce-test (contracted (goods-0 goods)) acctnum (0 0)
    (enc c acctnum goods (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods price price (pubk hash-0))
            (privk b)) (enc acctnum goods (pubk c))))))
  (label 238)
  (parent 146)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum goods-0 nb-0 nm price text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (nb goods-0) (price nb-0) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
    (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
    (enc acctnum nb-0 (pubk c)) (enc acctnum nb-0 m nb-0 (pubk c))
    (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum goods-0 (pubk m)))
      (send (enc acctnum nm m price (pubk c))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods-0 (pubk c))))))
  (label 239)
  (parent 147)
  (seen 209)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 nm price goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0)) ((5 2) (2 0))
    ((5 2) (4 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb-0 (1 0)
    (enc "hash" c acctnum-0 goods-1 nb-0 nb-0 (pubk hash-1))
    (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
    (enc acctnum-0 nb-0 (pubk c)) (enc acctnum-0 nb-0 m nb-0 (pubk c))
    (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price (pubk c))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 240)
  (parent 147)
  (seen 338)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0))))
  (label 241)
  (parent 148)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 242)
  (parent 149)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 acctnum-1
      nb-1 text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0))
    ((4 2) (5 0)) ((4 4) (1 0)) ((5 1) (4 3)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand bank 2) price (5 0)
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 243)
  (parent 150)
  (unrealized (0 0) (0 2) (1 0) (5 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 nb-1 nm price-0 acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (5 1)) ((1 1) (5 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (0 0)) ((5 0) (4 0)) ((5 2) (2 0)) ((5 2) (3 0))
    ((5 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb (0 2)
    (enc "hash" c nc nb nb-0 price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))))
  (label 244)
  (parent 152)
  (seen 32)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b)) (enc nc nb-0 (pubk c))))))
  (label 245)
  (parent 153)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 246)
  (parent 153)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 4 bank 2) nc (5 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-0))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nb-0 goods-0 (pubk c))))))
  (label 247)
  (parent 154)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 6 2 customer 3) nc (5 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 248)
  (parent 154)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb price) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price acctnum-0)
  (operation nonce-test (displaced 6 2 customer 3) nc (5 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb price price (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 price m price (pubk c)))
      (send (enc c acctnum-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 price price price (pubk hash-0))
            (privk b-0)) (enc acctnum-0 price (pubk c)))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc
            (enc "hash" c acctnum-0 goods-0 price price (pubk hash-2))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c))))))
  (label 249)
  (parent 154)
  (seen 126 127)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (6 0)) ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (5 0)
    (enc nc price m price (pubk c)) (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 250)
  (parent 154)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-0))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 251)
  (parent 155)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nc
    (1 0) (enc "hash" c nc price price price (pubk hash-0))
    (enc "hash" c nc nb-0 price price (pubk hash-1))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc price acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 252)
  (parent 156)
  (seen 246)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (5 0)) ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-0))
    (enc "hash" c nc nb-0 price price (pubk hash-1))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 253)
  (parent 156)
  (seen 250 388)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb-0 (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-0))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
    (enc nb-0 price (pubk c)) (enc nb-0 nb-0 (pubk c))
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-0))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) nb-0))))
  (label 254)
  (parent 156)
  (seen 381)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum nb-0 nb-1 goods text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0))))
  (label 255)
  (parent 157)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 nb-1 goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (5 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0))
    ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 256)
  (parent 157)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (5 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 6 3 bank 2) nb-1 (5 0)
    (enc nc nb-1 m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 nb-0 price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 257)
  (parent 158)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb price) (nc nc)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 258)
  (parent 158)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 6 4 customer 3) nb-0 (5 0)
    (enc nc nb-0 m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 259)
  (parent 158)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm acctnum-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm acctnum-0)
    (nb acctnum-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm acctnum-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb acctnum-0) (nc nc)
    (nm acctnum-0) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm acctnum-0)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb acctnum-0)
  (operation nonce-test (displaced 6 4 customer 3) nb-1 (5 0)
    (enc nc nb-1 m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc acctnum-0 m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum-0 price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb acctnum-0 (pubk hash)) (privk m))))
    ((recv (enc c nc acctnum-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum-0 price (pubk hash))
            (privk b)) (enc nc nb (pubk c)))))
    ((recv (enc c nc acctnum-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc acctnum-0 acctnum-0 price (pubk hash-0))
            (privk b-0)) (enc nc acctnum-0 (pubk c)))))
    ((recv (enc c nc acctnum-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 acctnum-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc acctnum-0 m price (pubk c)))
      (send (enc c nc acctnum-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc acctnum-0 acctnum-0 price (pubk hash-0))
            (privk b-0)) (enc nc acctnum-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc acctnum-0 acctnum-0 price (pubk hash-0))
            (privk b-0)) acctnum-0)))
    ((recv (enc c nc acctnum-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 acctnum-0 price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 260)
  (parent 158)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc price) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc price) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc price)
    (nm nb-0) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 0 merchant 2) nb-0 (5 0)
    (enc price nb-0 m price (pubk c)))
  (traces
    ((recv (enc c price goods (pubk m)))
      (send (enc price nb-0 m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c price nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          (enc price nb (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc price nb-1 (pubk c)))))
    ((send (enc c price goods-0 (pubk m)))
      (recv (enc price nb-0 m price (pubk c)))
      (send (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 261)
  (parent 159)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 nb-1 goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (5 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nc
    (1 0) (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-1 (pubk c))
    (enc nc nb-0 m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc nb-0 acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 262)
  (parent 160)
  (seen 255 256)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 nm price-0
      text) (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 0) (5 0)) ((4 2) (2 0))
    ((4 2) (3 0)) ((4 4) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-1 (pubk c))
    (enc nc nb-0 m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 nb-0 price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 263)
  (parent 160)
  (seen 403 408)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 nm price-0 nb-2
      text) (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc price) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc price) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc price)
    (nm nb-0) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand merchant 2 (nc price) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-2)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 0) (5 0)) ((4 2) (2 0))
    ((4 2) (3 0)) ((4 4) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
    (enc "hash" c price nb-1 nb-0 price (pubk hash-1))
    (enc price nb-0 (pubk c)) (enc price nb-1 (pubk c))
    (enc price nb-0 m price (pubk c)) (enc price nm m price-0 (pubk c))
    (enc c price goods-0 (pubk m))
    (enc c price nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c price goods (pubk m)))
      (send (enc price nb-0 m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c price nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          (enc price nb (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc price nb-1 (pubk c)))))
    ((send (enc c price goods-0 (pubk m)))
      (recv (enc price nb-0 m price (pubk c)))
      (send (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c price goods-0 (pubk m)))
      (send (enc price nm m price-0 (pubk c))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-2 nb-0 price (pubk hash-2))
            (privk b-0)) (enc price nb-2 (pubk c))))))
  (label 264)
  (parent 160)
  (seen 414)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 nb-0 goods-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc price) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc price) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc price)
    (nm nb-0) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (5 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 2 bank 2) nb-0 (5 0)
    (enc price nb-0 m price (pubk c)))
  (traces
    ((recv (enc c price goods (pubk m)))
      (send (enc price nb-0 m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c price nb-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c price nb nb-0 price (pubk hash)) (privk b))
          (enc price nb (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c)))))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c)))))
    ((send (enc c price goods-0 (pubk m)))
      (recv (enc price nb-0 m price (pubk c)))
      (send (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc price nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c price nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c price nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc price nb-1 (pubk c))))))
  (label 265)
  (parent 161)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc price) (nm acctnum-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc price) (nm acctnum-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm acctnum-0)
    (nb acctnum-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm acctnum-0)
    (nb acctnum-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb acctnum-0) (nc price)
    (nm acctnum-0) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc price) (nm acctnum-0)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price acctnum-0)
  (operation nonce-test (displaced 6 4 customer 3) nb-1 (5 0)
    (enc price nb-1 m price (pubk c)))
  (traces
    ((recv (enc c price goods (pubk m)))
      (send (enc price acctnum-0 m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c price nb acctnum-0 price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb acctnum-0 (pubk hash)) (privk m))))
    ((recv (enc c price acctnum-0 acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c price nb acctnum-0 price (pubk hash))
            (privk b)) (enc price nb (pubk c)))))
    ((recv (enc c price acctnum-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc
            (enc "hash" c price acctnum-0 acctnum-0 price (pubk hash-0))
            (privk b-0)) (enc price acctnum-0 (pubk c)))))
    ((recv (enc c price acctnum-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc
            (enc "hash" c price acctnum-0 acctnum-0 price (pubk hash-0))
            (privk b-0)) (enc price acctnum-0 (pubk c)))))
    ((send (enc c price goods-0 (pubk m)))
      (recv (enc price acctnum-0 m price (pubk c)))
      (send (enc c price acctnum-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc
            (enc "hash" c price acctnum-0 acctnum-0 price (pubk hash-0))
            (privk b-0)) (enc price acctnum-0 (pubk c))))
      (send
        (cat
          (enc
            (enc "hash" c price acctnum-0 acctnum-0 price (pubk hash-0))
            (privk b-0)) acctnum-0)))
    ((recv (enc c price acctnum-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price nb-0 acctnum-0 price (pubk hash-1))
            (privk b-0)) (enc price nb-0 (pubk c))))))
  (label 266)
  (parent 161)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 nb-1 goods-0 acctnum-1
      nb-2 text) (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-2)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 2) (5 0)) ((4 4) (1 0)) ((5 1) (4 3)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (added-strand bank 2) nb-0 (5 0)
    (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-2 nb-0 price (pubk hash-2))
            (privk b-0)) (enc nc nb-2 (pubk c))))))
  (label 267)
  (parent 162)
  (seen 164)
  (unrealized (0 0) (0 2) (1 0) (5 0) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 nb-0 goods-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (4 0))
    ((2 4) (1 0)) ((3 1) (2 3)) ((4 1) (3 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (acctnum-1 acctnum-0)) nb-0 (4 0)
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 268)
  (parent 164)
  (unrealized (0 0) (0 2) (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 goods-0 acctnum-1 nb-0 nb-1
      text) (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb price) (nc nc)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (3 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 2) (5 0)) ((3 4) (1 0))
    ((4 1) (3 3)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) price (4 0)
    (enc "hash" c nc nb-0 price price (pubk hash-1))
    (enc nc price m price (pubk c))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 price price (pubk hash-2))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 269)
  (parent 164)
  (unrealized (0 0) (0 2) (1 0) (4 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 goods-0 acctnum-1 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (5 0)) ((3 4) (1 0)) ((4 1) (3 3))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 6 5 bank 2) nb-1 (4 0)
    (enc "hash" c nc nb-0 nb-1 price (pubk hash-1))
    (enc nc nb-1 m price (pubk c))
    (enc c nc nb-1 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 270)
  (parent 164)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum acctnum-0 nb-0 goods-0 acctnum-1 nb-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nc) (nm nb-0) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (4 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (5 0)) ((3 4) (1 0)) ((4 1) (3 3))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 6 2 bank 2) nb-0 (4 0)
    (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
    (enc nc nb-0 m price (pubk c))
    (enc c nc nb-0 acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m price (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum price (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m price (pubk c)))
      (send (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 price (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 271)
  (parent 164)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb acctnum goods text) (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm acctnum) (goods goods)
    (price acctnum) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb)
    (price acctnum) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb acctnum)
    (price acctnum) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm acctnum)
    (goods goods) (price acctnum) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (3 1)) ((1 1) (3 3)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb acctnum)
  (operation generalization deleted (2 0))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc acctnum m acctnum (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb acctnum (pubk hash)) (privk m))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c)))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc acctnum acctnum acctnum (pubk hash-0))
            (privk b)) (enc nc acctnum (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc acctnum m acctnum (pubk c)))
      (send (enc c nc acctnum acctnum acctnum (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))))
  (label 272)
  (parent 166)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb nb-0 nm price acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm acctnum) (goods goods)
    (price acctnum) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb)
    (price acctnum) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb-0)
    (price acctnum) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb acctnum)
    (price acctnum) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm acctnum)
    (goods goods) (price acctnum) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (5 1)) ((1 1) (5 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (0 0)) ((5 0) (4 0)) ((5 2) (2 0)) ((5 2) (3 0))
    ((5 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nc nb nm acctnum)
  (operation nonce-test (displaced 2 6 customer 5) nb (0 2)
    (enc "hash" c nc nb price-0 price-0 (pubk hash))
    (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc acctnum m acctnum (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb acctnum (pubk hash)) (privk m))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c)))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 acctnum acctnum (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc acctnum acctnum acctnum (pubk hash-1))
            (privk b)) (enc nc acctnum (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc acctnum m acctnum (pubk c)))
      (send (enc c nc acctnum acctnum acctnum (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))))
  (label 273)
  (parent 167)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb nb-0 goods text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods) (price nb-0) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          nb-0))))
  (label 274)
  (parent 168)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nc nb goods nb-0 goods-0 nm price text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (4 0))
    ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c)))))
  (label 275)
  (parent 168)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods nb-0 goods-0 nm price text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 0) (4 0)) ((3 2) (2 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum nb-0)) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc nc nm m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 nb-0 nb-0 (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c)))))
  (label 276)
  (parent 170)
  (seen 275)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 nm price nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-1)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 3))
    ((3 0) (0 0)) ((3 0) (4 0)) ((3 2) (2 0)) ((3 4) (1 0))
    ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc nc nm m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 277)
  (parent 170)
  (seen 174)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 acctnum-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-1)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0))
    ((4 1) (3 3)) ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (added-strand bank 2) nb-0 (4 0)
    (enc nc nb-0 m nb-0 (pubk c)) (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 278)
  (parent 171)
  (seen 285)
  (unrealized (0 0) (0 2) (1 0) (4 0) (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 goods text) (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) price))))
  (label 279)
  (parent 172)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price nb-0 goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 3))
    ((4 0) (5 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0))
    ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) price)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 280)
  (parent 172)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb goods-0)
    (price nb-0) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (5 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb nb-0)
  (operation nonce-test (displaced 6 2 bank 2) price (5 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 nb-0 nb-0 (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 281)
  (parent 173)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) price)))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 282)
  (parent 173)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price nb-0 goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 0) (5 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) price)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 283)
  (parent 174)
  (seen 280)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (4 3)) ((4 0) (0 0)) ((4 0) (5 0)) ((4 2) (2 0))
    ((4 2) (3 0)) ((4 4) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 284)
  (parent 174)
  (seen 441 443)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (5 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 6 2 bank 2) price (5 0)
    (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 285)
  (parent 175)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 goods-0 acctnum-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 2) (5 0)) ((4 4) (1 0)) ((5 1) (4 3)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price)
  (operation nonce-test (added-strand bank 2) price (5 0)
    (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 price price (pubk hash-2))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 286)
  (parent 175)
  (seen 285)
  (unrealized (0 0) (0 2) (1 0) (5 0) (6 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb nb-0 nm price acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm acctnum) (goods goods)
    (price acctnum) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb)
    (price acctnum) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb-0)
    (price acctnum) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb acctnum)
    (price acctnum) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm acctnum)
    (goods goods) (price acctnum) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (5 1)) ((1 1) (5 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nc nb nm acctnum)
  (operation nonce-test (displaced 2 6 customer 5) nb (0 2)
    (enc "hash" c nc nb price-0 price-0 (pubk hash))
    (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc acctnum m acctnum (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb acctnum (pubk hash)) (privk m))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c)))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 acctnum acctnum (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc acctnum acctnum acctnum (pubk hash-1))
            (privk b)) (enc nc acctnum (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc acctnum m acctnum (pubk c)))
      (send (enc c nc acctnum acctnum acctnum (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))))
  (label 287)
  (parent 176)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods nb-0 nm price goods-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (5 3)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum nb-0)) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc nc nm m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 nb-0 nb-0 (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          nb-0))))
  (label 288)
  (parent 177)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-1)
    (price nb-0) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 2) (3 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc nc nm m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 nb-0 (pubk hash-2))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 289)
  (parent 177)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 2) (6 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (displaced 7 5 customer 3) nb-0 (6 0)
    (enc nc nb-0 m nb-0 (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 290)
  (parent 178)
  (seen 177)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods nb-0 nm price goods-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (5 3)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum nb-0)) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc nc nm m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 nb-0 nb-0 (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0)) (privk b))
          nb-0))))
  (label 291)
  (parent 179)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-1)
    (price nb-0) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 2) (3 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
    (enc nc nb-0 (pubk c)) (enc nc nb-0 m nb-0 (pubk c))
    (enc nc nm m price (pubk c)) (enc c nc goods-0 (pubk m))
    (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-1 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc nc nb-1 (pubk c))))))
  (label 292)
  (parent 179)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price nb-0 nm price-0 goods-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (5 3))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) price))))
  (label 293)
  (parent 180)
  (seen 280)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nb-0 nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (5 3)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 2) (3 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand bank 2) nc (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc nb-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc nb-0 (pubk c))
    (enc nc price m price (pubk c)) (enc nc nm m price-0 (pubk c))
    (enc c nc goods-0 (pubk m)) (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nc goods-0 (pubk c))))))
  (label 294)
  (parent 180)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum nb-0 nm price-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 2) (6 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 7 5 customer 3) price (6 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 295)
  (parent 181)
  (seen 457)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price nb-0 nm price-0 acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (5 1)) ((1 1) (5 3)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (0 0)) ((5 0) (4 0)) ((5 2) (2 0)) ((5 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb (0 2)
    (enc "hash" c nb-0 nb price price (pubk hash))
    (enc nb-0 nb (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))))
  (label 296)
  (parent 183)
  (seen 329)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price goods nb-0 text)
    (m c hash b hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (5 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b)) (enc nb-0 price (pubk c))))))
  (label 297)
  (parent 184)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (6 0)) ((2 2) (3 0))
    ((2 2) (5 0)) ((3 1) (4 0)) ((4 1) (1 0)) ((5 1) (1 0))
    ((6 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nb-0 (0 0)
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 298)
  (parent 184)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand customer 5 (acctnum price) (nb price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-2))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (5 3)) ((5 0) (0 0)) ((5 2) (2 0)) ((5 2) (4 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation encryption-test (displaced 6 4 bank 2)
    (enc (enc "hash" c nb-0 price price price (pubk hash-2))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) price))))
  (label 299)
  (parent 185)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum nb-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand customer 5 (acctnum price) (nb price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-2))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 2) (2 0))
    ((5 2) (4 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nb-0 price price price (pubk hash-2))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) price)))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 300)
  (parent 185)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (6 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (5 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-2))
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 301)
  (parent 186)
  (seen 298)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum nb-0 nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-2))
  (precedes ((0 1) (6 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (4 0)) ((6 0) (0 0)) ((6 0) (5 0))
    ((6 2) (2 0)) ((6 2) (4 0)) ((6 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 7 customer 5) price (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-2))
    (enc "hash" c nb-0 goods-1 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) price))))
  (label 302)
  (parent 186)
  (unrealized (0 0) (0 2) (1 0) (6 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0))))
  (label 303)
  (parent 187)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (5 0)) ((4 2) (2 0)) ((4 4) (1 0))
    ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nb-0 (0 0)
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 304)
  (parent 187)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 305)
  (parent 188)
  (unrealized (0 0) (0 2) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (acctnum-1 acctnum-0)) price (5 0)
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 306)
  (parent 189)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 2 bank 2) price (5 0)
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 307)
  (parent 189)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (4 3)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) price (5 0)
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-2))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 308)
  (parent 189)
  (unrealized (0 0) (0 2) (1 0) (5 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods text) (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc goods) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb goods) (nc goods)
    (nm price) (goods goods) (price price) (b b) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price goods)
  (operation nonce-test (contracted (goods-0 goods)) goods (0 0)
    (enc c goods goods (pubk m)))
  (traces
    ((recv (enc c goods goods (pubk m)))
      (send (enc goods price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods nb price price (pubk hash))
            (privk b)) (enc goods nb (pubk c)))))
    ((recv (enc c goods price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods goods price price (pubk hash-0))
            (privk b)) (enc goods goods (pubk c)))))
    ((recv (enc c goods price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods goods price price (pubk hash-0))
            (privk b)) (enc goods goods (pubk c)))))
    ((send (enc c goods goods (pubk m)))
      (recv (enc goods price m price (pubk c)))
      (send (enc c goods price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods goods price price (pubk hash-0))
            (privk b)) (enc goods goods (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods goods price price (pubk hash-0))
            (privk b)) goods))))
  (label 309)
  (parent 190)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b) (c c) (m m)
    (hash hash-0))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (5 0)) ((4 2) (2 0)) ((4 4) (1 0))
    ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (added-strand merchant 2) goods-0 (0 0)
    (enc c goods-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) goods-0)))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c)))))
  (label 310)
  (parent 190)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc goods-0 price m price (pubk c)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 311)
  (parent 191)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods text) (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb goods) (nc goods)
    (nm price) (goods goods) (price price) (b b) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price goods)
  (operation nonce-test (contracted (goods-0 goods)) goods (0 0)
    (enc c goods goods (pubk m)))
  (traces
    ((recv (enc c goods goods (pubk m)))
      (send (enc goods price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods nb price price (pubk hash))
            (privk b)) (enc goods nb (pubk c)))))
    ((recv (enc c goods price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods goods price price (pubk hash-0))
            (privk b)) (enc goods goods (pubk c)))))
    ((recv (enc c goods price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods goods price price (pubk hash-1))
            (privk b)) (enc goods goods (pubk c)))))
    ((send (enc c goods goods (pubk m)))
      (recv (enc goods price m price (pubk c)))
      (send (enc c goods price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods goods price price (pubk hash-1))
            (privk b)) (enc goods goods (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods goods price price (pubk hash-1))
            (privk b)) goods))))
  (label 312)
  (parent 192)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b) (c c) (m m)
    (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (4 3))
    ((4 0) (5 0)) ((4 2) (2 0)) ((4 4) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (added-strand merchant 2) goods-0 (0 0)
    (enc c goods-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) goods-0)))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c)))))
  (label 313)
  (parent 192)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (4 3))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0)) ((4 4) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price goods-0)
  (operation nonce-test (displaced 6 4 customer 3) price (5 0)
    (enc goods-0 price m price (pubk c)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-2))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 314)
  (parent 193)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation nonce-test (contracted (acctnum-1 acctnum-0)) price (5 0)
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))))
  (label 315)
  (parent 194)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 4) (1 0))
    ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0)
  (operation nonce-test (displaced 6 2 bank 2) price (5 0)
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))))
  (label 316)
  (parent 194)
  (seen 115)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 acctnum-1 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (4 3)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price goods-0)
  (operation nonce-test (added-strand bank 2) price (5 0)
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-2))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 317)
  (parent 194)
  (unrealized (0 0) (0 2) (1 0) (5 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price nb-0 nm price-0 acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (5 1)) ((1 1) (5 3)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb (0 2)
    (enc "hash" c nb-0 nb price price (pubk hash))
    (enc nb-0 nb (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))))
  (label 318)
  (parent 195)
  (seen 373)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (6 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-2))
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b)) (enc nb-0 price (pubk c))))))
  (label 319)
  (parent 196)
  (seen 298)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum nb-0 nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand customer 5 (acctnum price) (nb price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-2))
  (precedes ((0 1) (6 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 0) (0 0)) ((6 0) (4 0))
    ((6 2) (2 0)) ((6 2) (5 0)) ((6 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 7 customer 5) price (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-2))
    (enc "hash" c nb-0 goods-1 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) price))))
  (label 320)
  (parent 196)
  (seen 467)
  (unrealized (0 0) (0 2) (1 0) (6 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0))))
  (label 321)
  (parent 197)
  (seen 304)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((2 1) (5 3)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0))
    ((5 0) (4 0)) ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 322)
  (parent 197)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 acctnum-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (6 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 7 5 customer 3) price (6 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 323)
  (parent 198)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) goods-0))))
  (label 324)
  (parent 199)
  (seen 310)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((2 1) (5 3)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0))
    ((5 0) (4 0)) ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 325)
  (parent 199)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (5 3))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) goods-0))))
  (label 326)
  (parent 200)
  (seen 313)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (5 3)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-2))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 327)
  (parent 200)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nm price-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (6 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (displaced 7 5 customer 3) price (6 0)
    (enc goods-0 price m price (pubk c)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))))
  (label 328)
  (parent 201)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (0 0))
    ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 329)
  (parent 203)
  (seen 165)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price goods text) (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))))
  (label 330)
  (parent 204)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (added-strand merchant 2) nc (0 0)
    (enc c nc goods-0 (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 331)
  (parent 204)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c nc price price price (pubk hash-1)) (privk b-0))
    (4 3))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 332)
  (parent 205)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods text) (c hash b m name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc acctnum)
    (nm price) (goods goods) (price price) (b b) (c c) (m m)
    (hash hash))
  (precedes ((0 1) (2 1)) ((1 1) (2 3)) ((2 0) (0 0)) ((2 2) (1 0))
    ((2 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk b) (privk m))
  (uniq-orig nb price acctnum)
  (operation generalization deleted (2 0))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))))
  (label 333)
  (parent 206)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc acctnum)
    (nm price) (goods goods) (price price) (b b) (c c) (m m)
    (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (0 0))
    ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nb price nm acctnum)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c acctnum-0 nb price price (pubk hash))
    (enc acctnum-0 nb (pubk c)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods price price (pubk hash-0))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))))
  (label 334)
  (parent 207)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb nb-0 acctnum goods text) (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb goods)
    (price nb-0) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc acctnum) (nm nb-0)
    (goods goods) (price nb-0) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nb nb-0 acctnum)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
    (enc acctnum-0 nb (pubk c)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))))
  (label 335)
  (parent 208)
  (seen 206)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb acctnum goods nb-0 nm price text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (goods goods) (price nb-0) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb goods)
    (price nb-0) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods) (price price)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) acctnum (0 0)
    (enc acctnum nm m price (pubk c)) (enc c acctnum goods (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price (pubk c)))))
  (label 336)
  (parent 209)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum nb-0 goods-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (nb goods-0) (price nb-0) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc acctnum)
    (nm nb-0) (goods goods-0) (price nb-0) (b b) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) acctnum
    (1 0) (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
    (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
    (enc acctnum nb-0 (pubk c)) (enc acctnum goods-0 (pubk c))
    (enc acctnum nb-0 m nb-0 (pubk c)) (enc c acctnum goods-0 (pubk m))
    (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods-0 (pubk c)))))
    ((send (enc c acctnum goods-0 (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) nb-0))))
  (label 337)
  (parent 210)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 goods-0 nm price text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (5 0)) ((4 2) (2 0)) ((4 2) (3 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0 nm)
  (operation nonce-test (added-strand merchant 2) acctnum-0 (1 0)
    (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
    (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
    (enc acctnum-0 nb-0 (pubk c)) (enc acctnum-0 goods-0 (pubk c))
    (enc acctnum-0 nb-0 m nb-0 (pubk c))
    (enc c acctnum-0 goods-0 (pubk m))
    (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price (pubk c)))))
  (label 338)
  (parent 210)
  (unrealized (0 0) (0 2) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0)
  (operation nonce-test (displaced 6 4 customer 3) nb-0 (5 0)
    (enc acctnum-0 nb-0 m nb-0 (pubk c)))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c acctnum-0 nb-0 acctnum-1 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))))
  (label 339)
  (parent 211)
  (seen 210)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price nb-0 nm price-0 acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (5 1)) ((1 1) (5 3)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 6 customer 5) nb (0 2)
    (enc "hash" c nb-0 nb price price (pubk hash))
    (enc nb-0 nb (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods price price (pubk hash-1))
            (privk b)) (enc nb-0 goods (pubk c)))))
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))))
  (label 340)
  (parent 212)
  (seen 354)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (6 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((6 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-2))
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b)) (enc nb-0 price (pubk c))))))
  (label 341)
  (parent 213)
  (seen 298)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum nb-0 nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand customer 5 (acctnum price) (nb price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-2))
  (precedes ((0 1) (6 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 1) (1 0)) ((6 0) (0 0)) ((6 0) (4 0))
    ((6 2) (2 0)) ((6 2) (5 0)) ((6 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 2 7 customer 5) price (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-2))
    (enc "hash" c nb-0 goods-1 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) price))))
  (label 342)
  (parent 213)
  (unrealized (0 0) (0 2) (1 0) (6 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (6 0)) ((3 1) (4 0)) ((4 1) (1 0))
    ((5 1) (4 0)) ((5 1) (6 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 7 2 customer 3) nb-0 (6 0)
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm m price-0 (pubk c))
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 343)
  (parent 214)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum goods-0 nb-0 nm price-0 nm-0 price-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nb-0) (nm nm-0) (goods goods-0)
    (price price-1) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 0) (7 0)) ((2 2) (3 0)) ((2 2) (6 0)) ((3 1) (4 0))
    ((4 1) (1 0)) ((5 1) (4 0)) ((6 1) (1 0)) ((7 1) (6 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm nm-0)
  (operation nonce-test (displaced 8 2 customer 3) nb-0 (6 0)
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm-0 m price-1 (pubk c))
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm-0 m price-1 (pubk c)))))
  (label 344)
  (parent 215)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 nm-0 price-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc price-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc price-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc price-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc price-0) (nm price) (nb price-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc price-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc price-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc price-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (defstrand merchant 2 (nc price-0) (nm nm-0) (goods goods-0)
    (price price-1) (c c) (m m))
  (precedes ((0 1) (2 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 0) (0 0))
    ((2 0) (5 0)) ((2 0) (7 0)) ((2 2) (3 0)) ((3 1) (4 0))
    ((4 1) (1 0)) ((5 1) (4 0)) ((5 1) (6 0)) ((6 1) (1 0))
    ((7 1) (6 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nm price-0 nm-0)
  (operation nonce-test (displaced 8 5 merchant 2) nb-0 (6 0)
    (enc nb-0 price m price (pubk c)) (enc nb-0 nm-0 m price-1 (pubk c))
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c price-0 goods (pubk m)))
      (send (enc price-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c price-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c price-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c price-0 nb price price (pubk hash))
            (privk b)) (enc price-0 nb (pubk c)))))
    ((send (enc c price-0 goods-0 (pubk m)))
      (recv (enc price-0 price m price (pubk c)))
      (send (enc c price-0 price price price (pubk b-0))))
    ((recv (enc c price-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price-0 price-0 price price (pubk hash-0))
            (privk b-0)) (enc price-0 price-0 (pubk c)))))
    ((recv (enc c price-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc price-0 goods-0 (pubk c)))))
    ((recv (enc c price-0 goods-0 (pubk m)))
      (send (enc price-0 nm m price-0 (pubk c))))
    ((recv (enc c price-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c price-0 price price price (pubk hash-2))
            (privk b-0)) (enc price-0 price (pubk c)))))
    ((recv (enc c price-0 goods-0 (pubk m)))
      (send (enc price-0 nm-0 m price-1 (pubk c)))))
  (label 345)
  (parent 215)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0))))
  (label 346)
  (parent 216)
  (seen 304)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((2 1) (5 3)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0))
    ((5 0) (4 0)) ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 347)
  (parent 216)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 acctnum-1
      text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (6 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 7 5 customer 3) price (6 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))))
  (label 348)
  (parent 217)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((2 1) (5 3))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) goods-0))))
  (label 349)
  (parent 218)
  (seen 310)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((2 1) (5 3)) ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0))
    ((5 0) (4 0)) ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 350)
  (parent 218)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (5 3))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 4) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b)) goods-0))))
  (label 351)
  (parent 219)
  (seen 313)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nm price-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb nb-0) (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (3 0))
    ((3 1) (5 3)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 4) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb-0 price price (pubk hash-2))
            (privk b-0)) (enc goods-0 nb-0 (pubk c))))))
  (label 352)
  (parent 219)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nm price-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc goods-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-1) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (3 0)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (6 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price goods-0 nm)
  (operation nonce-test (displaced 7 5 customer 3) price (6 0)
    (enc goods-0 price m price (pubk c)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-0))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 goods-0 (pubk m)))
      (send (enc goods-0 nm m price-0 (pubk c))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) goods-0)))
    ((recv (enc c goods-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))))
  (label 353)
  (parent 220)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 354)
  (parent 221)
  (seen 231)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (3 0))
    ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))))
  (label 355)
  (parent 222)
  (seen 331)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0)) ((5 2) (2 0))
    ((5 2) (4 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 6 customer 5) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc goods-1 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price))))
  (label 356)
  (parent 222)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc acctnum)
    (nm price) (goods goods) (price price) (b b) (c c) (m m)
    (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nb price nm acctnum)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c acctnum-0 nb price price (pubk hash))
    (enc acctnum-0 nb (pubk c)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods price price (pubk hash-0))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))))
  (label 357)
  (parent 223)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb acctnum goods nb-0 nm price text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (goods goods) (price nb-0) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb goods)
    (price nb-0) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods) (price price)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (5 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (4 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) acctnum (0 0)
    (enc c acctnum goods (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price (pubk c)))))
  (label 358)
  (parent 224)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 nm price goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (5 3)) ((3 1) (1 0))
    ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0)) ((5 2) (2 0))
    ((5 2) (3 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0 nm)
  (operation encryption-test (displaced 6 2 bank 2)
    (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price (pubk c))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0))))
  (label 359)
  (parent 225)
  (unrealized (0 0) (0 2) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods acctnum acctnum-0 nb-0 nm price goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (3 0)) ((5 0) (0 0)) ((5 0) (4 0))
    ((5 2) (2 0)) ((5 2) (3 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price (pubk c))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c acctnum-0 nb-0 acctnum-1 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))))
  (label 360)
  (parent 225)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price acctnum goods nb-0 nb-1 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (goods-0 goods)) nb-0 (0 0)
    (enc c nb-0 goods (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b)) (enc nb-0 nb-1 (pubk c))))))
  (label 361)
  (parent 227)
  (unrealized (0 2))
  (comment "empty cohort"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nb-1 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (5 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (1 0))
    ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nb-0 (0 0)
    (enc c nb-0 goods-0 (pubk m)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b)) (enc nb-0 nb-1 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 362)
  (parent 227)
  (unrealized (0 0) (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum price) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 2) (5 0)) ((3 4) (1 0))
    ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 3 customer 3) price (5 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 363)
  (parent 228)
  (unrealized (0 0) (0 2) (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum goods-0 nb-0 nb-1 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm nb-1) (goods goods)
    (price nb-1) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm nb-1) (nb nb)
    (price nb-1) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm nb-1) (nb nb-0)
    (price nb-1) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm nb-1)
    (goods goods-0) (price nb-1) (b b) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm nb-1) (nb nb-1)
    (price nb-1) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (3 3)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb nb-0 nb-1)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-1
    (1 0) (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
    (enc "hash" c nb-0 nb-1 nb-1 nb-1 (pubk hash-1))
    (enc nb-0 nb-1 (pubk c)) (enc nb-0 nb-1 m nb-1 (pubk c))
    (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nb-1 m nb-1 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-1 (pubk hash)) (privk m))))
    ((recv (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 nb-1 m nb-1 (pubk c)))
      (send (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 nb-1 nb-1 (pubk hash-1))
            (privk b)) (enc nb-0 nb-1 (pubk c))))))
  (label 364)
  (parent 229)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 goods-0 nb-0 nb-1 nb-2 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm nb-1) (goods goods)
    (price nb-1) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm nb-1) (nb nb)
    (price nb-1) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-0)
    (price nb-1) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm nb-1) (goods goods-0) (price nb-1) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-1)
    (price nb-1) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-2)
    (price nb-1) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (3 1)) ((0 1) (5 0)) ((1 1) (0 2)) ((2 1) (3 3))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 2) (4 0)) ((3 4) (1 0))
    ((4 1) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb nb-0 nb-1)
  (operation nonce-test (added-strand bank 2) nb-1 (1 0)
    (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
    (enc "hash" c nb-0 nb-1 nb-1 nb-1 (pubk hash-1))
    (enc nb-0 nb-1 (pubk c)) (enc nb-0 nb-1 m nb-1 (pubk c))
    (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nb-1 m nb-1 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-1 (pubk hash)) (privk m))))
    ((recv (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 nb-1 m nb-1 (pubk c)))
      (send (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 nb-1 nb-1 (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c)))))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-2 nb-1 nb-1 (pubk hash-2))
            (privk b-0)) (enc nb-0 nb-2 (pubk c))))))
  (label 365)
  (parent 229)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (4 0))
    ((2 4) (1 0)) ((3 1) (2 3)) ((4 1) (3 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (acctnum-1 acctnum-0)) price (4 0)
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 366)
  (parent 230)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 acctnum-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum price) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (3 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (2 0)) ((3 2) (5 0)) ((3 4) (1 0))
    ((4 1) (3 3)) ((5 1) (4 0)) ((6 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (added-strand bank 2) price (4 0)
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 367)
  (parent 230)
  (unrealized (0 0) (0 2) (1 0) (4 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 goods-0 nb-0 acctnum-1 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm nb-1) (goods goods)
    (price nb-1) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm nb-1) (nb nb)
    (price nb-1) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-0)
    (price nb-1) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm nb-1) (goods goods-0) (price nb-1) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm nb-1) (nb nb-0)
    (price nb-1) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-1)
    (price nb-1) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (5 0)) ((3 4) (1 0)) ((4 1) (3 3))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb nb-0 nb-1)
  (operation nonce-test (displaced 6 5 bank 2) price (4 0)
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nb-1 m nb-1 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-1 (pubk hash)) (privk m))))
    ((recv (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 nb-1 m nb-1 (pubk c)))
      (send (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 nb-1 acctnum-1 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 nb-1 nb-1 (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 368)
  (parent 230)
  (seen 551)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 acctnum-1 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (3 1)) ((1 1) (0 2)) ((2 1) (4 0)) ((3 0) (0 0))
    ((3 2) (2 0)) ((3 2) (5 0)) ((3 4) (1 0)) ((4 1) (3 3))
    ((5 1) (4 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 6 2 bank 2) price (4 0)
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 369)
  (parent 230)
  (seen 553)
  (unrealized (0 0) (0 2) (1 0) (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb nb-0 nm price acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm acctnum) (goods goods)
    (price acctnum) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb)
    (price acctnum) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb nb-0)
    (price acctnum) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm acctnum) (nb acctnum)
    (price acctnum) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm acctnum)
    (goods goods) (price acctnum) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (5 1)) ((1 1) (5 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0)) ((5 2) (2 0))
    ((5 2) (4 0)) ((5 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nc nb nm acctnum)
  (operation nonce-test (displaced 2 6 customer 5) nb (0 2)
    (enc "hash" c nc nb price-0 price-0 (pubk hash))
    (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc acctnum m acctnum (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb acctnum (pubk hash)) (privk m))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c)))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 acctnum acctnum (pubk hash-0))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((recv (enc c nc acctnum acctnum acctnum (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc acctnum acctnum acctnum (pubk hash-1))
            (privk b)) (enc nc acctnum (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc acctnum m acctnum (pubk c)))
      (send (enc c nc acctnum acctnum acctnum (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb acctnum acctnum (pubk hash))
            (privk b)) nb))))
  (label 370)
  (parent 232)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods acctnum nb-0 nm price goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum nb-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum nb-0) (nb nb-0) (nc nc) (nm nb-0)
    (goods goods-0) (price nb-0) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm nb-0) (nb nb-0)
    (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (4 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0))
  (uniq-orig nc nb nb-0 nm)
  (operation nonce-test (displaced 6 4 customer 3) nb-0 (5 0)
    (enc nc nb-0 m nb-0 (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nb-0 m nb-0 (pubk c)))
      (recv
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c nc nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat (enc (enc "hash" c nc nb nb-0 nb-0 (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price (pubk c))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc nb-0 m nb-0 (pubk c)))
      (send (enc c nc nb-0 nb-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nc nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c))))))
  (label 371)
  (parent 233)
  (seen 170)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nc nb goods price acctnum nb-0 nm price-0 goods-0 acctnum-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0)) ((5 2) (2 0))
    ((5 2) (4 0)) ((5 2) (6 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 7 5 customer 3) price (6 0)
    (enc nc price m price (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price)))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))))
  (label 372)
  (parent 235)
  (seen 174)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (2 0)) ((4 2) (3 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods price price (pubk hash-0))
            (privk b)) (enc nc goods (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 373)
  (parent 236)
  (seen 202)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price goods-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (3 0))
    ((2 2) (4 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (b-0 b) (acctnum price)) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc goods-0 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b)) (enc nc price (pubk c))))))
  (label 374)
  (parent 237)
  (seen 331)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum nm price-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods-0) (price price-0)
    (c c) (m m))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum price) (nb price) (nc nc) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (2 0)) ((5 2) (3 0))
    ((5 2) (4 0)) ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (displaced 2 6 customer 5) price (1 0)
    (enc "hash" c nc price price price (pubk hash-1))
    (enc "hash" c nc goods-1 price price (pubk hash-0))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price price price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc goods-0 (pubk m)))
      (send (enc nc nm m price-0 (pubk c))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-0))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((recv (enc c nc price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-1))
            (privk b-0)) price))))
  (label 375)
  (parent 237)
  (seen 443)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb price nm price-0 acctnum goods text)
    (c hash hash-0 b m name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods)
    (price price-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm price) (nb goods)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc acctnum)
    (nm price) (goods goods) (price price) (b b) (c c) (m m)
    (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (2 0)) ((4 2) (3 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk b) (privk m))
  (uniq-orig nb price nm acctnum)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c acctnum-0 nb price price (pubk hash))
    (enc acctnum-0 nb (pubk c)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price-0 (pubk c))))
    ((recv (enc c acctnum price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods price price (pubk hash-0))
            (privk b)) (enc acctnum goods (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum price m price (pubk c)))
      (send (enc c acctnum price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) (enc acctnum nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum nb price price (pubk hash))
            (privk b)) nb))))
  (label 376)
  (parent 238)
  (seen 206)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb acctnum goods nb-0 nm price text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc acctnum) (nm nb-0)
    (goods goods) (price nb-0) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb nb-0)
    (price nb-0) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum) (nm nm) (goods goods) (price price)
    (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum) (nm nb-0) (nb goods)
    (price nb-0) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (4 0))
    ((2 2) (3 0)) ((2 2) (5 0)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb acctnum nb-0 nm)
  (operation nonce-test (contracted (goods-0 goods)) acctnum (0 0)
    (enc c acctnum goods (pubk m)))
  (traces
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum nb (pubk c)))))
    ((send (enc c acctnum goods (pubk m)))
      (recv (enc acctnum nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum nb-0 acctnum nb-0 (pubk b))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b)) (enc acctnum nb-0 (pubk c)))))
    ((recv (enc c acctnum goods (pubk m)))
      (send (enc acctnum nm m price (pubk c))))
    ((recv (enc c acctnum nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum goods nb-0 nb-0 (pubk hash-1))
            (privk b)) (enc acctnum goods (pubk c))))))
  (label 377)
  (parent 239)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods acctnum acctnum-0 nb-0 nm price goods-0 acctnum-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc acctnum-0) (nm nm) (goods goods-0)
    (price price) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (precedes ((0 1) (5 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 0)) ((4 1) (1 0)) ((5 0) (0 0)) ((5 0) (3 0))
    ((5 2) (2 0)) ((5 2) (4 0)) ((5 4) (1 0)) ((6 1) (5 3)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb acctnum-0 nb-0 nm)
  (operation encryption-test (added-strand bank 2)
    (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
      (privk b-0)) (5 3))
  (traces
    ((recv (enc c acctnum-0 goods (pubk m)))
      (send (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb nb-0 (pubk hash)) (privk m))))
    ((recv (enc c acctnum-0 nb-0 acctnum nb-0 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb nb-0 nb-0 (pubk hash))
            (privk b)) (enc acctnum-0 nb (pubk c)))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c)))))
    ((recv (enc c acctnum-0 goods-0 (pubk m)))
      (send (enc acctnum-0 nm m price (pubk c))))
    ((recv (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 goods-0 nb-0 nb-0 (pubk hash-1))
            (privk b-0)) (enc acctnum-0 goods-0 (pubk c)))))
    ((send (enc c acctnum-0 goods-0 (pubk m)))
      (recv (enc acctnum-0 nb-0 m nb-0 (pubk c)))
      (send (enc c acctnum-0 nb-0 acctnum-0 nb-0 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c acctnum-0 nb-0 acctnum-1 nb-0 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c acctnum-0 nb-0 nb-0 nb-0 (pubk hash-0))
            (privk b-0)) (enc acctnum-0 nb-0 (pubk c))))))
  (label 378)
  (parent 240)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 nb-1 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b)) nb-0)))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b)) (enc nb-0 nb-1 (pubk c))))))
  (label 379)
  (parent 242)
  (seen 362)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 nm price-0 nb-1 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum price) (nb nb-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m) (hash hash-0))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum price) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-2))
  (precedes ((0 1) (4 1)) ((0 1) (6 0)) ((1 1) (0 2)) ((2 1) (4 3))
    ((3 1) (1 0)) ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0))
    ((4 2) (5 0)) ((4 4) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand bank 2) price (1 0)
    (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
    (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
    (enc nb-0 price m price (pubk c))
    (enc c nb-0 price price price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price price price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c)))))
    ((recv (enc c nb-0 price price price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-2))
            (privk b-0)) (enc nb-0 price (pubk c))))))
  (label 380)
  (parent 242)
  (unrealized (0 0) (0 2) (1 0) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 goods-0 nb-0 nm price nb-1 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm nb-1) (goods goods)
    (price nb-1) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm nb-1) (nb nb)
    (price nb-1) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-0)
    (price nb-1) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0) (price price)
    (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm nb-1) (goods goods-0) (price nb-1) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm nb-1) (nb nb-1)
    (price nb-1) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 2) (5 0))
    ((4 4) (1 0)) ((5 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb nb-0 nm nb-1)
  (operation nonce-test (displaced 6 5 bank 2) price-0 (1 0)
    (enc "hash" c nb-0 nb-0 price-0 price-0 (pubk hash-0))
    (enc "hash" c nb-0 nb-1 price-0 price-0 (pubk hash-1))
    (enc nb-0 price-0 m price-0 (pubk c))
    (enc c nb-0 price-0 acctnum-0 price-0 (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 nb-1 m nb-1 (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb nb-1 (pubk hash)) (privk m))))
    ((recv (enc c nb-0 nb-1 acctnum nb-1 (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb nb-1 nb-1 (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 nb-1 m nb-1 (pubk c)))
      (send (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 nb-1 nb-1 (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 nb-1 acctnum-0 nb-1 (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 nb-1 nb-1 (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 381)
  (parent 242)
  (unrealized (0 0) (0 2) (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars
    (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 acctnum-1
      nb-1 text) (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-1) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-1)
    (price price) (b b-0) (c c) (hash hash-1))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 0) (3 0)) ((4 2) (2 0)) ((4 2) (6 0))
    ((4 4) (1 0)) ((5 1) (4 3)) ((6 1) (5 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (displaced 7 4 customer 3) price (6 0)
    (enc nb-0 price m price (pubk c)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) nb-0)))
    ((recv (enc c nb-0 price acctnum-1 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-0))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-1 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-1 (pubk c))))))
  (label 382)
  (parent 243)
  (unrealized (0 0) (0 2) (1 0) (5 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price nb-0 acctnum goods text)
    (c hash hash-0 hash-1 b m name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum) (nb nb) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m) (hash hash))
  (precedes ((0 1) (4 1)) ((1 1) (4 3)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (0 2)))
  (non-orig (privk c) (privk hash) (privk hash-0) (privk hash-1)
    (privk b) (privk m))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 2 5 customer 5) nb (0 2)
    (enc "hash" c nc nb price price (pubk hash)) (enc nc nb (pubk c)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))))
  (label 383)
  (parent 245)
  (seen 57)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb price acctnum goods nb-0 nm price-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand merchant 2 (nc nc) (nm nm) (goods goods) (price price-0)
    (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (5 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)) ((5 1) (0 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price nm)
  (operation nonce-test (contracted (goods-0 goods)) nc (0 0)
    (enc nc nm m price-0 (pubk c)) (enc c nc goods (pubk m)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb-0 price price (pubk hash-1))
            (privk b)) (enc nc nb-0 (pubk c)))))
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc nm m price-0 (pubk c)))))
  (label 384)
  (parent 246)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum goods-0 nb-0 text)
    (m c hash b hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-2))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (5 0)) ((5 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) nb-0
    (1 0) (enc "hash" c nb-0 price price price (pubk hash-0))
    (enc "hash" c nb-0 goods-0 price price (pubk hash-2))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
    (enc nb-0 price (pubk c)) (enc nb-0 goods-0 (pubk c))
    (enc nb-0 nb-0 (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum price (pubk b)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum price (pubk b))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-0))
            (privk b)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-2))
            (privk b)) (enc nb-0 goods-0 (pubk c))))))
  (label 385)
  (parent 247)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-2))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc nb-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 2) (2 0)) ((5 2) (3 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0)
  (operation nonce-test (displaced 2 6 customer 5) nb-0 (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-0))
    (enc "hash" c nb-0 goods-0 price price (pubk hash-2))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
    (enc nb-0 price (pubk c)) (enc nb-0 goods-0 (pubk c))
    (enc nb-0 nb-0 (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-0))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) nb-0))))
  (label 386)
  (parent 247)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc goods-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc goods-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb price) (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc goods-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-2))
  (defstrand customer 5 (acctnum acctnum-0) (nb goods-0) (nc goods-0)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-2))
  (precedes ((0 1) (5 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (4 0))
    ((4 1) (1 0)) ((5 0) (0 0)) ((5 2) (2 0)) ((5 2) (3 0))
    ((5 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price goods-0)
  (operation nonce-test (displaced 2 6 customer 5) goods-0 (1 0)
    (enc "hash" c goods-0 price price price (pubk hash-0))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
    (enc "hash" c goods-0 goods-0 price price (pubk hash-2))
    (enc goods-0 price (pubk c)) (enc goods-0 goods-0 (pubk c))
    (enc goods-0 price m price (pubk c))
    (enc c goods-0 goods-0 (pubk m))
    (enc c goods-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c goods-0 goods (pubk m)))
      (send (enc goods-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c goods-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c goods-0 nb price price (pubk hash))
            (privk b)) (enc goods-0 nb (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 price price price (pubk hash-0))
            (privk b-0)) (enc goods-0 price (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-1))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((recv (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-2))
            (privk b-0)) (enc goods-0 goods-0 (pubk c)))))
    ((send (enc c goods-0 goods-0 (pubk m)))
      (recv (enc goods-0 price m price (pubk c)))
      (send (enc c goods-0 price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-2))
            (privk b-0)) (enc goods-0 goods-0 (pubk c))))
      (send
        (cat
          (enc (enc "hash" c goods-0 goods-0 price price (pubk hash-2))
            (privk b-0)) goods-0))))
  (label 387)
  (parent 247)
  (seen 483 487)
  (unrealized (0 0) (0 2) (1 0) (5 3))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods price acctnum acctnum-0 goods-0 nb-0 nm price-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc nb-0) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nb-0) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum-0) (nc nb-0) (nm price)
    (goods goods-0) (price price) (b b-0) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price) (nb nb-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc nb-0) (nm price)
    (nb goods-0) (price price) (b b-0) (c c) (hash hash-2))
  (defstrand merchant 2 (nc nb-0) (nm nm) (goods goods-0)
    (price price-0) (c c) (m m))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 0) (6 0))
    ((2 2) (3 0)) ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (5 0))
    ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1) (privk hash-2))
  (uniq-orig nb price nb-0 nm)
  (operation nonce-test (added-strand merchant 2) nb-0 (1 0)
    (enc "hash" c nb-0 price price price (pubk hash-0))
    (enc "hash" c nb-0 goods-0 price price (pubk hash-2))
    (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
    (enc nb-0 price (pubk c)) (enc nb-0 goods-0 (pubk c))
    (enc nb-0 nb-0 (pubk c)) (enc nb-0 price m price (pubk c))
    (enc c nb-0 goods-0 (pubk m))
    (enc c nb-0 price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nb-0 goods (pubk m)))
      (send (enc nb-0 price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nb-0 price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb price price (pubk hash)) (privk b))
          (enc nb-0 nb (pubk c)))))
    ((send (enc c nb-0 goods-0 (pubk m)))
      (recv (enc nb-0 price m price (pubk c)))
      (send (enc c nb-0 price acctnum-0 price (pubk b-0))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 price price price (pubk hash-0))
            (privk b-0)) (enc nb-0 price (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 nb-0 price price (pubk hash-1))
            (privk b-0)) (enc nb-0 nb-0 (pubk c)))))
    ((recv (enc c nb-0 price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nb-0 goods-0 price price (pubk hash-2))
            (privk b-0)) (enc nb-0 goods-0 (pubk c)))))
    ((recv (enc c nb-0 goods-0 (pubk m)))
      (send (enc nb-0 nm m price-0 (pubk c)))))
  (label 388)
  (parent 247)
  (unrealized (0 0) (0 2) (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum goods-0 text)
    (m c hash b hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand customer 3 (acctnum acctnum) (nc nc) (nm price)
    (goods goods-0) (price price) (b b) (c c) (m m))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb price)
    (price price) (b b) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb goods-0)
    (price price) (b b) (c c) (hash hash-1))
  (precedes ((0 1) (2 1)) ((1 1) (0 2)) ((2 0) (0 0)) ((2 2) (3 0))
    ((2 2) (4 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk m) (privk c) (privk hash) (privk b) (privk hash-0)
    (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (contracted (b-0 b) (acctnum-0 acctnum)) price
    (1 0) (enc "hash" c nc price price price (pubk hash-0))
    (enc "hash" c nc goods-0 price price (pubk hash-1))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price acctnum price (pubk b)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum price (pubk b))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-1))
            (privk b)) (enc nc goods-0 (pubk c))))))
  (label 389)
  (parent 248)
  (unrealized (0 0) (0 2))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nc nb goods price acctnum acctnum-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 name))
  (defstrand merchant 4 (nb nb) (nc nc) (nm price) (goods goods)
    (price price) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc nc) (nm price) (nb nb)
    (price price) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb price)
    (price price) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc nc) (nm price) (nb goods-0)
    (price price) (b b-0) (c c) (hash hash-1))
  (defstrand customer 5 (acctnum acctnum-0) (nb price) (nc nc)
    (nm price) (goods goods-0) (price price) (b b-0) (c c) (m m)
    (hash hash-0))
  (precedes ((0 1) (4 1)) ((1 1) (0 2)) ((2 1) (1 0)) ((3 1) (1 0))
    ((4 0) (0 0)) ((4 2) (2 0)) ((4 2) (3 0)) ((4 4) (1 0)))
  (non-orig (privk b) (privk m) (privk c) (privk hash) (privk b-0)
    (privk hash-0) (privk hash-1))
  (uniq-orig nc nb price)
  (operation nonce-test (displaced 2 5 customer 5) price (1 0)
    (enc "hash" c nc price price price (pubk hash-0))
    (enc "hash" c nc goods-1 price price (pubk hash-1))
    (enc nc price (pubk c)) (enc nc price m price (pubk c))
    (enc c nc price acctnum-0 price (pubk b-0)))
  (traces
    ((recv (enc c nc goods (pubk m)))
      (send (enc nc price m price (pubk c)))
      (recv
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          nb))
      (send (enc (enc "hash" b m nb price (pubk hash)) (privk m))))
    ((recv (enc c nc price acctnum price (pubk b)))
      (send
        (cat
          (enc (enc "hash" c nc nb price price (pubk hash)) (privk b))
          (enc nc nb (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c)))))
    ((recv (enc c nc price acctnum-0 price (pubk b-0)))
      (send
        (cat
          (enc (enc "hash" c nc goods-0 price price (pubk hash-1))
            (privk b-0)) (enc nc goods-0 (pubk c)))))
    ((send (enc c nc goods-0 (pubk m)))
      (recv (enc nc price m price (pubk c)))
      (send (enc c nc price acctnum-0 price (pubk b-0)))
      (recv
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) (enc nc price (pubk c))))
      (send
        (cat
          (enc (enc "hash" c nc price price price (pubk hash-0))
            (privk b-0)) price))))
  (label 390)
  (parent 248)
  (unrealized (0 0) (0 2) (1 0) (4 3))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton epmo_acctnum
  (vars (nb goods acctnum acctnum-0 nb-0 goods-0 text)
    (b m c hash b-0 hash-0 hash-1 hash-2 name))
  (defstrand merchant 4 (nb nb) (nc acctnum-0) (nm nb-0) (goods goods)
    (price nb-0) (b b) (c c) (m m) (hash hash))
  (defstrand bank 2 (acctnum acctnum) (nc acctnum-0) (nm nb-0) (nb nb)
    (price nb-0) (b b) (c c) (hash hash))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-0))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb nb-0) (price nb-0) (b b-0) (c c) (hash hash-1))
  (defstrand bank 2 (acctnum acctnum-0) (nc acctnum-0) (nm nb-0)
    (nb goods-0) (price nb-0) (b b-0) (c c) (hash hash-2))
  (defstrand customer 5 (acctnum acctnum-0) (nb nb-0) (nc acctnum-0)
    (nm nb-0) (goods goods-0) (price nb-0) (b b-0) (c c) (m m)
    (hash hash-1))
  (precedes ((0 1) (5 1)) ((1