(comment "CPSA 4.3.0")
(comment "All input read from tst/fragile_pruning.scm")

(defprotocol fragile_pruning basic
  (defrole init
    (vars (k akey) (n n1 n2 n3 text))
    (trace (send (enc n k)) (recv (enc n n1 k)) (recv (enc n n2 k))
      (recv (enc n n3 k)) (send (enc n n1 n2 n3 k))
      (recv (enc n n1 n2 n3 n k)))
    (non-orig (invk k))
    (uniq-orig n))
  (defrole adder
    (vars (k akey) (n new text))
    (trace (recv (enc n k)) (send (enc n new k)))
    (uniq-orig new))
  (defrole final
    (vars (k akey) (n n1 n2 n3 text))
    (trace (recv (enc n n1 n2 n3 k)) (send (enc n n1 n2 n3 n k))))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton fragile_pruning
  (vars (n n1 n2 n3 text) (k akey))
  (defstrand init 6 (n n) (n1 n1) (n2 n2) (n3 n3) (k k))
  (non-orig (invk k))
  (uniq-orig n n1 n2 n3)
  (traces
    ((send (enc n k)) (recv (enc n n1 k)) (recv (enc n n2 k))
      (recv (enc n n3 k)) (send (enc n n1 n2 n3 k))
      (recv (enc n n1 n2 n3 n k))))
  (label 0)
  (unrealized (0 1) (0 2) (0 3) (0 5))
  (origs (n (0 0)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n1 n2 n3 new text) (k akey))
  (defstrand init 6 (n n) (n1 n1) (n2 n2) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (invk k))
  (uniq-orig n n1 n2 n3 new)
  (operation nonce-test (added-strand adder 2) n (0 1) (enc n k))
  (traces
    ((send (enc n k)) (recv (enc n n1 k)) (recv (enc n n2 k))
      (recv (enc n n3 k)) (send (enc n n1 n2 n3 k))
      (recv (enc n n1 n2 n3 n k)))
    ((recv (enc n k)) (send (enc n new k))))
  (label 1)
  (parent 0)
  (unrealized (0 1) (0 2) (0 3) (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n2 n3 new text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 n2) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (invk k))
  (uniq-orig n n2 n3 new)
  (operation nonce-test (contracted (n1 new)) n (0 1) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n n2 k))
      (recv (enc n n3 k)) (send (enc n new n2 n3 k))
      (recv (enc n new n2 n3 n k)))
    ((recv (enc n k)) (send (enc n new k))))
  (label 2)
  (parent 1)
  (unrealized (0 2) (0 3) (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n3 new text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (invk k))
  (uniq-orig n n3 new)
  (operation nonce-test (contracted (n2 new)) n (0 2) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n n3 k)) (send (enc n new new n3 k))
      (recv (enc n new new n3 n k)))
    ((recv (enc n k)) (send (enc n new k))))
  (label 3)
  (parent 2)
  (unrealized (0 3) (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n2 n3 new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 n2) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 2)))
  (non-orig (invk k))
  (uniq-orig n n2 n3 new new-0)
  (operation nonce-test (added-strand adder 2) n (0 2) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n n2 k))
      (recv (enc n n3 k)) (send (enc n new n2 n3 k))
      (recv (enc n new n2 n3 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 4)
  (parent 2)
  (unrealized (0 2) (0 3) (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (invk k))
  (uniq-orig n new)
  (operation nonce-test (contracted (n3 new)) n (0 3) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k))))
  (label 5)
  (parent 3)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n3 new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n n3 new new-0)
  (operation nonce-test (added-strand adder 2) n (0 3) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n n3 k)) (send (enc n new new n3 k))
      (recv (enc n new new n3 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 6)
  (parent 3)
  (unrealized (0 3) (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n3 new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 2)))
  (non-orig (invk k))
  (uniq-orig n n3 new new-0)
  (operation nonce-test (contracted (n2 new)) n (0 2) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n n3 k)) (send (enc n new new n3 k))
      (recv (enc n new new n3 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 7)
  (parent 4)
  (unrealized (0 3) (0 5))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n3 new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 2)))
  (non-orig (invk k))
  (uniq-orig n n3 new new-0)
  (operation nonce-test (contracted (n2 new-0)) n (0 2) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n n3 k)) (send (enc n new new-0 n3 k))
      (recv (enc n new new-0 n3 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 8)
  (parent 4)
  (unrealized (0 3) (0 5))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 9)
  (parent 5)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)) ((1 1) (2 0)) ((2 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 10)
  (parent 5)
  (unrealized (2 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (contracted (n3 new)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 11)
  (parent 6)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (contracted (n3 new-0)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 12)
  (parent 6)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 2)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (contracted (n3 new)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 13)
  (parent 7)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 2)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (contracted (n3 new-0)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 14)
  (parent 7)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n3 new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n n3 new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n n3 k)) (send (enc n new new n3 k))
      (recv (enc n new new n3 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 15)
  (parent 7)
  (unrealized (0 3) (0 5))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 2)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (contracted (n3 new)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 16)
  (parent 8)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 2)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (contracted (n3 new-0)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 17)
  (parent 8)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n n3 new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 n3) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n n3 new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n n3 k)) (send (enc n new new-0 n3 k))
      (recv (enc n new new-0 n3 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 18)
  (parent 8)
  (unrealized (0 3) (0 5))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 5)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 19)
  (parent 9)
  (seen 21)
  (unrealized (3 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 4) (2 0)) ((1 1) (0 1)) ((2 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new)
  (operation nonce-test (displaced 3 0 init 5) n (2 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 20)
  (parent 10)
  (unrealized)
  (shape)
  (maps ((0) ((k k) (n n) (n1 new) (n2 new) (n3 new))))
  (origs (n (0 0)) (new (1 1))))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((1 1) (2 0))
    ((2 1) (0 5)) ((3 1) (2 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand adder 2) n (2 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 21)
  (parent 10)
  (unrealized (2 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 3)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 22)
  (parent 11)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 3)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 23)
  (parent 11)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 3)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 24)
  (parent 12)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 3)) ((2 1) (3 0)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 25)
  (parent 12)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 26)
  (parent 13)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 27)
  (parent 13)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 28)
  (parent 14)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 2)) ((2 1) (3 0)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 29)
  (parent 14)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (contracted (n3 new)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 30)
  (parent 15)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (contracted (n3 new-0)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 31)
  (parent 15)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (contracted (n3 new-1)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 32)
  (parent 15)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new-0 new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 33)
  (parent 16)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 2)) ((2 1) (3 0)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new-0 new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 34)
  (parent 16)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new-0 new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 35)
  (parent 17)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 2)) ((2 1) (3 0)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new new-0 new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 36)
  (parent 17)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (contracted (n3 new)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 37)
  (parent 18)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (contracted (n3 new-0)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 38)
  (parent 18)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 3)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (contracted (n3 new-1)) n (0 3) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 39)
  (parent 18)
  (unrealized (0 5))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 4) (3 0)) ((1 1) (0 1))
    ((2 1) (0 5)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 0 init 5) n (3 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 40)
  (parent 19)
  (seen 20)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 5)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 41)
  (parent 19)
  (unrealized (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (3 0)) ((0 4) (2 0)) ((1 1) (0 1))
    ((2 1) (0 5)) ((3 1) (2 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 0 init 5) n (2 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-0 k))))
  (label 42)
  (parent 21)
  (seen 20)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 3)) ((3 1) (0 5)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 43)
  (parent 22)
  (seen 45)
  (unrealized (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 3)) ((2 1) (3 0)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 2 adder 2) n (3 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 44)
  (parent 23)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 3)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 45)
  (parent 23)
  (seen 77)
  (unrealized (3 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 3)) ((2 1) (4 0)) ((3 1) (0 5))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 46)
  (parent 24)
  (seen 48)
  (unrealized (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 4) (3 0)) ((1 1) (0 1))
    ((2 1) (0 3)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 47)
  (parent 25)
  (unrealized)
  (shape)
  (maps ((0) ((k k) (n n) (n1 new) (n2 new) (n3 new-0))))
  (origs (n (0 0)) (new-0 (2 1)) (new (1 1))))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 3)) ((2 1) (3 0)) ((3 1) (0 5))
    ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 48)
  (parent 25)
  (unrealized (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 49)
  (parent 26)
  (seen 51)
  (unrealized (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((1 1) (3 0))
    ((2 1) (0 2)) ((2 1) (3 0)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 2 adder 2) n (3 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 50)
  (parent 27)
  (unrealized (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 51)
  (parent 27)
  (seen 84)
  (unrealized (3 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 5))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 52)
  (parent 28)
  (seen 54)
  (unrealized (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 4) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 53)
  (parent 29)
  (seen 47)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 2)) ((2 1) (3 0)) ((3 1) (0 5))
    ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 54)
  (parent 29)
  (unrealized (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 55)
  (parent 30)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 56)
  (parent 30)
  (unrealized (4 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 57)
  (parent 31)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 58)
  (parent 31)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 59)
  (parent 32)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((3 1) (0 3)) ((3 1) (4 0))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k))))
  (label 60)
  (parent 32)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 5))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new-0 new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 61)
  (parent 33)
  (seen 63)
  (unrealized (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 4) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 62)
  (parent 34)
  (unrealized)
  (shape)
  (maps ((0) ((k k) (n n) (n1 new) (n2 new-0) (n3 new))))
  (origs (n (0 0)) (new-0 (2 1)) (new (1 1))))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 2)) ((2 1) (3 0)) ((3 1) (0 5))
    ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 63)
  (parent 34)
  (unrealized (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 5))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new-0 new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 64)
  (parent 35)
  (seen 66)
  (unrealized (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 4) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 65)
  (parent 36)
  (unrealized)
  (shape)
  (maps ((0) ((k k) (n n) (n1 new) (n2 new-0) (n3 new-0))))
  (origs (n (0 0)) (new-0 (2 1)) (new (1 1))))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 2)) ((2 1) (3 0)) ((3 1) (0 5))
    ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 66)
  (parent 36)
  (unrealized (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new-0 new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 67)
  (parent 37)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new-0 new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 68)
  (parent 37)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new-0 new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 69)
  (parent 38)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new-0 new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 70)
  (parent 38)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new-0 new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 71)
  (parent 39)
  (unrealized (0 5))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((3 1) (4 0)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k)
    (enc n new new-0 new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-1 k))
      (send (enc n new new-0 new-1 n k))))
  (label 72)
  (parent 39)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((0 4) (3 0))
    ((1 1) (0 1)) ((2 1) (0 5)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 73)
  (parent 41)
  (seen 42)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 3)) ((2 1) (4 0)) ((3 1) (0 5))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 2 adder 2) n (4 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 74)
  (parent 43)
  (seen 77)
  (unrealized (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 3)) ((3 1) (0 5))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 75)
  (parent 43)
  (seen 114)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 4) (3 0)) ((1 1) (0 1))
    ((2 1) (0 3)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 76)
  (parent 44)
  (seen 20)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 3)) ((2 1) (3 0)) ((3 1) (0 5))
    ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 77)
  (parent 44)
  (unrealized (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 3)) ((3 1) (0 5)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 78)
  (parent 46)
  (seen 47)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 3)) ((2 1) (4 0))
    ((3 1) (0 5)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 79)
  (parent 46)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((0 4) (3 0))
    ((1 1) (0 1)) ((2 1) (0 3)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 80)
  (parent 48)
  (seen 47)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 5))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 2 adder 2) n (4 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 81)
  (parent 49)
  (seen 84)
  (unrealized (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((3 1) (0 5))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 82)
  (parent 49)
  (seen 118)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 4) (3 0)) ((1 1) (0 1))
    ((2 1) (0 2)) ((3 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0)
  (operation nonce-test (displaced 4 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 83)
  (parent 50)
  (seen 20)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((1 1) (3 0)) ((2 1) (0 2)) ((2 1) (3 0)) ((3 1) (0 5))
    ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (added-strand adder 2) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 84)
  (parent 50)
  (unrealized (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 85)
  (parent 52)
  (seen 53)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 5)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 86)
  (parent 52)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((0 4) (3 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 87)
  (parent 54)
  (seen 53)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k)
    (enc n new new new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 88)
  (parent 55)
  (seen 91)
  (unrealized (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 2 adder 2) n (4 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 89)
  (parent 56)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((3 1) (0 3)) ((3 1) (4 0))
    ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 3 adder 2) n (4 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 90)
  (parent 56)
  (seen 124)
  (unrealized (4 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 91)
  (parent 56)
  (seen 125 126)
  (unrealized (4 0))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k)
    (enc n new new new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 92)
  (parent 57)
  (seen 94)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((3 1) (4 0)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 3 adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 93)
  (parent 58)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 94)
  (parent 58)
  (seen 130)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((3 1) (0 3))
    ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k)
    (enc n new new new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k))))
  (label 95)
  (parent 59)
  (seen 97)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((3 1) (4 0)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 2 adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k))))
  (label 96)
  (parent 60)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((3 1) (0 3))
    ((3 1) (4 0)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 97)
  (parent 60)
  (seen 134)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 98)
  (parent 61)
  (seen 62)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 5)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 99)
  (parent 61)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((0 4) (3 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 100)
  (parent 63)
  (seen 62)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 101)
  (parent 64)
  (seen 65)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 5)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 102)
  (parent 64)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((0 4) (3 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 103)
  (parent 66)
  (seen 65)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k)
    (enc n new new-0 new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 104)
  (parent 67)
  (seen 106)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((3 1) (4 0)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 3 adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 105)
  (parent 68)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 106)
  (parent 68)
  (seen 140)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k)
    (enc n new new-0 new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 107)
  (parent 69)
  (seen 109)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((3 1) (4 0)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 3 adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 108)
  (parent 70)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 109)
  (parent 70)
  (seen 144)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand final 2) n (0 5) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k)
    (enc n new new-0 new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-1 k))
      (send (enc n new new-0 new-1 n k))))
  (label 110)
  (parent 71)
  (seen 112)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-1 k))
      (send (enc n new new-0 new-1 n k))))
  (label 111)
  (parent 72)
  (unrealized)
  (shape)
  (maps ((0) ((k k) (n n) (n1 new) (n2 new-0) (n3 new-1))))
  (origs (n (0 0)) (new-1 (3 1)) (new-0 (2 1)) (new (1 1))))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((3 1) (4 0)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-1 k))
      (send (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 112)
  (parent 72)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 3)) ((3 1) (0 5)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 113)
  (parent 74)
  (seen 40)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 3)) ((2 1) (4 0))
    ((3 1) (0 5)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 114)
  (parent 74)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((0 4) (3 0))
    ((1 1) (0 1)) ((2 1) (0 3)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 115)
  (parent 77)
  (seen 42)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 3)) ((3 1) (0 5))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 116)
  (parent 79)
  (seen 80)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 117)
  (parent 81)
  (seen 40)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 5)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 118)
  (parent 81)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (4 0)) ((0 4) (3 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5)) ((4 1) (3 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (3 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-1 k))))
  (label 119)
  (parent 84)
  (seen 42)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 120)
  (parent 86)
  (seen 87)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((3 1) (0 3))
    ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 3 adder 2) n (5 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 121)
  (parent 88)
  (seen 126)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 2 adder 2) n (5 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 122)
  (parent 88)
  (seen 125 150)
  (unrealized (5 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 123)
  (parent 88)
  (seen 151 152)
  (unrealized (5 0))
  (comment "2 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (0 3))
    ((3 1) (4 0)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 3 adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 124)
  (parent 89)
  (unrealized (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 125)
  (parent 89)
  (seen 154)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((3 1) (0 3))
    ((3 1) (4 0)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 126)
  (parent 90)
  (seen 154)
  (unrealized (4 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 3 adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 127)
  (parent 92)
  (seen 130)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5))
    ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 128)
  (parent 92)
  (seen 156)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 129)
  (parent 93)
  (seen 53)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((3 1) (4 0)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 130)
  (parent 93)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 2 adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k))))
  (label 131)
  (parent 95)
  (seen 134)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5))
    ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 132)
  (parent 95)
  (seen 159)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k))))
  (label 133)
  (parent 96)
  (seen 47)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((3 1) (4 0)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 134)
  (parent 96)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 135)
  (parent 99)
  (seen 100)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 136)
  (parent 102)
  (seen 103)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 3 adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 137)
  (parent 104)
  (seen 140)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5))
    ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 138)
  (parent 104)
  (seen 162)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 139)
  (parent 105)
  (seen 62)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((3 1) (4 0)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 140)
  (parent 105)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 3 adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 141)
  (parent 107)
  (seen 144)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5))
    ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 142)
  (parent 107)
  (seen 165)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 143)
  (parent 108)
  (seen 65)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((3 1) (4 0)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 144)
  (parent 108)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-1 k))
      (send (enc n new new-0 new-1 n k))))
  (label 145)
  (parent 110)
  (seen 111)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5))
    ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-1 k))
      (send (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 146)
  (parent 110)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-1 k))
      (send (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 147)
  (parent 112)
  (seen 111)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 3)) ((3 1) (0 5))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 148)
  (parent 114)
  (seen 73)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 5))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 149)
  (parent 118)
  (seen 73)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2)) ((2 1) (5 0))
    ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 2 adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 150)
  (parent 121)
  (seen 154)
  (unrealized (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5)) ((5 1) (0 5))
    ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 151)
  (parent 121)
  (seen 169)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5))
    ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 152)
  (parent 122)
  (seen 169)
  (unrealized (5 0))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 4) (4 0))
    ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3)) ((4 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1)
  (operation nonce-test (displaced 5 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 153)
  (parent 124)
  (seen 76)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (4 0))
    ((3 1) (0 3)) ((3 1) (4 0)) ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (added-strand adder 2) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 154)
  (parent 124)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k))))
  (label 155)
  (parent 127)
  (seen 85)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5))
    ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 156)
  (parent 127)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 157)
  (parent 130)
  (seen 87)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k))))
  (label 158)
  (parent 131)
  (seen 78)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5))
    ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 159)
  (parent 131)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 160)
  (parent 134)
  (seen 80)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k))))
  (label 161)
  (parent 137)
  (seen 98)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5))
    ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 162)
  (parent 137)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 163)
  (parent 140)
  (seen 100)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k))))
  (label 164)
  (parent 141)
  (seen 101)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5))
    ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 165)
  (parent 141)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 166)
  (parent 144)
  (seen 103)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (displaced 7 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-3 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-1 k)) (send (enc n new new-0 new-1 k))
      (recv (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-1 k))
      (send (enc n new new-0 new-1 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 167)
  (parent 146)
  (seen 147)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (0 5)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k))))
  (label 168)
  (parent 150)
  (seen 113)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((1 1) (5 0)) ((2 1) (0 2))
    ((2 1) (5 0)) ((3 1) (0 3)) ((3 1) (5 0)) ((4 1) (0 5))
    ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (added-strand adder 2) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 169)
  (parent 150)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (5 0))
    ((0 4) (4 0)) ((1 1) (0 1)) ((2 1) (0 2)) ((3 1) (0 3))
    ((4 1) (0 5)) ((5 1) (4 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2)
  (operation nonce-test (displaced 6 0 init 5) n (4 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-2 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-2 k))))
  (label 170)
  (parent 154)
  (seen 115)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (displaced 7 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-3 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-0 k)) (send (enc n new new new-0 k))
      (recv (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-0 k)) (send (enc n new new new-0 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 171)
  (parent 156)
  (seen 120)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new-1) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (displaced 7 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-3 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new-1 k)) (send (enc n new new new-1 k))
      (recv (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new-1 k)) (send (enc n new new new-1 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 172)
  (parent 159)
  (seen 116)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (displaced 7 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-3 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new k)) (send (enc n new new-0 new k))
      (recv (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new k)) (send (enc n new new-0 new n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 173)
  (parent 162)
  (seen 135)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new-0) (n3 new-0) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (displaced 7 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-3 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new-0 k))
      (recv (enc n new-0 k)) (send (enc n new new-0 new-0 k))
      (recv (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new-0 new-0 k))
      (send (enc n new new-0 new-0 n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 174)
  (parent 165)
  (seen 136)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton fragile_pruning
  (vars (n new new-0 new-1 new-2 new-3 text) (k akey))
  (defstrand init 6 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new) (k k))
  (defstrand adder 2 (n n) (new new-0) (k k))
  (defstrand adder 2 (n n) (new new-1) (k k))
  (defstrand adder 2 (n n) (new new-2) (k k))
  (defstrand final 2 (n n) (n1 new) (n2 new) (n3 new) (k k))
  (defstrand adder 2 (n n) (new new-3) (k k))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((0 0) (6 0)) ((0 4) (5 0)) ((1 1) (0 1)) ((2 1) (0 2))
    ((3 1) (0 3)) ((4 1) (0 5)) ((5 1) (0 5)) ((6 1) (5 0)))
  (non-orig (invk k))
  (uniq-orig n new new-0 new-1 new-2 new-3)
  (operation nonce-test (displaced 7 0 init 5) n (5 0) (enc n k)
    (enc n new k) (enc n new-0 k) (enc n new-1 k) (enc n new-3 k))
  (traces
    ((send (enc n k)) (recv (enc n new k)) (recv (enc n new k))
      (recv (enc n new k)) (send (enc n new new new k))
      (recv (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new k)))
    ((recv (enc n k)) (send (enc n new-0 k)))
    ((recv (enc n k)) (send (enc n new-1 k)))
    ((recv (enc n k)) (send (enc n new-2 k)))
    ((recv (enc n new new new k)) (send (enc n new new new n k)))
    ((recv (enc n k)) (send (enc n new-3 k))))
  (label 175)
  (parent 169)
  (seen 148)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Nothing left to do")
