(herald neuman-stubblebine-reauth (bound 8))

(comment "CPSA 4.3.0")
(comment "All input read from tst/neuman-stubblebine-reauth.lsp")

(defprotocol neuman-stubblebine-reauth basic
  (defrole init
    (vars (a b ks name) (ra rb text) (k skey) (tb text))
    (trace (send (cat a ra))
      (recv (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (defrole resp
    (vars (a b ks name) (ra rb text) (k skey) (tb text))
    (trace (recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (defrole init-reauth
    (vars (a b ks name) (ra-prime rb-prime text) (k skey) (tb text))
    (trace (recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k))))
  (defrole resp-reauth
    (vars (a b ks name) (ra-prime rb-prime text) (k skey) (tb text))
    (trace (recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k))))
  (defrole keyserver
    (vars (a b ks name) (ra rb text) (k skey) (tb text))
    (trace (recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    (uniq-orig k))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k))))
  (label 0)
  (unrealized (0 2) (1 0))
  (origs (rb (0 1)) (rb-prime (1 1)))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (precedes ((2 1) (0 2)) ((2 1) (1 0)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand keyserver 2)
    (enc a k tb-0 (ltk b ks)) (1 0))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0))))
  (label 1)
  (parent 0)
  (unrealized (0 2) (1 2) (2 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((2 1) (0 2)) ((2 1) (1 0)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 3 0 resp 2)
    (enc a ra-0 tb-0 (ltk b ks)) (2 0))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0))))
  (label 2)
  (parent 1)
  (unrealized (0 2) (1 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (precedes ((2 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp 2)
    (enc a ra-0 tb-0 (ltk b ks)) (2 0))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks))))))
  (label 3)
  (parent 1)
  (unrealized (0 2) (1 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((3 3) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc rb-prime k) (1 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k))))
  (label 4)
  (parent 2)
  (unrealized (0 2) (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (0 2)) ((2 1) (1 0))
    ((3 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb-prime k)
    (1 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb-prime))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb-prime k)))))
  (label 5)
  (parent 2)
  (unrealized (0 2) (3 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc rb-prime k) (1 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))))
  (label 6)
  (parent 2)
  (unrealized (0 2) (3 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((3 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb-prime k) (1 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv k) (send k)))
  (label 7)
  (parent 2)
  (unrealized (0 2) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0 tb-1
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-1) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 1) (2 0)) ((4 3) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc rb-prime k) (1 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a-0 k tb-1 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k))))
  (label 8)
  (parent 3)
  (unrealized (0 2) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-1 tb-1 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-1) (rb rb-prime) (tb tb-1) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((1 1) (4 1)) ((2 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb-prime k)
    (1 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-1 (ltk a-0 ks-0))
          (enc a-0 k tb-1 (ltk b-0 ks-0)) rb-prime))
      (send (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) (enc rb-prime k)))))
  (label 9)
  (parent 3)
  (unrealized (0 2) (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 rb-prime-0 tb-1
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb-1) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc rb-prime k) (1 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))))
  (label 10)
  (parent 3)
  (unrealized (0 2) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (deflistener k)
  (precedes ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0)) ((3 1) (2 0))
    ((4 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb-prime k) (1 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv k) (send k)))
  (label 11)
  (parent 3)
  (unrealized (0 2) (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((3 3) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (3 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k))))
  (label 12)
  (parent 4)
  (unrealized (0 2) (3 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (0 2)) ((2 1) (1 0))
    ((3 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (3 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k)))))
  (label 13)
  (parent 5)
  (unrealized (0 2) (3 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (0 2)) ((2 1) (1 0))
    ((3 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (3 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))))
  (label 14)
  (parent 6)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 1) (2 0)) ((4 3) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (4 0)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k))))
  (label 15)
  (parent 8)
  (unrealized (0 2) (4 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-1) (rb rb-prime) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (precedes ((1 1) (4 1)) ((2 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (4 1)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb-0 (ltk b ks)) (enc rb-prime k)))))
  (label 16)
  (parent 9)
  (unrealized (0 2) (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (4 0)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))))
  (label 17)
  (parent 10)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((3 3) (1 2)) ((4 3) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-0 k) (3 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 18)
  (parent 12)
  (unrealized (0 2) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 1)) ((3 3) (1 2)) ((4 2) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-0 k)
    (3 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-0 k)))))
  (label 19)
  (parent 12)
  (unrealized (0 2) (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (3 0))
    ((3 1) (1 0)) ((3 3) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 4 1 resp-reauth 2)
    (enc ra-prime-0 k) (3 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k))))
  (label 20)
  (parent 12)
  (unrealized (0 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((3 3) (1 2)) ((4 1) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-0 k) (3 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 21)
  (parent 12)
  (unrealized (0 2) (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((3 3) (1 2)) ((4 1) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-0 k)
    (3 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv k) (send k)))
  (label 22)
  (parent 12)
  (unrealized (0 2) (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (0 2)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 4 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (3 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k)))))
  (label 23)
  (parent 13)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 1) (1 2)) ((4 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 24)
  (parent 14)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 1))
    ((3 1) (1 2)) ((4 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 25)
  (parent 14)
  (unrealized (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb ra-prime rb-prime rb rb-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (0 2)) ((1 1) (3 0)) ((2 1) (1 0))
    ((3 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 4 1 resp-reauth 2) (enc rb-0 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))))
  (label 26)
  (parent 14)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 rb-prime-1 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 1) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 27)
  (parent 14)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 1) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))) ((recv k) (send k)))
  (label 28)
  (parent 14)
  (unrealized (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 tb-1 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-1) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a-0 k tb-1 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 29)
  (parent 15)
  (unrealized (0 2) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0 ra-1 tb-1
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-0) (tb tb-1) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-0 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-1 (ltk a-0 ks-0))
          (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) (enc ra-prime-0 k)))))
  (label 30)
  (parent 15)
  (unrealized (0 2) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (2 0))
    ((4 1) (1 0)) ((4 3) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 1 resp-reauth 2)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k))))
  (label 31)
  (parent 15)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      rb-prime-0 tb-1 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb-1) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 32)
  (parent 15)
  (unrealized (0 2) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-0 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv k) (send k)))
  (label 33)
  (parent 15)
  (unrealized (0 2) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (precedes ((1 1) (4 1)) ((2 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 2 keyserver 2)
    (enc b ra-1 k tb-0 (ltk a ks)) (4 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb-0 (ltk b ks)) (enc rb-prime k)))))
  (label 34)
  (parent 16)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 0)) ((2 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))))
  (label 35)
  (parent 17)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((3 3) (1 2)) ((4 3) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 36)
  (parent 18)
  (unrealized (0 2) (4 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 1)) ((3 3) (1 2)) ((4 2) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 37)
  (parent 19)
  (unrealized (0 2) (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 38)
  (parent 20)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 1))
    ((3 1) (1 0)) ((3 3) (1 2)) ((4 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 39)
  (parent 20)
  (unrealized (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((3 3) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 40)
  (parent 20)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((3 3) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv k) (send k)))
  (label 41)
  (parent 20)
  (unrealized (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((3 3) (1 2)) ((4 1) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 42)
  (parent 21)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 43)
  (parent 23)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 1))
    ((3 0) (0 0)) ((3 2) (1 2)) ((4 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 44)
  (parent 23)
  (unrealized (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb ra-prime rb-prime rb text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (0 2)) ((1 1) (3 1)) ((2 1) (1 0))
    ((3 0) (0 0)) ((3 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 4 1 resp-reauth 2) (enc rb-0 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k)))))
  (label 45)
  (parent 23)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (3 0)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 0) (0 0)) ((3 2) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 46)
  (parent 23)
  (unrealized (4 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 0) (0 0)) ((3 2) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv k) (send k)))
  (label 47)
  (parent 23)
  (unrealized (4 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 1) (1 2)) ((4 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 48)
  (parent 24)
  (unrealized (4 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 1))
    ((3 1) (1 2)) ((4 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 49)
  (parent 25)
  (unrealized (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 rb-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 1) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 50)
  (parent 27)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (5 0)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 51)
  (parent 29)
  (unrealized (0 2) (5 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0 ra-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (5 1)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb-0 (ltk b ks)) (enc ra-prime-0 k)))))
  (label 52)
  (parent 30)
  (unrealized (0 2) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (4 0)) ((3 1) (2 0))
    ((4 1) (1 0)) ((4 3) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k))))
  (label 53)
  (parent 31)
  (unrealized (0 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      rb-prime-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (5 0)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 54)
  (parent 32)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((1 1) (4 1)) ((2 1) (0 2)) ((2 1) (1 0)) ((3 1) (2 0))
    ((4 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k)))))
  (label 55)
  (parent 34)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 56)
  (parent 35)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-1 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 1) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 57)
  (parent 35)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra ra-prime rb-prime tb ra-0 rb rb-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (1 0)) ((1 1) (0 2)) ((1 1) (4 0)) ((2 1) (1 0))
    ((3 1) (2 0)) ((4 1) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 5 1 resp-reauth 2) (enc rb-1 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (cat a ra-0)) (send (cat b rb-0 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))))
  (label 58)
  (parent 35)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 rb-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 0)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 59)
  (parent 35)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0)) ((3 1) (2 0))
    ((4 1) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k)))) ((recv k) (send k)))
  (label 60)
  (parent 35)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 61)
  (parent 36)
  (unrealized (0 2) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 62)
  (parent 36)
  (unrealized (0 2) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (3 0))
    ((2 1) (4 0)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 1 resp-reauth 2)
    (enc ra-prime-1 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))))
  (label 63)
  (parent 36)
  (unrealized (0 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 64)
  (parent 36)
  (unrealized (0 2) (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 65)
  (parent 36)
  (unrealized (0 2) (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 1)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (4 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 66)
  (parent 37)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 67)
  (parent 38)
  (unrealized (4 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 1))
    ((3 1) (1 0)) ((3 3) (1 2)) ((4 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 68)
  (parent 39)
  (unrealized (4 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((3 1) (1 0)) ((3 3) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 69)
  (parent 40)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (3 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 70)
  (parent 42)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 71)
  (parent 42)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb ra-prime rb-prime rb ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (0 2)) ((1 1) (3 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((3 3) (1 2)) ((4 1) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 5 1 resp-reauth 2) (enc rb-0 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 72)
  (parent 42)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 rb-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 73)
  (parent 42)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))) ((recv k) (send k)))
  (label 74)
  (parent 42)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 75)
  (parent 43)
  (unrealized (4 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 1))
    ((3 0) (0 0)) ((3 2) (1 2)) ((4 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 76)
  (parent 44)
  (unrealized (4 1))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((3 0) (0 0)) ((3 2) (1 2)) ((4 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (4 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 77)
  (parent 46)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (3 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 78)
  (parent 48)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-0 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-0 k)))))
  (label 79)
  (parent 48)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((1 1) (4 2)) ((2 1) (4 0))
    ((3 1) (1 2)) ((4 1) (1 0)) ((4 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 1 resp-reauth 2)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 80)
  (parent 48)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 rb-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat rb-prime-1 (enc ra-prime-0 k)))))
  (label 81)
  (parent 48)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-0 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 82)
  (parent 48)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 1))
    ((3 1) (1 2)) ((4 0) (0 0)) ((4 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (4 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((send (cat a ra))
      (recv (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 83)
  (parent 49)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 ra-prime-2 tb-1 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-1) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-1 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 84)
  (parent 51)
  (unrealized (0 2) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 ra-1 tb-1 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-1) (tb tb-1) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-1 (ltk a-0 ks-0))
          (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 85)
  (parent 51)
  (unrealized (0 2) (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (5 2)) ((2 1) (0 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))))
  (label 86)
  (parent 51)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 rb-prime-0 tb-1 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-1) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 87)
  (parent 51)
  (unrealized (0 2) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 88)
  (parent 51)
  (unrealized (0 2) (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-1 k tb-0 (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb-0 (ltk b ks)) (enc ra-prime-0 k)))))
  (label 89)
  (parent 52)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 90)
  (parent 53)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-1 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 91)
  (parent 53)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 0)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 92)
  (parent 53)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0)) ((3 1) (2 0))
    ((4 1) (1 0)) ((4 3) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv k) (send k)))
  (label 93)
  (parent 53)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 94)
  (parent 54)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 95)
  (parent 55)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-1 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 2) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 96)
  (parent 55)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra ra-prime rb-prime tb ra-0 rb rb-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (1 0)) ((1 1) (0 2)) ((1 1) (4 1)) ((2 1) (1 0))
    ((3 1) (2 0)) ((4 2) (1 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 5 1 resp-reauth 2) (enc rb-1 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (cat a ra-0)) (send (cat b rb-0 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k)))))
  (label 97)
  (parent 55)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 0)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 2) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 98)
  (parent 55)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (deflistener k)
  (precedes ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0)) ((3 1) (2 0))
    ((4 2) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv k) (send k)))
  (label 99)
  (parent 55)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 100)
  (parent 56)
  (unrealized (5 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 1) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 101)
  (parent 57)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 rb-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 0)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 102)
  (parent 59)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 103)
  (parent 61)
  (unrealized (0 2) (5 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 104)
  (parent 62)
  (unrealized (0 2) (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 105)
  (parent 63)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 106)
  (parent 63)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 107)
  (parent 63)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 108)
  (parent 63)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 109)
  (parent 64)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 110)
  (parent 66)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 1)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 111)
  (parent 66)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb ra-prime rb-prime rb ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (0 2)) ((1 1) (3 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 1)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 5 1 resp-reauth 2) (enc rb-0 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 112)
  (parent 66)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 113)
  (parent 66)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv k) (send k)))
  (label 114)
  (parent 66)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 115)
  (parent 67)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2))
    ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-0 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-0 k)))))
  (label 116)
  (parent 67)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2))
    ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 117)
  (parent 67)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2))
    ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-0 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 118)
  (parent 67)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 1))
    ((3 1) (1 0)) ((3 3) (1 2)) ((4 0) (0 0)) ((4 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (4 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 119)
  (parent 68)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (rb (0 1)) (ra-prime (3 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 120)
  (parent 70)
  (unrealized (5 2))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 121)
  (parent 71)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 rb-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 122)
  (parent 73)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 123)
  (parent 75)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2))
    ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-0 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-0 k)))))
  (label 124)
  (parent 75)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((1 1) (4 2)) ((2 1) (4 0))
    ((3 0) (0 0)) ((3 2) (1 2)) ((4 1) (1 0)) ((4 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 5 1 resp-reauth 2)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 125)
  (parent 75)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (3 0)) (rb (0 1)) (ra-prime (4 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 tb-0 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2))
    ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-0 k) (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 126)
  (parent 75)
  (unrealized (5 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2))
    ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-0 k)
    (4 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 127)
  (parent 75)
  (unrealized (5 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 128)
  (parent 78)
  (unrealized (5 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 129)
  (parent 79)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 rb-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-1 (enc ra-prime-0 k)))))
  (label 130)
  (parent 81)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 ra-prime-2 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (6 0)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 131)
  (parent 84)
  (unrealized (0 2) (6 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 ra-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-1) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (6 1)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb-0 (ltk b ks)) (enc ra-prime-1 k)))))
  (label 132)
  (parent 85)
  (unrealized (0 2) (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (5 2)) ((2 1) (0 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))))
  (label 133)
  (parent 86)
  (unrealized (0 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 rb-prime-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test
    (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-1 tb-0)) k (6 0)
    (enc a k tb-0 (ltk b ks)) (enc b ra-0 k tb-0 (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 134)
  (parent 87)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 135)
  (parent 89)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 136)
  (parent 90)
  (unrealized (5 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 137)
  (parent 91)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 0)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 138)
  (parent 92)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      ra-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 139)
  (parent 94)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 140)
  (parent 94)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra ra-prime rb-prime tb ra-0 rb rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (1 0)) ((1 1) (0 2)) ((1 1) (4 2)) ((2 1) (1 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2) (enc rb-1 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (cat a ra-0)) (send (cat b rb-0 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 141)
  (parent 94)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 0)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 142)
  (parent 94)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (4 2))
    ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))) ((recv k) (send k)))
  (label 143)
  (parent 94)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 144)
  (parent 95)
  (unrealized (5 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 2) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 145)
  (parent 96)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 0)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 2) (1 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 146)
  (parent 98)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      ra-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-0 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 147)
  (parent 100)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-0) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-0 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-0 k)))))
  (label 148)
  (parent 100)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((1 1) (5 2)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 1) (1 2)) ((5 1) (1 0)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2)
    (enc ra-prime-0 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 149)
  (parent 100)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-0 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat rb-prime-1 (enc ra-prime-0 k)))))
  (label 150)
  (parent 100)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-0 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 151)
  (parent 100)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 1) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 152)
  (parent 101)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 153)
  (parent 103)
  (unrealized (0 2) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 154)
  (parent 103)
  (unrealized (0 2) (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 2)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2)
    (enc ra-prime-2 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))))
  (label 155)
  (parent 103)
  (unrealized (0 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 156)
  (parent 103)
  (unrealized (0 2) (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 157)
  (parent 103)
  (unrealized (0 2) (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 158)
  (parent 104)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 159)
  (parent 105)
  (unrealized (5 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 160)
  (parent 106)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 161)
  (parent 107)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 162)
  (parent 109)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 163)
  (parent 109)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb ra-prime rb-prime rb ra-prime-0 ra-prime-1 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (0 2)) ((1 1) (3 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2) (enc rb-0 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 164)
  (parent 109)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 165)
  (parent 109)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))) ((recv k) (send k)))
  (label 166)
  (parent 109)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 167)
  (parent 110)
  (unrealized (5 2))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 1)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 168)
  (parent 111)
  (unrealized (5 1))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((5 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 169)
  (parent 113)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 170)
  (parent 115)
  (unrealized (5 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2))
    ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 171)
  (parent 116)
  (unrealized (5 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2))
    ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 172)
  (parent 117)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (3 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 1) (1 0)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 173)
  (parent 120)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 174)
  (parent 120)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 175)
  (parent 120)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (3 2))
    ((4 1) (5 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 4 resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 176)
  (parent 120)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-1 (enc ra-prime-1 k)))))
  (label 177)
  (parent 120)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 178)
  (parent 120)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((3 3) (1 2)) ((4 1) (3 2))
    ((5 0) (0 0)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((send (cat a ra))
      (recv (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 179)
  (parent 121)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 180)
  (parent 123)
  (unrealized (5 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2))
    ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 181)
  (parent 124)
  (unrealized (5 1))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2))
    ((5 1) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (5 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 182)
  (parent 126)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (3 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 183)
  (parent 128)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 184)
  (parent 128)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((1 1) (5 2)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 1) (1 0))
    ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))))
  (label 185)
  (parent 128)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-1 (enc ra-prime-1 k)))))
  (label 186)
  (parent 128)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 187)
  (parent 128)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (1 2)) ((4 3) (0 2)) ((5 0) (0 0))
    ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 188)
  (parent 129)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (6 2)) ((2 1) (0 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 3) (4 2))
    ((6 1) (1 0)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))))
  (label 191)
  (parent 131)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-1 k tb-0 (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb-0 (ltk b ks)) (enc ra-prime-1 k)))))
  (label 194)
  (parent 132)
  (unrealized (0 2))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0))
    ((5 3) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 195)
  (parent 133)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-1 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0))
    ((5 3) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 196)
  (parent 133)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 0)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0))
    ((5 3) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 197)
  (parent 133)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0)) ((5 3) (4 2))
    ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 198)
  (parent 133)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 199)
  (parent 134)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 200)
  (parent 135)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-1 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 201)
  (parent 135)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra ra-prime rb-prime tb ra-0 rb rb-0 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (1 0)) ((1 1) (0 2)) ((1 1) (4 2)) ((2 1) (1 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2) (enc rb-1 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (cat a ra-0)) (send (cat b rb-0 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 202)
  (parent 135)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 0)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 203)
  (parent 135)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0)) ((2 1) (5 1))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 2) (4 2))
    ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv k) (send k)))
  (label 204)
  (parent 135)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-0 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 205)
  (parent 136)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-1 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-0) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2))
    ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-0 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-0 k)))))
  (label 206)
  (parent 136)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2))
    ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-0 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 207)
  (parent 136)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2))
    ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-0 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 208)
  (parent 136)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 209)
  (parent 137)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      ra-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 210)
  (parent 139)
  (unrealized (6 2))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      ra-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 211)
  (parent 140)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      rb-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 0)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 212)
  (parent 142)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-0 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 213)
  (parent 144)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-1 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-0) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-0 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-0 k)))))
  (label 214)
  (parent 144)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((1 1) (5 2)) ((2 1) (5 0))
    ((3 1) (2 0)) ((4 2) (1 2)) ((5 1) (1 0)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2)
    (enc ra-prime-0 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 215)
  (parent 144)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-0 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 216)
  (parent 144)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-0 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 217)
  (parent 144)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 1)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 1))
    ((3 1) (2 0)) ((4 2) (1 2)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 218)
  (parent 145)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      ra-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 219)
  (parent 147)
  (unrealized (6 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      ra-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 220)
  (parent 148)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      rb-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-1 (enc ra-prime-0 k)))))
  (label 221)
  (parent 150)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 222)
  (parent 153)
  (unrealized (0 2) (6 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-2))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-2 k)))))
  (label 223)
  (parent 154)
  (unrealized (0 2) (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 224)
  (parent 155)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 225)
  (parent 155)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 226)
  (parent 155)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 227)
  (parent 155)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 228)
  (parent 156)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 229)
  (parent 158)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 230)
  (parent 158)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb ra-prime rb-prime rb ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (0 2)) ((1 1) (3 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2) (enc rb-0 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 231)
  (parent 158)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 232)
  (parent 158)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv k) (send k)))
  (label 233)
  (parent 158)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((4 3) (5 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 4 init-reauth 4)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 234)
  (parent 159)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 235)
  (parent 159)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 236)
  (parent 159)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 237)
  (parent 159)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 238)
  (parent 159)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 3) (1 2)) ((4 1) (1 0)) ((4 3) (3 2))
    ((5 0) (0 0)) ((5 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 239)
  (parent 160)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (rb (0 1)) (ra-prime (4 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      ra-prime-2 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 240)
  (parent 162)
  (unrealized (6 2))
  (comment "7 in cohort - 7 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      ra-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 241)
  (parent 163)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      rb-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 242)
  (parent 165)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 243)
  (parent 167)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 244)
  (parent 167)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((4 2) (5 2)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 4 init 3) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 245)
  (parent 167)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((3 3) (1 2)) ((4 0) (0 0))
    ((4 2) (3 2)) ((5 1) (1 0)) ((5 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 246)
  (parent 167)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (rb (0 1)) (ra-prime (5 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 247)
  (parent 167)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 248)
  (parent 167)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((3 3) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 249)
  (parent 170)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (1 0)) ((3 3) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 250)
  (parent 170)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((3 3) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 251)
  (parent 170)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((3 3) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 252)
  (parent 170)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((3 1) (1 0)) ((3 3) (1 2)) ((4 3) (0 2))
    ((5 0) (0 0)) ((5 2) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (5 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 253)
  (parent 171)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (rb (0 1)) (ra-prime (3 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      ra-prime-2 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 254)
  (parent 174)
  (unrealized (6 2))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      ra-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 255)
  (parent 175)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      rb-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-1 (enc ra-prime-1 k)))))
  (label 256)
  (parent 177)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 0) (0 0)) ((3 2) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 257)
  (parent 180)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 tb-0
      text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 0) (0 0)) ((3 2) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 258)
  (parent 180)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 text) (a b ks name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((1 1) (5 2)) ((2 1) (4 0))
    ((2 1) (5 0)) ((3 0) (0 0)) ((3 2) (1 2)) ((4 3) (0 2))
    ((5 1) (1 0)) ((5 3) (4 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 6 1 resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))))
  (label 259)
  (parent 180)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (3 0)) (rb (0 1)) (ra-prime (5 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 0) (0 0)) ((3 2) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 260)
  (parent 180)
  (unrealized (6 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 0) (0 0)) ((3 2) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (5 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 261)
  (parent 180)
  (unrealized (6 0))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      ra-prime-2 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 262)
  (parent 183)
  (unrealized (6 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      ra-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 263)
  (parent 184)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      rb-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-1 (enc ra-prime-1 k)))))
  (label 264)
  (parent 186)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((1 1) (6 2)) ((2 1) (0 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 3) (4 2))
    ((6 1) (1 0)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))))
  (label 265)
  (parent 191)
  (unrealized (0 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc a k tb-0 (ltk b ks)) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 266)
  (parent 194)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0))
    ((5 3) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 267)
  (parent 195)
  (unrealized (6 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0))
    ((5 3) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 268)
  (parent 196)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 0)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0))
    ((5 3) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 269)
  (parent 197)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra ra-prime rb-prime tb ra-0 rb rb-0 ra-prime-0 ra-prime-1
      rb-prime-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (1 0)) ((1 1) (0 2)) ((1 1) (4 2)) ((2 1) (1 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2) (enc rb-1 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (cat a ra-0)) (send (cat b rb-0 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 272)
  (parent 199)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 275)
  (parent 200)
  (unrealized (6 2))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 276)
  (parent 201)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 0)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 277)
  (parent 203)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 278)
  (parent 205)
  (unrealized (6 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2))
    ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 279)
  (parent 206)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2))
    ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 280)
  (parent 207)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((1 1) (6 2)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((6 1) (1 0)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 281)
  (parent 210)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (6 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((5 1) (6 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 5 resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 284)
  (parent 210)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 287)
  (parent 211)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))))
  (label 288)
  (parent 213)
  (unrealized (6 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-1))
      (recv
        (cat (enc b ra-1 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 289)
  (parent 214)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra-0 k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k)))))
  (label 290)
  (parent 216)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((1 1) (6 2)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 1) (1 0)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))))
  (label 293)
  (parent 219)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (6 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 1) (1 2)) ((5 3) (0 2))
    ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 296)
  (parent 220)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 2)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-3 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-2 (enc ra-prime k)))
      (send (enc ra-prime-2 k))))
  (label 299)
  (parent 222)
  (unrealized (0 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-2) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 0) (0 0))
    ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-2))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-2 k)))))
  (label 302)
  (parent 223)
  (unrealized (0 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 303)
  (parent 224)
  (unrealized (6 2))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 304)
  (parent 225)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 305)
  (parent 226)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb ra-prime rb-prime rb ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (0 2)) ((1 1) (3 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2) (enc rb-0 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 308)
  (parent 228)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 311)
  (parent 229)
  (unrealized (6 2))
  (comment "7 in cohort - 7 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 312)
  (parent 230)
  (unrealized (6 1))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((6 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (cat (enc a k tb (ltk b ks)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 313)
  (parent 232)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 314)
  (parent 235)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 315)
  (parent 236)
  (unrealized (6 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 316)
  (parent 237)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((4 3) (6 2)) ((5 1) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 4 init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 318)
  (parent 240)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((5 1) (6 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 5 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 320)
  (parent 240)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((1 1) (6 2)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 1) (1 0)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 321)
  (parent 240)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (6 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (4 2)) ((6 0) (0 0)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((send (cat a ra))
      (recv (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 324)
  (parent 241)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (6 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 325)
  (parent 243)
  (unrealized (6 2))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 326)
  (parent 244)
  (unrealized (6 1))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 327)
  (parent 247)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((3 3) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 328)
  (parent 249)
  (unrealized (6 2))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (1 0)) ((3 3) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 329)
  (parent 250)
  (unrealized (6 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 0)) ((3 3) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 330)
  (parent 251)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (3 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((1 1) (6 2)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 1) (1 0)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))))
  (label 331)
  (parent 254)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (6 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 1) (3 2)) ((4 1) (6 2)) ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 4 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat ra-prime-1 (enc ra-prime-0 k)))
      (send (enc ra-prime-1 k))))
  (label 334)
  (parent 254)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2))
    ((4 1) (3 2)) ((5 3) (0 2)) ((6 0) (0 0)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 337)
  (parent 255)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (6 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 0) (0 0)) ((3 2) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 338)
  (parent 257)
  (unrealized (6 2))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 0) (0 0)) ((3 2) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 1) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 339)
  (parent 258)
  (unrealized (6 1))
  (dead)
  (comment "empty cohort"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 0) (0 0)) ((3 2) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 1) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation nonce-test (contracted (a-0 a) (b-0 b) (ks-0 ks) (tb-0 tb))
    k (6 0) (enc a k tb (ltk b ks)) (enc b ra k tb (ltk a ks)))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 340)
  (parent 260)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (3 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((1 1) (6 2)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))))
  (label 343)
  (parent 262)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (6 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (1 2)) ((4 3) (0 2))
    ((5 3) (4 2)) ((6 0) (0 0)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 346)
  (parent 263)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (6 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra ra-prime rb-prime tb ra-0 rb rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (1 0)) ((1 1) (0 2)) ((1 1) (4 2)) ((2 1) (1 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2) (enc rb-1 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (cat a ra-0)) (send (cat b rb-0 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 353)
  (parent 266)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0))
    ((5 3) (4 2)) ((5 3) (6 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 5 init-reauth 4)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 356)
  (parent 267)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 1) (1 0))
    ((5 3) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 361)
  (parent 268)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((5 2) (6 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 5 init 3) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 364)
  (parent 275)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((1 1) (6 2)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((6 1) (1 0)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 365)
  (parent 275)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (6 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (6 1)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 2) (4 2)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 368)
  (parent 276)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 1) (1 0)) ((4 3) (1 2))
    ((5 3) (0 2)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 373)
  (parent 279)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((1 1) (6 2)) ((2 1) (5 0))
    ((2 1) (6 0)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 1) (1 0)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k))))
  (label 376)
  (parent 288)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (6 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((3 1) (2 0)) ((4 2) (1 2)) ((5 3) (0 2))
    ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-1 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k)))))
  (label 379)
  (parent 289)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb ra-prime rb-prime rb ra-prime-0 ra-prime-1 ra-prime-2 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb ra-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-2) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (0 2)) ((1 1) (3 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 0) (0 0))
    ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2) (enc rb-0 k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b ra-prime (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc ra-prime k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-2))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-2 k)))))
  (label 386)
  (parent 302)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb ra-prime) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (6 0)) (ra-prime (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((5 3) (6 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 5 init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 389)
  (parent 303)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 3) (3 2))
    ((4 3) (6 2)) ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 4 init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 390)
  (parent 303)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (5 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2)) ((4 3) (3 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 0) (0 0)) ((6 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra))
      (recv (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb))
      (send (cat (enc a k tb (ltk b ks)) (enc rb k)))))
  (label 395)
  (parent 304)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (6 0)) (rb (0 1)) (ra-prime (5 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((4 3) (6 2)) ((5 0) (0 0)) ((5 2) (4 2))
    ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 4 init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k))))
  (label 396)
  (parent 311)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((5 2) (6 2))
    ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 5 init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k))))
  (label 398)
  (parent 311)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((1 1) (6 2)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2)) ((6 1) (1 0))
    ((6 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb (enc ra-prime k))) (send (enc rb k))))
  (label 399)
  (parent 311)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (5 0)) (rb (0 1)) (ra-prime (6 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((5 3) (0 2)) ((6 0) (0 0)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 403)
  (parent 314)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (6 0)) (rb (0 1)) (ra-prime (4 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2)) ((4 1) (1 0))
    ((4 3) (3 2)) ((4 3) (6 2)) ((5 3) (0 2)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 4 init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat ra-prime-1 (enc ra-prime-0 k)))
      (send (enc ra-prime-1 k))))
  (label 404)
  (parent 315)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (rb (0 1)) (ra-prime (4 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((4 2) (6 2)) ((5 3) (0 2))
    ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 4 init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat ra-prime-1 (enc ra-prime-0 k)))
      (send (enc ra-prime-1 k))))
  (label 411)
  (parent 325)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (rb (0 1)) (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((1 1) (6 2)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((3 3) (1 2))
    ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2)) ((6 1) (1 0))
    ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))))
  (label 412)
  (parent 325)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (4 0)) (rb (0 1)) (ra-prime (6 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((3 1) (1 0)) ((3 3) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 0) (0 0)) ((6 2) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 2 keyserver 2)
    (enc b ra-0 k tb (ltk a ks)) (6 1))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k)))))
  (label 419)
  (parent 329)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (6 0)) (rb (0 1)) (ra-prime (3 1))
    (rb-prime (1 1))))

(defskeleton neuman-stubblebine-reauth
  (vars (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 text)
    (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((1 1) (6 2)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((3 0) (0 0)) ((3 2) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (displaced 7 1 resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))))
  (label 422)
  (parent 338)
  (unrealized)
  (shape)
  (maps
    ((0 1)
      ((ra ra) (tb tb) (rb rb) (a a) (b b) (ks ks) (k k)
        (ra-prime ra-prime) (rb-prime rb-prime) (tb-0 tb))))
  (origs (k (2 1)) (ra (3 0)) (rb (0 1)) (ra-prime (6 1))
    (rb-prime (1 1))))

(comment "Strand bound exceeded--aborting run")

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 ra-prime-2 ra-prime-3 tb-1 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-1) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 3) (5 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-1 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 189)
  (parent 131)
  (unrealized (0 2) (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 ra-prime-2 ra-1 tb-1 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-2) (tb tb-1) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 3) (5 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-1 (ltk a-0 ks-0))
          (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 190)
  (parent 131)
  (unrealized (0 2) (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 ra-prime-2 rb-prime-0 tb-1 text)
    (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb-1) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-1 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 192)
  (parent 131)
  (unrealized (0 2) (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime tb-0 ra-0 rb-0 rb-1 ra-prime-0
      ra-prime-1 ra-prime-2 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb-0) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb-0) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 1) (0 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb-0 (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb-0 (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb-0 (ltk a ks)) (enc a k tb-0 (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0))
      (send (cat b rb-1 (enc a ra-0 tb-0 (ltk b ks)))))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb-0 (ltk b ks)))
      (send (cat (enc a k tb-0 (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 193)
  (parent 131)
  (unrealized (0 2) (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (7 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 1) (5 2)) ((7 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 270)
  (parent 199)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (7 1)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 1) (5 2)) ((7 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 271)
  (parent 199)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (7 0)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 1) (5 2)) ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 273)
  (parent 199)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 1) (5 2)) ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))) ((recv k) (send k)))
  (label 274)
  (parent 199)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      ra-prime-1 ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 1) (4 2)) ((6 3) (0 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 282)
  (parent 210)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      ra-prime-1 ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 1) (4 2)) ((6 3) (0 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 283)
  (parent 210)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      ra-prime-1 rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 1) (4 2)) ((6 3) (0 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-1 (enc ra-prime-1 k)))))
  (label 285)
  (parent 210)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 rb-prime-0
      ra-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 1) (4 2)) ((6 3) (0 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 286)
  (parent 210)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      ra-prime-1 ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 1) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 291)
  (parent 219)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      ra-prime-1 ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0)) ((4 1) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 292)
  (parent 219)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      ra-prime-1 rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 1) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-1 (enc ra-prime-1 k)))))
  (label 294)
  (parent 219)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 rb-prime-0 ra-prime-0
      ra-prime-1 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (5 2)) ((1 1) (4 0)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 1) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 295)
  (parent 219)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 ra-prime-4 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-4) (rb-prime ra-prime-3)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((2 1) (7 0)) ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2))
    ((6 3) (5 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-3 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-4))
      (recv (cat ra-prime-3 (enc ra-prime-4 k)))
      (send (enc ra-prime-3 k))))
  (label 297)
  (parent 222)
  (unrealized (0 2) (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-3) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((2 1) (7 1)) ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2))
    ((6 3) (5 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-3 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-3 k)))))
  (label 298)
  (parent 222)
  (unrealized (0 2) (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-3) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((2 1) (7 0)) ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2))
    ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-3 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (send (cat rb-prime-0 (enc ra-prime-3 k)))))
  (label 300)
  (parent 222)
  (unrealized (0 2) (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 2)) ((2 1) (1 0))
    ((2 1) (3 0)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((2 1) (7 0)) ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2))
    ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-3 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))) ((recv k) (send k)))
  (label 301)
  (parent 222)
  (unrealized (0 2) (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (5 2))
    ((7 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat rb (enc ra-prime-3 k))) (send (enc rb k))))
  (label 306)
  (parent 228)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (5 2))
    ((7 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k))))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 307)
  (parent 228)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-1) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (5 2))
    ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-1 (enc rb k)))))
  (label 309)
  (parent 228)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (5 2))
    ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))) ((recv k) (send k)))
  (label 310)
  (parent 228)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      ra-prime-2 ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 1) (4 2)) ((6 3) (0 2))
    ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 317)
  (parent 240)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      ra-prime-2 ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 1) (4 2)) ((6 3) (0 2))
    ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 319)
  (parent 240)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      ra-prime-2 rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 1) (4 2)) ((6 3) (0 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-1 (enc ra-prime-2 k)))))
  (label 322)
  (parent 240)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 rb-prime-0
      ra-prime-2 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 1) (4 2)) ((6 3) (0 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 323)
  (parent 240)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      ra-prime-2 ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 1) (3 2)) ((5 3) (0 2)) ((6 3) (5 2))
    ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 332)
  (parent 254)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      ra-prime-2 ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1))
    ((3 3) (1 2)) ((4 1) (3 2)) ((5 3) (0 2)) ((6 3) (5 2))
    ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 333)
  (parent 254)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      ra-prime-2 rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 1) (3 2)) ((5 3) (0 2)) ((6 3) (5 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-1 (enc ra-prime-2 k)))))
  (label 335)
  (parent 254)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 rb-prime-0 ra-prime-1
      ra-prime-2 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-0) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 1) (3 2)) ((5 3) (0 2)) ((6 3) (5 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (send (cat rb-prime-0 (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 336)
  (parent 254)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      ra-prime-2 ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 341)
  (parent 262)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      ra-prime-2 ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 342)
  (parent 262)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      ra-prime-2 rb-prime-1 tb-0 text) (a b ks a-0 b-0 ks-0 name)
    (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-1 (enc ra-prime-2 k)))))
  (label 344)
  (parent 262)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 rb-prime-0 ra-prime-0 ra-prime-1
      ra-prime-2 text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb-prime) (rb-prime rb-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 0)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (1 2))
    ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (cat (enc a k tb (ltk b ks)) rb-prime))
      (send (cat rb-prime-0 (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 345)
  (parent 262)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (7 2)) ((1 1) (6 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2)) ((7 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 347)
  (parent 265)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (7 1)) ((1 1) (6 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2)) ((7 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 348)
  (parent 265)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (7 0)) ((1 1) (6 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2)) ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 349)
  (parent 265)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (6 2)) ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 0))
    ((2 1) (7 0)) ((3 1) (2 0)) ((4 3) (1 2)) ((5 3) (4 2))
    ((6 1) (1 0)) ((6 3) (5 2)) ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 350)
  (parent 265)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (7 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 2) (5 2)) ((7 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k))))
  (label 351)
  (parent 266)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (7 1)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((2 1) (7 1)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 2) (5 2)) ((7 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 352)
  (parent 266)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (7 0)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 1)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 3) (4 2)) ((6 2) (5 2)) ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 354)
  (parent 266)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-1) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 1)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 3) (4 2)) ((6 2) (5 2)) ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv k) (send k)))
  (label 355)
  (parent 266)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 357)
  (parent 267)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 358)
  (parent 267)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 359)
  (parent 267)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (6 2)) ((1 1) (5 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 3) (1 2))
    ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 360)
  (parent 267)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 2) (4 2)) ((6 3) (0 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 362)
  (parent 275)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 2) (4 2)) ((6 3) (0 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 363)
  (parent 275)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 2) (4 2)) ((6 3) (0 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 366)
  (parent 275)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-0) (tb tb) (a a) (b b)
    (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (6 2)) ((1 1) (4 2)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 1)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0))
    ((4 3) (1 2)) ((5 2) (4 2)) ((6 3) (0 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 367)
  (parent 275)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 1) (1 0))
    ((4 3) (1 2)) ((5 3) (0 2)) ((6 3) (5 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 369)
  (parent 278)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0)) ((4 1) (1 0))
    ((4 3) (1 2)) ((5 3) (0 2)) ((6 3) (5 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 370)
  (parent 278)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 1) (1 0))
    ((4 3) (1 2)) ((5 3) (0 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 371)
  (parent 278)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (5 2)) ((1 1) (4 2)) ((2 1) (4 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 1) (1 0))
    ((4 3) (1 2)) ((5 3) (0 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 372)
  (parent 278)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-prime-2 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 2) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))))
  (label 374)
  (parent 288)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      ra-1 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-1) (rb ra-prime-1) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (2 0)) ((4 2) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a-0 ra-1))
      (recv
        (cat (enc b-0 ra-1 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-1 k)))))
  (label 375)
  (parent 288)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-1) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 2) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-1 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-1))
      (send (cat rb-prime-0 (enc ra-prime-1 k)))))
  (label 377)
  (parent 288)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra rb ra-prime rb-prime tb ra-0 rb-0 rb-1 ra-prime-0 ra-prime-1
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra-0) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp 2 (ra ra-0) (rb rb-1) (tb tb) (a a) (b b) (ks ks))
  (defstrand init 3 (ra ra-0) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (5 2)) ((1 1) (4 1)) ((2 1) (1 0)) ((2 1) (5 0))
    ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (2 0)) ((4 2) (1 2))
    ((5 3) (0 2)) ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-1 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra-0 tb (ltk b ks))))
      (send
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-0)))
    ((recv (cat a ra-0)) (send (cat b rb-1 (enc a ra-0 tb (ltk b ks)))))
    ((send (cat a ra-0))
      (recv
        (cat (enc b ra-0 k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k))) ((recv k) (send k)))
  (label 378)
  (parent 288)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2))
    ((7 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-2 (enc ra-prime k)))
      (send (enc ra-prime-2 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat rb (enc ra-prime-3 k))) (send (enc rb k))))
  (label 380)
  (parent 299)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2))
    ((7 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-2 (enc ra-prime k)))
      (send (enc ra-prime-2 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 381)
  (parent 299)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2))
    ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-2 (enc ra-prime k)))
      (send (enc ra-prime-2 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 382)
  (parent 299)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-2)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 3) (4 2)) ((6 1) (1 0)) ((6 3) (5 2))
    ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-2 (enc ra-prime k)))
      (send (enc ra-prime-2 k))) ((recv k) (send k)))
  (label 383)
  (parent 299)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-2) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime rb) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 0) (0 0))
    ((6 2) (5 2)) ((7 3) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-2))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-2 k))))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat rb (enc ra-prime-3 k))) (send (enc rb k))))
  (label 384)
  (parent 302)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-2) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra-0) (rb rb) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((2 1) (7 1))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 0) (0 0))
    ((6 2) (5 2)) ((7 2) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-2))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-2 k))))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc rb k)))))
  (label 385)
  (parent 302)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-2) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand resp-reauth 2 (ra-prime rb) (rb-prime rb-prime-0) (tb tb-0)
    (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 0) (0 0))
    ((6 2) (5 2)) ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2) (enc rb k)
    (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-2))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-2 k))))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) rb))
      (send (cat rb-prime-0 (enc rb k)))))
  (label 387)
  (parent 302)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-2) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 0)) ((2 1) (6 1)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 3) (4 2)) ((6 0) (0 0))
    ((6 2) (5 2)) ((7 1) (0 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc rb k) (0 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-2))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-2 k))))
    ((recv k) (send k)))
  (label 388)
  (parent 302)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2))
    ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 391)
  (parent 303)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2))
    ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 392)
  (parent 303)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 393)
  (parent 303)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 3) (3 2)) ((5 1) (1 0)) ((5 3) (4 2)) ((6 3) (0 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-1 (enc ra-prime k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 394)
  (parent 303)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((2 1) (7 1))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2))
    ((6 3) (0 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 397)
  (parent 311)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2))
    ((6 3) (0 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 400)
  (parent 311)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2))
    ((6 3) (0 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 401)
  (parent 311)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-1) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 0)) ((2 1) (5 1)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 3) (3 2)) ((5 0) (0 0)) ((5 2) (4 2))
    ((6 3) (0 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-1))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-1 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat rb (enc ra-prime-2 k))) (send (enc rb k)))
    ((recv k) (send k)))
  (label 402)
  (parent 311)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 3) (1 2))
    ((4 1) (1 0)) ((4 3) (3 2)) ((5 3) (0 2)) ((6 3) (5 2))
    ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 405)
  (parent 315)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 1) (1 0)) ((4 3) (3 2)) ((5 3) (0 2)) ((6 3) (5 2))
    ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 406)
  (parent 315)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 1) (1 0)) ((4 3) (3 2)) ((5 3) (0 2)) ((6 3) (5 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 407)
  (parent 315)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 3) (1 2))
    ((4 1) (1 0)) ((4 3) (3 2)) ((5 3) (0 2)) ((6 3) (5 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat ra-prime-0 (enc ra-prime k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 408)
  (parent 315)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2))
    ((6 3) (5 2)) ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 409)
  (parent 325)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1))
    ((3 3) (1 2)) ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2))
    ((6 3) (5 2)) ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 410)
  (parent 325)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2))
    ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 413)
  (parent 325)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra) (rb ra-prime-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (1 0)) ((2 1) (3 0))
    ((2 1) (4 1)) ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0))
    ((3 3) (1 2)) ((4 0) (0 0)) ((4 2) (3 2)) ((5 3) (0 2))
    ((6 3) (5 2)) ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb-prime (enc ra-prime-0 k))) (send (enc rb-prime k)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          ra-prime-0))
      (send (cat (enc a k tb (ltk b ks)) (enc ra-prime-0 k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat rb (enc ra-prime-1 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 414)
  (parent 325)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (1 0))
    ((3 3) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2))
    ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 415)
  (parent 328)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 1) (1 0))
    ((3 3) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2))
    ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 416)
  (parent 328)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (1 0))
    ((3 3) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 417)
  (parent 328)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 1) (1 0))
    ((3 3) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime))
      (recv (cat rb-prime (enc ra-prime k))) (send (enc rb-prime k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 418)
  (parent 328)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-prime-3 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-3) (rb-prime ra-prime-2)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 0) (0 0))
    ((3 2) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2))
    ((7 3) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init-reauth 4)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (enc a-0 k tb-0 (ltk b-0 ks-0)))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-3))
      (recv (cat ra-prime-2 (enc ra-prime-3 k)))
      (send (enc ra-prime-2 k))))
  (label 420)
  (parent 338)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      ra-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init 3 (ra ra-0) (rb ra-prime-2) (tb tb-0) (a a-0) (b b-0)
    (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 1)) ((3 0) (0 0))
    ((3 2) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2))
    ((7 2) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand init 3) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((send (cat a-0 ra-0))
      (recv
        (cat (enc b-0 ra-0 k tb-0 (ltk a-0 ks-0))
          (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) (enc ra-prime-2 k)))))
  (label 421)
  (parent 338)
  (unrealized (7 1))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      rb-prime-0 tb-0 text) (a b ks a-0 b-0 ks-0 name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 2 (ra-prime ra-prime-2) (rb-prime rb-prime-0)
    (tb tb-0) (a a-0) (b b-0) (ks ks-0) (k k))
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 0) (0 0))
    ((3 2) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-strand resp-reauth 2)
    (enc ra-prime-2 k) (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k)))
    ((recv (cat (enc a-0 k tb-0 (ltk b-0 ks-0)) ra-prime-2))
      (send (cat rb-prime-0 (enc ra-prime-2 k)))))
  (label 423)
  (parent 338)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))

(defskeleton neuman-stubblebine-reauth
  (vars
    (ra tb rb ra-prime rb-prime rb-0 ra-prime-0 ra-prime-1 ra-prime-2
      text) (a b ks name) (k skey))
  (defstrand resp 3 (ra ra) (rb rb) (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand resp-reauth 3 (ra-prime ra-prime) (rb-prime rb-prime)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand keyserver 2 (ra ra) (rb rb-0) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init 3 (ra ra) (rb rb-prime) (tb tb) (a a) (b b) (ks ks)
    (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-0) (rb-prime rb) (tb tb)
    (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-1) (rb-prime ra-prime-0)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (defstrand init-reauth 4 (ra-prime ra-prime-2) (rb-prime ra-prime-1)
    (tb tb) (a a) (b b) (ks ks) (k k))
  (deflistener k)
  (precedes ((0 1) (2 0)) ((1 1) (3 1)) ((2 1) (1 0)) ((2 1) (4 0))
    ((2 1) (5 0)) ((2 1) (6 0)) ((2 1) (7 0)) ((3 0) (0 0))
    ((3 2) (1 2)) ((4 3) (0 2)) ((5 3) (4 2)) ((6 3) (5 2))
    ((7 1) (6 2)))
  (non-orig (ltk a ks) (ltk b ks))
  (uniq-orig ra rb ra-prime rb-prime k)
  (operation encryption-test (added-listener k) (enc ra-prime-2 k)
    (6 2))
  (traces
    ((recv (cat a ra)) (send (cat b rb (enc a ra tb (ltk b ks))))
      (recv (cat (enc a k tb (ltk b ks)) (enc rb k))))
    ((recv (cat (enc a k tb (ltk b ks)) ra-prime))
      (send (cat rb-prime (enc ra-prime k))) (recv (enc rb-prime k)))
    ((recv (cat b rb-0 (enc a ra tb (ltk b ks))))
      (send
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks)) rb-0)))
    ((send (cat a ra))
      (recv
        (cat (enc b ra k tb (ltk a ks)) (enc a k tb (ltk b ks))
          rb-prime))
      (send (cat (enc a k tb (ltk b ks)) (enc rb-prime k))))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-0))
      (recv (cat rb (enc ra-prime-0 k))) (send (enc rb k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-1))
      (recv (cat ra-prime-0 (enc ra-prime-1 k)))
      (send (enc ra-prime-0 k)))
    ((recv (enc a k tb (ltk b ks)))
      (send (cat (enc a k tb (ltk b ks)) ra-prime-2))
      (recv (cat ra-prime-1 (enc ra-prime-2 k)))
      (send (enc ra-prime-1 k))) ((recv k) (send k)))
  (label 424)
  (parent 338)
  (unrealized (7 0))
  (aborted)
  (comment "aborted"))
