(herald wonthull2 (bound 9))

(comment "CPSA 4.3.0")
(comment "All input read from tst/wonthull2.scm")
(comment "Strand count bounded at 9")

(defprotocol wonthull2 basic
  (defrole init
    (vars (a name) (x1 x2 x3 x4 text))
    (trace (send (cat (enc x1 x3 (pubk a)) (enc x3 x2 (pubk a))))
      (recv (enc "okay" x3 x4 (pubk a))))
    (non-orig (privk a))
    (uniq-orig x3))
  (defrole resp
    (vars (a name) (y1 y2 y3 text))
    (trace (recv (enc y1 y2 (pubk a)))
      (send (enc "okay" y3 y1 (pubk a)))))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton wonthull2
  (vars (x1 x2 x3 x4 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x3) (x4 x4) (a a))
  (non-orig (privk a))
  (uniq-orig x3)
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x2 (pubk a))))
      (recv (enc "okay" x3 x4 (pubk a)))))
  (label 0)
  (unrealized (0 1))
  (origs (x3 (0 0)))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 x3 x4 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x3) (x4 x4) (a a))
  (defstrand resp 2 (y1 x3) (y2 x2) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (0 1)
    (enc x1 x3 (pubk a)) (enc x3 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x2 (pubk a))))
      (recv (enc "okay" x3 x4 (pubk a))))
    ((recv (enc x3 x2 (pubk a))) (send (enc "okay" y3 x3 (pubk a)))))
  (label 1)
  (parent 0)
  (unrealized (0 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 x4 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x4) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x4 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 2)
  (parent 0)
  (seen 5)
  (unrealized (0 1))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x2) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (x3 y3) (x4 y3)) y3 (0 1)
    (enc "okay" y3 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x2 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x2 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 3)
  (parent 1)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (x1 x1) (x2 x2) (x3 y3) (x4 y3))))
  (origs (y3 (0 0))))

(defskeleton wonthull2
  (vars (x1 x2 x3 x4 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x3) (x4 x4) (a a))
  (defstrand resp 2 (y1 x3) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x2) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (0 1)
    (enc "okay" y3 x3 (pubk a)) (enc x1 x3 (pubk a))
    (enc x3 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x2 (pubk a))))
      (recv (enc "okay" x3 x4 (pubk a))))
    ((recv (enc x3 x2 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x2 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 4)
  (parent 1)
  (unrealized (0 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 x4 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x4) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x1 (pubk a))
    (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x4 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 5)
  (parent 1)
  (seen 10)
  (unrealized (0 1))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x2 y3 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x2) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (x1 y3) (x4 y3)) y3 (0 1)
    (enc "okay" y3 y3 (pubk a)) (enc y3 x2 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x2 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 6)
  (parent 2)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 x4 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x4) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x1 (pubk a))
    (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x4 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 7)
  (parent 2)
  (seen 13)
  (unrealized (0 1))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x3 x1) (x4 x1)) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 8)
  (parent 4)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x2) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (x3 y3) (x4 y3)) y3 (0 1)
    (enc "okay" x1 y3 (pubk a)) (enc "okay" y3 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x2 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x2 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x2 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 9)
  (parent 4)
  (seen 3)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 x4 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x4) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x4 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 10)
  (parent 4)
  (unrealized (0 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x2 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x2) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (x1 y3-0) (x4 y3-0)) y3-0 (0 1)
    (enc "okay" y3 y3-0 (pubk a)) (enc "okay" y3-0 y3-0 (pubk a))
    (enc y3-0 x2 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x2 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x2 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 11)
  (parent 5)
  (seen 6)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x2 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x2) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (x1 y3) (x4 y3)) y3 (0 1)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc y3 x2 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x2 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x2 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 12)
  (parent 5)
  (seen 16)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 x4 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x4) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" y3 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x4 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 13)
  (parent 5)
  (unrealized (0 1))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x2 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x2) (x3 y3-0) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3 y3-0)
  (operation generalization separated y3-0)
  (traces
    ((send (cat (enc y3 y3-0 (pubk a)) (enc y3-0 x2 (pubk a))))
      (recv (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 14)
  (parent 6)
  (unrealized)
  (shape)
  (maps ((0) ((a a) (x1 y3) (x2 x2) (x3 y3-0) (x4 y3))))
  (origs (y3 (0 0)) (y3-0 (0 0))))

(defskeleton wonthull2
  (vars (x1 x2 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x4 x1)) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 15)
  (parent 7)
  (seen 6)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation generalization deleted (1 0))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 16)
  (parent 8)
  (seen 3)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x4 x1)) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x1 (pubk a))
    (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 17)
  (parent 10)
  (seen 12)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x2 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x2) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x2) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x4 x1)) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x1 (pubk a))
    (enc x1 x2 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x2 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x2 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 18)
  (parent 13)
  (seen 15)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Nothing left to do")

(defprotocol wonthull2 basic
  (defrole init
    (vars (a name) (x1 x2 x3 x4 text))
    (trace (send (cat (enc x1 x3 (pubk a)) (enc x3 x2 (pubk a))))
      (recv (enc "okay" x3 x4 (pubk a))))
    (non-orig (privk a))
    (uniq-orig x3))
  (defrole resp
    (vars (a name) (y1 y2 y3 text))
    (trace (recv (enc y1 y2 (pubk a)))
      (send (enc "okay" y3 y1 (pubk a)))))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 x3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3-0)
  (traces
    ((send (cat (enc x1-0 x3-0 (pubk a)) (enc x3-0 x3 (pubk a))))
      (recv (enc "okay" x3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0)))
      (send (enc "okay" x3 x1 (pubk a-0)))))
  (label 19)
  (unrealized (0 1))
  (origs (x3-0 (0 0)))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 text) (a name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 2 1 resp 2) x3-0 (0 1)
    (enc x1-0 x3-0 (pubk a-0)) (enc x3-0 x3 (pubk a-0)))
  (traces
    ((send (cat (enc x1-0 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a)))))
  (label 20)
  (parent 19)
  (unrealized (0 1))
  (origs (x1 (0 0)))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (displaced 2 1 resp 2) x3-0 (0 1)
    (enc x1-0 x3-0 (pubk a)) (enc x3-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0)))
      (send (enc "okay" x3 x1 (pubk a-0)))))
  (label 21)
  (parent 19)
  (seen 24)
  (unrealized (1 0))
  (origs (x3 (0 0)))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 x3-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3-0) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3-0)
  (operation nonce-test (added-strand resp 2) x3-0 (0 1)
    (enc x1-0 x3-0 (pubk a)) (enc x3-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3-0 (pubk a)) (enc x3-0 x3 (pubk a))))
      (recv (enc "okay" x3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3-0 x3 (pubk a)))
      (send (enc "okay" y3 x3-0 (pubk a)))))
  (label 22)
  (parent 19)
  (seen 26)
  (unrealized (0 1))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (0 1)
    (enc x1-0 x3 (pubk a)) (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a)))))
  (label 23)
  (parent 19)
  (seen 25 32)
  (unrealized (0 1))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (displaced 2 1 resp 2) x1-0 (0 1)
    (enc "okay" x3 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))
    (enc x1 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 24)
  (parent 20)
  (unrealized)
  (shape)
  (maps ((0 1) ((x1 x3) (x3 x3) (a a) (x1-0 x1) (x3-0 x3) (a-0 a))))
  (origs (x3 (0 0))))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 25)
  (parent 20)
  (unrealized (0 1))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1-0 x1 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 26)
  (parent 20)
  (seen 39)
  (unrealized (0 1))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a)))))
  (label 27)
  (parent 21)
  (unrealized)
  (shape)
  (maps ((0 1) ((x1 x1) (x3 x3) (a a) (x1-0 x1) (x3-0 x3) (a-0 a))))
  (origs (x3 (0 0))))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a)))))
  (label 28)
  (parent 21)
  (unrealized (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 x3-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3-0) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3-0)
  (operation nonce-test (added-strand resp 2) x3-0 (0 1)
    (enc "okay" y3 x3-0 (pubk a)) (enc x1-0 x3-0 (pubk a))
    (enc x3-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3-0 (pubk a)) (enc x3-0 x3 (pubk a))))
      (recv (enc "okay" x3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3-0 x3 (pubk a))) (send (enc "okay" y3 x3-0 (pubk a))))
    ((recv (enc x3-0 x3 (pubk a)))
      (send (enc "okay" x1-0 x3-0 (pubk a)))))
  (label 29)
  (parent 22)
  (seen 41)
  (unrealized (0 1))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (x1-0 y3) (x3-0 y3)) y3 (0 1)
    (enc "okay" y3 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 30)
  (parent 22)
  (seen 42)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (displaced 3 1 resp 2) x3-0 (0 1)
    (enc "okay" y3 x3-0 (pubk a)) (enc x1-0 x3-0 (pubk a))
    (enc x3-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a)))))
  (label 31)
  (parent 22)
  (seen 28 40)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (0 1)
    (enc "okay" y3 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))
    (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1-0 x3 (pubk a))) (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3-0 x1-0 (pubk a)))))
  (label 32)
  (parent 22)
  (seen 35 39 50)
  (unrealized (0 1))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (0 1)
    (enc "okay" y3 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))
    (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 33)
  (parent 23)
  (seen 56)
  (unrealized (0 1))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (x1 y3) (x1-0 y3)) y3 (0 1)
    (enc "okay" y3 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 34)
  (parent 23)
  (seen 36)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (displaced 3 2 resp 2) x1-0 (0 1)
    (enc "okay" y3 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))
    (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a)))))
  (label 35)
  (parent 23)
  (seen 38)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 3 2 resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 36)
  (parent 25)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 37)
  (parent 25)
  (seen 36)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 3 2 resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 38)
  (parent 25)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 39)
  (parent 25)
  (seen 38)
  (unrealized (0 1))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (displaced 3 1 resp 2) x1-0 (0 1)
    (enc "okay" x3 x1-0 (pubk a)) (enc "okay" y3 x1-0 (pubk a))
    (enc x1-0 x3 (pubk a)) (enc x1 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a)))))
  (label 40)
  (parent 26)
  (seen 24)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1-0 x1 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1-0 x1 (pubk a)))))
  (label 41)
  (parent 26)
  (unrealized (0 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 3 2 resp 2) x1-0 (0 1)
    (enc "okay" x3 x1-0 (pubk a)) (enc "okay" y3 x1-0 (pubk a))
    (enc x1-0 x3 (pubk a)) (enc x1 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 42)
  (parent 26)
  (unrealized)
  (shape)
  (maps ((0 1) ((x1 y3) (x3 x3) (a a) (x1-0 x1) (x3-0 y3) (a-0 a))))
  (origs (y3 (0 0))))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a)))))
  (label 43)
  (parent 28)
  (seen 27)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a)))))
  (label 44)
  (parent 28)
  (seen 24)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a)))))
  (label 45)
  (parent 28)
  (unrealized (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 46)
  (parent 28)
  (seen 77)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (x1-0 y3) (x3-0 y3)) y3 (0 1)
    (enc "okay" x1 y3 (pubk a)) (enc "okay" y3 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 47)
  (parent 29)
  (seen 53 73)
  (unrealized (1 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (x3-0 x1)) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 48)
  (parent 29)
  (seen 74)
  (unrealized (1 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (displaced 4 1 resp 2) x3-0 (0 1)
    (enc "okay" x1-0 x3-0 (pubk a)) (enc "okay" y3 x3-0 (pubk a))
    (enc x1-0 x3-0 (pubk a)) (enc x3-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a)))))
  (label 49)
  (parent 29)
  (seen 72)
  (unrealized (1 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (0 1)
    (enc "okay" x1-0 x1-0 (pubk a)) (enc "okay" y3 x1-0 (pubk a))
    (enc x1-0 x3 (pubk a)) (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1-0 x3 (pubk a))) (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x3 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3-0 x1-0 (pubk a)))))
  (label 50)
  (parent 29)
  (seen 60)
  (unrealized (0 1))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 3 2 resp 2) y3 (1 0)
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 51)
  (parent 30)
  (unrealized (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 52)
  (parent 30)
  (seen 93)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 53)
  (parent 30)
  (seen 94 97)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a)))))
  (label 54)
  (parent 31)
  (seen 27)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a)))))
  (label 55)
  (parent 31)
  (seen 28)
  (unrealized (1 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (0 1)
    (enc "okay" y3 x1-0 (pubk a)) (enc "okay" y3-0 x1-0 (pubk a))
    (enc x1-0 x3 (pubk a)) (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1-0 x3 (pubk a))) (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3-0 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 56)
  (parent 32)
  (seen 60)
  (unrealized (0 1))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (x1 y3-0) (x1-0 y3-0)) y3-0 (0 1)
    (enc "okay" y3 y3-0 (pubk a)) (enc "okay" y3-0 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 57)
  (parent 32)
  (seen 63 70)
  (unrealized (1 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (x1 y3) (x1-0 y3)) y3 (0 1)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 58)
  (parent 32)
  (seen 53 71)
  (unrealized (1 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1)) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 59)
  (parent 33)
  (seen 37 62)
  (unrealized (1 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (displaced 4 3 resp 2) x1-0 (0 1)
    (enc "okay" x1-0 x1-0 (pubk a)) (enc "okay" y3 x1-0 (pubk a))
    (enc x1-0 x3 (pubk a)) (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 60)
  (parent 33)
  (unrealized (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 3 2 resp 2) y3 (1 0)
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 61)
  (parent 34)
  (unrealized (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 62)
  (parent 34)
  (seen 119)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 63)
  (parent 34)
  (seen 120 123)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (displaced 3 2 resp 2) x1-0 (1 0)
    (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a)))))
  (label 64)
  (parent 35)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (1 0)
    (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3-0 x1-0 (pubk a)))))
  (label 65)
  (parent 35)
  (seen 64)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3-0) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation generalization separated y3-0)
  (traces
    ((send (cat (enc y3 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 66)
  (parent 36)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((1 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 67)
  (parent 38)
  (seen 24)
  (unrealized)
  (origs (x1 (0 0)))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 68)
  (parent 39)
  (seen 74)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 69)
  (parent 39)
  (seen 70)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 4 2 resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 70)
  (parent 39)
  (seen 36)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (displaced 4 3 resp 2) x1 (0 1)
    (enc "okay" x3 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 71)
  (parent 39)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (displaced 4 1 resp 2) x1-0 (0 1)
    (enc "okay" x3 x1-0 (pubk a)) (enc "okay" x1 x1-0 (pubk a))
    (enc "okay" y3 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))
    (enc x1 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 72)
  (parent 41)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 4 2 resp 2) x1-0 (0 1)
    (enc "okay" x3 x1-0 (pubk a)) (enc "okay" x1 x1-0 (pubk a))
    (enc "okay" y3 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))
    (enc x1 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 73)
  (parent 41)
  (seen 42)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 4 3 resp 2) x1-0 (0 1)
    (enc "okay" x3 x1-0 (pubk a)) (enc "okay" x1 x1-0 (pubk a))
    (enc "okay" y3 x1-0 (pubk a)) (enc x1-0 x3 (pubk a))
    (enc x1 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 74)
  (parent 41)
  (seen 131)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 75)
  (parent 45)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 76)
  (parent 45)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" x1-0 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 77)
  (parent 45)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 78)
  (parent 46)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 79)
  (parent 46)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 4 2 resp 2) y3 (1 0)
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 80)
  (parent 47)
  (unrealized (1 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 4 3 resp 2) y3 (1 0)
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 81)
  (parent 47)
  (seen 95 139 142)
  (unrealized (1 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 82)
  (parent 47)
  (seen 95 97 141)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 83)
  (parent 48)
  (seen 97)
  (unrealized (1 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 4 2 resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 84)
  (parent 48)
  (seen 97)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 4 3 resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 85)
  (parent 48)
  (seen 148 152)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 86)
  (parent 48)
  (seen 84 149 154)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 87)
  (parent 49)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (displaced 4 2 resp 2) x3 (1 0)
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a)))))
  (label 88)
  (parent 49)
  (seen 45)
  (unrealized (1 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (displaced 4 3 resp 2) x3 (1 0)
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a)))))
  (label 89)
  (parent 49)
  (seen 45 102)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a)))))
  (label 90)
  (parent 49)
  (seen 88 102)
  (unrealized (1 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1)) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 91)
  (parent 50)
  (seen 68 83 110)
  (unrealized (1 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 92)
  (parent 51)
  (seen 42)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 93)
  (parent 51)
  (unrealized (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 94)
  (parent 51)
  (seen 173)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 95)
  (parent 52)
  (seen 172)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 96)
  (parent 52)
  (seen 42)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 97)
  (parent 52)
  (seen 173 176)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 98)
  (parent 53)
  (seen 177)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 99)
  (parent 53)
  (seen 131)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a)))))
  (label 100)
  (parent 55)
  (seen 43)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a)))))
  (label 101)
  (parent 55)
  (seen 44)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a)))))
  (label 102)
  (parent 55)
  (seen 45)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 103)
  (parent 55)
  (seen 46 182)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1)) x1 (0 1)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 104)
  (parent 56)
  (seen 69 106 113)
  (unrealized (1 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (displaced 4 3 resp 2) y3-0 (1 0)
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 105)
  (parent 57)
  (seen 120)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a)))))
  (label 106)
  (parent 57)
  (seen 123 188)
  (unrealized (1 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a)))))
  (label 107)
  (parent 57)
  (seen 63 190 193)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 108)
  (parent 58)
  (seen 53)
  (unrealized (1 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 4 2 resp 2) y3 (1 0)
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 109)
  (parent 58)
  (seen 94 198)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 110)
  (parent 58)
  (seen 97 199 201)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 4 3 resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 111)
  (parent 59)
  (seen 119)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 112)
  (parent 59)
  (seen 62 205)
  (unrealized (1 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 113)
  (parent 59)
  (seen 123 206 209)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (displaced 4 2 resp 2) x1-0 (1 0)
    (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 114)
  (parent 60)
  (seen 127)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 115)
  (parent 60)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (displaced 4 3 resp 2) x1-0 (1 0)
    (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 116)
  (parent 60)
  (seen 127 129)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (1 0)
    (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3-0 x1-0 (pubk a)))))
  (label 117)
  (parent 60)
  (seen 114 129)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 118)
  (parent 61)
  (seen 36)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 119)
  (parent 61)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 120)
  (parent 61)
  (seen 219)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 121)
  (parent 62)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 122)
  (parent 62)
  (seen 36)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 123)
  (parent 62)
  (seen 219 222)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 124)
  (parent 63)
  (seen 224)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 125)
  (parent 63)
  (seen 36)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 126)
  (parent 64)
  (seen 67)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (1 0)
    (enc "okay" y3 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 127)
  (parent 64)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 128)
  (parent 65)
  (seen 126)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (1 0)
    (enc "okay" y3-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3-0 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 129)
  (parent 65)
  (seen 127)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3-0) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a) (privk a-0))
  (uniq-orig y3-0)
  (operation generalization separated a-0)
  (traces
    ((send (cat (enc y3 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 130)
  (parent 66)
  (unrealized)
  (shape)
  (maps ((0 1) ((x1 y3) (x3 x3) (a a) (x1-0 y3) (x3-0 y3-0) (a-0 a-0))))
  (origs (y3-0 (0 0))))

(defskeleton wonthull2
  (vars (x3 y3 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 131)
  (parent 71)
  (seen 42)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 132)
  (parent 72)
  (seen 24)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 133)
  (parent 75)
  (seen 24)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 134)
  (parent 76)
  (seen 27)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" x1 x3 (pubk a))
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 135)
  (parent 77)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" x1 x3 (pubk a))
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 136)
  (parent 77)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 137)
  (parent 78)
  (seen 24)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 138)
  (parent 79)
  (seen 27)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 4 3 resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 139)
  (parent 80)
  (seen 94 172)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 140)
  (parent 80)
  (seen 92)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 141)
  (parent 80)
  (seen 172 176)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 142)
  (parent 80)
  (seen 176)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" x1 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 143)
  (parent 81)
  (seen 42)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 144)
  (parent 82)
  (seen 176 231)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 145)
  (parent 82)
  (seen 96)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 146)
  (parent 83)
  (seen 177)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 147)
  (parent 83)
  (seen 99)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 5 3 resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 148)
  (parent 83)
  (seen 173)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 149)
  (parent 83)
  (seen 97 236 238)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 150)
  (parent 84)
  (seen 176)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 151)
  (parent 84)
  (seen 131)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 4 3 resp 2) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 152)
  (parent 84)
  (seen 173)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 153)
  (parent 85)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 154)
  (parent 85)
  (seen 152 238)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 155)
  (parent 86)
  (seen 150 240)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 156)
  (parent 86)
  (seen 151)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 157)
  (parent 87)
  (seen 27)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 158)
  (parent 88)
  (seen 157)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 159)
  (parent 88)
  (seen 132)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a)))))
  (label 160)
  (parent 88)
  (unrealized (1 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 161)
  (parent 88)
  (seen 77 248)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 162)
  (parent 89)
  (seen 134)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 163)
  (parent 89)
  (seen 133)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a)))))
  (label 164)
  (parent 90)
  (seen 160)
  (unrealized (1 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a)))))
  (label 165)
  (parent 90)
  (seen 158)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a)))))
  (label 166)
  (parent 90)
  (seen 159)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 167)
  (parent 90)
  (seen 161 182 253)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 168)
  (parent 91)
  (seen 83 199)
  (unrealized (1 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 5 3 resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 169)
  (parent 91)
  (seen 148 201 258)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 170)
  (parent 91)
  (seen 110 149 259 261)
  (unrealized (1 0))
  (comment "6 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 171)
  (parent 93)
  (seen 92)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 172)
  (parent 93)
  (seen 173)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 173)
  (parent 93)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 174)
  (parent 94)
  (seen 243)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" x1 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 175)
  (parent 95)
  (seen 143)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 176)
  (parent 95)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 177)
  (parent 97)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 178)
  (parent 97)
  (seen 99)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 179)
  (parent 98)
  (seen 218)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 180)
  (parent 102)
  (seen 76)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 181)
  (parent 102)
  (seen 75)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" x1-0 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 182)
  (parent 102)
  (seen 77)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 183)
  (parent 103)
  (seen 79)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 184)
  (parent 103)
  (seen 78)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 5 4 resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 185)
  (parent 104)
  (seen 188 206)
  (unrealized (1 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 186)
  (parent 104)
  (seen 106 209 271)
  (unrealized (1 0))
  (comment "6 in cohort - 3 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 187)
  (parent 104)
  (seen 113 193 272 275)
  (unrealized (1 0))
  (comment "6 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a)))))
  (label 188)
  (parent 105)
  (seen 219)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 189)
  (parent 105)
  (seen 118)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a)))))
  (label 190)
  (parent 105)
  (seen 120 279)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc "okay" y3-1 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 191)
  (parent 106)
  (seen 222)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-1 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a)))))
  (label 192)
  (parent 106)
  (seen 122)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc "okay" y3-1 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-2 y3-0 (pubk a)))))
  (label 193)
  (parent 106)
  (seen 123 279 282)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc "okay" y3-1 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 194)
  (parent 107)
  (seen 124 284)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-1 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a)))))
  (label 195)
  (parent 107)
  (seen 125)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 196)
  (parent 108)
  (seen 98)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 197)
  (parent 108)
  (seen 99)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (displaced 5 2 resp 2) y3 (1 0)
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 198)
  (parent 108)
  (seen 94)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-2 y3 (pubk a)))))
  (label 199)
  (parent 108)
  (seen 97 287 289)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 200)
  (parent 109)
  (seen 243)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 201)
  (parent 109)
  (seen 173 289)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 202)
  (parent 110)
  (seen 176 291)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 203)
  (parent 110)
  (seen 151)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 204)
  (parent 111)
  (seen 118)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 205)
  (parent 111)
  (seen 119)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 206)
  (parent 111)
  (seen 219 295)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 207)
  (parent 112)
  (seen 121)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 208)
  (parent 112)
  (seen 122)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 209)
  (parent 112)
  (seen 123 295 298)
  (unrealized (1 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 210)
  (parent 113)
  (seen 224 300)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 211)
  (parent 113)
  (seen 125)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" y3 x1 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 212)
  (parent 114)
  (seen 214)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (1 0)
    (enc "okay" y3 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 213)
  (parent 114)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (1 0)) ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 214)
  (parent 115)
  (seen 67)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 215)
  (parent 116)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x1-0) (x3 x1-0) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1-0) (y3 x1-0) (a a-0))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1-0) (y2 x1-0) (y3 x1-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1-0)
  (operation nonce-test (added-strand resp 2) x1-0 (1 0)
    (enc "okay" y3-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x1-0 (pubk a)) (enc x1-0 x1-0 (pubk a))))
      (recv (enc "okay" x1-0 x1 (pubk a))))
    ((recv (enc x1 x1-0 (pubk a-0)))
      (send (enc "okay" x1-0 x1 (pubk a-0))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" y3-0 x1-0 (pubk a))))
    ((recv (enc x1-0 x1-0 (pubk a)))
      (send (enc "okay" x1-0 x1-0 (pubk a)))))
  (label 216)
  (parent 117)
  (seen 213)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 217)
  (parent 117)
  (seen 212)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 218)
  (parent 119)
  (seen 118)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 219)
  (parent 119)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 220)
  (parent 120)
  (seen 118)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 221)
  (parent 121)
  (seen 218)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 222)
  (parent 121)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 223)
  (parent 123)
  (seen 125)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-0 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 224)
  (parent 123)
  (unrealized (1 0))
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 225)
  (parent 124)
  (seen 242)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 226)
  (parent 127)
  (seen 303)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 227)
  (parent 129)
  (seen 226)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 228)
  (parent 135)
  (seen 137)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 229)
  (parent 136)
  (seen 138)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" x1 y3 (pubk a)) (enc "okay" y3 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 230)
  (parent 139)
  (seen 92)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 231)
  (parent 141)
  (seen 176)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a)))))
  (label 232)
  (parent 141)
  (seen 171)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a)))))
  (label 233)
  (parent 142)
  (seen 99)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" x1 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 234)
  (parent 144)
  (seen 175)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 235)
  (parent 146)
  (seen 179)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 236)
  (parent 146)
  (seen 177)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 237)
  (parent 148)
  (seen 174)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 238)
  (parent 148)
  (seen 173)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 239)
  (parent 149)
  (seen 178)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 240)
  (parent 149)
  (seen 176)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 241)
  (parent 150)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (1 0))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 242)
  (parent 152)
  (seen 243)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 243)
  (parent 153)
  (seen 131)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 244)
  (parent 154)
  (seen 242)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 245)
  (parent 155)
  (seen 241)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 246)
  (parent 160)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 247)
  (parent 160)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" x1-0 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 248)
  (parent 160)
  (unrealized (1 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 249)
  (parent 161)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" y3 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 250)
  (parent 161)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 251)
  (parent 164)
  (seen 247)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x1 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 252)
  (parent 164)
  (seen 246)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 x3 x1-0 y3 y3-0 text) (a a-0 name))
  (defstrand init 2 (x1 x1-0) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (added-strand resp 2) x3 (1 0)
    (enc "okay" x1-0 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1-0 x3 (pubk a)))
  (traces
    ((send (cat (enc x1-0 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 253)
  (parent 164)
  (seen 248)
  (unrealized (1 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 254)
  (parent 167)
  (seen 249)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" y3-0 x3 (pubk a))
    (enc x3 x3 (pubk a)) (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 255)
  (parent 167)
  (seen 250)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 256)
  (parent 168)
  (seen 146 287)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 257)
  (parent 168)
  (seen 197)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (displaced 6 3 resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 258)
  (parent 168)
  (seen 148 289)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 259)
  (parent 168)
  (seen 149 199 322 324)
  (unrealized (1 0))
  (comment "6 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (0 1)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 260)
  (parent 169)
  (seen 200)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 261)
  (parent 169)
  (seen 201 238 324)
  (unrealized (1 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 262)
  (parent 170)
  (seen 202 240 325)
  (unrealized (1 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 263)
  (parent 170)
  (seen 203)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" x1 y3 (pubk a)) (enc "okay" y3 y3 (pubk a))
    (enc "okay" y3-0 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 264)
  (parent 172)
  (seen 230)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 265)
  (parent 173)
  (seen 174)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 266)
  (parent 176)
  (seen 265)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc "okay" y3-0 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 267)
  (parent 177)
  (seen 305)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" x1 x3 (pubk a))
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 268)
  (parent 182)
  (seen 135)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" x1 x3 (pubk a))
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 269)
  (parent 182)
  (seen 136)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 270)
  (parent 185)
  (seen 204)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 271)
  (parent 185)
  (seen 188 295)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 272)
  (parent 185)
  (seen 206 279 330)
  (unrealized (1 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 273)
  (parent 186)
  (seen 191 298)
  (unrealized (1 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 274)
  (parent 186)
  (seen 208)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 275)
  (parent 186)
  (seen 193 209 330 333)
  (unrealized (1 0))
  (comment "6 in cohort - 2 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 276)
  (parent 187)
  (seen 210 284 334)
  (unrealized (1 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 277)
  (parent 187)
  (seen 211)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a)))))
  (label 278)
  (parent 188)
  (seen 218)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-2 y3-0 (pubk a)))))
  (label 279)
  (parent 188)
  (seen 219)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a)))))
  (label 280)
  (parent 190)
  (seen 220)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 281)
  (parent 191)
  (seen 221)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-2 y3-0 (pubk a)))))
  (label 282)
  (parent 191)
  (seen 222)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-1 y3-0 (pubk a)) (enc "okay" y3-2 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-2 y3-0 (pubk a)))))
  (label 283)
  (parent 193)
  (seen 223)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-2) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (added-strand resp 2) y3-0 (1 0)
    (enc "okay" y3-1 y3-0 (pubk a)) (enc "okay" y3-2 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a-0)))
      (send (enc "okay" x3 y3-0 (pubk a-0))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-2 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 284)
  (parent 193)
  (seen 224)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc y3-0 x3 (pubk a)) (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 285)
  (parent 194)
  (seen 225)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 286)
  (parent 196)
  (seen 294)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-2 y3 (pubk a)))))
  (label 287)
  (parent 196)
  (seen 177)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 288)
  (parent 198)
  (seen 174)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-2 y3 (pubk a)))))
  (label 289)
  (parent 198)
  (seen 173)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3-1 y3 (pubk a)) (enc "okay" y3-2 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-2 y3 (pubk a)))))
  (label 290)
  (parent 199)
  (seen 178)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-2) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (added-strand resp 2) y3 (1 0)
    (enc "okay" y3-1 y3 (pubk a)) (enc "okay" y3-2 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a-0))) (send (enc "okay" x3 y3 (pubk a-0))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-2 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 291)
  (parent 199)
  (seen 176)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 292)
  (parent 201)
  (seen 242)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc y3 x3 (pubk a)) (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 293)
  (parent 202)
  (seen 292)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 294)
  (parent 205)
  (seen 218)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 295)
  (parent 205)
  (seen 219)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a)))))
  (label 296)
  (parent 206)
  (seen 220)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 297)
  (parent 207)
  (seen 221)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 298)
  (parent 207)
  (seen 222)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 299)
  (parent 209)
  (seen 223)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-0 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 300)
  (parent 209)
  (seen 224)
  (unrealized (1 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 301)
  (parent 210)
  (seen 225)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3 x1 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 302)
  (parent 213)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((1 1) (0 1)) ((2 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 303)
  (parent 215)
  (seen 67)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 304)
  (parent 216)
  (seen 302)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (1 0)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 305)
  (parent 219)
  (seen 220)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a)))))
  (label 306)
  (parent 222)
  (seen 305)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-0 y3 (pubk a))
    (enc "okay" y3-1 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 307)
  (parent 224)
  (seen 265)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" x1 y3 (pubk a)) (enc "okay" y3 y3 (pubk a))
    (enc "okay" y3-0 y3 (pubk a)) (enc x1 y3 (pubk a))
    (enc y3 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x1 y3 (pubk a)))))
  (label 308)
  (parent 231)
  (seen 264)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 309)
  (parent 236)
  (seen 267)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 310)
  (parent 238)
  (seen 265)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 311)
  (parent 240)
  (seen 266)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 312)
  (parent 241)
  (seen 243)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 313)
  (parent 246)
  (seen 133)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a)))))
  (label 314)
  (parent 247)
  (seen 134)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" x1 x3 (pubk a))
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 315)
  (parent 248)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" x1 x3 (pubk a))
    (enc "okay" y3 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 316)
  (parent 248)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 317)
  (parent 249)
  (seen 138)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 318)
  (parent 250)
  (seen 137)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x3) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" x1 x3 (pubk a))
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 319)
  (parent 253)
  (seen 315)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation nonce-test (contracted (x1-0 x1) (a-0 a)) x3 (1 0)
    (enc "okay" x3 x3 (pubk a)) (enc "okay" x1 x3 (pubk a))
    (enc "okay" y3-0 x3 (pubk a)) (enc x3 x3 (pubk a))
    (enc x1 x3 (pubk a)))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" y3-0 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 320)
  (parent 253)
  (seen 316)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 321)
  (parent 256)
  (seen 286)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((0 0) (7 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (0 1)) ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0))
    ((7 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 322)
  (parent 256)
  (seen 236 287)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 323)
  (parent 258)
  (seen 288)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 324)
  (parent 258)
  (seen 238 289)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((0 0) (7 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (0 1)) ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0))
    ((7 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc "okay" y3-2 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 325)
  (parent 259)
  (seen 240 291)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc "okay" y3-2 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 326)
  (parent 259)
  (seen 290)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (0 1))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 327)
  (parent 261)
  (seen 292)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 328)
  (parent 262)
  (seen 293)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 329)
  (parent 271)
  (seen 294)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 330)
  (parent 271)
  (seen 279 295)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 331)
  (parent 272)
  (seen 296)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 332)
  (parent 273)
  (seen 297)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((0 0) (7 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (0 1)) ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0))
    ((7 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 333)
  (parent 273)
  (seen 282 298)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a a-0 name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a-0))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((0 0) (7 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (0 1)) ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0))
    ((7 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (added-strand resp 2) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc "okay" y3-2 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a-0))) (send (enc "okay" x3 x1 (pubk a-0))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 334)
  (parent 275)
  (seen 284 300)
  (unrealized (1 0))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" y3-1 x1 (pubk a)) (enc "okay" y3-2 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 335)
  (parent 275)
  (seen 299)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc x1 x3 (pubk a)) (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 336)
  (parent 276)
  (seen 301)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc "okay" y3-2 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-2 y3-0 (pubk a)))))
  (label 337)
  (parent 279)
  (seen 305)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc "okay" y3-2 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-2 y3-0 (pubk a)))))
  (label 338)
  (parent 282)
  (seen 306)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 y3-0) (x2 x3) (x3 y3-0) (x4 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 y3-0) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-2) (a a))
  (defstrand resp 2 (y1 y3-0) (y2 x3) (y3 y3-0) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3-0)
  (operation nonce-test (contracted (a-0 a)) y3-0 (1 0)
    (enc "okay" y3-0 y3-0 (pubk a)) (enc "okay" y3-1 y3-0 (pubk a))
    (enc "okay" y3-2 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))
    (enc y3-0 y3-0 (pubk a)))
  (traces
    ((send (cat (enc y3-0 y3-0 (pubk a)) (enc y3-0 x3 (pubk a))))
      (recv (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" x3 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a))) (send (enc "okay" y3 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a))))
    ((recv (enc y3-0 y3-0 (pubk a)))
      (send (enc "okay" y3-1 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-2 y3-0 (pubk a))))
    ((recv (enc y3-0 x3 (pubk a)))
      (send (enc "okay" y3-0 y3-0 (pubk a)))))
  (label 339)
  (parent 284)
  (seen 307)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc "okay" y3-2 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-2 y3 (pubk a)))))
  (label 340)
  (parent 287)
  (seen 343)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (1 0)) ((3 1) (0 1)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc "okay" y3-2 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-2 y3 (pubk a)))))
  (label 341)
  (parent 289)
  (seen 265)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 y3) (x2 x3) (x3 y3) (x4 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 y3) (y2 y3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3-2) (a a))
  (defstrand resp 2 (y1 y3) (y2 x3) (y3 y3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig y3)
  (operation nonce-test (contracted (a-0 a)) y3 (1 0)
    (enc "okay" y3 y3 (pubk a)) (enc "okay" y3-1 y3 (pubk a))
    (enc "okay" y3-2 y3 (pubk a)) (enc y3 x3 (pubk a))
    (enc y3 y3 (pubk a)))
  (traces
    ((send (cat (enc y3 y3 (pubk a)) (enc y3 x3 (pubk a))))
      (recv (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" x3 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-0 y3 (pubk a))))
    ((recv (enc y3 y3 (pubk a))) (send (enc "okay" y3-1 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3-2 y3 (pubk a))))
    ((recv (enc y3 x3 (pubk a))) (send (enc "okay" y3 y3 (pubk a)))))
  (label 342)
  (parent 291)
  (seen 341)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0))
    ((5 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 343)
  (parent 295)
  (seen 305)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a)))))
  (label 344)
  (parent 298)
  (seen 306)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-0 x1 (pubk a))
    (enc "okay" y3-1 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 345)
  (parent 300)
  (seen 307)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x1) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x1 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 346)
  (parent 302)
  (seen 303)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 347)
  (parent 315)
  (seen 228)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x3) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x3) (y2 x3) (y3 x3) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((1 1) (0 1))
    ((2 1) (0 1)) ((3 1) (1 0)) ((4 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x3)
  (operation generalization deleted (2 0))
  (traces
    ((send (cat (enc x1 x3 (pubk a)) (enc x3 x3 (pubk a))))
      (recv (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x1 x3 (pubk a))))
    ((recv (enc x3 x3 (pubk a))) (send (enc "okay" x3 x3 (pubk a)))))
  (label 348)
  (parent 316)
  (seen 229)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((0 0) (7 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (0 1)) ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0))
    ((7 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc "okay" y3-2 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 349)
  (parent 322)
  (seen 340)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (1 0))
    ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc "okay" y3-2 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 350)
  (parent 324)
  (seen 341)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((0 0) (7 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (0 1)) ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0))
    ((7 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc "okay" y3-2 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 351)
  (parent 325)
  (seen 342)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((1 1) (0 1)) ((2 1) (0 1)) ((3 1) (0 1))
    ((4 1) (1 0)) ((5 1) (1 0)) ((6 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc "okay" y3-2 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 352)
  (parent 330)
  (seen 343)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((0 0) (7 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (0 1)) ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0))
    ((7 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc "okay" y3-2 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a)))))
  (label 353)
  (parent 333)
  (seen 344)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wonthull2
  (vars (x3 x1 y3 y3-0 y3-1 y3-2 text) (a name))
  (defstrand init 2 (x1 x1) (x2 x3) (x3 x1) (x4 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-0) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 x1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x1) (y3 y3-1) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 y3-2) (a a))
  (defstrand resp 2 (y1 x1) (y2 x3) (y3 x1) (a a))
  (precedes ((0 0) (2 0)) ((0 0) (3 0)) ((0 0) (4 0)) ((0 0) (5 0))
    ((0 0) (6 0)) ((0 0) (7 0)) ((1 1) (0 1)) ((2 1) (0 1))
    ((3 1) (0 1)) ((4 1) (0 1)) ((5 1) (1 0)) ((6 1) (1 0))
    ((7 1) (1 0)))
  (non-orig (privk a))
  (uniq-orig x1)
  (operation nonce-test (contracted (a-0 a)) x1 (1 0)
    (enc "okay" x1 x1 (pubk a)) (enc "okay" y3-1 x1 (pubk a))
    (enc "okay" y3-2 x1 (pubk a)) (enc x1 x3 (pubk a))
    (enc x1 x1 (pubk a)))
  (traces
    ((send (cat (enc x1 x1 (pubk a)) (enc x1 x3 (pubk a))))
      (recv (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x3 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-0 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" x1 x1 (pubk a))))
    ((recv (enc x1 x1 (pubk a))) (send (enc "okay" y3-1 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" y3-2 x1 (pubk a))))
    ((recv (enc x1 x3 (pubk a))) (send (enc "okay" x1 x1 (pubk a)))))
  (label 354)
  (parent 334)
  (seen 345)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(comment "Nothing left to do")
