(herald wrap-decrypt (bound 8))

(comment "CPSA 4.2.3")
(comment "All input read from tst/wrap_decrypt.lsp")

(defprotocol wrap-decrypt basic
  (defrole make
    (vars (k skey) (old mesg) (lk locn))
    (trace (load lk old) (stor lk (cat k "init")) (send (hash k)))
    (uniq-gen k))
  (defrole set-wrap
    (vars (k skey) (cur mesg) (lk locn))
    (trace (load lk (cat k cur)) (stor lk (cat k "wrap")))
    (gen-st (cat k cur))
    (facts (neq cur "wrap")))
  (defrole set-decrypt
    (vars (k skey) (cur mesg) (lk locn))
    (trace (load lk (cat k cur)) (stor lk (cat k "decrypt")))
    (gen-st (cat k cur))
    (facts (neq cur "decrypt")))
  (defrole wrap
    (vars (k0 k1 skey) (lk locn) (cur mesg))
    (trace (recv (hash k0)) (recv (hash k1)) (load lk (cat k0 cur))
      (load lk (cat k1 "wrap")) (send (enc k0 k1)))
    (gen-st (cat k0 cur))
    (gen-st (cat k1 "wrap")))
  (defrole decrypt
    (vars (x mesg) (k skey) (lk locn))
    (trace (recv (enc x k)) (recv (hash k)) (load lk (cat k "decrypt"))
      (send x))
    (gen-st (cat k "decrypt")))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule trRl_make-at-1
    (forall ((z strd)) (implies (p "make" z 2) (trans z 1))))
  (defrule trRl_make-at-0
    (forall ((z strd)) (implies (p "make" z 1) (trans z 0))))
  (defrule fact-set-wrap-neq0
    (forall ((z strd) (cur mesg))
      (implies
        (and (p "set-wrap" z 1) (p "set-wrap" "cur" z cur))
        (fact neq cur "wrap"))))
  (defrule gen-st-set-wrap-0
    (forall ((z strd) (cur mesg) (k skey))
      (implies
        (and (p "set-wrap" z 1) (p "set-wrap" "cur" z cur)
          (p "set-wrap" "k" z k))
        (gen-st (cat k cur)))))
  (defrule trRl_set-wrap-at-1
    (forall ((z strd)) (implies (p "set-wrap" z 2) (trans z 1))))
  (defrule trRl_set-wrap-at-0
    (forall ((z strd)) (implies (p "set-wrap" z 1) (trans z 0))))
  (defrule fact-set-decrypt-neq0
    (forall ((z strd) (cur mesg))
      (implies
        (and (p "set-decrypt" z 1) (p "set-decrypt" "cur" z cur))
        (fact neq cur "decrypt"))))
  (defrule gen-st-set-decrypt-0
    (forall ((z strd) (cur mesg) (k skey))
      (implies
        (and (p "set-decrypt" z 1) (p "set-decrypt" "cur" z cur)
          (p "set-decrypt" "k" z k))
        (gen-st (cat k cur)))))
  (defrule trRl_set-decrypt-at-1
    (forall ((z strd)) (implies (p "set-decrypt" z 2) (trans z 1))))
  (defrule trRl_set-decrypt-at-0
    (forall ((z strd)) (implies (p "set-decrypt" z 1) (trans z 0))))
  (defrule gen-st-wrap-1
    (forall ((z strd) (cur mesg) (k0 skey))
      (implies
        (and (p "wrap" z 3) (p "wrap" "cur" z cur) (p "wrap" "k0" z k0))
        (gen-st (cat k0 cur)))))
  (defrule gen-st-wrap-0
    (forall ((z strd) (k1 skey))
      (implies
        (and (p "wrap" z 2) (p "wrap" "k1" z k1))
        (gen-st (cat k1 "wrap")))))
  (defrule gen-st-decrypt-0
    (forall ((z strd) (k skey))
      (implies
        (and (p "decrypt" z 1) (p "decrypt" "k" z k))
        (gen-st (cat k "decrypt")))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k kp skey) (lk lk-0 lk-1 lk-2 lk-3 lk-4 locn))
  (deflistener k)
  (defstrand decrypt 4 (x k) (k kp) (lk lk))
  (defstrand make 2 (old old) (k kp) (lk lk-0))
  (defstrand set-decrypt 1 (cur "wrap") (k kp) (lk lk-1))
  (defstrand set-wrap 1 (cur "init") (k kp) (lk lk-2))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 kp) (lk lk-3))
  (defstrand make 2 (old old-0) (k k) (lk lk-4))
  (traces ((recv k) (send k))
    ((recv (enc k kp)) (recv (hash kp)) (load lk (cat pt kp "decrypt"))
      (send k))
    ((load lk-0 (cat pt-0 old)) (stor lk-0 (cat pt-1 kp "init")))
    ((load lk-1 (cat pt-2 kp "wrap")))
    ((load lk-2 (cat pt-3 kp "init")))
    ((recv (hash k)) (recv (hash kp)) (load lk-3 (cat pt-4 k "init"))
      (load lk-3 (cat pt-5 kp "wrap")) (send (enc k kp)))
    ((load lk-4 (cat pt-6 old-0)) (stor lk-4 (cat pt-7 k "init"))))
  (label 0)
  (unrealized)
  (origs (pt-7 (6 1)) (pt-1 (2 1)))
  (comment "Not closed under rules"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k kp skey) (lk lk-0 lk-1 lk-2 lk-3 lk-4 locn))
  (deflistener k)
  (defstrand decrypt 4 (x k) (k kp) (lk lk))
  (defstrand make 2 (old old) (k kp) (lk lk-0))
  (defstrand set-decrypt 1 (cur "wrap") (k kp) (lk lk-1))
  (defstrand set-wrap 1 (cur "init") (k kp) (lk lk-2))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 kp) (lk lk-3))
  (defstrand make 2 (old old-0) (k k) (lk lk-4))
  (genStV (cat k "init") (cat kp "decrypt") (cat kp "init")
    (cat kp "wrap"))
  (facts (neq "init" "decrypt") (neq "wrap" "decrypt")
    (neq "init" "wrap") (neq "wrap" "wrap") (trans 6 0) (trans 4 0)
    (trans 3 0) (trans 2 0) (trans 6 1) (trans 2 1))
  (rule gen-st-decrypt-0 gen-st-wrap-1 fact-set-decrypt-neq0
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0 trRl_make-at-1)
  (traces ((recv k) (send k))
    ((recv (enc k kp)) (recv (hash kp)) (load lk (cat pt kp "decrypt"))
      (send k))
    ((load lk-0 (cat pt-0 old)) (stor lk-0 (cat pt-1 kp "init")))
    ((load lk-1 (cat pt-2 kp "wrap")))
    ((load lk-2 (cat pt-3 kp "init")))
    ((recv (hash k)) (recv (hash kp)) (load lk-3 (cat pt-4 k "init"))
      (load lk-3 (cat pt-5 kp "wrap")) (send (enc k kp)))
    ((load lk-4 (cat pt-6 old-0)) (stor lk-4 (cat pt-7 k "init"))))
  (label 1)
  (parent 0)
  (unrealized (1 2) (3 0) (4 0) (5 2) (5 3))
  (dead)
  (origs (pt-7 (6 1)) (pt-1 (2 1)))
  (comment "empty cohort"))

(comment "Nothing left to do")

(defprotocol wrap-decrypt basic
  (defrole make
    (vars (k skey) (old mesg) (lk locn))
    (trace (load lk old) (stor lk (cat k "init")) (send (hash k)))
    (uniq-gen k))
  (defrole set-wrap
    (vars (k skey) (cur mesg) (lk locn))
    (trace (load lk (cat k cur)) (stor lk (cat k "wrap")))
    (gen-st (cat k cur))
    (facts (neq cur "wrap")))
  (defrole set-decrypt
    (vars (k skey) (cur mesg) (lk locn))
    (trace (load lk (cat k cur)) (stor lk (cat k "decrypt")))
    (gen-st (cat k cur))
    (facts (neq cur "decrypt")))
  (defrole wrap
    (vars (k0 k1 skey) (lk locn) (cur mesg))
    (trace (recv (hash k0)) (recv (hash k1)) (load lk (cat k0 cur))
      (load lk (cat k1 "wrap")) (send (enc k0 k1)))
    (gen-st (cat k0 cur))
    (gen-st (cat k1 "wrap")))
  (defrole decrypt
    (vars (x mesg) (k skey) (lk locn))
    (trace (recv (enc x k)) (recv (hash k)) (load lk (cat k "decrypt"))
      (send x))
    (gen-st (cat k "decrypt")))
  (defrule cakeRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (leads-to z0 i0 z1 i1)
          (leads-to z0 i0 z2 i2) (prec z1 i1 z2 i2))
        (false))))
  (defrule no-interruption
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (leads-to z0 i0 z2 i2) (trans z1 i1)
          (same-locn z0 i0 z1 i1) (prec z0 i0 z1 i1) (prec z1 i1 z2 i2))
        (false))))
  (defrule neqRl_mesg
    (forall ((x mesg)) (implies (fact neq x x) (false))))
  (defrule neqRl_strd
    (forall ((x strd)) (implies (fact neq x x) (false))))
  (defrule neqRl_indx
    (forall ((x indx)) (implies (fact neq x x) (false))))
  (defrule scissorsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (leads-to z0 i0 z2 i2))
        (and (= z1 z2) (= i1 i2)))))
  (defrule trRl_make-at-1
    (forall ((z strd)) (implies (p "make" z 2) (trans z 1))))
  (defrule trRl_make-at-0
    (forall ((z strd)) (implies (p "make" z 1) (trans z 0))))
  (defrule fact-set-wrap-neq0
    (forall ((z strd) (cur mesg))
      (implies
        (and (p "set-wrap" z 1) (p "set-wrap" "cur" z cur))
        (fact neq cur "wrap"))))
  (defrule gen-st-set-wrap-0
    (forall ((z strd) (cur mesg) (k skey))
      (implies
        (and (p "set-wrap" z 1) (p "set-wrap" "cur" z cur)
          (p "set-wrap" "k" z k))
        (gen-st (cat k cur)))))
  (defrule trRl_set-wrap-at-1
    (forall ((z strd)) (implies (p "set-wrap" z 2) (trans z 1))))
  (defrule trRl_set-wrap-at-0
    (forall ((z strd)) (implies (p "set-wrap" z 1) (trans z 0))))
  (defrule fact-set-decrypt-neq0
    (forall ((z strd) (cur mesg))
      (implies
        (and (p "set-decrypt" z 1) (p "set-decrypt" "cur" z cur))
        (fact neq cur "decrypt"))))
  (defrule gen-st-set-decrypt-0
    (forall ((z strd) (cur mesg) (k skey))
      (implies
        (and (p "set-decrypt" z 1) (p "set-decrypt" "cur" z cur)
          (p "set-decrypt" "k" z k))
        (gen-st (cat k cur)))))
  (defrule trRl_set-decrypt-at-1
    (forall ((z strd)) (implies (p "set-decrypt" z 2) (trans z 1))))
  (defrule trRl_set-decrypt-at-0
    (forall ((z strd)) (implies (p "set-decrypt" z 1) (trans z 0))))
  (defrule gen-st-wrap-1
    (forall ((z strd) (cur mesg) (k0 skey))
      (implies
        (and (p "wrap" z 3) (p "wrap" "cur" z cur) (p "wrap" "k0" z k0))
        (gen-st (cat k0 cur)))))
  (defrule gen-st-wrap-0
    (forall ((z strd) (k1 skey))
      (implies
        (and (p "wrap" z 2) (p "wrap" "k1" z k1))
        (gen-st (cat k1 "wrap")))))
  (defrule gen-st-decrypt-0
    (forall ((z strd) (k skey))
      (implies
        (and (p "decrypt" z 1) (p "decrypt" "k" z k))
        (gen-st (cat k "decrypt")))))
  (defrule shearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (trans z2 i2)
          (leads-to z0 i0 z1 i1) (same-locn z0 i0 z2 i2)
          (prec z0 i0 z2 i2))
        (or (and (= z1 z2) (= i1 i2)) (prec z1 i1 z2 i2)))))
  (defrule invShearsRule
    (forall ((z0 z1 z2 strd) (i0 i1 i2 indx))
      (implies
        (and (trans z0 i0) (trans z1 i1) (same-locn z0 i0 z1 i1)
          (leads-to z1 i1 z2 i2) (prec z0 i0 z2 i2))
        (or (and (= z0 z1) (= i0 i1)) (prec z0 i0 z1 i1))))))

(defskeleton wrap-decrypt
  (vars (k skey))
  (deflistener k)
  (pen-non-orig k)
  (traces ((recv k) (send k)))
  (label 2)
  (unrealized (0 0))
  (origs)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (precedes ((1 1) (0 0)))
  (pen-non-orig k)
  (facts (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init"))))
  (label 3)
  (parent 2)
  (unrealized (0 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap"))))
  (label 4)
  (parent 3)
  (unrealized (0 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt"))))
  (label 5)
  (parent 3)
  (unrealized (0 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1))))
  (label 6)
  (parent 3)
  (unrealized (2 0) (2 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 0)) ((3 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 3 0) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-2 k "decrypt"))))
  (label 7)
  (parent 4)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 0)) ((3 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 3 1) (neq "wrap" "wrap")
    (trans 3 0) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-2 k "wrap"))))
  (label 8)
  (parent 4)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))))
  (label 9)
  (parent 4)
  (unrealized (0 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 10)
  (parent 4)
  (unrealized (3 0) (3 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 11)
  (parent 4)
  (unrealized (3 0) (3 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 0)) ((3 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init"))
  (facts (neq "decrypt" "decrypt") (trans 3 1) (neq "decrypt" "wrap")
    (trans 3 0) (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk (cat pt-1 k "decrypt")) (stor lk (cat pt-2 k "wrap"))))
  (label 12)
  (parent 5)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))))
  (label 13)
  (parent 5)
  (seen 21)
  (unrealized (0 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 0)) ((3 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init"))
  (facts (trans 3 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 3 0) (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk (cat pt-1 k "decrypt")) (stor lk (cat pt-2 k "decrypt"))))
  (label 14)
  (parent 5)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 15)
  (parent 5)
  (unrealized (3 0) (3 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 16)
  (parent 5)
  (unrealized (3 0) (3 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 4) (0 0)) ((2 2) (1 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1))
  (operation encryption-test (displaced 1 3 make 3) (hash k) (2 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k))))
  (label 17)
  (parent 6)
  (seen 43)
  (unrealized (1 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 2) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (2 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k))))
  (label 18)
  (parent 6)
  (seen 44)
  (unrealized (2 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (2 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 19)
  (parent 6)
  (unrealized (2 3) (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 0)) ((3 1) (0 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 4 0) (trans 3 0) (trans 3 1) (neq "init" "decrypt")
    (trans 2 1) (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-4 k "decrypt"))))
  (label 20)
  (parent 9)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init"))
      (stor lk-0 (cat pt-4 k "decrypt"))))
  (label 21)
  (parent 9)
  (unrealized (0 0))
  (comment "9 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 0)) ((3 1) (0 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 4 1) (neq "wrap" "wrap")
    (trans 4 0) (trans 3 0) (trans 3 1) (neq "init" "decrypt")
    (trans 2 1) (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-4 k "wrap"))))
  (label 22)
  (parent 9)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 23)
  (parent 9)
  (unrealized (4 0) (4 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 24)
  (parent 9)
  (seen 27)
  (unrealized (4 0) (4 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 25)
  (parent 9)
  (seen 30)
  (unrealized (4 0) (4 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 1 4 make 3) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k))))
  (label 26)
  (parent 10)
  (seen 66 67)
  (unrealized (2 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 27)
  (parent 10)
  (seen 68 69)
  (unrealized (3 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 28)
  (parent 10)
  (unrealized (3 3) (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (0 0)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 1 4 make 3) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k))))
  (label 29)
  (parent 11)
  (seen 72 73)
  (unrealized (2 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 30)
  (parent 11)
  (seen 74 75)
  (unrealized (3 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 31)
  (parent 11)
  (unrealized (3 3) (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 0)) ((3 1) (0 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init"))
  (facts (neq "decrypt" "decrypt") (trans 4 1) (neq "decrypt" "wrap")
    (trans 4 0) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk (cat pt-1 k "decrypt")) (stor lk (cat pt-4 k "wrap"))))
  (label 32)
  (parent 13)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 33)
  (parent 13)
  (unrealized (4 0) (4 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 0)) ((3 1) (0 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init"))
  (facts (trans 4 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 4 0) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk (cat pt-1 k "decrypt")) (stor lk (cat pt-4 k "decrypt"))))
  (label 34)
  (parent 13)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 35)
  (parent 13)
  (seen 38)
  (unrealized (4 0) (4 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 36)
  (parent 13)
  (seen 41)
  (unrealized (4 0) (4 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 1 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 1 4 make 3) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "decrypt"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k))))
  (label 37)
  (parent 15)
  (seen 88)
  (unrealized (2 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 38)
  (parent 15)
  (seen 89)
  (unrealized (3 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 39)
  (parent 15)
  (unrealized (3 3) (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (0 0)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 1 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 1 4 make 3) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k))))
  (label 40)
  (parent 16)
  (seen 92)
  (unrealized (2 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 41)
  (parent 16)
  (seen 93)
  (unrealized (3 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 42)
  (parent 16)
  (unrealized (3 3) (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old cur mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 4) (0 0)) ((2 1) (3 0)) ((2 2) (1 0)) ((3 1) (1 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 3 1) (neq cur "wrap") (trans 3 0)
    (trans 2 0) (trans 2 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt k1 "wrap")) (1 3))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-2 k1 cur)) (stor lk (cat pt k1 "wrap"))))
  (label 43)
  (parent 17)
  (seen 72 96)
  (unrealized (3 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 0)) ((2 4) (0 0)) ((3 2) (2 0))
    ((4 1) (2 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 4 1) (neq cur "wrap") (trans 4 0)
    (trans 3 0) (trans 3 1) (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-1 k1 "wrap")) (2 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-4 k1 cur)) (stor lk (cat pt-1 k1 "wrap"))))
  (label 44)
  (parent 18)
  (seen 72 74 97)
  (unrealized (4 0))
  (comment "6 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 4 1 make 2) k (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 45)
  (parent 19)
  (unrealized (2 3) (3 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (3 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))))
  (label 46)
  (parent 19)
  (seen 98)
  (unrealized (2 3) (3 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (5 0))
    ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init"))
  (facts (trans 5 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 5 0) (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 47)
  (parent 21)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 0)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 5 1) (neq "wrap" "wrap")
    (trans 5 0) (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 48)
  (parent 21)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init"))
  (facts (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 49)
  (parent 21)
  (unrealized (0 0))
  (comment "9 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (5 0))
    ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init"))
  (facts (neq "decrypt" "decrypt") (trans 5 1) (neq "decrypt" "wrap")
    (trans 5 0) (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "wrap"))))
  (label 50)
  (parent 21)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (5 2))
    ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 51)
  (parent 21)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 0)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 5 0) (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 52)
  (parent 21)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((3 1) (5 2))
    ((4 1) (0 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 53)
  (parent 21)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 2)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 54)
  (parent 21)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 1) (4 0))
    ((4 1) (0 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 55)
  (parent 21)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 56)
  (parent 23)
  (seen 72 128 129)
  (unrealized (3 3))
  (comment "8 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 1 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 57)
  (parent 23)
  (seen 72 130)
  (unrealized (3 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 58)
  (parent 23)
  (seen 74 131 132)
  (unrealized (4 3))
  (comment "8 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 59)
  (parent 23)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 1 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 60)
  (parent 24)
  (seen 136 137)
  (unrealized (3 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 61)
  (parent 24)
  (seen 138 139)
  (unrealized (4 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 62)
  (parent 24)
  (seen 71)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 1 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 63)
  (parent 25)
  (seen 142 143)
  (unrealized (3 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 64)
  (parent 25)
  (seen 144 145)
  (unrealized (4 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 65)
  (parent 25)
  (seen 77)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation channel-test (displaced 4 1 set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (2 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k))))
  (label 66)
  (parent 26)
  (seen 136)
  (unrealized (0 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old cur mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 1) (2 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 4 1) (neq cur "wrap") (trans 4 0)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 3 0) (trans 3 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-0 k1 "wrap")) (2 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k1 cur)) (stor lk (cat pt-0 k1 "wrap"))))
  (label 67)
  (parent 26)
  (seen 152)
  (unrealized (4 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation channel-test (displaced 5 2 set-wrap 2)
    (ch-msg lk (cat pt-4 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k))))
  (label 68)
  (parent 27)
  (seen 138)
  (unrealized (0 0))
  (comment "8 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 69)
  (parent 27)
  (seen 160)
  (unrealized (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 5 1 make 2) k (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 70)
  (parent 28)
  (seen 161)
  (unrealized (3 3) (4 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 71)
  (parent 28)
  (seen 162)
  (unrealized (3 3) (4 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation channel-test (displaced 4 1 set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (2 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k))))
  (label 72)
  (parent 29)
  (seen 142)
  (unrealized (0 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old cur mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (4 0)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0))
    ((4 1) (2 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 4 1) (neq cur "wrap") (trans 4 0)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 3 0) (trans 3 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-0 k1 "wrap")) (2 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k1 cur)) (stor lk (cat pt-0 k1 "wrap"))))
  (label 73)
  (parent 29)
  (seen 171)
  (unrealized (4 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation channel-test (displaced 5 2 set-wrap 2)
    (ch-msg lk (cat pt-4 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k))))
  (label 74)
  (parent 30)
  (seen 144)
  (unrealized (0 0))
  (comment "8 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 75)
  (parent 30)
  (seen 179)
  (unrealized (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 5 1 make 2) k (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 76)
  (parent 31)
  (unrealized (3 3) (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 77)
  (parent 31)
  (seen 180)
  (unrealized (3 3) (4 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 78)
  (parent 33)
  (seen 185)
  (unrealized (3 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (trans 1 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 1 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 79)
  (parent 33)
  (seen 186)
  (unrealized (3 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 80)
  (parent 33)
  (seen 187)
  (unrealized (4 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 81)
  (parent 33)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (trans 1 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 1 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "decrypt"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 82)
  (parent 35)
  (seen 191)
  (unrealized (3 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 83)
  (parent 35)
  (seen 192)
  (unrealized (4 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 84)
  (parent 35)
  (seen 91)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (trans 1 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 1 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 85)
  (parent 36)
  (seen 195)
  (unrealized (3 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 86)
  (parent 36)
  (seen 196)
  (unrealized (4 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 87)
  (parent 36)
  (seen 95)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old cur mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 1) (2 3)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 4 1) (neq cur "wrap") (trans 4 0)
    (trans 1 1) (neq "init" "decrypt") (neq "init" "wrap") (trans 1 0)
    (trans 3 0) (trans 3 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-0 k1 "wrap")) (2 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "decrypt"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k1 cur)) (stor lk (cat pt-0 k1 "wrap"))))
  (label 88)
  (parent 37)
  (seen 199)
  (unrealized (4 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 4 0) (trans 4 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 89)
  (parent 38)
  (seen 200)
  (unrealized (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 5 1 make 2) k (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 90)
  (parent 39)
  (seen 202)
  (unrealized (3 3) (4 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 91)
  (parent 39)
  (seen 201)
  (unrealized (3 3) (4 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old cur mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (4 0)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0))
    ((4 1) (2 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 4 1) (neq cur "wrap") (trans 4 0)
    (trans 1 1) (neq "init" "decrypt") (neq "init" "wrap") (trans 1 0)
    (trans 3 0) (trans 3 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-0 k1 "wrap")) (2 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k1 cur)) (stor lk (cat pt-0 k1 "wrap"))))
  (label 92)
  (parent 40)
  (seen 207)
  (unrealized (4 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 4 0) (trans 4 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 93)
  (parent 41)
  (seen 208)
  (unrealized (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 5 1 make 2) k (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 94)
  (parent 42)
  (unrealized (3 3) (4 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 95)
  (parent 42)
  (seen 209)
  (unrealized (3 3) (4 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-0) (k k1) (lk lk))
  (precedes ((1 4) (0 0)) ((2 1) (4 0)) ((2 2) (1 0)) ((3 1) (1 3))
    ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 3 1)
    (neq "init" "wrap") (trans 3 0) (trans 2 0) (trans 2 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-2 k1 "init")) (3 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-2 k1 "init")) (stor lk (cat pt k1 "wrap")))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-2 k1 "init"))))
  (label 96)
  (parent 43)
  (unrealized)
  (shape)
  (maps ((0) ((k k))))
  (origs (pt-2 (4 1)) (pt (3 1)) (pt-1 (2 1))))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-1) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (5 0)) ((2 4) (0 0)) ((3 2) (2 0))
    ((4 1) (2 3)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 4 1)
    (neq "init" "wrap") (trans 4 0) (trans 3 0) (trans 3 1) (trans 1 0)
    (trans 1 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-4 k1 "init")) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-4 k1 "init")) (stor lk (cat pt-1 k1 "wrap")))
    ((load lk (cat pt-5 old-1)) (stor lk (cat pt-4 k1 "init"))))
  (label 97)
  (parent 44)
  (unrealized)
  (shape)
  (maps ((0) ((k k))))
  (origs (pt-4 (5 1)) (pt-1 (4 1)) (pt-3 (3 1)) (pt-0 (1 1))))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))))
  (label 98)
  (parent 45)
  (unrealized (2 3) (3 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1-0 "wrap")) (send (enc k k1-0))))
  (label 99)
  (parent 45)
  (unrealized (2 3) (4 0) (4 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap"))))
  (label 100)
  (parent 46)
  (seen 215)
  (unrealized (2 3) (3 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init"))
      (stor lk-0 (cat pt-4 k "decrypt"))))
  (label 101)
  (parent 46)
  (seen 214)
  (unrealized (2 3) (3 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1-0 "wrap")) (send (enc k k1-0))))
  (label 102)
  (parent 46)
  (unrealized (2 3) (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (6 0)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0)
    (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-7 k "decrypt"))))
  (label 103)
  (parent 49)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (6 0))
    ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init"))
  (facts (trans 6 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0)
    (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-7 k "decrypt"))))
  (label 104)
  (parent 49)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (6 0)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0)
    (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-7 k "wrap"))))
  (label 105)
  (parent 49)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (6 0))
    ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init"))
  (facts (neq "decrypt" "decrypt") (trans 6 1) (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0)
    (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-7 k "wrap"))))
  (label 106)
  (parent 49)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (6 2))
    ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-7 k1 "wrap")) (send (enc k k1))))
  (label 107)
  (parent 49)
  (seen 114)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt-7 k1 "wrap")) (send (enc k k1))))
  (label 108)
  (parent 49)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((3 1) (6 2))
    ((4 1) (0 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-7 k1 "wrap")) (send (enc k k1))))
  (label 109)
  (parent 49)
  (seen 118)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (6 2)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-7 k1 "wrap")) (send (enc k k1))))
  (label 110)
  (parent 49)
  (seen 122)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 1) (4 0))
    ((4 1) (0 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt"))
    (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-7 k1 "wrap")) (send (enc k k1))))
  (label 111)
  (parent 49)
  (seen 126)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0))
    ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-2 k "decrypt"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 112)
  (parent 51)
  (seen 256 257 258 259)
  (unrealized (4 3))
  (comment "14 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((3 1) (4 2)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 113)
  (parent 51)
  (seen 260 262)
  (unrealized (4 3))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (5 2))
    ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 114)
  (parent 51)
  (seen 263 264 265 266)
  (unrealized (5 3))
  (comment "14 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (5 2))
    ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 115)
  (parent 51)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 116)
  (parent 53)
  (seen 270 271 272)
  (unrealized (4 3))
  (comment "14 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 117)
  (parent 53)
  (seen 273)
  (unrealized (4 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((3 1) (5 2))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 118)
  (parent 53)
  (seen 274 275 276)
  (unrealized (5 3))
  (comment "14 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((3 1) (5 2))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 119)
  (parent 53)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 120)
  (parent 54)
  (seen 153 280)
  (unrealized (4 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (4 2)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 121)
  (parent 54)
  (seen 281 282)
  (unrealized (4 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (5 2)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 122)
  (parent 54)
  (seen 283 284)
  (unrealized (5 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (5 2)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 123)
  (parent 54)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 124)
  (parent 55)
  (seen 172 288)
  (unrealized (4 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 125)
  (parent 55)
  (seen 289 290)
  (unrealized (4 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 1) (4 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 126)
  (parent 55)
  (seen 291 292)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 1) (4 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 127)
  (parent 55)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 5 2 set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k))))
  (label 128)
  (parent 56)
  (seen 72 270 298)
  (unrealized (0 0))
  (comment "19 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 cur)) (stor lk-0 (cat pt-2 k1 "wrap"))))
  (label 129)
  (parent 56)
  (seen 72 128 303 304)
  (unrealized (5 0))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (0 0)) ((2 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 130)
  (parent 57)
  (seen 72 174 305)
  (unrealized (5 0))
  (comment "6 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-6 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 131)
  (parent 58)
  (seen 74 274 310)
  (unrealized (0 0))
  (comment "22 in cohort - 10 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 cur mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((3 1) (6 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-7 k1 cur)) (stor lk-0 (cat pt-4 k1 "wrap"))))
  (label 132)
  (parent 58)
  (seen 74 131 304 316 317)
  (unrealized (6 0))
  (comment "9 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 1 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 133)
  (parent 59)
  (seen 100)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (5 0)) ((4 4) (0 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 3 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 134)
  (parent 59)
  (seen 319)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 135)
  (parent 59)
  (seen 318 321)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation channel-test (displaced 5 1 set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k))))
  (label 136)
  (parent 60)
  (seen 281)
  (unrealized (0 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 cur)) (stor lk-0 (cat pt-2 k1 "wrap"))))
  (label 137)
  (parent 60)
  (seen 332 333)
  (unrealized (5 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk (cat pt-6 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k))))
  (label 138)
  (parent 61)
  (seen 283)
  (unrealized (0 0))
  (comment "10 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 cur mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((2 1) (6 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k)))
    ((load lk (cat pt-7 k1 cur)) (stor lk (cat pt-4 k1 "wrap"))))
  (label 139)
  (parent 61)
  (seen 343 344)
  (unrealized (6 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 1 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 140)
  (parent 62)
  (seen 162 345)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 141)
  (parent 62)
  (seen 346)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (3 3)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation channel-test (displaced 5 1 set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k))))
  (label 142)
  (parent 63)
  (seen 289 304)
  (unrealized (0 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (5 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 cur)) (stor lk-0 (cat pt-2 k1 "wrap"))))
  (label 143)
  (parent 63)
  (seen 298 356)
  (unrealized (5 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk (cat pt-6 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k))))
  (label 144)
  (parent 64)
  (seen 291 316)
  (unrealized (0 0))
  (comment "10 in cohort - 8 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 cur mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (6 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k)))
    ((load lk (cat pt-7 k1 cur)) (stor lk (cat pt-4 k1 "wrap"))))
  (label 145)
  (parent 64)
  (seen 310 365)
  (unrealized (6 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 1 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 146)
  (parent 65)
  (seen 180)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 147)
  (parent 65)
  (seen 366)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 4 1) (neq "wrap" "wrap")
    (trans 4 0) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt k "wrap")) (stor lk (cat pt-2 k "wrap"))))
  (label 148)
  (parent 66)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 4 0) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt k "wrap")) (stor lk (cat pt-2 k "decrypt"))))
  (label 149)
  (parent 66)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 2) (2 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 150)
  (parent 66)
  (unrealized (4 0) (4 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 151)
  (parent 66)
  (unrealized (4 0) (4 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-0) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (5 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 1) (2 3)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 4 1)
    (neq "init" "wrap") (trans 4 0) (trans 1 1) (trans 1 0) (trans 3 0)
    (trans 3 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-3 k1 "init")) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k1 "init")) (stor lk (cat pt-0 k1 "wrap")))
    ((load lk (cat pt-4 old-0)) (stor lk (cat pt-3 k1 "init"))))
  (label 152)
  (parent 67)
  (unrealized)
  (shape)
  (maps ((0) ((k k))))
  (origs (pt-3 (5 1)) (pt-0 (4 1)) (pt-2 (3 1)) (pt (1 1))))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init"))
      (stor lk-0 (cat pt-4 k "decrypt"))))
  (label 153)
  (parent 68)
  (seen 334)
  (unrealized (0 0))
  (comment "10 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 5 1) (neq "wrap" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 2 1) (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-4 k "wrap"))))
  (label 154)
  (parent 68)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap"))))
  (label 155)
  (parent 68)
  (seen 335)
  (unrealized (0 0))
  (comment "9 in cohort - 8 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 2 1) (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-4 k "decrypt"))))
  (label 156)
  (parent 68)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 2))
    ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 157)
  (parent 68)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 158)
  (parent 68)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 159)
  (parent 68)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-1) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 2 1)
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 "init")) (stor lk (cat pt-2 k1 "wrap")))
    ((load lk (cat pt-6 old-1)) (stor lk (cat pt-5 k1 "init"))))
  (label 160)
  (parent 69)
  (unrealized)
  (shape)
  (maps ((0) ((k k))))
  (origs (pt-5 (6 1)) (pt-2 (5 1)) (pt-4 (4 1)) (pt-1 (2 1))
    (pt-0 (1 1))))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (4 0)) ((3 4) (0 0)) ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 5 2 set-wrap 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 161)
  (parent 70)
  (unrealized (3 3) (4 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 162)
  (parent 70)
  (seen 406)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0))))
  (label 163)
  (parent 70)
  (unrealized (3 3) (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 164)
  (parent 71)
  (seen 409)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 165)
  (parent 71)
  (seen 410)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (6 2)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 166)
  (parent 71)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 3)) ((1 1) (4 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 4 1) (neq "wrap" "wrap")
    (trans 4 0) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt k "wrap")) (stor lk (cat pt-2 k "wrap"))))
  (label 167)
  (parent 72)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 3)) ((1 1) (4 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 4 0) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt k "wrap")) (stor lk (cat pt-2 k "decrypt"))))
  (label 168)
  (parent 72)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 2) (2 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 169)
  (parent 72)
  (unrealized (4 0) (4 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 3)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 170)
  (parent 72)
  (unrealized (4 0) (4 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-0) (k k1) (lk lk))
  (precedes ((1 1) (5 0)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0))
    ((4 1) (2 3)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 4 1)
    (neq "init" "wrap") (trans 4 0) (trans 1 1) (trans 1 0) (trans 3 0)
    (trans 3 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-3 k1 "init")) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k1 "init")) (stor lk (cat pt-0 k1 "wrap")))
    ((load lk (cat pt-4 old-0)) (stor lk (cat pt-3 k1 "init"))))
  (label 171)
  (parent 73)
  (seen 96)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init"))
      (stor lk-0 (cat pt-4 k "decrypt"))))
  (label 172)
  (parent 74)
  (seen 357)
  (unrealized (0 0))
  (comment "10 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (5 0))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 5 1) (neq "wrap" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 2 1) (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-4 k "wrap"))))
  (label 173)
  (parent 74)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap"))))
  (label 174)
  (parent 74)
  (seen 358)
  (unrealized (0 0))
  (comment "9 in cohort - 8 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (5 0))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 2 1) (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-4 k "decrypt"))))
  (label 175)
  (parent 74)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 176)
  (parent 74)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (5 2))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 177)
  (parent 74)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (3 3))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 178)
  (parent 74)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-1) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 2 1)
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 "init")) (stor lk (cat pt-2 k1 "wrap")))
    ((load lk (cat pt-6 old-1)) (stor lk (cat pt-5 k1 "init"))))
  (label 179)
  (parent 75)
  (seen 97)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 180)
  (parent 76)
  (unrealized (3 3) (4 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0))))
  (label 181)
  (parent 76)
  (unrealized (3 3) (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 182)
  (parent 77)
  (seen 465)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 183)
  (parent 77)
  (seen 466)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 2)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 184)
  (parent 77)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 4 0) (trans 4 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 cur)) (stor lk-0 (cat pt-2 k1 "wrap"))))
  (label 185)
  (parent 78)
  (seen 289 486)
  (unrealized (5 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (0 0)) ((2 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 2 0) (trans 2 1) (trans 1 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 186)
  (parent 79)
  (seen 172 487)
  (unrealized (5 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 cur mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((3 1) (6 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-7 k1 cur)) (stor lk-0 (cat pt-4 k1 "wrap"))))
  (label 187)
  (parent 80)
  (seen 289 291 488)
  (unrealized (6 0))
  (comment "6 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 1 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 188)
  (parent 81)
  (seen 101)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (5 0)) ((4 4) (0 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 3 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 189)
  (parent 81)
  (seen 490)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 190)
  (parent 81)
  (seen 489 492)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 2 0) (trans 2 1) (trans 1 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "decrypt"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 cur)) (stor lk-0 (cat pt-2 k1 "wrap"))))
  (label 191)
  (parent 82)
  (seen 256 497)
  (unrealized (5 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 cur mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((2 1) (6 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k)))
    ((load lk (cat pt-7 k1 cur)) (stor lk (cat pt-4 k1 "wrap"))))
  (label 192)
  (parent 83)
  (seen 263 498)
  (unrealized (6 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 1 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 193)
  (parent 84)
  (seen 201 500)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 194)
  (parent 84)
  (seen 499)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (5 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (trans 2 0) (trans 2 1) (trans 1 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-2 k1 "wrap")) (3 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 cur)) (stor lk-0 (cat pt-2 k1 "wrap"))))
  (label 195)
  (parent 85)
  (seen 270 505)
  (unrealized (5 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 cur mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (6 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k)))
    ((load lk (cat pt-7 k1 cur)) (stor lk (cat pt-4 k1 "wrap"))))
  (label 196)
  (parent 86)
  (seen 274 506)
  (unrealized (6 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 1 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 197)
  (parent 87)
  (seen 209)
  (unrealized (4 3) (5 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 198)
  (parent 87)
  (seen 507)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-0) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (5 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 1) (2 3)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "init")
    (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 4 1)
    (neq "init" "wrap") (trans 4 0) (trans 1 1) (trans 1 0) (trans 3 0)
    (trans 3 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-3 k1 "init")) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "decrypt"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k1 "init")) (stor lk (cat pt-0 k1 "wrap")))
    ((load lk (cat pt-4 old-0)) (stor lk (cat pt-3 k1 "init"))))
  (label 199)
  (parent 88)
  (unrealized)
  (shape)
  (maps ((0) ((k k))))
  (origs (pt-3 (5 1)) (pt-0 (4 1)) (pt-2 (3 1)) (pt (1 1))))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-1) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "init")
    (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 2 1)
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 "init")) (stor lk (cat pt-2 k1 "wrap")))
    ((load lk (cat pt-6 old-1)) (stor lk (cat pt-5 k1 "init"))))
  (label 200)
  (parent 89)
  (unrealized)
  (shape)
  (maps ((0) ((k k))))
  (origs (pt-5 (6 1)) (pt-2 (5 1)) (pt-4 (4 1)) (pt-1 (2 1))
    (pt-0 (1 1))))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 201)
  (parent 90)
  (seen 514)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (4 0)) ((3 4) (0 0)) ((4 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 5 2 set-decrypt 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 202)
  (parent 90)
  (seen 514)
  (unrealized (3 3) (4 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0))))
  (label 203)
  (parent 90)
  (unrealized (3 3) (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 204)
  (parent 91)
  (seen 513)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 205)
  (parent 91)
  (seen 512)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (6 2)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 206)
  (parent 91)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-0) (k k1) (lk lk))
  (precedes ((1 1) (5 0)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0))
    ((4 1) (2 3)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 4 1)
    (neq "init" "wrap") (trans 4 0) (trans 1 1) (trans 1 0) (trans 3 0)
    (trans 3 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-3 k1 "init")) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-2 k "init")) (stor lk (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k1 "init")) (stor lk (cat pt-0 k1 "wrap")))
    ((load lk (cat pt-4 old-0)) (stor lk (cat pt-3 k1 "init"))))
  (label 207)
  (parent 92)
  (seen 96)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-1) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 2 1)
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 "init")) (stor lk (cat pt-2 k1 "wrap")))
    ((load lk (cat pt-6 old-1)) (stor lk (cat pt-5 k1 "init"))))
  (label 208)
  (parent 93)
  (seen 97)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 209)
  (parent 94)
  (unrealized (3 3) (4 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0))))
  (label 210)
  (parent 94)
  (unrealized (3 3) (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 211)
  (parent 95)
  (seen 537)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 212)
  (parent 95)
  (seen 536)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 2)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 213)
  (parent 95)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init"))
      (stor lk-0 (cat pt-4 k "decrypt"))))
  (label 214)
  (parent 98)
  (unrealized (2 3) (3 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap"))))
  (label 215)
  (parent 98)
  (unrealized (2 3) (3 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1-0 "wrap")) (send (enc k k1-0))))
  (label 216)
  (parent 98)
  (seen 232)
  (unrealized (2 3) (5 0) (5 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (5 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (3 0))
    ((5 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1-0 "wrap")) (send (enc k k1-0))))
  (label 217)
  (parent 98)
  (seen 219)
  (unrealized (2 3) (5 0) (5 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 4) (0 0)) ((2 1) (1 0)) ((3 4) (2 0)) ((4 2) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 1 5 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-0 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init"))
      (send (hash k))))
  (label 218)
  (parent 99)
  (unrealized (1 3) (3 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 219)
  (parent 99)
  (unrealized (2 3) (4 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (deflistener k)
  (precedes ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 220)
  (parent 99)
  (unrealized (2 3) (4 3) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt-4 k "wrap")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 221)
  (parent 100)
  (unrealized (2 3) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 222)
  (parent 100)
  (seen 564)
  (unrealized (2 3) (3 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt-4 k "wrap"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 223)
  (parent 100)
  (unrealized (2 3) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 2)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "wrap"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 224)
  (parent 100)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((4 1) (6 2)) ((5 1) (3 0)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 225)
  (parent 100)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (neq "decrypt" "decrypt") (trans 6 1) (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "wrap"))))
  (label 226)
  (parent 101)
  (unrealized (2 3) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 5 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 227)
  (parent 101)
  (seen 557 578)
  (unrealized (2 3) (3 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 228)
  (parent 101)
  (unrealized (2 3) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 2)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0))
      (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 229)
  (parent 101)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((4 1) (6 2)) ((5 1) (3 0)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 230)
  (parent 101)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 4 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 231)
  (parent 102)
  (seen 604)
  (unrealized (2 3) (4 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 4) (0 0)) ((2 1) (1 0)) ((3 1) (4 2)) ((4 4) (2 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 232)
  (parent 102)
  (seen 605)
  (unrealized (1 3) (4 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 k1-0 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 233)
  (parent 102)
  (seen 606)
  (unrealized (2 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 234)
  (parent 102)
  (unrealized (2 3) (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (5 2)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-2 k "decrypt"))
      (load lk-1 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 235)
  (parent 107)
  (seen 610 611 612 613)
  (unrealized (5 3))
  (comment "14 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((3 1) (5 2)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 236)
  (parent 107)
  (seen 614 616)
  (unrealized (5 3))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (0 0)) ((4 1) (5 2))
    ((5 4) (0 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 239)
  (parent 108)
  (seen 172 306 617)
  (unrealized (5 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 1) (5 2))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 240)
  (parent 108)
  (seen 289 618)
  (unrealized (5 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 5 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-7 k "init"))
      (load lk-1 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 241)
  (parent 108)
  (seen 289 619 620)
  (unrealized (5 3))
  (comment "8 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (0 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-7 k "init"))
      (load lk-1 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 244)
  (parent 109)
  (seen 621 622 623)
  (unrealized (5 3))
  (comment "14 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((2 1) (5 2)) ((3 1) (0 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 245)
  (parent 109)
  (seen 624)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (5 2)) ((3 1) (0 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 248)
  (parent 110)
  (seen 334 625)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (5 2)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt k "wrap"))
      (load lk-1 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 249)
  (parent 110)
  (seen 626 627)
  (unrealized (5 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 252)
  (parent 111)
  (seen 357 628)
  (unrealized (5 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-7 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-7 k "init"))
      (load lk-1 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-6 old-1)) (stor lk-1 (cat pt-7 k "init"))
      (send (hash k))))
  (label 253)
  (parent 111)
  (seen 629 630)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 256)
  (parent 112)
  (seen 610)
  (unrealized (0 0))
  (comment "8 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (2 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 257)
  (parent 112)
  (seen 256 610 632 634 635 636 637)
  (unrealized (0 0))
  (comment "16 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (2 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 258)
  (parent 112)
  (seen 256 610 632 634 635 636 637)
  (unrealized (0 0))
  (comment "16 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((3 1) (6 0))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-3 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-2 k "decrypt"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-6 k1 cur)) (stor lk-0 (cat pt-3 k1 "wrap"))))
  (label 259)
  (parent 112)
  (seen 256 638)
  (unrealized (6 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((2 1) (5 0)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule invShearsRule)
  (operation channel-test (displaced 6 1 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 260)
  (parent 113)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule invShearsRule)
  (operation channel-test (displaced 6 1 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 261)
  (parent 113)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((3 1) (4 2)) ((3 1) (6 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-3 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-6 k1 cur)) (stor lk (cat pt-3 k1 "wrap"))))
  (label 262)
  (parent 113)
  (seen 639)
  (unrealized (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (4 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 263)
  (parent 114)
  (unrealized (0 0))
  (comment "11 in cohort - 11 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (1 0)) ((3 1) (4 0))
    ((4 1) (2 0)) ((4 1) (5 2)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 264)
  (parent 114)
  (seen 263 640 642 643 644 646 647 648 649 650)
  (unrealized (0 0))
  (comment "22 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (4 0)) ((4 1) (2 0))
    ((4 1) (5 2)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 265)
  (parent 114)
  (seen 263 640 642 643 644 646 647 648 649 650)
  (unrealized (0 0))
  (comment "22 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (6 0)) ((2 1) (0 0)) ((3 1) (4 0))
    ((4 1) (5 2)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 1 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 267)
  (parent 115)
  (seen 204)
  (unrealized (5 3) (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((3 1) (6 0))
    ((4 1) (5 2)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 268)
  (parent 115)
  (seen 652 655)
  (unrealized (5 3) (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((4 4) (0 0))
    ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 270)
  (parent 116)
  (seen 621)
  (unrealized (0 0))
  (comment "8 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (2 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 1) (3 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 271)
  (parent 116)
  (seen 270 621 658 660 661 662 663)
  (unrealized (0 0))
  (comment "16 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (6 0)) ((4 4) (0 0))
    ((5 1) (3 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-3 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-6 k1 cur)) (stor lk-0 (cat pt-3 k1 "wrap"))))
  (label 272)
  (parent 116)
  (seen 270 664)
  (unrealized (6 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (0 0)) ((2 1) (3 0)) ((2 1) (4 2)) ((3 1) (6 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-3 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-6 k1 cur)) (stor lk (cat pt-3 k1 "wrap"))))
  (label 273)
  (parent 117)
  (seen 665)
  (unrealized (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (4 0)) ((3 1) (5 2))
    ((4 1) (1 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 274)
  (parent 118)
  (unrealized (0 0))
  (comment "11 in cohort - 11 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (1 0)) ((3 1) (4 0))
    ((3 1) (5 2)) ((4 1) (2 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 275)
  (parent 118)
  (seen 274 666 668 669 670 672 673 674 675 676)
  (unrealized (0 0))
  (comment "22 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (6 0)) ((2 1) (0 0)) ((3 1) (4 0))
    ((3 1) (5 2)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 1 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 277)
  (parent 119)
  (seen 211)
  (unrealized (5 3) (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((3 1) (6 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 278)
  (parent 119)
  (seen 678)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((2 1) (6 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-3 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-6 k1 cur)) (stor lk (cat pt-3 k1 "wrap"))))
  (label 280)
  (parent 120)
  (seen 682)
  (unrealized (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (4 2)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (operation channel-test (displaced 6 1 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 281)
  (parent 121)
  (seen 626)
  (unrealized (0 0))
  (comment "10 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (4 2)) ((1 1) (6 0)) ((2 1) (3 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-3 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-6 k1 cur)) (stor lk-0 (cat pt-3 k1 "wrap"))))
  (label 282)
  (parent 121)
  (seen 692)
  (unrealized (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (5 2)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 283)
  (parent 122)
  (unrealized (0 0))
  (comment "13 in cohort - 13 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (6 0)) ((2 1) (5 2)) ((3 1) (4 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 1 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 285)
  (parent 123)
  (seen 706)
  (unrealized (5 3) (6 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (5 2)) ((3 1) (4 0)) ((3 1) (6 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 286)
  (parent 123)
  (seen 165 708)
  (unrealized (5 3) (6 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (6 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-3 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-6 k1 cur)) (stor lk (cat pt-3 k1 "wrap"))))
  (label 288)
  (parent 124)
  (seen 712)
  (unrealized (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (operation channel-test (displaced 6 1 set-wrap 2)
    (ch-msg lk-0 (cat pt-5 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 289)
  (parent 125)
  (seen 629)
  (unrealized (0 0))
  (comment "10 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (6 0)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-3 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-6 k1 cur)) (stor lk-0 (cat pt-3 k1 "wrap"))))
  (label 290)
  (parent 125)
  (seen 722)
  (unrealized (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (5 3)) ((3 1) (4 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 291)
  (parent 126)
  (unrealized (0 0))
  (comment "13 in cohort - 13 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (6 0)) ((2 1) (0 0)) ((3 1) (4 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 1 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 293)
  (parent 127)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 1) (4 0))
    ((3 1) (6 0)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 294)
  (parent 127)
  (seen 183 737)
  (unrealized (5 3) (6 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 5 1) (neq "wrap" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 2 1) (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-4 k "wrap"))))
  (label 296)
  (parent 128)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))))
  (label 297)
  (parent 128)
  (seen 142 619 621 742)
  (unrealized (0 0))
  (comment "21 in cohort - 8 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (1 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "wrap"))))
  (label 298)
  (parent 128)
  (seen 742)
  (unrealized (0 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 2 1) (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-4 k "decrypt"))))
  (label 299)
  (parent 128)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 300)
  (parent 128)
  (unrealized (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 301)
  (parent 128)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 302)
  (parent 128)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk-0))
  (defstrand make 2 (old old-1) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (6 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 2 1)
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk-0 (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 "init")) (stor lk-0 (cat pt-2 k1 "wrap")))
    ((load lk-0 (cat pt-6 old-1)) (stor lk-0 (cat pt-5 k1 "init"))))
  (label 303)
  (parent 129)
  (unrealized)
  (comment "1 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk-0 (cat pt-4 k "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap"))))
  (label 304)
  (parent 129)
  (unrealized (0 0))
  (comment "9 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-1) (k k1) (lk lk))
  (precedes ((1 1) (0 0)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1)
    (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 "init")) (stor lk (cat pt-2 k1 "wrap")))
    ((load lk (cat pt-6 old-1)) (stor lk (cat pt-5 k1 "init"))))
  (label 305)
  (parent 130)
  (seen 97)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (6 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k "init"))
      (stor lk-0 (cat pt-6 k "decrypt"))))
  (label 306)
  (parent 131)
  (seen 172 666 780)
  (unrealized (0 0))
  (comment "24 in cohort - 12 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 0)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-6 k "wrap"))))
  (label 307)
  (parent 131)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 old-2 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand make 2 (old old-2) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-1 (cat pt-6 old-2)) (stor lk-1 (cat pt-7 k "init"))))
  (label 308)
  (parent 131)
  (seen 144 669 779 792)
  (unrealized (0 0))
  (comment "24 in cohort - 11 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (6 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-6 k "wrap"))))
  (label 309)
  (parent 131)
  (seen 174 668 791 802)
  (unrealized (0 0))
  (comment "23 in cohort - 10 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (4 2)) ((3 1) (6 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (1 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-6 k "wrap"))))
  (label 310)
  (parent 131)
  (seen 780 792 802)
  (unrealized (0 0))
  (comment "10 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 0)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-6 k "decrypt"))))
  (label 311)
  (parent 131)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 1) (6 2)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 312)
  (parent 131)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (6 2)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 313)
  (parent 131)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 2)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 314)
  (parent 131)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 315)
  (parent 131)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 2)) ((3 1) (6 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "init" "decrypt") (trans 6 1) (neq "init" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (trans 2 1) (trans 2 0) (trans 1 0) (trans 1 1))
  (operation channel-test (displaced 7 3 make 2)
    (ch-msg lk-0 (cat pt-7 k1 "init")) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap"))))
  (label 316)
  (parent 132)
  (unrealized (0 0))
  (comment "12 in cohort - 12 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 318)
  (parent 133)
  (seen 222)
  (unrealized (4 3) (5 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (5 0))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 3 make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 319)
  (parent 133)
  (seen 215 847)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 320)
  (parent 133)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (5 0)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 321)
  (parent 134)
  (seen 847)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (6 2)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 322)
  (parent 134)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (precedes ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap"))))
  (label 326)
  (parent 136)
  (unrealized (0 0))
  (comment "9 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 5 1) (neq "wrap" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (neq "init" "decrypt")
    (trans 1 1) (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-4 k "wrap"))))
  (label 327)
  (parent 136)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (neq "init" "decrypt")
    (trans 1 1) (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-4 k "decrypt"))))
  (label 328)
  (parent 136)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 329)
  (parent 136)
  (seen 372)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 330)
  (parent 136)
  (seen 375)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 331)
  (parent 136)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk-0))
  (defstrand make 2 (old old-1) (k k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (6 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1)
    (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk-0 (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 "init")) (stor lk-0 (cat pt-2 k1 "wrap")))
    ((load lk-0 (cat pt-6 old-1)) (stor lk-0 (cat pt-5 k1 "init"))))
  (label 332)
  (parent 137)
  (seen 152)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1) (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule invShearsRule)
  (operation channel-test (displaced 6 2 make 2)
    (ch-msg lk-0 (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap"))))
  (label 333)
  (parent 137)
  (unrealized (0 0))
  (comment "7 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (6 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-1 (cat pt-5 k "init"))
      (stor lk-1 (cat pt-6 k "decrypt"))))
  (label 334)
  (parent 138)
  (seen 694)
  (unrealized (0 0))
  (comment "12 in cohort - 11 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (6 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-1 (cat pt-5 k "init")) (stor lk-1 (cat pt-6 k "wrap"))))
  (label 335)
  (parent 138)
  (seen 696)
  (unrealized (0 0))
  (comment "11 in cohort - 10 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (6 0)) ((4 4) (0 0))
    ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-6 k "wrap"))))
  (label 336)
  (parent 138)
  (seen 895 905)
  (unrealized (0 0))
  (comment "12 in cohort - 10 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((2 1) (6 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-6 k "wrap"))))
  (label 337)
  (parent 138)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (6 2)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-5 k "init"))
      (load lk-1 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 338)
  (parent 138)
  (seen 396)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((2 1) (6 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-6 k "decrypt"))))
  (label 339)
  (parent 138)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (6 2)) ((4 4) (0 0))
    ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 340)
  (parent 138)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((2 1) (6 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 341)
  (parent 138)
  (seen 400)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 342)
  (parent 138)
  (seen 404)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 0)) ((2 1) (4 2)) ((3 1) (6 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "init" "decrypt") (trans 6 1) (neq "init" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (trans 2 1) (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 7 3 make 2)
    (ch-msg lk-1 (cat pt-7 k1 "init")) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "wrap"))))
  (label 343)
  (parent 139)
  (unrealized (0 0))
  (comment "10 in cohort - 10 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (5 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 2 set-wrap 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 345)
  (parent 140)
  (seen 406)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 346)
  (parent 140)
  (seen 950)
  (unrealized (4 3) (5 0))
  (comment "6 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 347)
  (parent 140)
  (seen 414)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (3 3)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 5 1) (neq "wrap" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (neq "init" "decrypt")
    (trans 1 1) (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-4 k "wrap"))))
  (label 351)
  (parent 142)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (3 3)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (neq "init" "decrypt")
    (trans 1 1) (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-4 k "decrypt"))))
  (label 352)
  (parent 142)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 3)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 353)
  (parent 142)
  (seen 431)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 3)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 354)
  (parent 142)
  (seen 434)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk-0 (cat pt k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 355)
  (parent 142)
  (unrealized (5 0) (5 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk-0))
  (defstrand make 2 (old old-1) (k k1) (lk lk-0))
  (precedes ((1 1) (6 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1)
    (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk-0 (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 "init")) (stor lk-0 (cat pt-2 k1 "wrap")))
    ((load lk-0 (cat pt-6 old-1)) (stor lk-0 (cat pt-5 k1 "init"))))
  (label 356)
  (parent 143)
  (seen 766)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (6 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-1 (cat pt-5 k "init"))
      (stor lk-1 (cat pt-6 k "decrypt"))))
  (label 357)
  (parent 144)
  (seen 724 836)
  (unrealized (0 0))
  (comment "12 in cohort - 10 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (6 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk-1 (cat pt-5 k "init")) (stor lk-1 (cat pt-6 k "wrap"))))
  (label 358)
  (parent 144)
  (seen 726 839)
  (unrealized (0 0))
  (comment "11 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((2 1) (6 0))
    ((3 1) (0 0)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-6 k "wrap"))))
  (label 359)
  (parent 144)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (6 2)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-5 k "init"))
      (load lk-1 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 360)
  (parent 144)
  (seen 455)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((2 1) (6 0))
    ((3 1) (0 0)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-6 k "decrypt"))))
  (label 361)
  (parent 144)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((3 1) (6 2))
    ((4 4) (0 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 362)
  (parent 144)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((2 1) (6 2))
    ((3 1) (0 0)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 363)
  (parent 144)
  (seen 459)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((1 1) (6 2)) ((2 1) (4 3))
    ((3 1) (0 0)) ((4 4) (0 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-1 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 364)
  (parent 144)
  (seen 463)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 366)
  (parent 146)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 367)
  (parent 146)
  (seen 470)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0))
    ((3 2) (4 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 5 3 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 371)
  (parent 150)
  (seen 1013 1014)
  (unrealized (4 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 372)
  (parent 150)
  (seen 1015 1016)
  (unrealized (4 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 373)
  (parent 150)
  (unrealized (4 3) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 5 3 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 374)
  (parent 151)
  (seen 66)
  (unrealized (4 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 375)
  (parent 151)
  (seen 1019 1020)
  (unrealized (4 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 376)
  (parent 151)
  (unrealized (4 3) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 377)
  (parent 153)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 378)
  (parent 153)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (neq "decrypt" "decrypt") (trans 6 1) (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "wrap"))))
  (label 379)
  (parent 153)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 380)
  (parent 153)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 381)
  (parent 153)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 382)
  (parent 153)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 383)
  (parent 153)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 384)
  (parent 153)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand decrypt 4 (x k) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (6 2)) ((6 3) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-decrypt-0)
  (operation nonce-test (added-strand decrypt 4) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (enc k k)) (recv (hash k)) (load lk-0 (cat pt-4 k "decrypt"))
      (send k)))
  (label 385)
  (parent 153)
  (unrealized (6 0) (6 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt-4 k "wrap"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 386)
  (parent 155)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt-4 k "wrap")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 387)
  (parent 155)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 388)
  (parent 155)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "wrap"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 389)
  (parent 155)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 390)
  (parent 155)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 391)
  (parent 155)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 392)
  (parent 155)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 393)
  (parent 155)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 2) (3 0))
    ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 394)
  (parent 157)
  (seen 1013 1058 1059 1060)
  (unrealized (5 3))
  (comment "16 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (4 2)) ((3 2) (2 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 395)
  (parent 157)
  (seen 1013 1061 1062)
  (unrealized (4 3))
  (comment "13 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 2))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 396)
  (parent 157)
  (seen 1015 1063 1064 1065)
  (unrealized (5 3))
  (comment "16 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 2))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 397)
  (parent 157)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 398)
  (parent 158)
  (seen 68)
  (unrealized (5 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 2) (2 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 399)
  (parent 158)
  (seen 1019 1069)
  (unrealized (4 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 400)
  (parent 158)
  (seen 1070)
  (unrealized (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 401)
  (parent 158)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 402)
  (parent 159)
  (seen 1074 1075)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 2) (2 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 403)
  (parent 159)
  (seen 1076 1077)
  (unrealized (4 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 404)
  (parent 159)
  (seen 1078 1079)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 405)
  (parent 159)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 0)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 406)
  (parent 161)
  (unrealized (3 3) (4 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0))))
  (label 407)
  (parent 161)
  (unrealized (3 3) (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (4 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0))))
  (label 408)
  (parent 161)
  (unrealized (3 3) (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 409)
  (parent 162)
  (seen 1084)
  (unrealized (3 3) (4 0))
  (comment "8 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 410)
  (parent 162)
  (seen 1083)
  (unrealized (3 3) (4 0))
  (comment "8 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 2)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 411)
  (parent 162)
  (seen 427)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 412)
  (parent 162)
  (seen 414)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk (cat pt-2 old)) (stor lk (cat pt-3 k "init"))
      (send (hash k))))
  (label 413)
  (parent 163)
  (seen 1112)
  (unrealized (2 3) (4 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 414)
  (parent 163)
  (seen 1113)
  (unrealized (3 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 415)
  (parent 163)
  (unrealized (3 3) (5 3) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 5 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 426)
  (parent 166)
  (seen 1112 1116 1117)
  (unrealized (3 3) (5 3))
  (comment "14 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 427)
  (parent 166)
  (seen 1112 1118)
  (unrealized (2 3) (5 3))
  (comment "11 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0))
    ((3 2) (4 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 5 3 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 430)
  (parent 169)
  (seen 72)
  (unrealized (4 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 431)
  (parent 169)
  (seen 1119 1120)
  (unrealized (4 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 432)
  (parent 169)
  (unrealized (4 3) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 3)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 5 3 make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1))))
  (label 433)
  (parent 170)
  (seen 1013 1123)
  (unrealized (4 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 3)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 434)
  (parent 170)
  (seen 1076 1124)
  (unrealized (4 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 3)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (added-listener k) (hash k) (4 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 435)
  (parent 170)
  (unrealized (4 3) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 436)
  (parent 172)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (6 0))
    ((3 4) (0 0)) ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 437)
  (parent 172)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (neq "decrypt" "decrypt") (trans 6 1) (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "wrap"))))
  (label 438)
  (parent 172)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 439)
  (parent 172)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (6 0))
    ((3 4) (0 0)) ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 440)
  (parent 172)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (6 2))
    ((3 4) (0 0)) ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 441)
  (parent 172)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 442)
  (parent 172)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((1 1) (6 2)) ((2 1) (3 3))
    ((3 4) (0 0)) ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 443)
  (parent 172)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand decrypt 4 (x k) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (6 2)) ((6 3) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-decrypt-0)
  (operation nonce-test (added-strand decrypt 4) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (enc k k)) (recv (hash k)) (load lk-0 (cat pt-4 k "decrypt"))
      (send k)))
  (label 444)
  (parent 172)
  (unrealized (6 0) (6 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt-4 k "wrap"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 445)
  (parent 174)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt-4 k "wrap")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 446)
  (parent 174)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (6 0))
    ((3 4) (0 0)) ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 447)
  (parent 174)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "wrap"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 448)
  (parent 174)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (6 0))
    ((3 4) (0 0)) ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 449)
  (parent 174)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 450)
  (parent 174)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (6 2))
    ((3 4) (0 0)) ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 451)
  (parent 174)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((1 1) (6 2)) ((2 1) (3 3))
    ((3 4) (0 0)) ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 452)
  (parent 174)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 453)
  (parent 176)
  (seen 72 1162 1164)
  (unrealized (5 3))
  (comment "16 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 1) (4 2)) ((3 2) (2 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 1) (2 2)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 454)
  (parent 176)
  (seen 72 1166)
  (unrealized (4 3))
  (comment "14 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 455)
  (parent 176)
  (seen 1119 1167 1169)
  (unrealized (5 3))
  (comment "16 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 456)
  (parent 176)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (5 2))
    ((3 4) (0 0)) ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 457)
  (parent 177)
  (seen 1074 1173)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 3)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 2) (2 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 1) (2 2)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 458)
  (parent 177)
  (seen 1015 1174)
  (unrealized (4 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (5 2))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 459)
  (parent 177)
  (seen 1078 1175)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((2 1) (5 2))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 460)
  (parent 177)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (3 3))
    ((3 4) (0 0)) ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 461)
  (parent 178)
  (seen 74)
  (unrealized (5 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 2) (2 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 1) (2 2)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 462)
  (parent 178)
  (seen 1119 1179)
  (unrealized (4 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (3 3))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 463)
  (parent 178)
  (seen 1180)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (3 3))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 464)
  (parent 178)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 465)
  (parent 180)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 466)
  (parent 180)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 2)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 467)
  (parent 180)
  (seen 483)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 468)
  (parent 180)
  (seen 470)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (0 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk (cat pt-2 old)) (stor lk (cat pt-3 k "init"))
      (send (hash k))))
  (label 469)
  (parent 181)
  (unrealized (2 3) (4 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 470)
  (parent 181)
  (unrealized (3 3) (5 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 471)
  (parent 181)
  (unrealized (3 3) (5 3) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 5 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 482)
  (parent 184)
  (seen 1204)
  (unrealized (3 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 483)
  (parent 184)
  (seen 1205)
  (unrealized (2 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk-0))
  (defstrand make 2 (old old-1) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (6 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 2 1)
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk-0 (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 "init")) (stor lk-0 (cat pt-2 k1 "wrap")))
    ((load lk-0 (cat pt-6 old-1)) (stor lk-0 (cat pt-5 k1 "init"))))
  (label 486)
  (parent 185)
  (seen 766)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk))
  (defstrand make 2 (old old-1) (k k1) (lk lk))
  (precedes ((1 1) (0 0)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1)
    (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 "init")) (stor lk (cat pt-2 k1 "wrap")))
    ((load lk (cat pt-6 old-1)) (stor lk (cat pt-5 k1 "init"))))
  (label 487)
  (parent 186)
  (seen 97)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 489)
  (parent 188)
  (seen 227)
  (unrealized (4 3) (5 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (5 0))
    ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 3 make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 490)
  (parent 188)
  (seen 214 1207)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 491)
  (parent 188)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (5 0)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 492)
  (parent 189)
  (seen 1207)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (6 2)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 493)
  (parent 189)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk-0))
  (defstrand make 2 (old old-1) (k k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (6 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "init")
    (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1)
    (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk-0 (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "decrypt"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 "init")) (stor lk-0 (cat pt-2 k1 "wrap")))
    ((load lk-0 (cat pt-6 old-1)) (stor lk-0 (cat pt-5 k1 "init"))))
  (label 497)
  (parent 191)
  (seen 199)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 499)
  (parent 193)
  (seen 1227)
  (unrealized (4 3) (5 0))
  (comment "6 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (5 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 2 set-decrypt 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 500)
  (parent 193)
  (seen 514 1227)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 501)
  (parent 193)
  (seen 520)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk-0))
  (defstrand make 2 (old old-1) (k k1) (lk lk-0))
  (precedes ((1 1) (6 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1)
    (trans 1 0) (trans 4 0) (trans 4 1))
  (rule invShearsRule trRl_make-at-0 trRl_make-at-1)
  (operation channel-test (added-strand make 2)
    (ch-msg lk-0 (cat pt-5 k1 "init")) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1 "init")) (stor lk-0 (cat pt-2 k1 "wrap")))
    ((load lk-0 (cat pt-6 old-1)) (stor lk-0 (cat pt-5 k1 "init"))))
  (label 505)
  (parent 195)
  (seen 766)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 507)
  (parent 197)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 508)
  (parent 197)
  (seen 541)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 512)
  (parent 201)
  (seen 1245)
  (unrealized (3 3) (4 0))
  (comment "8 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 513)
  (parent 201)
  (seen 1252)
  (unrealized (3 3) (4 0))
  (comment "8 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 0)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 2 1) (trans 2 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 1 0) (trans 1 1))
  (rule scissorsRule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 514)
  (parent 201)
  (seen 1245 1252)
  (unrealized (3 3) (4 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 2)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 515)
  (parent 201)
  (seen 533)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 516)
  (parent 201)
  (seen 520)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0))))
  (label 517)
  (parent 202)
  (unrealized (3 3) (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (4 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0))))
  (label 518)
  (parent 202)
  (unrealized (3 3) (5 0) (5 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 1 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "decrypt"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk (cat pt-2 old)) (stor lk (cat pt-3 k "init"))
      (send (hash k))))
  (label 519)
  (parent 203)
  (unrealized (2 3) (4 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 520)
  (parent 203)
  (unrealized (3 3) (5 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 521)
  (parent 203)
  (unrealized (3 3) (5 3) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 5 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "decrypt"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 532)
  (parent 206)
  (seen 1273)
  (unrealized (3 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "decrypt"))
      (load lk-0 (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 533)
  (parent 206)
  (seen 1274)
  (unrealized (2 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-decrypt-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 536)
  (parent 209)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 0)) ((6 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 2 1)
    (neq "init" "decrypt") (neq "init" "wrap") (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 537)
  (parent 209)
  (unrealized (3 3) (4 0))
  (comment "6 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 0)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (6 2)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 538)
  (parent 209)
  (seen 554)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 1) (4 0)) ((6 4) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (4 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 539)
  (parent 209)
  (seen 541)
  (unrealized (3 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (precedes ((1 1) (0 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 1 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk (cat pt-2 old)) (stor lk (cat pt-3 k "init"))
      (send (hash k))))
  (label 540)
  (parent 210)
  (unrealized (2 3) (4 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 541)
  (parent 210)
  (unrealized (3 3) (5 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 2 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 542)
  (parent 210)
  (unrealized (3 3) (5 3) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 5 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 553)
  (parent 213)
  (seen 1295)
  (unrealized (3 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-0 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-1 old)) (stor lk (cat pt-2 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-2 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 554)
  (parent 213)
  (seen 1296)
  (unrealized (2 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 5 1) (neq "init" "decrypt")
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 557)
  (parent 214)
  (unrealized (2 3) (3 0))
  (comment "7 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (neq "decrypt" "decrypt") (trans 6 1) (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "wrap"))))
  (label 558)
  (parent 214)
  (unrealized (2 3) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 6 0) (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((load lk-0 (cat pt-4 k "decrypt"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 559)
  (parent 214)
  (unrealized (2 3) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 2)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0))
      (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 560)
  (parent 214)
  (seen 597)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((4 1) (6 2)) ((5 1) (3 0)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 561)
  (parent 214)
  (seen 601)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (6 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "decrypt")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 562)
  (parent 214)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt-4 k "wrap"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 563)
  (parent 215)
  (unrealized (2 3) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 564)
  (parent 215)
  (seen 1298)
  (unrealized (2 3) (3 0))
  (comment "7 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 0)) ((6 1) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt-4 k "wrap")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 565)
  (parent 215)
  (unrealized (2 3) (3 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (6 2)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "wrap"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 566)
  (parent 215)
  (seen 584)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((4 1) (6 2)) ((5 1) (3 0)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 567)
  (parent 215)
  (seen 588)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (6 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 0))
    ((5 1) (3 0)) ((6 4) (3 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (3 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init"))
    (ch-msg lk-0 (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 568)
  (parent 215)
  (unrealized (2 3) (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 4 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 569)
  (parent 216)
  (seen 1330)
  (unrealized (2 3) (4 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 k1-0 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 570)
  (parent 216)
  (seen 1331)
  (unrealized (2 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (3 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 571)
  (parent 216)
  (seen 607)
  (unrealized (2 3) (5 3) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 4) (0 0)) ((2 1) (1 0)) ((3 1) (2 0)) ((4 4) (2 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 572)
  (parent 217)
  (unrealized (1 3) (4 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 k1-0 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (5 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (3 0))
    ((5 4) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1) (trans 1 0)
    (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 573)
  (parent 217)
  (unrealized (2 3) (5 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (deflistener k)
  (precedes ((1 1) (5 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (3 0))
    ((5 4) (3 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 574)
  (parent 217)
  (seen 576)
  (unrealized (2 3) (5 3) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 k1-0 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (deflistener k)
  (precedes ((1 1) (5 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 6 1 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 575)
  (parent 220)
  (unrealized (2 3) (4 3) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 576)
  (parent 220)
  (seen 1336)
  (unrealized (2 3) (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 4 1) (neq "init" "wrap")
    (trans 4 0) (trans 6 0) (trans 6 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 4 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-2 k "wrap"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 583)
  (parent 224)
  (seen 1341 1342)
  (unrealized (2 3) (5 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 4) (0 0)) ((2 1) (1 0)) ((3 1) (4 0)) ((4 1) (5 2))
    ((5 4) (2 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 4 1) (neq "init" "wrap")
    (trans 4 0) (trans 3 0) (trans 3 1) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-2 k "wrap"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 584)
  (parent 224)
  (seen 1343 1344)
  (unrealized (1 3) (5 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (3 0))
    ((5 4) (3 0)) ((6 1) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 4 1) (neq "init" "wrap")
    (trans 4 0) (trans 6 0) (trans 6 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 4 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 587)
  (parent 225)
  (seen 1345 1346)
  (unrealized (2 3) (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 4) (0 0)) ((2 1) (1 0)) ((3 1) (4 0)) ((3 1) (5 2))
    ((4 1) (2 0)) ((5 4) (2 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (neq "init" "decrypt") (trans 4 1) (neq "init" "wrap")
    (trans 4 0) (trans 3 0) (trans 3 1) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 588)
  (parent 225)
  (seen 1347 1348)
  (unrealized (1 3) (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 4 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 4 0) (trans 6 0) (trans 6 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 4 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0))
      (load lk-0 (cat pt-2 k "decrypt"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 596)
  (parent 229)
  (seen 1349)
  (unrealized (2 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 4) (0 0)) ((2 1) (1 0)) ((3 1) (4 0)) ((4 1) (5 2))
    ((5 4) (2 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 4 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 4 0) (trans 3 0) (trans 3 1) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 597)
  (parent 229)
  (seen 1350)
  (unrealized (1 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (3 0))
    ((5 4) (3 0)) ((6 1) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 4 0) (trans 6 0) (trans 6 1) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 4 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 600)
  (parent 230)
  (seen 1351)
  (unrealized (2 3) (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 4) (0 0)) ((2 1) (1 0)) ((3 1) (4 0)) ((3 1) (5 2))
    ((4 1) (2 0)) ((5 4) (2 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 1) (neq "init" "decrypt") (neq "init" "wrap")
    (trans 4 0) (trans 3 0) (trans 3 1) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 601)
  (parent 230)
  (seen 1352)
  (unrealized (1 3) (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1-0) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 4) (3 0))
    ((5 1) (6 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 cur)
    (cat k1-0 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-2 k1-0 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-5 k1-0 cur))
      (stor lk-0 (cat pt-2 k1-0 "wrap"))))
  (label 604)
  (parent 231)
  (seen 1345 1353)
  (unrealized (2 3) (6 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1-0) (lk lk))
  (precedes ((1 4) (0 0)) ((2 1) (1 0)) ((3 1) (4 2)) ((3 1) (6 0))
    ((4 4) (2 0)) ((5 2) (4 0)) ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 cur)
    (cat k1-0 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 3 0) (trans 3 1) (trans 5 0) (trans 5 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1-0 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1-0 cur)) (stor lk (cat pt-2 k1-0 "wrap"))))
  (label 605)
  (parent 232)
  (seen 1347 1354)
  (unrealized (1 3) (6 0))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (6 0)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (5 2))
    ((5 4) (3 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 1 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 607)
  (parent 234)
  (unrealized (2 3) (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (2 0)) ((4 1) (6 0))
    ((5 4) (3 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 4 make 2) k (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1-0 "wrap")) (send (enc k k1-0)))
    ((recv k) (send k)))
  (label 608)
  (parent 234)
  (seen 1356)
  (unrealized (2 3) (5 3) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (1 0)) ((3 1) (5 2))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-6 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-5 old-1)) (stor lk (cat pt-6 k "init"))
      (send (hash k))))
  (label 610)
  (parent 235)
  (unrealized (0 0))
  (comment "10 in cohort - 10 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (2 0)) ((3 1) (5 2))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 0))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-6 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-5 old-1)) (stor lk (cat pt-6 k "init"))
      (send (hash k))))
  (label 611)
  (parent 235)
  (seen 610 1360 1361 1363 1364 1366 1367 1368 1369)
  (unrealized (0 0))
  (comment "20 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (2 0)) ((3 1) (5 2))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-6 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-5 old-1)) (stor lk (cat pt-6 k "init"))
      (send (hash k))))
  (label 612)
  (parent 235)
  (seen 610 1360 1361 1363 1364 1366 1367 1368 1369)
  (unrealized (0 0))
  (comment "20 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (5 3)) ((2 1) (3 0)) ((2 1) (6 0)) ((3 1) (1 0))
    ((3 1) (5 2)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (rule invShearsRule)
  (operation channel-test (displaced 7 1 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-6 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk-0 (cat pt-0 old)) (stor lk-0 (cat pt-1 k "init")))
    ((load lk-0 (cat pt-1 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-2 k "decrypt"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 614)
  (parent 236)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (5 3)) ((2 1) (3 0)) ((3 1) (1 0)) ((3 1) (5 2))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (rule invShearsRule)
  (operation channel-test (displaced 7 1 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-6 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk-0 (cat pt-0 old)) (stor lk-0 (cat pt-1 k "init")))
    ((load lk-0 (cat pt-1 k "init")) (stor lk-0 (cat pt-2 k "decrypt")))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-2 k "decrypt"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 615)
  (parent 236)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 1) (trans 4 0) (trans 3 0)
    (trans 3 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-6 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-5 old-1)) (stor lk (cat pt-6 k "init"))
      (send (hash k))))
  (label 619)
  (parent 241)
  (seen 289 1370 1375)
  (unrealized (0 0))
  (comment "24 in cohort - 13 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (1 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-6 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-6 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-5 old-1)) (stor lk (cat pt-6 k "init"))
      (send (hash k))))
  (label 621)
  (parent 244)
  (seen 1370)
  (unrealized (0 0))
  (comment "10 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (5 3)) ((3 1) (2 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 6 0)
    (trans 6 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule)
  (operation channel-test (displaced 7 2 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-6 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-6 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-5 old-1)) (stor lk (cat pt-6 k "init"))
      (send (hash k))))
  (label 622)
  (parent 244)
  (seen 621 1370 1383 1385 1386 1388 1389 1390 1391)
  (unrealized (0 0))
  (comment "20 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (5 2)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (operation channel-test (displaced 7 1 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt k "wrap"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 626)
  (parent 249)
  (unrealized (0 0))
  (comment "11 in cohort - 11 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (5 3)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 3 1) (trans 3 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 6 0) (trans 6 1))
  (operation channel-test (displaced 7 1 set-wrap 2)
    (ch-msg lk-1 (cat pt-7 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 629)
  (parent 253)
  (unrealized (0 0))
  (comment "11 in cohort - 11 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 0)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0))
    ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 631)
  (parent 256)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 1) (6 2)) ((5 2) (4 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 632)
  (parent 256)
  (unrealized (6 0) (6 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 0)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0))
    ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 633)
  (parent 256)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 2)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 634)
  (parent 256)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 1) (6 2)) ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 635)
  (parent 256)
  (unrealized (6 0) (6 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 636)
  (parent 256)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand decrypt 4 (x k) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 1) (6 2)) ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0))
    ((6 3) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (added-strand decrypt 4) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (enc k k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (send k)))
  (label 637)
  (parent 256)
  (unrealized (6 0) (6 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (6 0)) ((2 1) (0 0)) ((3 1) (4 0))
    ((3 1) (6 0)) ((4 1) (5 2)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (6 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 652)
  (parent 267)
  (seen 513 1431)
  (unrealized (5 3) (6 0))
  (comment "7 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 1) (4 0)) ((4 1) (6 0))
    ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 4 set-decrypt 2) k (6 0)
    (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 655)
  (parent 268)
  (seen 1431)
  (unrealized (5 3) (6 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 657)
  (parent 270)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((4 4) (0 0))
    ((5 1) (3 0)) ((5 1) (6 2)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 658)
  (parent 270)
  (unrealized (6 0) (6 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 0)) ((3 1) (1 0))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 659)
  (parent 270)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 2)) ((3 1) (1 0))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 660)
  (parent 270)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (6 2))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 661)
  (parent 270)
  (unrealized (6 0) (6 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 662)
  (parent 270)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand decrypt 4 (x k) (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (6 2))
    ((4 4) (0 0)) ((5 1) (3 0)) ((5 2) (4 0)) ((6 3) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 5 0) (trans 5 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-decrypt-0)
  (operation nonce-test (added-strand decrypt 4) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-2 k "decrypt")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (enc k k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (send k)))
  (label 663)
  (parent 270)
  (unrealized (6 0) (6 1))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (6 0)) ((2 1) (0 0)) ((3 1) (4 0))
    ((3 1) (6 0)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (6 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 678)
  (parent 277)
  (seen 537)
  (unrealized (5 3) (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk))
  (precedes ((1 1) (4 2)) ((2 1) (3 0)) ((3 1) (6 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (neq "decrypt" "decrypt") (trans 6 1) (neq "decrypt" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-2 k "decrypt")) (stor lk (cat pt-5 k "wrap"))))
  (label 683)
  (parent 281)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (4 2)) ((1 1) (6 0)) ((2 1) (3 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 684)
  (parent 281)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (4 2)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 1) (6 2)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 685)
  (parent 281)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk))
  (precedes ((1 1) (4 2)) ((2 1) (3 0)) ((3 1) (6 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-2 k "decrypt")) (stor lk (cat pt-5 k "decrypt"))))
  (label 686)
  (parent 281)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (4 2)) ((1 1) (6 0)) ((2 1) (3 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 687)
  (parent 281)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (4 2)) ((2 1) (3 0)) ((3 1) (6 2)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 688)
  (parent 281)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (4 2)) ((1 1) (6 2)) ((2 1) (3 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 689)
  (parent 281)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (4 2)) ((2 1) (3 0)) ((2 1) (6 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 690)
  (parent 281)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand decrypt 4 (x k) (k k) (lk lk))
  (precedes ((1 1) (4 2)) ((2 1) (3 0)) ((3 1) (6 2)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 3) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-decrypt-0)
  (operation nonce-test (added-strand decrypt 4) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (enc k k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (send k)))
  (label 691)
  (parent 281)
  (unrealized (6 0) (6 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (6 0)) ((3 1) (4 0)) ((4 1) (0 0))
    ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 2 set-wrap 2) k (6 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 706)
  (parent 285)
  (unrealized (5 3) (6 0))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (6 0)) ((2 1) (5 2)) ((3 1) (4 0))
    ((3 1) (6 0)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (6 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 708)
  (parent 285)
  (seen 410 1475)
  (unrealized (5 3) (6 0))
  (comment "7 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "decrypt") (k k) (lk lk))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((3 1) (6 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (neq "decrypt" "decrypt") (trans 6 1) (neq "decrypt" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-2 k "decrypt")) (stor lk (cat pt-5 k "wrap"))))
  (label 713)
  (parent 289)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (4 3)) ((1 1) (6 0)) ((2 1) (3 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 714)
  (parent 289)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 1) (6 2)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 715)
  (parent 289)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "decrypt") (k k) (lk lk))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((3 1) (6 0)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "decrypt" "decrypt") (neq "decrypt" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 gen-st-set-wrap-0
    fact-set-wrap-neq0 trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-2 k "decrypt")) (stor lk (cat pt-5 k "decrypt"))))
  (label 716)
  (parent 289)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (4 3)) ((1 1) (6 0)) ((2 1) (3 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 717)
  (parent 289)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((3 1) (6 2)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-wrap-0 gen-st-wrap-1)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 718)
  (parent 289)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (4 3)) ((1 1) (6 2)) ((2 1) (3 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 719)
  (parent 289)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((2 1) (6 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 720)
  (parent 289)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand decrypt 4 (x k) (k k) (lk lk))
  (precedes ((1 1) (4 3)) ((2 1) (3 0)) ((3 1) (6 2)) ((4 4) (0 0))
    ((5 1) (1 0)) ((5 2) (4 0)) ((6 3) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 3 1) (trans 3 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 5 0) (trans 5 1))
  (rule gen-st-decrypt-0)
  (operation nonce-test (added-strand decrypt 4) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-2 k "decrypt"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((recv (enc k k)) (recv (hash k)) (load lk (cat pt-2 k "decrypt"))
      (send k)))
  (label 721)
  (parent 289)
  (unrealized (6 0) (6 1))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (6 0)) ((2 1) (0 0)) ((3 1) (4 0))
    ((3 1) (6 0)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (6 0)
    (ch-msg lk (cat pt-0 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 737)
  (parent 293)
  (seen 466)
  (unrealized (5 3) (6 0))
  (comment "5 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 4 0)
    (trans 4 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init")))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt-6 k "wrap"))))
  (label 741)
  (parent 297)
  (seen 304 1383 1508)
  (unrealized (0 0))
  (comment "23 in cohort - 11 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (6 0))
    ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (1 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (trans 6 0) (trans 5 0) (trans 5 1) (trans 4 0)
    (trans 4 1) (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap")
    (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule shearsRule trRl_set-wrap-at-1 trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init")))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-6 k "wrap"))))
  (label 742)
  (parent 297)
  (seen 1375 1508)
  (unrealized (0 0))
  (comment "9 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-6 k "wrap"))))
  (label 743)
  (parent 297)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 744)
  (parent 297)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 0) (trans 5 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-6 k "decrypt"))))
  (label 745)
  (parent 297)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 746)
  (parent 297)
  (seen 756)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (6 2)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 747)
  (parent 297)
  (seen 760)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk-0 (cat pt-5 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 748)
  (parent 297)
  (seen 764)
  (unrealized (6 0) (6 3))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (1 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 749)
  (parent 298)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (1 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 750)
  (parent 298)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (1 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 751)
  (parent 298)
  (unrealized (6 0) (6 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (1 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-4 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 752)
  (parent 298)
  (unrealized (6 0) (6 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (6 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (1 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 753)
  (parent 298)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (1 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk (cat pt-3 k "init")) (ch-msg lk (cat pt-4 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 754)
  (parent 298)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 755)
  (parent 300)
  (seen 128)
  (unrealized (5 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 756)
  (parent 300)
  (seen 1553)
  (unrealized (5 3))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 757)
  (parent 300)
  (unrealized (5 3) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 758)
  (parent 301)
  (seen 1058 1557)
  (unrealized (5 3))
  (comment "11 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 3)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (5 0))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 759)
  (parent 301)
  (seen 1558 1560)
  (unrealized (4 3))
  (comment "11 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 760)
  (parent 301)
  (seen 1561 1563)
  (unrealized (5 3))
  (comment "11 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 761)
  (parent 301)
  (unrealized (5 3) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 762)
  (parent 302)
  (seen 1162 1568)
  (unrealized (5 3))
  (comment "12 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 1) (5 0)) ((3 2) (2 0))
    ((4 4) (0 0)) ((5 1) (1 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (operation encryption-test (displaced 1 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k))))
  (label 763)
  (parent 302)
  (seen 1569 1572)
  (unrealized (4 3))
  (comment "12 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 764)
  (parent 302)
  (seen 1573 1576)
  (unrealized (5 3))
  (comment "12 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 765)
  (parent 302)
  (unrealized (5 3) (6 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k1) (lk lk-0))
  (defstrand make 2 (old old-1) (k k1) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 4) (0 0)) ((3 1) (5 0)) ((3 2) (2 0))
    ((4 1) (2 3)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "init") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 4 1)
    (neq "init" "wrap") (trans 4 0) (trans 3 0) (trans 3 1) (trans 1 0)
    (trans 1 1))
  (operation generalization deleted (2 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-1 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k1 "init")) (stor lk-0 (cat pt-1 k1 "wrap")))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-4 k1 "init"))))
  (label 766)
  (parent 303)
  (seen 96)
  (unrealized)
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 5 1) (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((load lk-0 (cat pt-2 k "wrap"))
      (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 767)
  (parent 304)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (6 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 5 1) (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 768)
  (parent 304)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap") (trans 5 0)
    (trans 2 1) (trans 2 0) (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 769)
  (parent 304)
  (seen 1406)
  (unrealized (0 0))
  (comment "10 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 5 1) (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((load lk-0 (cat pt-2 k "wrap")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 770)
  (parent 304)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (3 3)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 771)
  (parent 304)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (6 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 4 0) (trans 4 1) (neq "init" "decrypt")
    (trans 5 1) (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((load lk (cat pt-1 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 772)
  (parent 304)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-2 k "wrap"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 773)
  (parent 304)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (6 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (3 3)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 774)
  (parent 304)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 1) (trans 2 0) (trans 1 0)
    (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap"))
    (ch-msg lk-0 (cat pt-2 k "wrap")) (ch-msg lk-0 (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-4 k "init")) (stor lk-0 (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 775)
  (parent 304)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 2) (3 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 2)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 6 0) (trans 6 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt old)) (stor lk-0 (cat pt-0 k "init")))
    ((load lk-0 (cat pt-0 k "init")) (stor lk-0 (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-6 k "init"))
      (load lk-0 (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-6 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 816)
  (parent 312)
  (seen 1552 1604)
  (unrealized (5 3))
  (comment "3 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 1) (6 2)) ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 817)
  (parent 312)
  (seen 131)
  (unrealized (6 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((3 4) (0 0)) ((4 1) (5 2))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 2))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 6 0) (trans 6 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt old)) (stor lk-0 (cat pt-0 k "init")))
    ((load lk-0 (cat pt-0 k "init")) (stor lk-0 (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-6 k "init"))
      (load lk-0 (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 820)
  (parent 313)
  (seen 128 1605)
  (unrealized (5 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (3 3)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-6 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk-0 (cat pt-0 old)) (stor lk-0 (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-1 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 821)
  (parent 313)
  (seen 1606)
  (unrealized (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((3 1) (1 0)) ((3 1) (4 2))
    ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 822)
  (parent 313)
  (seen 128 1608 1609)
  (unrealized (6 3))
  (comment "8 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 2))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 6 0) (trans 6 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt old)) (stor lk-0 (cat pt-0 k "init")))
    ((load lk-0 (cat pt-0 k "init")) (stor lk-0 (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-6 k "init"))
      (load lk-0 (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-1 k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 825)
  (parent 314)
  (seen 1063 1611)
  (unrealized (5 3))
  (comment "11 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (3 3)) ((1 1) (5 2)) ((2 1) (3 2)) ((2 1) (6 0))
    ((3 4) (0 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-6 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk-0 (cat pt-0 old)) (stor lk-0 (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-1 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 826)
  (parent 314)
  (seen 1612 1614)
  (unrealized (5 3))
  (comment "11 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 3)) ((2 1) (6 2)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 827)
  (parent 314)
  (seen 1615 1617)
  (unrealized (6 3))
  (comment "11 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 2))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 6 0) (trans 6 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt old)) (stor lk-0 (cat pt-0 k "init")))
    ((load lk-0 (cat pt-0 k "init")) (stor lk-0 (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-6 k "init"))
      (load lk-0 (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-0 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 830)
  (parent 315)
  (seen 1167 1620)
  (unrealized (5 3))
  (comment "12 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (3 3)) ((2 1) (3 2)) ((2 1) (6 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-6 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk-0 (cat pt-0 old)) (stor lk-0 (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-1 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-6 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))
      (send (hash k))))
  (label 831)
  (parent 315)
  (seen 1621 1624)
  (unrealized (5 3))
  (comment "12 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (4 3)) ((3 1) (1 0))
    ((3 1) (4 2)) ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-4 old-1)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 832)
  (parent 315)
  (seen 1625 1628)
  (unrealized (6 3))
  (comment "12 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (5 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation nonce-test (displaced 7 3 make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-1 (cat pt-6 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 847)
  (parent 318)
  (seen 564)
  (unrealized (4 3) (5 0))
  (comment "7 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (5 0)) ((2 1) (0 0)) ((3 1) (6 2))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 852)
  (parent 319)
  (seen 863)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (0 0)) ((3 1) (5 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 853)
  (parent 319)
  (seen 854)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (3 0)) ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 854)
  (parent 320)
  (seen 1347 1348)
  (unrealized (3 3) (5 3))
  (comment "7 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 855)
  (parent 320)
  (seen 1345 1346)
  (unrealized (3 3) (5 3))
  (comment "7 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 862)
  (parent 322)
  (unrealized (3 3) (5 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 863)
  (parent 322)
  (unrealized (3 3) (5 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (6 0)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-5 k "decrypt"))))
  (label 866)
  (parent 326)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((load lk (cat pt-4 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 867)
  (parent 326)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 5 1) (trans 5 0) (trans 2 0)
    (trans 2 1) (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 4 0) (trans 4 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 868)
  (parent 326)
  (seen 1395)
  (unrealized (0 0))
  (comment "10 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (6 0)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((load lk-0 (cat pt k "wrap")) (stor lk-0 (cat pt-5 k "wrap"))))
  (label 869)
  (parent 326)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 870)
  (parent 326)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (6 0)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((load lk (cat pt-4 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 871)
  (parent 326)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (6 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 872)
  (parent 326)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-4 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 873)
  (parent 326)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (3 2)) ((2 1) (5 0)) ((2 1) (6 2)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt-1 k "init")) (ch-msg lk (cat pt-4 k "wrap"))
    (ch-msg lk-0 (cat pt k "wrap")) (ch-msg lk-0 (cat pt-3 k "init")))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 874)
  (parent 326)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 875)
  (parent 329)
  (seen 1665 1666)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 876)
  (parent 329)
  (seen 1667 1668)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 877)
  (parent 329)
  (seen 1018)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 878)
  (parent 330)
  (seen 136)
  (unrealized (5 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 879)
  (parent 330)
  (seen 1671 1672)
  (unrealized (5 3))
  (comment "4 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 880)
  (parent 330)
  (seen 1022)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 881)
  (parent 331)
  (seen 1013 1675)
  (unrealized (5 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0))
    ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 2 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 882)
  (parent 331)
  (seen 1013 1558 1676)
  (unrealized (4 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 883)
  (parent 331)
  (seen 1015 1612 1677)
  (unrealized (5 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 884)
  (parent 331)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-1) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 5 1)
    (neq "init" "wrap") (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1)
    (trans 1 0) (trans 4 0) (trans 4 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init"))
    (ch-msg lk (cat pt-2 k "wrap")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((load lk-0 (cat pt-5 old-1)) (stor lk-0 (cat pt-6 k "init"))))
  (label 885)
  (parent 333)
  (unrealized (0 0))
  (comment "9 in cohort - 9 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-wrap 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((5 1) (6 0))
    ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "wrap" "decrypt") (trans 6 1) (neq "wrap" "wrap")
    (trans 6 0) (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1) (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule fact-set-decrypt-neq0 trRl_set-wrap-at-1 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-wrap 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init"))
    (ch-msg lk (cat pt-2 k "wrap")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((load lk (cat pt-2 k "wrap")) (stor lk (cat pt-5 k "wrap"))))
  (label 886)
  (parent 333)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "wrap") (k k) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((5 1) (6 0))
    ((6 1) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 6 1) (neq "wrap" "decrypt") (neq "wrap" "wrap")
    (trans 6 0) (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1) (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_set-decrypt-at-1 fact-set-decrypt-neq0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation nonce-test (added-strand set-decrypt 2) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init"))
    (ch-msg lk (cat pt-2 k "wrap")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((load lk (cat pt-2 k "wrap")) (stor lk (cat pt-5 k "decrypt"))))
  (label 887)
  (parent 333)
  (unrealized (0 0))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3)) ((5 1) (6 2))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1) (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init"))
    (ch-msg lk (cat pt-2 k "wrap")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 888)
  (parent 333)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 1) (6 2)) ((4 2) (3 0)) ((5 1) (3 3))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1) (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init"))
    (ch-msg lk (cat pt-2 k "wrap")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-4 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 889)
  (parent 333)
  (unrealized (6 0) (6 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (5 0)) ((2 1) (6 2))
    ((3 4) (0 0)) ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1) (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init"))
    (ch-msg lk (cat pt-2 k "wrap")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 890)
  (parent 333)
  (unrealized (6 0) (6 3))
  (comment "4 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((1 1) (6 2)) ((2 1) (5 0))
    ((3 4) (0 0)) ((4 1) (1 0)) ((4 2) (3 0)) ((5 1) (3 3))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 5 1) (neq "init" "wrap")
    (trans 5 0) (trans 2 0) (trans 2 1) (trans 1 1) (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (0 0) (enc k k)
    (ch-msg lk (cat pt k "wrap")) (ch-msg lk (cat pt-1 k "init"))
    (ch-msg lk (cat pt-2 k "wrap")) (ch-msg lk (cat pt-4 k "init")))
  (traces ((recv k) (send k))
    ((load lk (cat pt-4 k "init")) (stor lk (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-3 old-0)) (stor lk (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 891)
  (parent 333)
  (unrealized (6 0) (6 3))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 2))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt k "wrap"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 923)
  (parent 338)
  (seen 1665 1704 1705)
  (unrealized (5 3))
  (comment "13 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 2) (4 0)) ((5 2) (6 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-5 k "init"))
      (load lk-1 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 924)
  (parent 338)
  (seen 1665 1706 1707 1708)
  (unrealized (6 3))
  (comment "16 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 2) (3 0))
    ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 6 0) (trans 6 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 927)
  (parent 340)
  (seen 1076 1561 1709)
  (unrealized (5 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 2)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 2) (3 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt k "wrap"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 928)
  (parent 340)
  (seen 1076 1710)
  (unrealized (5 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((3 1) (6 2)) ((4 4) (0 0))
    ((5 2) (4 0)) ((5 2) (6 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 929)
  (parent 340)
  (seen 1074 1615 1711)
  (unrealized (6 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 2)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt k "wrap"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt k "wrap"))
      (load lk-1 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 932)
  (parent 341)
  (seen 1671 1712)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (4 2)) ((2 1) (6 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 933)
  (parent 341)
  (seen 138)
  (unrealized (6 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 2) (3 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt k "wrap"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 936)
  (parent 342)
  (seen 1713 1714)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (4 2)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 937)
  (parent 342)
  (seen 1715 1716)
  (unrealized (6 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((2 1) (5 0)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))))
  (label 950)
  (parent 345)
  (unrealized (4 3) (5 0))
  (comment "5 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (6 2)) ((3 1) (0 0)) ((4 4) (0 0))
    ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 951)
  (parent 345)
  (seen 1089)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (5 0)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 1) (4 0)) ((6 4) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule gen-st-wrap-0)
  (operation nonce-test (added-strand wrap 5) k (5 0)
    (ch-msg lk (cat pt-0 k "init")) (ch-msg lk (cat pt-1 k "wrap")))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1-0 "wrap")) (send (enc k k1-0))))
  (label 952)
  (parent 345)
  (seen 1092)
  (unrealized (4 3) (6 0) (6 3))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (3 2)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap")
    (cat k1-0 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 957)
  (parent 347)
  (seen 1728)
  (unrealized (3 3) (5 3))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 3)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 960)
  (parent 353)
  (seen 142)
  (unrealized (5 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 3)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 961)
  (parent 353)
  (seen 1729 1730)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (3 3)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 1) (5 2)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 962)
  (parent 353)
  (seen 1122)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (3 3)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 963)
  (parent 354)
  (seen 1665 1733)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 3)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 964)
  (parent 354)
  (seen 1713 1734)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (precedes ((1 1) (3 3)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 965)
  (parent 354)
  (seen 1126)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (displaced 6 4 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1))))
  (label 966)
  (parent 355)
  (seen 72 1737)
  (unrealized (5 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 3)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 2) (2 0))
    ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (operation encryption-test (displaced 2 6 make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k))))
  (label 967)
  (parent 355)
  (seen 72 1569 1738)
  (unrealized (4 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 4 0) (trans 4 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation encryption-test (added-strand make 3) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 968)
  (parent 355)
  (seen 1119 1621 1739)
  (unrealized (5 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 1) (1 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 4 0) (trans 4 1))
  (operation encryption-test (added-listener k) (hash k) (5 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 969)
  (parent 355)
  (unrealized (5 3) (6 0))
  (comment "3 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 3)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (5 2))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 2))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 989)
  (parent 360)
  (seen 142 1744)
  (unrealized (5 3))
  (comment "14 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((3 1) (0 0))
    ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-5 k "init"))
      (load lk-1 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 990)
  (parent 360)
  (seen 142 1745 1747)
  (unrealized (6 3))
  (comment "16 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (2 0)) ((1 1) (3 2)) ((2 1) (3 3)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 6 0) (trans 6 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 3 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 993)
  (parent 362)
  (seen 1119 1573 1748)
  (unrealized (5 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 3)) ((2 1) (5 2)) ((3 4) (0 0)) ((4 2) (3 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 2)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 994)
  (parent 362)
  (seen 1119 1749)
  (unrealized (5 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((3 1) (6 2))
    ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 995)
  (parent 362)
  (seen 74 1625 1750)
  (unrealized (6 3))
  (comment "8 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 3)) ((1 1) (5 2)) ((2 1) (0 0)) ((3 4) (0 0))
    ((4 2) (3 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 2))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt k "wrap"))
      (load lk-1 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 998)
  (parent 363)
  (seen 1667 1751)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((2 1) (4 3)) ((2 1) (6 2))
    ((3 1) (0 0)) ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 999)
  (parent 363)
  (seen 1715 1752)
  (unrealized (6 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-1))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk-1))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-1))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (precedes ((1 1) (3 3)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 2) (3 0))
    ((5 4) (0 0)) ((6 1) (1 0)) ((6 1) (3 2)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 0) (trans 4 1) (trans 2 0) (trans 2 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-1 (cat pt-6 k "init")) (stor lk-1 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-1 (cat pt-6 k "init"))
      (load lk-1 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-1 (cat pt-5 old-1)) (stor lk-1 (cat pt-6 k "init"))
      (send (hash k))))
  (label 1002)
  (parent 364)
  (seen 1729 1753)
  (unrealized (5 3))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 old-1 mesg) (k k1 skey) (lk lk-0 lk-1 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-1) (k k) (lk lk-1))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (4 2)) ((1 1) (6 2)) ((2 1) (4 3))
    ((3 1) (0 0)) ((4 4) (0 0)) ((5 2) (4 0)) ((5 2) (6 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 0) (trans 5 1) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 5 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-1 (cat pt-4 old-1)) (stor lk-1 (cat pt-5 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-6 k1 "wrap")) (send (enc k k1))))
  (label 1003)
  (parent 364)
  (seen 144)
  (unrealized (6 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 k1-0 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (deflistener k)
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1-0) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (0 0)) ((2 1) (0 0)) ((3 4) (0 0)) ((4 1) (3 0))
    ((5 4) (4 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k1 "wrap") (cat k1-0 "wrap"))
  (facts (trans 2 0) (trans 2 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((recv (hash k)) (recv (hash k1-0)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1-0 "wrap")) (send (enc k k1-0)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1010)
  (parent 367)
  (unrealized (3 3) (5 3))
  (dead)
  (comment "empty cohort"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 3)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((4 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation channel-test (displaced 5 1 set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k))))
  (label 1013)
  (parent 371)
  (seen 1665)
  (unrealized (0 0))
  (comment "5 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old cur mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (5 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((3 2) (4 0)) ((4 4) (0 0)) ((5 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 5 1) (neq cur "wrap") (trans 5 0)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 3 0) (trans 3 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk (cat pt-3 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 1014)
  (parent 371)
  (seen 1758)
  (unrealized (5 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((1 1) (4 3)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 1) (4 2)) ((3 2) (2 0)) ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (operation channel-test (displaced 6 1 set-wrap 2)
    (ch-msg lk (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k))))
  (label 1015)
  (parent 372)
  (seen 1667)
  (unrealized (0 0))
  (comment "8 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (6 0)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 1) (4 2)) ((3 2) (2 0)) ((4 4) (0 0)) ((5 2) (4 0))
    ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (rule shearsRule invShearsRule fact-set-decrypt-neq0
    trRl_set-wrap-at-1 gen-st-set-wrap-0 fact-set-wrap-neq0
    trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 1016)
  (parent 372)
  (seen 1766)
  (unrealized (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 1) (5 0))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation nonce-test (displaced 6 3 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 1017)
  (parent 373)
  (unrealized (4 3) (5 0))
  (comment "2 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (1 0)) ((3 1) (4 2))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 1018)
  (parent 373)
  (seen 1767)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (operation channel-test (displaced 6 1 set-wrap 2)
    (ch-msg lk (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k))))
  (label 1019)
  (parent 375)
  (seen 1671)
  (unrealized (0 0))
  (comment "8 in cohort - 7 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((1 1) (6 0)) ((2 4) (0 0))
    ((3 1) (1 0)) ((3 2) (2 0)) ((4 4) (0 0)) ((5 2) (4 0))
    ((6 1) (4 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 5 0) (trans 5 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk (cat pt-2 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))
      (send (hash k)))
    ((load lk (cat pt-5 k1 cur)) (stor lk (cat pt-2 k1 "wrap"))))
  (label 1020)
  (parent 375)
  (seen 1779)
  (unrealized (6 0))
  (comment "2 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old mesg) (k k1 skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 1) (5 0)) ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap")
    (trans 1 0) (trans 3 0) (trans 3 1))
  (operation nonce-test (displaced 6 3 make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k)))
  (label 1021)
  (parent 376)
  (seen 1780)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (deflistener k)
  (defstrand make 2 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((1 1) (4 2)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (4 0)) ((6 1) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 6 0) (trans 6 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 3 0) (trans 3 1))
  (rule trRl_make-at-0 trRl_make-at-1)
  (operation nonce-test (added-strand make 2) k (5 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt k "wrap"))
      (load lk (cat pt-2 k1 "wrap")) (send (enc k k1)))
    ((recv k) (send k))
    ((load lk-0 (cat pt-3 old-0)) (stor lk-0 (cat pt-4 k "init"))))
  (label 1022)
  (parent 376)
  (seen 1781)
  (unrealized (4 3) (5 0))
  (comment "4 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((4 2) (6 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 4 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "decrypt"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 1023)
  (parent 380)
  (seen 1786 1787 1788 1789 1790)
  (unrealized (6 3))
  (comment "18 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "decrypt") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (4 0)) ((3 2) (2 0))
    ((4 1) (5 2)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap")
    (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "decrypt"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1024)
  (parent 380)
  (seen 1791 1792 1793 1794)
  (unrealized (5 3))
  (comment "11 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((4 2) (6 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 4 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 1027)
  (parent 382)
  (seen 153)
  (unrealized (6 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((1 1) (5 2)) ((2 4) (0 0)) ((3 1) (4 0))
    ((3 2) (2 0)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1028)
  (parent 382)
  (seen 1772 1795)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((4 2) (6 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 4 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 1031)
  (parent 383)
  (seen 1796 1797 1798 1799)
  (unrealized (6 3))
  (comment "18 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (4 0)) ((3 1) (5 2))
    ((3 2) (2 0)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1032)
  (parent 383)
  (seen 1800)
  (unrealized (5 3))
  (comment "4 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((4 2) (6 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 4 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 1035)
  (parent 384)
  (seen 1801 1802)
  (unrealized (6 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (4 0)) ((3 2) (2 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "decrypt")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1036)
  (parent 384)
  (seen 1803 1804)
  (unrealized (5 3))
  (comment "7 in cohort - 2 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-decrypt 2 (cur "init") (k k) (lk lk-0))
  (defstrand decrypt 4 (x k) (k k) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (6 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((5 1) (6 2)) ((6 3) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "decrypt") (cat k "init") (cat k "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 3 wrap 5) (enc k k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "decrypt")))
    ((recv (enc k k)) (recv (hash k)) (load lk-0 (cat pt-4 k "decrypt"))
      (send k)))
  (label 1039)
  (parent 385)
  (unrealized)
  (shape)
  (maps ((0) ((k k))))
  (origs (pt-4 (5 1)) (pt-1 (2 1)) (pt-3 (4 1)) (pt-0 (1 1))))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((4 2) (6 0)) ((5 1) (6 2)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 4 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-4 k "wrap"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 1042)
  (parent 389)
  (seen 66 1805 1806 1807 1808 1809 1810)
  (unrealized (6 3))
  (comment "21 in cohort - 6 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (4 0)) ((3 2) (2 0))
    ((4 1) (5 2)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-2 k "wrap"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1043)
  (parent 389)
  (seen 66 1811 1812 1813 1814)
  (unrealized (5 3))
  (comment "12 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (5 0))
    ((4 2) (3 0)) ((4 2) (6 0)) ((5 1) (0 0)) ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 4 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 1046)
  (parent 391)
  (seen 1013 1815 1816 1817 1818 1819)
  (unrealized (6 3))
  (comment "23 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (4 0)) ((3 1) (5 2))
    ((3 2) (2 0)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1047)
  (parent 391)
  (seen 1013 1821 1822)
  (unrealized (5 3))
  (comment "15 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (6 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((4 2) (6 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 4 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 1050)
  (parent 392)
  (seen 155)
  (unrealized (6 3))
  (comment "1 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((1 1) (5 2)) ((2 4) (0 0)) ((3 1) (4 0))
    ((3 2) (2 0)) ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0))
    ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1051)
  (parent 392)
  (seen 66 1774 1824 1825)
  (unrealized (5 3))
  (comment "10 in cohort - 3 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk))
  (precedes ((1 1) (2 0)) ((1 1) (6 2)) ((2 1) (3 2)) ((3 4) (0 0))
    ((4 1) (5 0)) ((4 2) (3 0)) ((4 2) (6 0)) ((5 1) (0 0))
    ((6 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 5 1) (trans 5 0) (trans 4 0) (trans 4 1)
    (neq "init" "decrypt") (trans 2 1) (neq "init" "wrap") (trans 2 0)
    (trans 1 0) (trans 1 1))
  (operation encryption-test (displaced 7 4 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((load lk-0 (cat pt-3 k "init")) (stor lk-0 (cat pt-4 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk (cat pt-0 k "init"))
      (load lk (cat pt-5 k1 "wrap")) (send (enc k k1))))
  (label 1054)
  (parent 393)
  (seen 1013 1826 1827 1828 1830)
  (unrealized (6 3))
  (comment "18 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk-0))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk-0))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (precedes ((1 1) (2 2)) ((2 4) (0 0)) ((3 1) (4 0)) ((3 2) (2 0))
    ((4 1) (0 0)) ((5 4) (0 0)) ((6 1) (1 0)) ((6 2) (5 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 "wrap"))
  (facts (trans 4 1) (trans 4 0) (trans 3 0) (trans 3 1)
    (neq "init" "decrypt") (trans 1 1) (neq "init" "wrap") (trans 1 0)
    (trans 6 0) (trans 6 1))
  (operation encryption-test (displaced 1 7 make 3) (hash k) (6 0))
  (traces ((recv k) (send k))
    ((load lk-0 (cat pt-5 k "init")) (stor lk-0 (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk-0 (cat pt k "wrap"))
      (load lk-0 (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((load lk (cat pt-1 k "init")) (stor lk (cat pt-2 k "wrap")))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-5 k "init"))
      (load lk-0 (cat pt-3 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-4 old-0)) (stor lk-0 (cat pt-5 k "init"))
      (send (hash k))))
  (label 1055)
  (parent 393)
  (seen 1013 1831 1832 1833 1834)
  (unrealized (5 3))
  (comment "17 in cohort - 4 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 3)) ((3 4) (0 0))
    ((4 1) (1 0)) ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k))))
  (label 1058)
  (parent 394)
  (seen 1013 1706 1796 1815)
  (unrealized (0 0))
  (comment "19 in cohort - 5 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((2 1) (5 3)) ((3 4) (0 0))
    ((4 1) (2 0)) ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule)
  (operation channel-test (displaced 6 2 set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-3 k "init"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k))))
  (label 1059)
  (parent 394)
  (seen 1013 1058 1665 1706 1756 1757 1796 1815 1837 1838 1839)
  (unrealized (0 0))
  (comment "24 in cohort - 0 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 cur mesg) (k k1 skey) (lk lk-0 locn))
  (deflistener k)
  (defstrand make 2 (old old) (k k) (lk lk))
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk-0))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k1) (lk lk-0))
  (defstrand set-wrap 2 (cur cur) (k k1) (lk lk-0))
  (precedes ((1 1) (2 0)) ((2 1) (3 2)) ((3 4) (0 0)) ((4 1) (6 0))
    ((4 2) (3 0)) ((4 2) (5 0)) ((5 4) (0 0)) ((6 1) (5 3)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap") (cat k1 cur) (cat k1 "wrap"))
  (facts (neq cur "decrypt") (trans 6 1) (neq cur "wrap") (trans 6 0)
    (trans 4 0) (trans 4 1) (neq "init" "decrypt") (trans 2 1)
    (neq "init" "wrap") (trans 2 0) (trans 1 0) (trans 1 1))
  (rule invShearsRule fact-set-decrypt-neq0 trRl_set-wrap-at-1
    gen-st-set-wrap-0 fact-set-wrap-neq0 trRl_make-at-0)
  (operation channel-test (added-strand set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (5 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt old)) (stor lk (cat pt-0 k "init")))
    ((load lk (cat pt-0 k "init")) (stor lk (cat pt-1 k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "wrap"))
      (load lk (cat pt-1 k "wrap")) (send (enc k k)))
    ((load lk-0 (cat pt-2 old-0)) (stor lk-0 (cat pt-3 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k1)) (load lk-0 (cat pt-3 k "init"))
      (load lk-0 (cat pt-4 k1 "wrap")) (send (enc k k1)))
    ((load lk-0 (cat pt-5 k1 cur)) (stor lk-0 (cat pt-4 k1 "wrap"))))
  (label 1060)
  (parent 394)
  (seen 1013 1058 1818 1840)
  (unrealized (6 0))
  (comment "7 in cohort - 1 not yet seen"))

(defskeleton wrap-decrypt
  (vars (old old-0 mesg) (k skey) (lk locn))
  (deflistener k)
  (defstrand set-wrap 2 (cur "init") (k k) (lk lk))
  (defstrand wrap 5 (cur "wrap") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old) (k k) (lk lk))
  (defstrand wrap 5 (cur "init") (k0 k) (k1 k) (lk lk))
  (defstrand make 3 (old old-0) (k k) (lk lk))
  (precedes ((1 1) (2 2)) ((1 1) (4 3)) ((2 4) (0 0)) ((3 1) (1 0))
    ((3 1) (4 2)) ((3 2) (2 0)) ((4 4) (0 0)) ((5 1) (1 0))
    ((5 2) (4 0)))
  (pen-non-orig k)
  (genStV (cat k "init") (cat k "wrap"))
  (facts (trans 3 0) (trans 3 1) (neq "init" "decrypt") (trans 1 1)
    (neq "init" "wrap") (trans 1 0) (trans 5 0) (trans 5 1))
  (rule invShearsRule)
  (operation channel-test (displaced 6 1 set-wrap 2)
    (ch-msg lk-0 (cat pt-4 k1 "wrap")) (4 3))
  (traces ((recv k) (send k))
    ((load lk (cat pt-3 k "init")) (stor lk (cat pt k "wrap")))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt k "wrap"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-0 old)) (stor lk (cat pt-1 k "init"))
      (send (hash k)))
    ((recv (hash k)) (recv (hash k)) (load lk (cat pt-1 k "init"))
      (load lk (cat pt k "wrap")) (send (enc k k)))
    ((load lk (cat pt-2 old-0)) (stor lk (cat pt-3 k "init"))
      (send (hash k))))
  (label 1061)
  (parent 395)
  (seen 1013 1665 1756 1757)
  (unrealized (0 0))
  (comment "11 in cohort - 0 not yet seen"))

