package io.quarkus.hibernate.orm.runtime.boot.registry;

import java.util.Collection;

import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;

/**
 * Mirror replay of the state generated by
 * org.hibernate.integrator.internal.IntegratorServiceImpl
 *
 * N.B. 1 the original implementations sneaks in some non-explicit integrators;
 * in particular one might want to prevent JaccIntegrator to ever reach the
 * state being mirrored.
 *
 * N.B. 2 when generating the state of Integrators, it does search for
 * extensions over loadJavaServices. This implies the state needs to be recorded
 * when all extension points are discoverable.
 */
final class MirroringIntegratorService implements IntegratorService {

    private final Collection<Integrator> integrators;

    MirroringIntegratorService(Collection<Integrator> integrators) {
        this.integrators = integrators;
    }

    @Override
    public Iterable<Integrator> getIntegrators() {
        return integrators;
    }

}
