**Title:** Pro Git (Second Edition)

**Authors:** Scott Chacon and Ben Straub

**Short description:**

Pro Git (Second Edition) is your fully-updated guide to Git and its usage in the modern world. Git has come a long way since it was first developed by Linus Torvalds for Linux kernel development. It has taken the open source world by storm since its inception in 2005, and this book teaches you how to use it like a pro. 

**Long description:**

Pro Git (Second Edition) is your fully-updated guide to Git and its usage in the modern world. Git has come a long way since it was first developed by Linus Torvalds for Linux kernel development. It has taken the open source world by storm since its inception in 2005, and this book teaches you how to use it like a pro. 

Effective and well-implemented version control is a necessity for successful web projects, whether large or small. With this book you’ll learn how to master the world of distributed version workflow, use the distributed features of Git to the full, and extend Git to meet your every need.

Written by Git pros Scott Chacon and Ben Straub, Pro Git (Second Edition) builds on the hugely successful first edition, and is now fully updated for Git version 2.0, as well as including an indispensable chapter on GitHub. It’s the best book for all your Git needs.

## What You’ll Learn

* Effectively use Git, either as a programmer or a project leader
* Become a fluent Git user
* Master branching, using Git on the server, and on other systems
* Integrate Git in your development workflow
* Migrate programming projects from other SCMs to Git
* Extend Git for your personal project needs
* Effectively use GitHub

## Who This Book Is For

This book is for all open source developers: you are bound to encounter Git somewhere in the course of your working life. Proprietary software developers will appreciate Git’s enormous scalability, since it is used for the Linux project, which comprises thousands of developers and testers.


## Short Table of Contents

1.	Getting Started
2.	Git Basics
3.	Git Branching
4.	Git on the Server
5.	Distributed Git
6.	GitHub
7.	Git Tools
8.	Customizing Git
9.	Git and Other Systems
10.	Git in Other Environments
11.	Git Internals

## Expanded Table of Contents:

```
1.	Getting Started
    a.	About Version Control
    b.	A Short History of Git
    c.	Installing Git
    d.	First-Time Git Setup
    e.	Getting Help
    f.	Summary
2.	Git Basics
    a.	Getting a Git Repository
    b.	Recording Changes to the Repository
    c.	Viewing the Commit History
    d.	Undoing Things
    e.	Working with Remotes
    f.	Tagging
    g.	Tips and Tricks
    h.	Summary
3.	Git Branching
    a.	What a Branch Is
    b.	Basic Branching and Merging
    c.	Branch Management
    d.	Branching Workflows
    e.	Remote Branches
    f.	Rebasing
    g.	Summary
4.	Git on the Server
    a.	The Protocols
    b.	Getting Git on a Server
    c.	Generating Your SSH Public Key
    d.	Setting Up the Server
    e.	Public Access
    f.	GitWeb
    g.	Git Daemon
    h.	Gitolite
    i.	GitLab
    j.	Gerrit
    k.	Other Hosting Options (bitbucket, stash, kiln, etc.)
    l.	Summary
5.	Distributed Git
    a.	Distributed Workflows
    b.	Contributing to a Project
    c.	Maintaining a Project
    d.	Summary
6.	GitHub
    a.	Setting Up a User Account
    b.	Projects
    c.	GitHub Flow
    d.	Discussions
    e.	Organizations
    f.	Tips & Tricks
    g.	The API
    h.	Summary
7.	Git Tools
    a.	Revision Selection
    b.	Interactive Staging
    c.	Stashing
    d.	Searching (git grep)
    e.	Rewriting History
    f.	Debugging with Git
    g.	Submodules
    h.	Subtree Merging
    i.	Notes
    j.	Bundle
    k.	Rerere
    l.	History Hacks
    m.	Summary
8.	Customizing Git
    a.	Git Configuration
    b.	Git Attributes
    c.	Git Hooks
    d.	An Example Git-Enforced Policy
    e.	Summary
9.	Git and Other Systems
    a.	Git and Subversion
    b.	Git and Mercurial
    c.	Git and Perforce
    d.	Git and TFS
    e.	Migrating to Git
    f.	A Custom Credential Cache
    g.	Summary
10.	Git in Other Environments
    a.	Graphical Interfaces
    b.	Git in Visual Studio
    c.	Git in Eclipse
    d.	Git in Bash
    e.	Git in Zsh
    f.	Git in Powershell
    g.	Git in Your Application
11.	Git Internals
    a.	Plumbing and Porcelain
    b.	Git Objects
    c.	Git References
    d.	Packfiles
    e.	The Refspec
    f.	Transfer Protocols
    g.	Maintenance and Data Recovery
    h.	Environment Variables
    i.	Summary
```

