# Copyright 2013-2020 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class AlsaLib(AutotoolsPackage):
    """The Advanced Linux Sound Architecture (ALSA) provides audio and MIDI
    functionality to the Linux operating system. alsa-lib contains the user
    space library that developers compile ALSA applications against."""

    homepage = "https://www.alsa-project.org"
    url      = "ftp://ftp.alsa-project.org/pub/lib/alsa-lib-1.2.2.tar.bz2"

    version('1.2.2', sha256='d8e853d8805574777bbe40937812ad1419c9ea7210e176f0def3e6ed255ab3ec')
    version('1.1.4.1', sha256='91bb870c14d1c7c269213285eeed874fa3d28112077db061a3af8010d0885b76')

    variant('python', default=False, description='enable python')

    patch('python.patch', when='@1.1.4:1.1.5 +python')

    depends_on('python', type=('link', 'run'), when='+python')

    def configure_args(self):
        spec = self.spec
        args = []
        if spec.satisfies('+python'):
            args.append(
                '--with-pythonlibs={0}'.format(spec['python'].libs.ld_flags)
            )
            args.append(
                '--with-pythonincludes={0}'.format(
                    spec['python'].headers.include_flags
                )
            )
        else:
            args.append('--disable-python')
        return args
