# Copyright 2013-2020 Lawrence Livermore National Security, LLC and other
# Spack Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

from spack import *


class RAskpass(RPackage):
    """Cross-platform utilities for prompting the user for credentials or a
    passphrase, for example to authenticate with a server or read a protected
    key. Includes native programs for MacOS and Windows, hence no 'tcltk' is
    required. Password entry can be invoked in two different ways: directly
    from R via the askpass() function, or indirectly as password-entry back-end
    for 'ssh-agent' or 'git-credential' via the SSH_ASKPASS and GIT_ASKPASS
    environment variables. Thereby the user can be prompted for credentials or
    a passphrase if needed when R calls out to git or ssh."""

    homepage = "https://github.com/jeroen/askpass#readme"
    url      = "https://cloud.r-project.org/src/contrib/askpass_1.1.tar.gz"
    list_url = "https://cloud.r-project.org/src/contrib/Archive/askpass"

    version('1.1', sha256='db40827d1bdbb90c0aa2846a2961d3bf9d76ad1b392302f9dd84cc2fd18c001f')

    depends_on('r-sys@2.1:', type=('build', 'run'))
