#!/bin/bash                                                                                                                                                                                                                                  

MONO_GIT_ROOT="<MONO_GIT_ROOT>"
TE_PRJ_DIR="<TE_GIT_ROOT>/src/Servers/Kestrel/perf/PlatformBenchmarks"

# Build mono netcore                                                                                                                                                                                                                        
cd $MONO_GIT_ROOT
scripts/update_submodules.sh
cd netcore
./build.sh -c Release
make patch-local-dotnet

# Build and test app with patched dotnet
export BenchmarksTargetFramework=netcoreapp5.0
export MicrosoftAspNetCoreAppPackageVersion=5.0.0-alpha1.19470.6
export MicrosoftNETCoreAppPackageVersion=5.0.0-alpha1.19507.3
export MONO_DEBUG=disable_omit_fp

../.dotnet/dotnet build -c Release $TE_PRJ_DIR
../.dotnet/dotnet $TE_PRJ_DIR/bin/Release/netcoreapp5.0/PlatformBenchmarks.dll &

# Wait for the server to start accepting requests                                                                                                                                                                                           
while ! echo exit | nc localhost 8080; do sleep 10; done

# Start measurement                                                                                                                                                                                                           
wrk --latency -t 8 -d 15 -c 256 --header "Accept: text/plain,text/html;q=0.9,application/xhtml+xml;q=0.9,application/xml;q=0.8,*/*;q=0.7" --header "Connection: keep-alive" http://localhost:8080/plaintext
