# EnTT in Action

`EnTT` is widely used in private and commercial applications. I cannot even
mention most of them because of some signatures I put on some documents time
ago. Fortunately, there are also people who took the time to implement open
source projects based on `EnTT` and did not hold back when it came to
documenting them.

Below an incomplete list of games, applications and articles that can be used as
a reference. Where I put the word _apparently_ means that the use of `EnTT` is
documented but the authors didn't make explicit announcements or contacted me
directly.

I hope this list can grow much more in the future:

* Games:
  * [Minecraft](https://minecraft.net/en-us/attribution/) by
    [Mojang](https://mojang.com/): of course, **that** Minecraft, see the
    open source attributions page for more details.
  * [Land of the Rair](https://github.com/LandOfTheRair/core2): the new backend
    of [a retro-style MUD](https://rair.land/) for the new age.
  * [Openblack](https://github.com/openblack/openblack): open source
    reimplementation of the game _Black & White_ (2001).
  * [Face Smash](https://play.google.com/store/apps/details?id=com.gamee.facesmash):
    a game to play with your face.
  * [EnTT Pacman](https://github.com/Kerndog73/EnTT-Pacman): an example of how
    to make Pacman with `EnTT`.
  * [Wacman](https://github.com/carlfindahl/wacman): a pacman clone with OpenGL.
  * [Classic Tower Defence](https://github.com/kerndog73/Classic-Tower-Defence):
    a tiny little tower defence game featuring a homemade font.
    [Check it out](https://indi-kernick.itch.io/classic-tower-defence).
  * [The Machine](https://github.com/Kerndog73/The-Machine): a box pushing
    puzzler with logic gates and other cool stuff.
    [Check it out](https://indi-kernick.itch.io/the-machine-web-version).
  * [EnttPong](https://github.com/reworks/EnttPong): an example of how to make
    Pong with `EnTT`.
  * [Randballs](https://github.com/gale93/randballs): simple `SFML` and `EnTT`
    playground.
  * [EnTT Tower Defense](https://github.com/Daivuk/tddod): a data oriented tower
    defense example.
  * [EnTT Breakout](https://github.com/vblanco20-1/entt-breakout): simple
    example of a breakout game, using `SDL` and `EnTT`.
  * [Arcade puzzle game with EnTT](https://github.com/MasonRG/ArcadePuzzleGame):
    arcade puzzle game made in C++ using the `SDL2` and `EnTT` libraries.
  * [Snake with EnTT](https://github.com/MasonRG/SnakeGame): simple snake game
    made in C++ with the `SDL2` and `EnTT` libraries.
  * [Mirrors lasers and robots](https://github.com/guillaume-haerinck/imac-tower-defense):
    a small tower defense game based on mirror orientation.
  * [PopHead](https://github.com/SPC-Some-Polish-Coders/PopHead/): 2D, Zombie,
    RPG game made from scratch in C++.
  * [Robotligan](https://github.com/Trisslotten/robotligan): multiplayer
    football game.
  * [DungeonSlayer](https://github.com/alohaeee/DungeonSlayer): 2D game made
    from scratch in C++.

* Engines and the like:
  * [Fling Engine](https://github.com/flingengine/FlingEngine): a Vulkan game
    engine with a focus on data oriented design.
  * [Apparently](https://teamwisp.github.io/credits/)
    [Wisp](https://teamwisp.github.io/product/) by
    [Team Wisp](https://teamwisp.github.io/): an advanced real-time ray tracing
    renderer built for the demands of video game artists.
  * [starlight](https://github.com/DomRe/starlight): game programming framework
    using `Allegro`, `Lua` and modern C++.
  * [Apparently](https://github.com/JosiahWI/qub3d-libdeps)
    [Qub3d](https://qub3d.org/): because blocks should be open source.
  * [shiva](https://github.com/Milerius/shiva): modern C++ engine with
    modularity.
  * [NovusCore](https://github.com/novuscore/NovusCore): a modern take on World
    of Warcraft emulation.
  * [ImGui/EnTT editor](https://github.com/Green-Sky/imgui_entt_entity_editor):
    a drop-in, single-file entity editor for `EnTT` that uses `ImGui` as
    graphical backend (with
    [demo code](https://github.com/Green-Sky/imgui_entt_entity_editor_demo)).
  * [SgOgl](https://github.com/stwe/SgOgl): a game engine library for OpenGL
    developed for educational purposes.
  * [Lumos](https://github.com/jmorton06/Lumos): game engine written in C++
    using OpenGL and Vulkan.
  * [Chrysalis](https://github.com/ivanhawkes/Chrysalis): action RPG SDK for
    CRYENGINE games.
  * [LM-Engine](https://github.com/Lawrencemm/LM-Engine): the Vim of game
    engines.

* Articles and blog posts:
  * [Some posts](https://skypjack.github.io/tags/#entt) on my personal
    [blog](https://skypjack.github.io/) are about `EnTT`, for those who want to
    know **more** on this project.
  * [Space Battle: Huge edition](http://victor.madtriangles.com/code%20experiment/2018/06/11/post-ecs-battle-huge.html):
    huge space battle built entirely from scratch.
  * [Space Battle](https://github.com/vblanco20-1/ECS_SpaceBattle): huge space
    battle built on `UE4`.
  * [Experimenting with ECS in UE4](http://victor.madtriangles.com/code%20experiment/2018/03/25/post-ue4-ecs-battle.html):
    interesting article about `UE4` and `EnTT`.
  * [Implementing ECS architecture in UE4](https://forums.unrealengine.com/development-discussion/c-gameplay-programming/1449913-implementing-ecs-architecture-in-ue4-giant-space-battle):
    giant space battle.
  * [Conan Adventures (SFML and EnTT in C++)](https://leinnan.github.io/blog/conan-adventuressfml-and-entt-in-c.html):
    create projects in modern C++ using `SFML`, `EnTT`, `Conan` and `CMake`.
  * [Adding EnTT ECS to Chrysalis](https://www.tauradius.com/post/adding-an-ecs-to-chrysalis/):
    a blog entry about the process followed and the results of the integration
    of `EnTT` into `Chrysalis`.
  * [Creating Minecraft in One Week with C++ and Vulkan](https://vazgriz.com/189/creating-minecraft-in-one-week-with-c-and-vulkan/):
    a crack at recreating Minecraft in one week using a custom C++ engine and
    Vulkan ([code included](https://github.com/vazgriz/VoxelGame)).

* Any Other Business:
  * [ArcGIS Runtime SDKs](https://developers.arcgis.com/arcgis-runtime/) by
    [Esri](https://www.esri.com/): they use `EnTT` for the internal ECS and the
    cross platform C++ rendering engine. The SDKs are utilized by a lot of
    enterprise custom apps, as well as by Esri for its own public applications
    such as
    [Explorer](https://play.google.com/store/apps/details?id=com.esri.explorer),
    [Collector](https://play.google.com/store/apps/details?id=com.esri.arcgis.collector)
    and
    [Navigator](https://play.google.com/store/apps/details?id=com.esri.navigator).
  * [FASTSUITE Edition 2](https://www.fastsuite.com/en_EN/fastsuite/fastsuite-edition-2.html)
    by [Cenit](http://www.cenit.com/en_EN/about-us/overview.html): they use
    `EnTT` to drive their simulation, that is, the communication between robot
    controller emulator and renderer.
  * [Apparently](https://www.linkedin.com/in/skypjack/)
    [NIO](https://www.nio.io/): there was a collaboration to make some changes
    to `EnTT`, at the time used for internal projects.
  * [Apparently](https://www.linkedin.com/jobs/view/architekt-c%2B%2B-at-tieto-1219512333/)
    [Tieto](https://www.tieto.com/): they published a job post where `EnTT` was
    listed on their software stack.
  * [Sequentity](https://github.com/alanjfs/sequentity): A MIDI-like
    sequencer/tracker for C++ and `ImGui` (with `Magnum` and `EnTT`).
  * [Godot meets EnTT](https://github.com/portaloffreedom/godot_entt_example/):
    a simple example on how to use `EnTT` within
    [`Godot`](https://godotengine.org/).
  * [Godot and GameNetworkingSockets meet EnTT](https://github.com/portaloffreedom/godot_entt_net_example):
    a simple example on how to use `EnTT` and
    [`GameNetworkingSockets`](https://github.com/ValveSoftware/GameNetworkingSockets)
    within [`Godot`](https://godotengine.org/).
  * [MatchOneEntt](https://github.com/mhaemmerle/MatchOneEntt): port of
    [Match One](https://github.com/sschmid/Match-One) for `Entitas-CSharp`.
  * GitHub contains also
    [many other examples](https://github.com/search?o=desc&q=%22skypjack%2Fentt%22&s=indexed&type=Code)
    of use of `EnTT` from which to take inspiration if interested.

If you know of other resources out there that are about `EnTT`, feel free to
open an issue or a PR and I'll be glad to add them to this page.
