package org.ff4j.cli.util;

/*
 * #%L
 * ff4j-cli
 * %%
 * Copyright (C) 2013 - 2016 FF4J
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


/**
 * Operating System.
 *
 * @author Cedrick Lunven (@clunven)</a>
 */
public enum OSSupported {

    /** Windows. */
    WINDOWS("win"),
    
    /** Mac. */
    OS_X("mac"),
    
    /** Unix. */
    UNIX("unix"),
    
    /** Unix. */
    SOLARIS("solaris");
    
    /** Code color for foreGround. */
    private final String name;
    
    /**
     * Default Constructor.
     *
     * @param pname
     *      current name
     */
    private OSSupported(String pname) {
        this.name = pname;
    }

    /**
     * Getter accessor for attribute 'name'.
     *
     * @return
     *       current value of 'name'
     */
    public String getName() {
        return name;
    }
    
}
