package org.ff4j.elastic.store;

/*
 * #%L
 * ff4j-store-elastic
 * %%
 * Copyright (C) 2013 - 2020 FF4J
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.net.MalformedURLException;
import java.net.URL;

import org.ff4j.elastic.ElasticQueryHelper;

import io.searchbox.client.JestClient;

public class JestClientTestFactory {

    private static final String ELASTIC_URL = "http://localhost:9200";
    
    private static JestClient jc = null;
    
    public static synchronized JestClient getJestClient() {
        try {
            if (null == jc) {
                URL node1 = new URL(ELASTIC_URL);
                jc = ElasticQueryHelper.createDefaultJestClient(node1);
            }
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return jc;
    }
}
