---
title: MCP Server
description: Use Nuxt UI components in your AI assistants with Model Context Protocol support.
navigation.icon: i-lucide-server
---

## What is MCP?

MCP (Model Context Protocol) is a standardized protocol that enables AI assistants to access external data sources and tools. Nuxt UI provides an MCP server that allows AI assistants like Claude Code, Cursor, and Windsurf to access component information, source code, and usage examples directly.

The MCP server provides structured access to our component library, making it easy for AI tools to understand and assist with Nuxt UI development.

## Available Resources

The Nuxt UI MCP server provides the following resources for discovery:

- **`resource://nuxt-ui/components`**: Browse all available components with categories
- **`resource://nuxt-ui/composables`**: Browse all available composables with categories
- **`resource://nuxt-ui/examples`**: Browse all available code examples
- **`resource://nuxt-ui/templates`**: Browse all available project templates
- **`resource://nuxt-ui/documentation-pages`**: Browse all available documentation pages

You're able to access these resources with tools like Claude Code by using `@`.

## Available Tools

The Nuxt UI MCP server provides the following tools organized by category:

### Component Tools

- **`list_components`**: Lists all available Nuxt UI components with their categories and basic information
- **`list_composables`**: Lists all available Nuxt UI composables with their categories and basic information
- **`get_component`**: Retrieves component documentation and details
- **`get_component_metadata`**: Retrieves detailed metadata for a component including props, slots, and events
- **`search_components_by_category`**: Searches components by category or text filter

### Template Tools

- **`list_templates`**: Lists all available Nuxt UI templates with optional category filtering
- **`get_template`**: Retrieves template details and setup instructions

### Documentation Tools

- **`list_documentation_pages`**: Lists all documentation pages
- **`get_documentation_page`**: Retrieves documentation page content by URL path
- **`list_getting_started_guides`**: Lists all getting started guides and installation instructions

### Example Tools

- **`list_examples`**: Lists all available UI examples and code demonstrations
- **`get_example`**: Retrieves specific UI example implementation code and details

### Migration Tools

- **`get_migration_guide`**: Retrieves version-specific migration guides and upgrade instructions

## Available Prompts

The Nuxt UI MCP server provides guided prompts for common workflows:

- **`find_component_for_usecase`**: Find the best component for your specific use case
- **`implement_component_with_props`**: Generate complete component implementation with proper props
- **`setup_project_with_template`**: Get guided setup instructions for project templates

You're able to access these resources with tools like Claude Code by using `/`.

## Configuration

The Nuxt UI MCP server uses HTTP transport and can be configured in different AI assistants.

### ChatGPT

::note{icon="i-lucide-info"}
**Custom connectors using MCP are available on ChatGPT for Pro and Plus accounts** on the web.
::

Follow these steps to set up Nuxt UI as a connector within ChatGPT:

1. **Enable Developer mode:**
   - Go to Settings → Connectors → Advanced settings → Developer mode

2. **Open ChatGPT settings**

3. **In the Connectors tab, Create a new connector:**
   - Give it a name: `Nuxt UI`
   - MCP server URL: `https://ui.nuxt.com/mcp`
   - Authentication: `None`

4. **Click Create**

The Nuxt UI connector will appear in the composer's "Developer mode" tool later during conversations.

### Claude Code

::note{icon="i-lucide-info"}
**Ensure Claude Code is installed** - Visit [Anthropic's documentation](https://docs.anthropic.com/en/docs/claude-code/quickstart) for installation instructions.
::

Add the server using the CLI command:

```bash
claude mcp add --transport http nuxt-ui-remote https://ui.nuxt.com/mcp
```

### Cursor

#### Quick Install

Click the button below to install the Nuxt UI MCP server directly in Cursor:

::u-button
---
to: "cursor://anysphere.cursor-deeplink/mcp/install?name=nuxt-ui&config=eyJ0eXBlIjoiaHR0cCIsInVybCI6Imh0dHBzOi8vdWkubnV4dC5jb20vbWNwIn0%3D"
label: Install MCP Server
color: neutral
icon: i-custom-cursor
---
::

#### Manual Setup Instructions:

1. Open Cursor and go to "Settings" > "Tools & MCP"
2. Add the Nuxt UI MCP server configuration

Or manually create/update `.cursor/mcp.json` in your project root:

```json [.cursor/mcp.json]
{
  "mcpServers": {
    "nuxt-ui": {
      "type": "http",
      "url": "https://ui.nuxt.com/mcp"
    }
  }
}
```

### Le Chat Mistral

#### Setup Instructions:

1. Navigate to "Intelligence" > "Connectors"
2. Click on "Add Connector" button, then select "Custom MCP Connector"
3. Create your Custom MCP Connector:
    - Connector Name : `NuxtUI`
    - Connector Server : `https://ui.nuxt.com/mcp`

### Visual Studio Code

::note{icon="i-lucide-info"}
**Install required extensions** - Ensure you have [GitHub Copilot](https://marketplace.visualstudio.com/items?itemName=GitHub.copilot) and [GitHub Copilot Chat](https://marketplace.visualstudio.com/items?itemName=GitHub.copilot-chat) extensions installed.
::

#### Setup Instructions:

1. Open VS Code and access the Command Palette (Ctrl/Cmd + Shift + P)
2. Type "Preferences: Open Workspace Settings (JSON)" and select it
3. Navigate to your project's `.vscode` folder or create one if it doesn't exist
4. Create or edit the `mcp.json` file with the following configuration:

```json [.vscode/mcp.json]
{
  "servers": {
    "nuxt-ui": {
      "type": "http",
      "url": "https://ui.nuxt.com/mcp"
    }
  }
}
```

### Windsurf

#### Setup Instructions:

1. Open Windsurf and navigate to "Settings" > "Windsurf Settings" > "Cascade"
2. Click the "Manage MCPs" button, then select the "View raw config" option
3. Add the following configuration to your MCP settings:

```json [.codeium/windsurf/mcp_config.json]
{
  "mcpServers": {
    "nuxt-ui": {
      "type": "http",
      "url": "https://ui.nuxt.com/mcp"
    }
  }
}
```

### Zed

#### Setup Instructions:

1. Open Zed and go to "Settings" > "Open Settings"
2. Navigate to the JSON settings file
3. Add the following context server configuration to your settings:

```json [.config/zed/settings.json]
{
  "context_servers": {
    "nuxt-ui": {
      "source": "custom",
      "command": "npx",
      "args": ["mcp-remote", "https://ui.nuxt.com/mcp"],
      "env": {}
    }
  }
}
```

### Opencode

#### Setup Instructions:

1. In your project root, create `opencode.json`
2. Add the following configuration:

```json
{
  "$schema": "https://opencode.ai/config.json",
  "mcp": {
    "nuxt-ui": {
      "type": "remote",
      "url": "https://ui.nuxt.com/mcp",
      "enabled": true
    },
  }
}
```

## Usage Examples

Once configured, you can ask your AI assistant questions like:

- "List all available Nuxt UI components"
- "Get Button component documentation"
- "What props does Input accept?"
- "Find form-related components"
- "List dashboard templates"
- "Get template setup instructions"
- "Show installation guide"
- "Get v4 migration guide"
- "List all examples"
- "Get ContactForm example code"

The AI assistant will use the MCP server to fetch structured JSON data and provide guided assistance for Nuxt UI during development.
