---
title: Headers and text
description: 'Beautifully styled headings, paragraphs, text formatting, and links for optimal readability.'
framework: nuxt
---

## Headings

Use headings to organize your content and make it easier to read.

H1 to H3 headings get anchor links and show up in the table of contents for easy navigation.

::note
You can control [anchor links](https://content.nuxt.com/docs/getting-started/configuration#anchorlinks) generation (for example, for AI chat interfaces) in your `nuxt.config.ts`:

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  content: {
    renderer: {
      anchorLinks: false
    }
  }
})
```
::

::note
You can control behavior of [toc generation](https://content.nuxt.com/docs/getting-started/configuration#toc) in your `nuxt.config.ts`:

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  content: {
    build: {
      markdown: {
        toc: {
          depth: 3
        }
      }
    }
  }
})
```
::

### Heading 1

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0"}

# Nuxt UI

#code

```mdc
# Nuxt UI
```

::

:component-theme{slug="h1" prose label="Theme"}

::

### Heading 2

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0"}

## What's new in v4?

#code

```mdc
## What's new in v4?
```

::

:component-theme{slug="h2" prose label="Theme"}

::

### Heading 3

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0"}

### Enhanced components

#code

```mdc
### Enhanced components
```

::

:component-theme{slug="h3" prose label="Theme"}

::

### Heading 4

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0"}

#### Getting started

#code

```mdc
#### Getting started
```

::

:component-theme{slug="h4" prose label="Theme"}

::

## Text formatting

Structure your content with clear paragraphs and consistent text formatting for better readability.

### Paragraph

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0"}
Nuxt UI provides a comprehensive collection of Vue components, composables and utilities for building modern, accessible applications with consistent design and enhanced user experience.

#code

```mdc
Nuxt UI provides a comprehensive collection of Vue components, composables and utilities for building modern, accessible applications with consistent design and enhanced user experience.
```

::

:component-theme{slug="p" prose label="Theme"}

::

### Strong

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0"}
**Strong text**

#code

```mdc
**Strong text**
```

::

:component-theme{slug="strong" pro prose label="Theme"}

::

### Emphasis

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0"}
*Emphasized text*

#code

```mdc
*Emphasized text*
```

::

:component-theme{slug="em" pro prose label="Theme"}

::

## Links

To create a link, wrap the link text in brackets followed by the URL in parentheses. Works for both external and internal links.

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0"}
[Nuxt documentation](https://nuxt.com)

#code

```mdc
[Nuxt documentation](https://nuxt.com)
```

::

:component-theme{slug="a" prose label="Theme"}

::

## Blockquotes

Use blockquotes to highlight important information or quotes.

::tabs{class="gap-0"}

::code-preview{label="Preview"}
> Nuxt UI automatically adapts to your theme settings, ensuring consistent typography across your entire application.

#code

```mdc
> Nuxt UI automatically adapts to your theme settings, ensuring consistent typography across your entire application.
```

::

:component-theme{slug="blockquote" prose label="Theme"}

::

## Horizontal rules

Use horizontal rules to visually separate content sections.

::tabs{class="gap-0"}

::code-preview{label="Preview" class="[&>div]:*:my-0 [&>div]:*:w-full"}
:hr

#code

```mdc
---
```

::

:component-theme{slug="hr" prose label="Theme"}

::
